C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Build_XSD_Data ( lustats, Min_ratio, 
     :     Min_mean, Min_range, luglobal,
     :     XSD_mean, XSD_range, XSD_ratio, XSD_subband,
     :     ntrco, nsampo, nreco, delta_mean, delta_range, 
     :     delta_subband, delta_ratio, user_multiplier )

#include <f77/iounit.h>

c declare variables passed from calling routine

      integer lustats, ntrco, nsampo, nreco, luglobal

      real Min_ratio, Min_mean, Min_range
      real XSD_mean(nsampo,ntrco)
      real XSD_range(nsampo,ntrco)
      real XSD_ratio(nsampo,ntrco)
      real XSD_subband(nsampo,ntrco)
      real delta_mean, delta_range, delta_subband, delta_ratio
      real user_multiplier

c declare local variables

      integer rec, trace, nsum, j, k

      real rrec, rtrace, mean, range, ratio, subband
      real mean_sum, mean_square, range_sum, range_square
      real ratio_sum, ratio_square, factor
      real mean_mean, mean_stddev, range_mean, range_stddev
      real ratio_mean, ratio_stddev

      character label1*80, label2*80, label3*80

      logical mean_done, range_done, ratio_done, subband_done

c initialize variables

      mean_sum = 0.0
      mean_square = 0.0
      range_sum = 0.0
      range_square = 0.0
      ratio_sum = 0.0
      ratio_square = 0.0
      nsum = 0
      label1 = ' mean (mean)   mean (range)   mean (ratio)'
      label2 = ' std dev (mean)   std dev (range)   std dev (ratio)'
      label3 = ' record   trace   mean   range   ratio  subband'

c determine amplitude range to use for displays

      DO k = 1, nreco
         do j = 1, ntrco

            read(lustats,*, end=100)rrec, rtrace, mean, range, ratio, 
     :           subband

            mean_sum = mean_sum + mean
            mean_square = mean_square + mean * mean

            range_sum = range_sum + range
            range_square = range_square + range * range

            ratio_sum = ratio_sum + ratio
            ratio_square = ratio_square + ratio * ratio

            nsum = nsum + 1
         enddo
      ENDDO

 100  continue

c calculate mean and standard deviation for each display for scaling 
c purposes, if this works then will need to read through the stats
c twice, once to calculate deltas and once to bin the data.
      
      factor = 1.0 / float(nsum)
      mean_mean = mean_sum * factor
      mean_stddev = mean_square * factor - mean_mean * mean_mean
      mean_stddev = sqrt(mean_stddev)

      range_mean = range_sum * factor
      range_stddev = range_square * factor - range_mean * range_mean
      range_stddev = sqrt(range_stddev)

      ratio_mean = ratio_sum * factor
      ratio_stddev = ratio_square * factor - ratio_mean * ratio_mean
      ratio_stddev = sqrt(ratio_stddev)

c write mean and std deviation data to stats file, read past header
c enter means, read past header enter std deviations, read past
c stats header


      write(luglobal,'(a80)') label1
      write ( luglobal,'(3(1x,e15.5))') mean_mean, range_mean, 
     :     ratio_mean
      write(luglobal,'(a80)') label2
      write (luglobal,'(3(1x,e15.5))') mean_stddev, range_stddev, 
     :     ratio_stddev

c print stats to printout file

      write(LERR,*)' '
      write(LERR,*)' Mean of mean() = ', mean_mean
      write(LERR,*)' Standard Deviation of mean() = ',mean_stddev
      write(LERR,*)' '
      write(LERR,*)' Mean of range() = ', range_mean
      write(LERR,*)' Standard Deviation of range() = ',range_stddev
      write(LERR,*)' '
      write(LERR,*)' Mean of ratio() = ', ratio_mean
      write(LERR,*)' Standard Deviation of ratio() = ',ratio_stddev
      write(LERR,*)' '

      if ( mean_stddev .lt. mean_mean ) then
         delta_mean = user_multiplier*(mean_mean + 4*mean_stddev - 
     :        Min_mean) / float(nsampo)
      else
         delta_mean = user_multiplier*(mean_mean + mean_stddev - 
     :        Min_mean) / float(nsampo)
      endif

      if ( range_stddev .lt. range_mean ) then
         delta_range = user_multiplier*(range_mean + 4*range_stddev - 
     :        Min_range) / float(nsampo)
      else
         delta_range = user_multiplier*(range_mean + range_stddev - 
     :        Min_range) / float(nsampo)
      endif

      if ( ratio_stddev .lt. ratio_mean ) then
         delta_ratio = user_multiplier*(ratio_mean + 4*ratio_stddev - 
     :        Min_ratio) / float(nsampo)
      else
         delta_ratio = user_multiplier*(ratio_mean + ratio_stddev - 
     :        Min_ratio) / float(nsampo)
      endif

      write(LERR,*)' '
      write(LERR,*)' Delta mean =  ', delta_mean
      write(LERR,*)' Delta range =  ', delta_range
      write(LERR,*)' Delta ratio =  ', delta_ratio
      write(LERR,*)' '

      write(LERR,*)' '
      write(LERR,*)' Maximally Anomalous Traces'
      write(LERR,*)' --------------------------'
      write(LERR,*)' '

c will have to play with the upper limit in the presence of spikes
c to see what a good algorithm is so as not to squash the plot
c too much. Report to the printout file all entries that fall in the
c last sample.  These should be the spike traces if everything is 
c working properly.

c rewind the stats file 

      rewind ( lustats )

c read past header

      read ( lustats,*)

      DO k = 1, nreco

         do 10 j = 1, ntrco

            read(lustats,*, end=999)rrec, rtrace, mean, range, ratio, 
     :           subband

            rec = nint(rrec)
            trace = nint(rtrace)

            mean_done = .false.
            range_done = .false.
            ratio_done = .false.
            subband_done = .false.

            if ( mean .gt. (Min_mean + nsampo * delta_mean) ) then
               XSD_mean(nsampo,trace) = XSD_mean(nsampo,trace) + 1.
               write(LERR,*)rrec, rtrace, mean, range, ratio, subband
               mean_done = .true.
            endif
               
            if ( range .gt. ( Min_range + nsampo * delta_range )) then
               XSD_range(nsampo,trace) = XSD_range(nsampo,trace) + 1.
               range_done = .true.
            endif

            if ( ratio .gt. ( Min_ratio + nsampo * delta_ratio )) then
               XSD_ratio(nsampo,trace) = XSD_ratio(nsampo,trace) + 1.
               ratio_done = .true.
            endif

            
            do i = 1, nsampo

c lets not do every bin for every entry,  stop when all are done

               if ( mean_done .and. 
     :              range_done .and. 
     :              ratio_done .and. 
     :              subband_done ) goto 10
               
               if ( mean .le. ( Min_mean + float(i) * delta_mean ) 
     :              .and. .not. mean_done ) then
                  XSD_mean(i,trace) = XSD_mean(i,trace) + 1.
                  mean_done = .true.
               endif

               if ( range .le. ( Min_range + float(i) * delta_range )
     :              .and. .not. range_done ) then
                  XSD_range(i,trace) = XSD_range(i,trace) + 1.
                  range_done = .true.
               endif

               if ( ratio .le. ( Min_ratio + float(i) * delta_ratio )
     :              .and. .not. ratio_done ) then
                  XSD_ratio(i,trace) = XSD_ratio(i,trace) + 1.
                  ratio_done = .true.
               endif

               if(( subband .gt. (1. + float(i) * delta_subband))
     :              .and. 
     :             (subband .le. (2. + float(i) * delta_subband))
     :              .and.  .not. subband_done ) then
                  XSD_subband(i,trace) = XSD_subband(i,trace) + 1.
                  subband_done = .true.
               endif

            enddo
 10      continue
      ENDDO

 999  continue
      return
      end
