C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FuncLimits ( TrcWrd, Trace, MinLimit, MaxLimit, Nfunc,
     :     FuncMin, FuncMax )

c declare variables passed from calling routine

      integer TrcWrd, Nfunc

      real Trace(Nfunc), MinLimit(Nfunc), MaxLimit(Nfunc)
      real FuncMin, FuncMax

c declare local variables


c interpolate min and max limits

      if ( TrcWrd .le. Trace(1) ) then
         FuncMin = MinLimit(1)
         FuncMax = MaxLimit(1)
         return
      elseif ( TrcWrd .ge. Trace(Nfunc) ) then
         FuncMin = MinLimit(Nfunc)
         FuncMax = MaxLimit(Nfunc)
         return
      else

         do i = 2, Nfunc

            if ( TrcWrd .le. Trace(i) ) then

               FuncMin = MinLimit(i-1) + (( MinLimit(i) - MinLimit(i-1))
     :              / (Trace(i) - Trace(i-1)) 
     :              * (float(TrcWrd) - Trace(i-1)))
               FuncMax = MaxLimit(i-1) + (( MaxLimit(i) - MaxLimit(i-1))
     :              / (Trace(i) - Trace(i-1)) 
     :              * (float(TrcWrd) - Trace(i-1)))
               return
            endif
         enddo
         
      endif

      end
