C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine MeanUpdate( DesiredRunningCount, RunningMeanMean, 
     :     RunningMeanRange, RunningMeanRatio, MeanMean, MeanRange, 
     :     MeanRatio, Mean, Range, Ratio, RunningCount )

c routine to keep the MeanMean, MeanRange and MeanRatio updated
c for the last DesiredRunningCount good traces.  These values are
c used should zonal kills be desired.

c declare variables passed from calling routine

      integer DesiredRunningCount, RunningCount

      real RunningMeanMean(DesiredRunningCount)
      real RunningMeanRange(DesiredRunningCount)
      real RunningMeanRatio(DesiredRunningCount)
      real MeanMean, MeanRange, MeanRatio
      real Mean, Range, Ratio 

c declare local variables

      integer i

      real SumMean, SumRange, SumRatio

c initialize variables

      SumMean = 0.0
      SumRange = 0.0
      SumRatio = 0.0

      if ( RunningCount .le. DesiredRunningCount ) then

c do not update as not enough traces have gone by yet, just
c start filling the rolling buffer

            RunningMeanMean(RunningCount) =  Mean
            RunningMeanRange(RunningCount) =  Range
            RunningMeanRatio(RunningCount) =  Ratio
         
      else

c roll along the trace statistics

         do i = DesiredRunningCount, 2, -1
            RunningMeanMean(i) =  RunningMeanMean(i-1)
            RunningMeanRange(i) =  RunningMeanRange(i-1)
            RunningMeanRatio(i) =  RunningMeanRatio(i-1)
         enddo

c assign current trace statistics

         RunningMeanMean(1) =  Mean
         RunningMeanRange(1) =  Range
         RunningMeanRatio(1) =  Ratio

c update MeanMean, MeanRange and MeanRatio

         do i = 1, DesiredRunningCount
            SumMean = SumMean + RunningMeanMean(i)
            SumRange = SumRange + RunningMeanRange(i)
            SumRatio = SumRatio + RunningMeanRatio(i)
         enddo

         MeanMean = SumMean / float(DesiredRunningCount) 
         MeanRange = SumRange / float(DesiredRunningCount) 
         MeanRatio = SumRatio / float(DesiredRunningCount)
 
      endif

      return
      end
