C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c     Program Changes:

c      May 12, 1998: made -s and -e entries the processing limits as opposed to the
c                    data pass limits.
c      Garossino
c
c      Apr 1,1998: added a graceful end option for when the line header is lying
c                  about the number of records in the dataset being process.  We
c                  still want an XSD output file for qc at this point which was
c                  previously not being generated in this case.
c
c                  also added universal header logic for RecWrd and TrcWrd to 
c                  allow the user to use any header word of choice for these
c                  entries
c      Garossino

c      Jan 98: added ability to kill off zone only [as opposed to whole trace]
c              added global stats output to printout file and created a global
c              stats file for use with -zone mode.  Because of SGI problem 
c              with fortran i/o and pointer control I have been forced into
c              using a separate global stats file.
c      Garossino

c      Jan 97:  added maximally anomalous output to printout file from xsd display 
c               builder
c      Garossino

c      Dec 96:  put in window start velocity, sample skip option on
c               qc mode only, usp output format to be used for picking
c               limiting function file.  Sample interval for each display is
c               in Horz08.  The minimum value for each display is in Horz07.
c               Pickfile interface reads in standard pickfile and
c               sample interval information from xsd file for use in limiting
c               the data.
c      Garossino

c

c      - original written: April 26, 1996
c        [Paul G. A. and Julia C. Garossino]

c     Program Description:

c      - Short Time Fourier Transform to generate time - frequency version
c        of input data.  Detect spike based on amplitude spectrum discriminator
c        and kill samples based on user defined limits on spectral mean amplitude 
c        [default], max spectral amp - mean, or ratio of the two.

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr( 2*SZLNHD )
     
      integer     nsamp, nsamp_process, nsi, ntrc, ntrco, nrec, nreco
      integer     iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis

      real        tri( 2*SZLNHD )

      character   ntap*255, otap*255, name*7

      logical     verbos

c Program Specific _ dynamic memory variables

      integer errcd1, errcd2, errcd3, errcd4, errcd5, errcd6
      integer errcd7, errcd8, errcd9, abort
      integer tfsize, ctrsize, rec_size, DesiredRunningCount

      real stft_Record, XSD_mean, XSD_range, XSD_ratio, XSD_subband
      real RunningMeanMean, RunningMeanRange, RunningMeanRatio

      complex  ctr

      pointer (ptr_ctr, ctr(1))
      pointer (ptr_stft_record, stft_Record(1))
      pointer (ptr_XSD_mean, XSD_mean(1))
      pointer (ptr_XSD_range, XSD_range(1))
      pointer (ptr_XSD_ratio, XSD_ratio(1))
      pointer (ptr_XSD_subband, XSD_subband(1))
      pointer (ptr_RunningMeanMean, RunningMeanMean(1))
      pointer (ptr_RunningMeanRange, RunningMeanRange(1))
      pointer (ptr_RunningMeanRatio, RunningMeanRatio(1))

c Program Specific _ static memory variables

      integer ifmt_RecWrd,l_RecWrd,ln_RecWrd, RecWrd
      integer ifmt_TrcWrd,l_TrcWrd,ln_TrcWrd, TrcWrd
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_Horz01,l_Horz01,ln_Horz01
      integer ifmt_Horz02,l_Horz02,ln_Horz02
      integer ifmt_Horz03,l_Horz03,ln_Horz03
      integer ifmt_Horz04,l_Horz04,ln_Horz04
      integer ifmt_Horz08, l_Horz08, ln_Horz08
      integer ifmt_Horz07, l_Horz07, ln_Horz07
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer nwin, nu, nwin2, nf2, nf, i, ia, ordfft
      integer kill_count, lustats, lufunc, Nfunc, lupick
      integer lukill, length, JJ, KK, lestats, lexsd
      integer step_size, window_start, tr_index
      integer luxsd, xsd_trace(SZLNHD), xsd_record
      integer RunningCount

      integer luglobal

      real w( SZLNHD ), Workspace( 2*SZLNHD ) 
      real sigma, sigma2, pi, spi, velocity, Subband
      real delta_subband, delta_ratio, delta_mean, delta_range, delta
      real Trace(SZLNHD), MinLimit(SZLNHD), MaxLimit(SZLNHD)
      real FuncMin, FuncMax, Mean, Range, Ratio, StatRec, StatTrc
      real Max_ratio, Min_ratio, Max_mean, Min_mean, min
      real Max_range, Min_range, user_multiplier
      real MeanMean, MeanRange, MeanRatio
      real StdDevMean, StdDevRange, StdDevRatio
      real DesiredStdDevMultiplier
      real spaceholder, r_RecWrd, r_TrcWrd

      character statstap*255, functap*255, c_RecWrd*6, c_TrcWrd*6
      character killtap*255, xsdtap*255, picktap*255
      character label*80

      character globaltap*255

      logical kill, use_ratio, use_range, qc, zone, premature_eof

c Initialize variables

      data abort/0/
      data name/"TFSKILL"/
      data kill_count/0/
      data RunningCount/0/
      data spaceholder /99999.9e30/
      data premature_eof/.FALSE./

      label = ' record   trace   mean   range   ratio  subband'

      call vclr ( w, 1, SZLNHD )
      call vclr ( Workspace, 1, 2*SZLNHD )
      call vclr ( Trace, 1, SZLNHD )
      call vclr ( MinLimit, 1, SZLNHD )
      call vclr ( MaxLimit, 1, SZLNHD )

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, name, nwin, 
     :     statstap, functap, use_ratio, use_range, c_RecWrd, c_TrcWrd, 
     :     killtap, qc, velocity, step_size, xsdtap, picktap, 
     :     user_multiplier, zone, DesiredRunningCount, 
     :     DesiredStdDevMultiplier, globaltap, verbos )

c Policemen

c when running in spike kill mode [as opposed to trace kill mode]
c need to examine every sample [for now] so step size needs to be
c unity

      if ( .not. qc .and. zone ) step_size = 1

c subroutine that forms the stft record uses this size of array
c in tri.  IF tri is not this big then trouble.

      if ( ( nsamp + nwin ) .gt. SZLNHD ) then

         write(LERR,*)' '
         write(LERR,*)' Your trace is too long for USP.  Either break'
         write(LERR,*)' it down into a smaller problem or call the USP'
         write(LERR,*)' help line for moral support'
         write(LERR,*)'FATAL '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'TFSKILL: '
         write(LER,*)' Your trace is too long for USP.  Either break'
         write(LER,*)' it down into a smaller problem or call the USP'
         write(LER,*)' help line for moral support'
         write(LER,*)'FATAL '
         write(LER,*)' '
         stop
      endif

c open input and output files

      call getln(luin , ntap,'r', 0)
      if ( .not. qc ) call getln(luout, otap,'w', 1)

c this is the SGI hack, because the SGI compiler cannot handle
c backing up on a read/write file and filling in a reserved slot
c I have to put this information into a completely separate file.
c how boring.
      
      if ( globaltap .eq. ' ' ) globaltap = 'tfskill_global_stats'
      length = lenth(globaltap)
      call alloclun (luglobal)
      open ( luglobal, file=globaltap(1:length), status='unknown',
     :     err=989 )
      
      if ( .not. qc ) then
         read ( luglobal,* )
         read ( luglobal, * ) MeanMean, MeanRange, MeanRatio
         read ( luglobal,* )
         read ( luglobal, * ) StdDevMean, StdDevRange, StdDevRatio
      endif

c open time - frequency statistics file file

      IF ( statstap .ne. ' ' ) then

c user has entered a filename on the command line

         lestats = lenth(statstap)
         call alloclun ( lustats )

         if ( qc ) then 

c open the stats file and put in the header lines, the standard deviation 
c information will go in last but space must be left at this point to 
c avoid clobbering the initial trace statistics.

            open ( lustats, file=statstap(1:lestats), status='unknown',
     :           err=990 )
            write(lustats,'(a80)') label

         else
            
c open the stats file and read past the header line

            open ( lustats, file=statstap(1:lestats), status='old',
     :           err=990 )
            read ( lustats,* )

         endif

      ELSE

c user has not entered a filename for the stats file on the command line
c
c if qc mode then open the stats file using a default name.  If in
c process mode then kill the routine as the user has not attached
c a pre-existing stats file to use in trace kill control

         if ( .not. qc ) then
            write(LERR,*)' '
            write(LERR,*)' require a pre-existing statistics file '
            write(LERR,*)' for process mode.  Supply such a file '
            write(LERR,*)' using -X on the command line or run the'
            write(LERR,*)' routine using -qc for quality control'
            write(LERR,*)' '
            write(LER,*)' '
            write(LER,*)'TFSKILL'
            write(LER,*)' require a pre-existing statistics file '
            write(LER,*)' for process mode.  Supply such a file '
            write(LER,*)' using -X on the command line or run the'
            write(LER,*)' routine using -qc for quality control'
            write(LER,*)'FATAL'
            stop
         else

            statstap = 'tfskill_stats'
            lestats = lenth(statstap)
            call alloclun ( lustats )
            open ( lustats, file=statstap(1:lestats), status='unknown',
     :           err=990 )
            write(lustats,'(a80)') label
            
         endif

      ENDIF

c open xsd dataset file if required

      if ( qc ) then

c if user has not entered a filename for the xsd file on the command
c line then use tfskill_xsd

         if ( xsdtap .eq. ' ' ) xsdtap = 'tfskill_xsd'

c open the xsd dataset file

         lexsd = lenth(xsdtap)
         call getln(luxsd ,xsdtap(1:lexsd), 'w', 0)
         do i = 1, SZLNHD
            xsd_trace(i) = 0
         enddo

      else

         if ( picktap .ne. ' ' ) then

c if user is using a pickfile interface then need to open the
c xsd file to get the sample interval information for the display 
c that was picked.

            call alloclun(lupick)
            length = lenth(picktap)
            open( lupick, file=picktap(1:length), status='old', err=991)

            if ( xsdtap .eq. ' ' ) xsdtap = 'tfskill_xsd'
            lexsd = lenth(xsdtap)
            call getln(luxsd ,xsdtap(1:lexsd), 'r', 0)
            
         else

c open limiting function file if attached 

            length = lenth ( functap )
            call alloclun ( lufunc )
            open ( lufunc, file=functap(1:length), status='old', 
     :           err=991 )

         endif

c open kill stats file if limiting function file is attached, if the
c user has not entered a filename for this file on the command line
c then user the name tfskill_kills

         if ( killtap .eq. ' ' ) killtap = 'tfskill_kills'

         length = lenth ( killtap )
         call alloclun ( lukill )
         open ( lukill, file=killtap(1:length), status='unknown', 
     :        err=992 )
         write(lukill,*)' RecNum   TrcNum ',c_RecWrd,' ', c_TrcWrd, '  m
     :ean   range   ratio subband'
      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'TFSKILL: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu(c_RecWrd,ifmt_RecWrd,l_RecWrd,ln_RecWrd,TRACEHEADER)
      call savelu(c_TrcWrd,ifmt_TrcWrd,l_TrcWrd,ln_TrcWrd,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('Horz01',ifmt_Horz01,l_Horz01,ln_Horz01,TRACEHEADER)
      call savelu('Horz02',ifmt_Horz02,l_Horz02,ln_Horz02,TRACEHEADER)
      call savelu('Horz03',ifmt_Horz03,l_Horz03,ln_Horz03,TRACEHEADER)
      call savelu('Horz04',ifmt_Horz04,l_Horz04,ln_Horz04,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('Horz08',ifmt_Horz08,l_Horz08,ln_Horz08,TRACEHEADER)
      call savelu('Horz07',ifmt_Horz07,l_Horz07,ln_Horz07,TRACEHEADER)

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 7, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      nreco = ire - irs + 1

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc
      ntrco = ne - ns + 1

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1

      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp
      nsamp_process = iend - ist + 1

c if not in qc mode will need to update and write an output line header

      if ( .not. qc ) then
         call savew(itr, 'NumRec', nreco, LINHED)
         call savew(itr, 'NumTrc', ntrco  , LINHED)

c will always output the same number of samples as the input, the -s and -e
c options are processing limits only

         call savew(itr, 'NumSmp', nsamp  , LINHED)

c save out hlh and line header

         call savhlh  ( itr, lbytes, lbyout )
         call wrtape ( luout, itr, lbyout )
      else

c write out xsd dataset lineheader

         call savew(itr, 'NumRec', 4, LINHED)
         call savew(itr, 'NumTrc', ntrco  , LINHED)
         call savew(itr, 'NumSmp', nsamp  , LINHED)

c save out hlh and line header

         call savhlh  ( itr, lbytes, lbyout )
         call wrtape ( luxsd, itr, lbyout )
      endif

c determine output trace length in bytes, good for output data 
c and output xsd dataset

      obytes = SZTRHD + SZSMPD * nsamp

      if ( .not. qc .and. picktap .ne. ' ' ) then

c if not in qc mode and pickfile interface is being used will need
c to read the sample interval from the appropriate record of the 
c xsd file.

         call rtape(luxsd, itr, lbytes)
         if(lbytes.eq.0)then
            write(LER,*)'TFSKILL: no line header on xsd dataset',xsdtap
            write(LER,*)'FATAL'
            stop
         endif

c skip unwanted input records
      
         if ( use_ratio ) then
            xsd_record = 3
         elseif (use_range) then
            xsd_record = 2
         else
            xsd_record = 1
         endif

         call recskp ( 1, xsd_record-1, luxsd, ntrco, itr )

c read first trace of appropriate record and retrieve sample interval

         call rtape ( luxsd, itr, nbytes )
         if(lbytes.eq.0)then
           write(LERR,*)'TFSKILL: no data at record ',xsd_record
           write(LERR,*)'         of xsd dataset. Cannot retrieve'
           write(LERR,*)'         sample interval for use with pickfile'
           write(LERR,*)'FATAL'
            write(LER,*)'TFSKILL: no data at record ',xsd_record
            write(LER,*)'         of xsd dataset. Cannot retrieve'
            write(LER,*)'         sample interval for use with pickfile'
            write(LER,*)'FATAL'
            stop
         endif

         call saver2 ( itr, ifmt_Horz08, l_Horz08, ln_Horz08, delta, 
     :        TRACEHEADER )
         call saver2 ( itr, ifmt_Horz07, l_Horz07, ln_Horz07, min, 
     :        TRACEHEADER )

      endif

c determine next power of 2 for window and number of frequencies to generate
c which we need to do regardless of whether we are in qc mode or not.

      if ( nwin .lt. 32 ) nwin = 32
      nu = ordfft ( nwin )
      nwin2 = 2 ** nu
      nf = nwin2 / 2
      delta_subband = float(nf) / float(nsamp_process)

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, ntrco, nreco, nsamp_process, nwin , 
     :     statstap, functap, use_ratio, use_range, c_RecWrd, c_TrcWrd, 
     :     killtap, qc, velocity, step_size, xsdtap, picktap, delta, 
     :     min, user_multiplier, zone, DesiredRunningCount, 
     :     DesiredStdDevMultiplier, verbos)

c setup the Gaussian sampling window, which again must be done 
c regardless of the mode we are operating in

      sigma = float(nwin) / ( 2. * 3. )
      sigma2 = 2. * sigma**2
      pi = acos(-1.)
      nf2 = nf + 1
      spi = 1. / ( sqrt(2. * pi) * sigma )
      
      do i = 1, nwin2
         ia = i - nf2
         w ( i ) = spi * exp ( - ( float(ia) )**2 / sigma2 )
      enddo
      
      if ( .not. qc ) then

c in Process Mode: read in limiting function file or xsd pickfile 
c as required

         if ( functap .ne. ' ' ) then
            call ReadLimFunction ( lufunc, Trace, MinLimit, MaxLimit, 
     :           Nfunc )
         elseif( picktap .ne. ' ' ) then
            call ReadPicks(lupick, xsd_record, Trace, MinLimit, 
     :           MaxLimit, ntrco, delta, min, Nfunc )
         endif

         if (verbos) then
            write(lerr,*) ' '
            write(lerr,*) ' Kill Statistics '
            write(lerr,*) ' '
            write(lerr,*) ' RecNum   TrcNum   Mean       Range      Rati
     :o  Subband'
            write(lerr,*) ' ------   ------   ----       -----      ----
     :-  -------'
            write(lerr,*) ' '
         endif
      endif

c dynamic memory allocation
      
      ctrsize= nf * 4 
      tfsize = 2 * nsamp * nf
      rec_size = ntrco * nsamp
      
      call galloc ( ptr_ctr, ctrsize * SZSMPD, errcd1, abort )
      call galloc ( ptr_stft_record, tfsize * SZSMPD, errcd2, 
     :     abort )
      call galloc ( ptr_XSD_mean, rec_size * SZSMPD, errcd3, 
     :     abort )
      call galloc ( ptr_XSD_range, rec_size * SZSMPD, errcd4, 
     :     abort )
      call galloc ( ptr_XSD_ratio, rec_size * SZSMPD, errcd5, 
     :     abort )
      call galloc ( ptr_XSD_subband, rec_size * SZSMPD, errcd6, 
     :     abort )
      call galloc ( ptr_RunningMeanMean, DesiredRunningCount * 
     :     SZSMPD, errcd7, abort )
      call galloc ( ptr_RunningMeanRange, DesiredRunningCount * 
     :     SZSMPD, errcd8, abort )
      call galloc ( ptr_RunningMeanRatio, DesiredRunningCount * 
     :     SZSMPD, errcd9, abort )

      if ( errcd1 .ne. 0 .or. 
     :     errcd2. ne. 0 .or. 
     :     errcd3. ne. 0 .or. 
     :     errcd4. ne. 0 .or.
     :     errcd5. ne. 0 .or.
     :     errcd6. ne. 0 .or.
     :     errcd7. ne. 0 .or.
     :     errcd8. ne. 0 .or.
     :     errcd9. ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)' Unable to allocate workspace:'
         write(LERR,*) ctrsize * SZSMPD, ' bytes '
         write(LERR,*) tfsize * SZSMPD, ' bytes '
         write(LERR,*) 4 * rec_size * SZSMPD, ' bytes '
         write(LERR,*) 2 * DesiredRunningCount * SZSMPD, ' bytes '
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)' TFSKILL: Unable to allocate workspace:'
         write(LER,*) ctrsize * SZSMPD, ' bytes '
         write(LER,*) tfsize * SZSMPD, ' bytes '
         write(LER,*) 4 * rec_size * SZSMPD, ' bytes '
         write(LER,*) 2 * DesiredRunningCount * SZSMPD, ' bytes '
         write(LER,*)' '
         goto 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) ctrsize * SZSMPD, ' bytes '
         write(LERR,*) tfsize * SZSMPD, ' bytes '
         write(LERR,*) 4 * rec_size * SZSMPD, ' bytes '
         write(LERR,*) 2 * DesiredRunningCount * SZSMPD, ' bytes '
         write(LERR,*)' '
      endif
         
c initialize memory

      call vclr ( XSD_mean, 1, rec_size )
      call vclr ( XSD_range, 1, rec_size )
      call vclr ( XSD_ratio, 1, rec_size )
      call vclr ( XSD_subband, 1, rec_size )
      call vclr ( RunningMeanMean, 1, DesiredRunningCount )
      call vclr ( RunningMeanRange, 1, DesiredRunningCount )
      call vclr ( RunningMeanRatio, 1, DesiredRunningCount )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

c read a trace

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK

c if we have a lineheader that is wrong [for instance an edit3d run
c where -liveonly is used may result in the wrong number of records
c in the output line header] then we still want to do all the xsd
c qc display stuff if we are in qc mode.  I have arbitrarily decided
c that if we have processed more than just the first record this will
c happen.  If something has ended before the first record, I know, 
c what about a single record dataset that end prematurely....hey you
c can't have everything.....then I will just bail....Garossino

               if ( JJ .gt. irs ) then
                  premature_eof = .true.
                  go to 500
               else
                  goto 999
               endif
            endif

c retrieve dead trace flag

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

            if ( StaCor .ne. 30000) then

c add logic to allow universal headerword choice for RecWrd and TrcWrd

c               call saver2( itr, ifmt_RecWrd, l_RecWrd, ln_RecWrd, 
c     :              RecWrd, TRACEHEADER )

               if ( ifmt_RecWrd .eq. SAVE_SHORT_DEF .or.
     :              ifmt_RecWrd .eq. SAVE_LONG_DEF ) then
                  call saver2(itr,ifmt_RecWrd,l_RecWrd, ln_RecWrd,
     1                 RecWrd  , TRACEHEADER)
               else
                  call saver2(itr,ifmt_RecWrd,l_RecWrd, ln_RecWrd,
     1                 r_RecWrd  , TRACEHEADER)
                  RecWrd = nint(r_RecWrd)
               endif

c               call saver2( itr, ifmt_TrcWrd, l_TrcWrd, ln_TrcWrd, 
c     :              TrcWrd, TRACEHEADER )

               if ( ifmt_TrcWrd .eq. SAVE_SHORT_DEF .or.
     :              ifmt_TrcWrd .eq. SAVE_LONG_DEF ) then
                  call saver2(itr,ifmt_TrcWrd,l_TrcWrd, ln_TrcWrd,
     1                 TrcWrd  , TRACEHEADER)
               else
                  call saver2(itr,ifmt_TrcWrd,l_TrcWrd, ln_TrcWrd,
     1                 r_TrcWrd  , TRACEHEADER)
                  TrcWrd = nint(r_TrcWrd)
               endif

               call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :              RecNum, TRACEHEADER )
               call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :              TrcNum, TRACEHEADER )
               call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :              DstSgn, TRACEHEADER )

               call vmov ( itr(ITHWP1), 1, tri(nf), 1, nsamp )

c initialize time - frequency spectrum and complex trace arrays
c in preparation for the t-f transform of this trace

               call vclr ( stft_Record, 1, tfsize )
               do i = 1, nf
                  ctr(i) = cmplx(0.0,0.0)
               enddo
c process only live traces, move time series into tri and leave a 
c half window length zone of zero pad at the top and bottom.  The
c top can be done by moving to tri(nf) the bottom is automatic as
c tri is dimensioned a lot bigger than the trace going in.

c determine window start sample for this trace

               window_start = ist + 
     :              nint((float(DstSgn)/velocity * 1000.)/float(nsi))

               if ( (iend - window_start) .lt. nwin ) then
                  write(LERR,*)' '
                  write(LERR,*)' not enough samples in window to'
                  write(LERR,*)' time-frequency transform at:'
                  write(LERR,*)' record = ',JJ
                  write(LERR,*)' trace =  ',KK
                  write(LERR,*)' window start sample = ',window_start
                  write(LERR,*)' window end sample = ',iend
                  write(LERR,*)' trace distance  = ',DstSgn
                  write(LERR,*)'FATAL'
                  write(LER,*)' '
                  write(LER,*)'TFSKILL: '
                  write(LER,*)' not enough samples in window to'
                  write(LER,*)' time-frequency transform at:'
                  write(LER,*)' sequential record = ',JJ
                  write(LER,*)' sequential trace = ',KK
                  write(LER,*)' window start sample = ',window_start
                  write(LER,*)' window end sample = ',iend
                  write(LER,*)' trace distance  = ',DstSgn
                  write(LER,*)'FATAL'
                  stop
               endif


               IF ( qc ) then

c FORWARD TRANSFORM
               
c generate forward t-f spectrum for this trace.  The input trace has
c nsamp samples.  The output spectrum has nf traces of nsamp_process samples.

                  call forward_stft ( tri, Workspace, nsamp, 
     :                 window_start, iend, 
     :                 nf, nwin, stft_Record, nsamp_process, 
     :                 w, ctr, step_size, verbos )

c the subroutine looks for the subband with the maximum range of input values
c in the amplitude spectrum and uses that sub-band to calculate the time - freq
c statistics for this trace.  The tf transform window is 32 samples and the 
c tf transformation starts at window_start, goes to iend and moves down in
c step_size increments.  This allows one to garner statistics on the data
c without having to tf transform for every sample position.

                  call AutoDetect( stft_record, nsamp_process, nf, 
     :                 lustats, 
     :                 RecWrd, TrcWrd, Mean, Range, Ratio, Subband,
     :                 statstap, lestats, Max_ratio, Min_ratio, 
     :                 Max_mean, Min_mean, Max_range, Min_range, 
     :                 step_size, window_start, iend )

               ELSE

c determine function limits for this trace based on the input limiting
c function file and the trace position of this trace

                  call FuncLimits ( TrcWrd, Trace, MinLimit, MaxLimit, 
     :              Nfunc, FuncMin, FuncMax )

c determine if calculated statistics for this trace fall inside the limits

                  kill = .false.

c The assumption here is that the input statistics file has an entry for 
c every trace in the dataset.  i.e. that the user has run tfskill on this
c exact dataset in qc mode using the attached statistics file using the 
c same record and trace index choices.  If this is not true then I will 
c abort and complain.  If we find that a global limiting function is 
c possible then it should not be too much of an effort to allow this
c routine to calculate the qc statistics on the fly and edit immediately
c based on an attached limiting function file without the presence of
c a tfskill statistics file

                  read ( lustats, *) StatRec, StatTrc, Mean, Range, 
     :                 Ratio, Subband

                  if ( RecWrd .ne. nint(StatRec) .or. 
     :                 TrcWrd .ne. nint(StatTrc) ) then
                     write(LERR,*)' '
                     write(LERR,*)' something fishy '
                     write(LERR,*)' At sequential record ', RecNum
                     write(LERR,*)' sequential trace ', TrcNum, ' your '
                     write(LERR,*)' stats file was expecting a record'
                     write(LERR,*)' index of ',StatRec, ' while your '
                     write(LERR,*)' dataset, using ',c_RecWrd, ' has'
                     write(LERR,*)' an index of ',RecWrd, ' The'
                     write(LERR,*)' expected trace index was ',StatTrc
                     write(LERR,*)' while your dataset, using ',c_TrcWrd
                     write(LERR,*)' has an index of ',TrcWrd
                     write(LERR,*)' '
                     write(LERR,*)' Check that you are using the '
                     write(LERR,*)' correct statistics file and '
                     write(LERR,*)' that your command line entries for'
                     write(LERR,*)' -hw1 and -hw2 are the same for this'
                     write(LERR,*)' run as for your -qc run'
                     write(LERR,*)' '
                     write(LERR,*)'FATAL '
                     write(LER,*)'TFSKILL'
                     write(LER,*)' '
                     write(LER,*)' something fishy with your statistics'
                     write(LER,*)' file.  At sequential record ',RecNum
                     write(LER,*)' sequential trace ', TrcNum, ' your'
                     write(LER,*)' stats file was expecting a record'
                     write(LER,*)' index of ',StatRec, ' while your'
                     write(LER,*)' dataset, using ',c_RecWrd, ' has'
                     write(LER,*)' an index of ',RecWrd, ' The'
                     write(LER,*)' expected trace index was ',StatTrc
                     write(LER,*)' while your dataset, using ',c_TrcWrd
                     write(LER,*)' has an index of ',TrcWrd
                     write(LER,*)' '
                     write(LER,*)' Check that you are using the'
                     write(LER,*)' correct statistics file and'
                     write(LER,*)' that your command line entries for'
                     write(LER,*)' -hw1 and -hw2 are the same for this'
                     write(LER,*)' run as for your -qc run'
                     write(LER,*)' '
                     write(LER,*)'FATAL '
                     goto 999
                  endif

                  if ( use_ratio ) then
                     if ( Ratio .gt. FuncMax .or. Ratio .lt. FuncMin ) 
     :                    kill = .true.
                  elseif ( use_range ) then
                     if ( Range .gt. FuncMax .or. Range .lt. FuncMin ) 
     :                    kill = .true.
                  else
c                     if ( Mean .gt. FuncMax .or. Mean .lt. FuncMin ) 
c     :                    kill = .true.
                     if ( Mean .gt. FuncMax ) 
     :                    kill = .true.
                  endif

                  call savew2 ( itr, ifmt_Horz01, l_Horz01, ln_Horz01, 
     :                 Mean, TRACEHEADER )
                  call savew2 ( itr, ifmt_Horz02, l_Horz02, ln_Horz02, 
     :                 Range, TRACEHEADER )
                  call savew2 ( itr, ifmt_Horz03, l_Horz03, ln_Horz03, 
     :                 Ratio, TRACEHEADER )
                  call savew2 ( itr, ifmt_Horz04, l_Horz04, ln_Horz04, 
     :                 Subband, TRACEHEADER )

c Kill any trace that fails the detection criteria

                  if ( kill ) then

c if the user has specified a zone kill then we do not want to arbitrarily
c kill the entire trace.  In this case we will make use of the mean and 
c std deviation data for the parameter chosen to allow zonal kills of 
c offensive samples

                     if ( zone ) then
                        
c generate forward t-f spectrum for this trace.  The input trace has
c nsamp samples.  The output spectrum has nf traces of nsamp_process samples.

                        call forward_stft ( tri, Workspace, nsamp, 
     :                       window_start, iend, 
     :                       nf, nwin, stft_Record, nsamp_process, 
     :                       w, ctr, step_size, verbos )
                        
c examine subband dictated by stats file for spectral amplitudes that
c violate the criteria, if amp is found kill trace data for 16 samples 
c on either side, then walk down 16 samples and continue...make sure 
c overlap is correct so no spike energy is left in the middle of nowhere 
c in this call statement the MeanMean, MeanRange and MeanRatio used are
c continuously updated based on non-anomalous traces as we go by them.  We
c will use a user defined number of traces in this estimate of the mean.
c For the traces prior to passing that number we will use the global means
c from the start of the stats file.  In all cases we will use the std deviation
c information for the global stats file.                      

                        call ZoneKill ( tri, nsamp, nf, nsamp_process, 
     :                       stft_Record, use_ratio, use_range, ist, 
     :                       iend, Subband, MeanMean, StdDevMean, 
     :                       MeanRange, StdDevRange, 
     :                       MeanRatio, StdDevRatio, 
     :                       DesiredStdDevMultiplier )

                        kill_count = kill_count + 1
                        if ( verbos ) write(lerr,*)RecNum, '      ',
     :                       TrcNum, Mean, Range, Ratio, Subband
                        write(lukill,'(4(i10,1x),4(e10.4,1x))') RecNum, 
     :                       TrcNum, RecWrd, TrcWrd, Mean, Range, Ratio, 
     :                       Subband
                        
                        call vmov( tri(nf), 1, itr(ITHWP1), 1, nsamp )

                     else

                        call vclr ( tri, 1, nsamp )
                        call vmov( tri, 1, itr(ITHWP1), 1, nsamp )
                        call savew2 ( itr, ifmt_StaCor, l_StaCor, 
     :                       ln_StaCor, 30000, TRACEHEADER )
                        
                        kill_count = kill_count + 1
                        if ( verbos ) write(lerr,*)RecNum, '      ',
     :                       TrcNum, Mean, Range, Ratio, Subband
                        write(lukill,'(4(i10,1x),4(e10.4,1x))') RecNum, 
     :                       TrcNum, RecWrd, TrcWrd, Mean, Range, Ratio, 
     :                       Subband
                        
                     endif

                  else

                     if ( zone ) then

c this is a non-anomalous trace so let us update the means for this
c entry.

                        RunningCount = RunningCount + 1
                        
                        call MeanUpdate ( DesiredRunningCount,   
     :                       RunningMeanMean, RunningMeanRange, 
     :                       RunningMeanRatio, MeanMean, MeanRange, 
     :                       MeanRatio, Mean, Range, Ratio, 
     :                       RunningCount )

                     endif

                  endif

               ENDIF

            endif

c if in Process Mode output this trace

            if ( .not. qc ) call wrtape ( luout, itr, obytes )

         ENDDO

c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

 500  continue

c if we have a premature eof and get to this point then we also
c have JJ being greater than 1.  We will need to reassign the 
c nreco entry in order not to run off the end of the stats file
c in the Build_XSD_Data subroutine.

      if ( premature_eof ) then
         nreco = JJ - 1
      endif

      if ( qc ) then

c rewind statistics file and position the file pointer at the first
c input data line

         close(lustats)
         open ( lustats, file=statstap(1:lestats), status='old',
     :        err=990 )
         read ( lustats,*)

c build an output USP format dataset viewable in XSD from which picks may be 
c made as an alternate method of deriving a limiting function file.  This routine
c also calculates and installs the global mean and std deviation data to the
c stats file.

         call Build_XSD_Data(lustats, Min_ratio, 
     :        Min_mean, Min_range, luglobal,
     :        XSD_mean, XSD_range, XSD_ratio, XSD_subband, 
     :        ntrco, nsamp, nreco, delta_mean, delta_range, 
     :        delta_subband, delta_ratio, user_multiplier )

c echo info to printout file

         write(LERR,*)' '
         write(LERR,*)' Global Statistics '
         write(LERR,*)' ----------------- '
         write(LERR,*)' '
         write(LERR,*)' Minimum Spectral Mean = ', Min_mean
         write(LERR,*)' Maximum Spectral Mean = ', Max_mean
         write(LERR,*)' XSD display delta mean = ', delta_mean
         write(LERR,*)' '
         write(LERR,*)' Minimum Spectral Range = ', Min_range
         write(LERR,*)' Maximum Spectral Range = ', Max_range
         write(LERR,*)' XSD display delta Range = ', delta_range
         write(LERR,*)' '
         write(LERR,*)' Minimum Spectral Ratio = ', Min_ratio
         write(LERR,*)' Maximum Spectral Ratio = ', Max_ratio
         write(LERR,*)' XSD display delta Ratio = ', delta_ratio
         write(LERR,*)' '
         write(LERR,*)' Minimum Spectral Subband =  1.0'
         write(LERR,*)' Maximum Spectral Subband =  16.0'
         write(LERR,*)' XSD display delta Subband = ', delta_subband
         write(LERR,*)' '

c write spectral mean output record

         RecNum = 1
         call savew2 ( xsd_trace, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :                 RecNum, TRACEHEADER )

         tr_index = 1 - nsamp

         do j = 1, ntrco
            call savew2 ( xsd_trace, ifmt_TrcNum, l_TrcNum, 
     :           ln_TrcNum, j, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz08, l_Horz08, 
     :           ln_Horz08, delta_mean, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz07, l_Horz07, 
     :           ln_Horz07, Min_Mean, TRACEHEADER )
            tr_index = tr_index + nsamp
            call vmov ( XSD_mean(tr_index), 1, xsd_trace(ITRWRD), 1, 
     :           nsamp )
            call wrtape ( luxsd, xsd_trace, obytes )
         enddo


c write spectral range output record

         RecNum = 2
         call savew2 ( xsd_trace, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :                 RecNum, TRACEHEADER )

         tr_index = 1 - nsamp

         do j = 1, ntrco
            call savew2 ( xsd_trace, ifmt_TrcNum, l_TrcNum, 
     :           ln_TrcNum, j, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz08, l_Horz08, 
     :           ln_Horz08, delta_range, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz07, l_Horz07, 
     :           ln_Horz07, Min_Range, TRACEHEADER )
            tr_index = tr_index + nsamp
            call vmov ( XSD_range(tr_index), 1, xsd_trace(ITRWRD), 1,
     :           nsamp )
            call wrtape ( luxsd, xsd_trace, obytes )
         enddo

c write spectral ratio output record

         RecNum = 3
         call savew2 ( xsd_trace, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :                 RecNum, TRACEHEADER )

         tr_index = 1 - nsamp
         
         do j = 1, ntrco
            call savew2 ( xsd_trace, ifmt_TrcNum, l_TrcNum, 
     :           ln_TrcNum, j, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz08, l_Horz08, 
     :           ln_Horz08, delta_ratio, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz07, l_Horz07, 
     :           ln_Horz07, Min_Ratio, TRACEHEADER )
            tr_index = tr_index + nsamp
            call vmov ( XSD_ratio(tr_index), 1, xsd_trace(ITRWRD), 1,
     :           nsamp )
            call wrtape ( luxsd, xsd_trace, obytes )
         enddo

c write spectral subband output record

         RecNum = 4
         call savew2 ( xsd_trace, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :                 RecNum, TRACEHEADER )

         tr_index = 1 - nsamp
         
         do j = 1, ntrco
            call savew2 ( xsd_trace, ifmt_TrcNum, l_TrcNum, 
     :           ln_TrcNum, j, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz08, l_Horz08, 
     :           ln_Horz08, delta_subband, TRACEHEADER )
            call savew2 ( xsd_trace, ifmt_Horz07, l_Horz07, 
     :           ln_Horz07, 1.0, TRACEHEADER )
            tr_index = tr_index + nsamp
            call vmov ( XSD_subband(tr_index), 1, xsd_trace(ITRWRD), 1,
     :           nsamp )
            call wrtape ( luxsd, xsd_trace, obytes )
         enddo

         if ( premature_eof ) goto 999

c close xsd dataset

         call lbclos ( luxsd )
      endif

c close data files 

      call lbclos ( luin )

      close (luglobal)
      close (lustats)

      if ( .not. qc ) then
         call lbclos ( luout )
         if ( picktap .ne. ' ' ) then
            close (lupick)
            call lbclos(luxsd)
         else
            close (lufunc)
         endif
         close (lukill)
         write(LERR,*)'  '
         write(LERR,*)' Total Traces Killed = ',kill_count
         write(LERR,*)'  '
      endif
      write(LERR,*)'tfskill: Normal Termination'
      write(LER,*)'tfskill: Normal Termination'
      stop

C ABNORMAL COMPLETION

 989  continue
      write(LERR,*) ' ' 
      write(LERR,*) ' TFSKILL: error opening global file: '
      write(LERR,*) '         check read/write permissions'
      write(LERR,*) '         and rerun'
      write(LERR,*) ' FATAL'        
      write(LER,*) ' ' 
      write(LER,*) ' TFSKILL: error opening global file: '
      write(LER,*) '         check read/write permissions'
      write(LER,*) '         and rerun'
      write(LER,*) ' FATAL' 
      stop
      
 990  continue
      write(LERR,*) ' ' 
      write(LERR,*) ' TFSKILL: error opening statistics file: '
      write(LERR,*) '         check read/write permissions'
      write(LERR,*) '         and rerun'
      write(LERR,*) ' FATAL'        
      write(LER,*) ' ' 
      write(LER,*) ' TFSKILL: error opening statistics  file: '
      write(LER,*) '         check read/write permissions'
      write(LER,*) '         and rerun'
      write(LER,*) ' FATAL' 
      stop
      
 991  continue
      write(LERR,*) ' ' 
      write(LERR,*) ' TFSKILL: error opening limiting function file: '
      write(LERR,*) '          check existence/permissions'
      write(LERR,*) '          and rerun'
      write(LERR,*) ' FATAL'        
      write(LER,*) ' ' 
      write(LER,*) ' TFSKILL: error opening limiting function file: '
      write(LER,*) '         check existence/permissions'
      write(LER,*) '         and rerun'
      write(LER,*) ' FATAL' 
      stop
      
 992  continue
      write(LERR,*) ' ' 
      write(LERR,*) ' TFSKILL: error opening kill stats file: '
      write(LERR,*) '          check permissions'
      write(LERR,*) '          and rerun'
      write(LERR,*) ' FATAL'        
      write(LER,*) ' ' 
      write(LER,*) ' TFSKILL: error opening kill stats file: '
      write(LER,*) '         check permissions'
      write(LER,*) '         and rerun'
      write(LER,*) ' FATAL' 
      stop

 999  continue

      call lbclos ( luin )
      close (lustats)
      close (luglobal)

      if ( .not. qc ) then
         call lbclos ( luout )
         if ( picktap .ne. ' ' ) then
            close (lupick)
            call lbclos(luxsd)
         else
            close (lufunc)
         endif
         close (lukill)
         write(LERR,*)' Traces Killed = ',kill_count
         write(LERR,*)' '
      endif

      write(LERR,*)'tfskill: ABNORMAL Termination'
      write(LER,*)'tfskill: ABNORMAL Termination'

      stop
      end
