C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln (ntap,otap,dt,dx,dy,dz,dkx,dky,
     1  square, hole, complex, reverse,zero,verbos)

c variables to be parsed and passed back to calling routine

      integer     argis, square, hole

      real        dt, dx, dy, dz, dkx, dky

      character   ntap*(*), otap*(*)

      logical     reverse, complex, zero, verbos 

C parse away

      complex = ( argis ('-complex') .gt. 0 )

      call argr4( '-dkx', dkx, 400.0, 400.0 )
      call argr4( '-dky', dky, 400.0, 400.0 )
      call argr4( '-dt', dt, 4.0, 4.0 )
      call argr4( '-dx', dx, 25.0, 25.0 )
      call argr4( '-dy', dy, 25.0, 25.0 )
      call argr4( '-dz', dz, 0.0, 0.0 )

      call argi4( '-hole', hole, 6, 6 )

      call argstr ( '-N', ntap, ' ', ' ' )

      call argstr ( '-O', otap, ' ', ' ' )

      reverse = ( argis ('-R') .gt. 0 )

      call argi4( '-square', square, 14, 14 )

      verbos = ( argis ('-V') .gt. 0 )

      zero = ( argis ('-zero') .gt. 0 )

      if ( dt .le. 32. ) then
         dt = dt / 1000.
      else
         dt = dt / 1000000.
      endif

      if ( abs(dz) .gt. 1.e-30 ) then
c this will make depth units kilometers or kilofeet
         dt = dz / 1000.
      endif
         
      return
      end



