C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cpunch ( rdata, nsamp, ntrc, nt, nt2, nx, cdata, nkx, 
     :     nky, square, hole, zero )

c  pick the noise threads from kk data, calculate an average comples value in
c   square-hole and apply in hole.

c  input

c      rdata  -  matrix of real input data
c      nsamp  -  # samps in rdata
c       ntrc  -  # traces in rdata
c         nt  -  power of 2 time samples
c         nx  -  power of 2 # traces
c        nkx  -  base position of thread in x
c        nky  -  base position of thread in y
c     square  -  linear dimension of a square around punch out aone
c       hole  - linear dimension of a square punch out zone inside square

c output

c      cdata  -  matrix of complex transformed values (x,iy)
c      rdata  -  split matrix of complex transformed values (r,theta)


c declare variables passed from calling routine

      integer nsamp, ntrc, nt, nt2, nx, nkx, nky, square, hole

      real rdata( nt2, nx )

      complex  cdata( nt, nx )

      logical zero

c declare local variables

      integer i, j, kx, ix, kxout, kt, iamp, ktout, iphase, count
      integer ii, jj

      DO kt= 1,nt,nkx
         DO kx= 1,nx,nky

            cout=(0,0)
            count=0

            if ((kt.ge.nkx) .OR. (kx.ge.nky)) then

               IF ( .not. zero ) THEN

c form average value in square outside of circle

                  do i= kt-square/2,kt+square/2
                     do j= kx-square/2,kx+square/2
                        if ((j .lt. kx-hole/2) .or. (j.gt.kx+hole/2)) 
     :                       then
                           if ((i .lt. kt-hole/2).or.(i.gt.kt+hole/2)) 
     :                          then
                              ii = i
                              jj=j
                              if (i .le.0 ) ii=i+nt
                              if (i .gt.nt ) ii=i-nt
                              if (j .le.0 ) jj=j+nx
                              if (j .gt.nx ) jj=j-nx
                              cout= cout + cdata(ii,jj)
                              count =count +1
                           endif
                        endif
                     enddo
                  enddo
               
                  cout= cout/count

c replace circle with average value

                  do i= kt-hole,kt+hole
                     do j= kx-hole,kx+hole
                        ii = i
                        jj=j
                        if (i .le.0 ) ii=i+nt
                        if (i .gt.nt ) ii=i-nt
                        if (j .le.0 ) jj=j+nx
                        if (j .gt.nx ) jj=j-nx
                        cdata(ii,jj) = cout
                     enddo
                  enddo

               ELSE

c just zero out data in circle

                  do i= kt-hole,kt+hole
                     do j= kx-hole,kx+hole
                        ii = i
                        jj=j
                        if (i .le.0 ) ii=i+nt
                        if (i .gt.nt ) ii=i-nt
                        if (j .le.0 ) jj=j+nx
                        if (j .gt.nx ) jj=j-nx
                        cdata(ii,jj) = cout
                     enddo
                  enddo

               ENDIF

            endif

         ENDDO
      ENDDO

c
c form amplitude and phase for output
c

      do  kx = 1, nx
 
         if (kx .gt. nx/2) then
            kxout = kx - nx/2
         else
            kxout = nx/2 + kx
         endif
 
         ix = kxout
 
         do  kt = 1, nt
 
            if (kt .gt. nt/2) then
               ktout = kt - nt/2
            else
               ktout = nt/2 + kt
            endif
 
            iamp   = nt  - ktout + 1
            iphase = nt2 - ktout + 1
 
            rdata(iamp, ix  ) = cabs ( cdata(kt,kx) )
 
            if (rdata(iamp, ix  ) .eq. 0.) then
               rdata(iphase, ix  ) = 0.
            else
               rdata(iphase, ix  ) =
     1              atan2 ( aimag(cdata(kt,kx)),
     2              real(cdata(kt,kx))  )
            endif
         enddo
      enddo

      return
      end
