C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c     TOAST : Terminate Objectionable Amplutide with
c               Spacial Temerity (Deedee Ragusa)
c
c             Toss Out All Stupid Traces (Marilyn Miller)
c     
c     
c	Amplitude Editt/QC program
c	James M. Gridley
c	USP Team
c	Tulsa OK
c	September 1997

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor
      character   ntap*255, otap*255, name*255, qctap*255

      logical     verbos, QC, Zero

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, errcd1, errcd2, errcd3, abort
      integer Headers, velocity

      real    Record, Record_WorkSpace
      real    Average_Val, Stan_Dev,Max_Val, A_Dev
      real    A_Dev_Window, Avg_Window
      real    Stan_Dev_Window,  A_Stan_Dev_Window
      real    Max_A_Dev, Area

      pointer (memadr_Record, Record(200000))
      pointer (memadr_Average_Val, Average_Val(200000))
      pointer (memadr_Max_Val, Max_Val(200000))
      pointer (memadr_Stan_Dev, Stan_Dev(200000))
      pointer (memadr_A_Dev, A_Dev(200000))
      pointer (memadr_A_Dev_Window, A_Dev_Window(200000))
      pointer (memadr_Avg_Window, Avg_Window(200000))
      pointer (memadr_Max_A_Dev, Max_A_Dev(200000))
      pointer (memadr_Space, Record_WorkSpace(200000))
      pointer (memadr_Headers, Headers(200000))
      pointer (memadr_Area, Area(200000))  
      pointer (memadr_A_Stan_Dev_Window, A_Stan_Dev_Window(200000))     
      pointer (memadr_Stan_Dev_Window, Stan_Dev_Window(200000))
      pointer (memadr_A_Dev_Trace, A_Dev_Trace(200000))
      pointer (memadr_Average_Val_Trace, Average_Val_Trace(200000))

c Program Specific _ static memory variables



      integer hdr_index, tr_index, JJ, KK

c Initialize variables

      data abort/0/
      data name/"TOAST"/

c     default the module to fix the data      
      Repair = 1

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters


      call cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos, iwin, N_SD, QC, Zero)
c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      
      if (QC) then
         len1=lenth(otap)
	 if (len1 .gt. 0) then
           qctap(1:len1)=otap(1:len1)
	 else
	   qctap(1:5) = 'toast'
           len1=5
	 endif
         qctap(len1+1:len1+3)='_QC'
 
         luin2 = 11
         open(unit=luin2, file=qctap(1:len1+3),status='unknown')
      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'TOAST: no line header on input file',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1

c     convert window length from time to samples
      iwin_sample =  int(iwin / nsi)
    

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

c verbose output of all pertinent information before processing begins

      call verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, verbos, iwin_sample, N_SD, Zero)
c dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      HeaderSize = ntrc * ITRWRD 

      call galloc (memadr_Record, RecordSize * SZSMPD, errcd1, abort)
      call galloc (memadr_Space, RecordSize * SZSMPD, errcd2, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd3, abort)
      call galloc (memadr_Average_Val,  RecordSize * 
     :     SZSMPD, errcd4, abort)
      call galloc (memadr_Stan_Dev,  RecordSize * 
     :     SZSMPD, errcd5, abort)
          call galloc (memadr_Max_Val,  RecordSize * 
     :     SZSMPD, errcd6, abort)
          call galloc (memadr_A_Dev,  RecordSize * 
     :     SZSMPD, errcd7, abort)
          call galloc (memadr_Max_A_Dev,  RecordSize * 
     :     SZSMPD, errcd8, abort)
          call galloc (memadr_Area,  RecordSize * 
     :     SZSMPD, errcd9, abort)
          call galloc (memadr_A_Stan_Dev_Window,  RecordSize * 
     :     SZSMPD, errcd10, abort)
          call galloc (memadr_A_Dev_Window,  RecordSize * 
     :     SZSMPD, errcd11, abort)
          call galloc (memadr_Avg_Window,  RecordSize * 
     :     SZSMPD, errcd12, abort)
          call galloc (memadr_Stan_Dev_Window,  RecordSize * 
     :     SZSMPD, errcd13, abort)
          call galloc (memadr_A_Stan_Dev_Window,RecordSize * 
     :     SZSMPD, errcd14, abort)
          call galloc (memadr_Average_Val_Trace,RecordSize * 
     :         SZSMPD, errcd15, abort)
          call galloc (memadr_A_Dev_Trace,RecordSize * 
     :         SZSMPD, errcd16, abort)

      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 .or.
     :     errcd4 .ne. 0 .or.
     :     errcd5 .ne. 0 .or.
     :     errcd6 .ne. 0 .or.
     :     errcd7 .ne. 0 .or.
     :     errcd8 .ne. 0 .or.
     :     errcd9 .ne. 0 .or.
     :     errcd10 .ne. 0 .or.
     :     errcd11 .ne. 0 .or.
     :     errcd12 .ne. 0 .or.
     :     errcd13 .ne. 0 .or.
     :     errcd14 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( Record_WorkSpace, 1, RecordSize )
      call vclr ( Headers, 1, HeaderSize )
      call vclr ( Average_Val, 1, RecordSize )
      call vclr ( Average_Val_Trace, 1, RecordSize )
      call vclr ( A_Dev_Trace, 1, RecordSize )
           QC = (argis('-qc') .gt. 0)


      call vclr ( Max_A_Dev, 1, RecordSize )
      call vclr ( A_Dev_Window, 1, RecordSize )
      call vclr ( Avg_Window, 1, RecordSize )
      call vclr ( Stan_Dev, 1, RecordSize)
      call vclr ( Max_Val, 1, RecordSize)
      call vclr ( Area, 1, RecordSize)
      call vclr ( A_Stan_Dev_Window, 1, RecordSize)
      call vclr ( Stan_Dev_Window, 1 , RecordSize)
      call vclr ( A_Stan_Dev_Window, 1 , RecordSize)

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

c load record to memory

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

          DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c set array load points for this trace 

           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

              call vmov ( itr(ITHWP1), 1, Record(tr_index), 1, nsamp )

           else
              call vclr ( Record(tr_index), 1, nsamp )
           endif

c load trace header to array Headers[]

            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

         ENDDO

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]
c========================================================================
c     get the correct number of samples in the analysis window
      
      Number_Windows = (iend - ist + 1)/iwin_sample
      
c     Policeman, be sure we have enough windows to cover all the data
c     if not then the last window will work from the end of the data
c     and count back.  This will be redundant for some data but it will
c     ensure that all data is being considered with similar conditions.
            
      if (Number_Windows*iwin_samples .lt. nsi) then
         Number_Windows = Number_Windows +1 
      endif
      
c========================================================================

      call Calculate_Average_Record (Record, Headers, Record_WorkSpace,
     :     nsamp, ntrc, ist, iend,
     :     iwin_sample, JJ, nsi, velocity,
     :     Average_Val,A_Dev,
     :     Number_Windows, Stan_Dev)


      do icounter_trace=1,ntrc
         
         call Calculate_Average_Trace (Record, Headers, 
     :        Record_WorkSpace,
     :        nsamp, ntrc, ist, iend,
     :        iwin_sample, JJ, nsi, velocity,
     :        Average_Val_Trace,A_Dev_Trace,
     :        Number_Windows,icounter_trace) 
         
         do irun = 1,Number_Windows
            
            if ((Average_Val_Trace(irun)) .gt. 
     :           (Average_Val(irun)+ (N_SD)*Stan_Dev(irun))) 
     :           then
        
            StaCor = 30000
          
            call savew2 ( Headers((icounter_trace-1)*ITRWRD +1),
     :           ifmt_StaCor,
     :           l_StaCor, ln_StaCor, StaCor , TRACEHEADER)

            if (QC) then
               write(luin2,*)JJ,icounter_trace
            endif
            
            write(LERR,*)JJ,icounter_trace,'    Killed at ',
     :           (irun-1)*nsi*iwin_sample,' - ',irun*nsi*iwin_sample

            if (Zero) then
              
               call  Zero_Trace  (Record, Headers, Space,
     :              nsamp, ntrc, ist, iend,
     :              iwin_sample, JJ, nsi,icounter_trace)
            endif
            
         endif
      enddo
      
      enddo
      
c     reset array load points for this trace 

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

c write output data

         DO KK = 1, ntrc

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD

            call vmov ( Record(tr_index), 1, itr(ITHWP1), 1, nsamp )
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape (luout, itr, obytes)
 
         ENDDO
      ENDDO

c close data files 

      if (qc) close (unit=11)
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'TOAST: Normal Termination'
      write(LER,*)'TOAST: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'TOAST: ABNORMAL Termination'
      write(LER,*)'TOAST: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for TOAST'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-win[] -- analysis window length       (1000 ms )'
      write(LER,*)'-nsd[] -- Number of Standard Deviations for '
      write(LER,*)'                    trace killing             (1)'
      write(LER,*)'-qc   --Output qc file of rec/trc killed/repaired'
      write(LER,*)'          by the module.  filename = stdin_qc'
      write(LER,*)'-Z    -- Zero bad traces '
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       d_kill -N[] -O[] -s[] -e[] -rs[] -re[]'
      write(LER,*)'             -win[]  ( -Z -qc -V)'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos, iwin, N_SD, QC, Zero)


#include <f77/iounit.h>

      integer    ist, iend, irs, ire, argis, iwin
      integer    N_SD


      character  ntap*(*), otap*(*), name*(*)

      logical    verbos, QC, Zero

           call argi4 ( '-e', iend, 0, 0 )

           call argi4 ( '-nsd', N_SD, 1, 1 )
           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           QC = (argis('-qc') .gt. 0)

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )
       
           verbos = (argis('-V') .gt. 0)

           call argi4 ( '-win', iwin, 1000, 1000 )

           Zero = (argis('-Z') .gt. 0)
        
c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, verbos, iwin_sample, N_SD, Zero)
  

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, nsi
      integer    N_SD
      character  ntap*(*), otap*(*)

      logical    verbos, Repair, Zero

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' window length           = ', iwin_sample*nsi
      write(LERR,*) ' Using ',N_SD,' Standard Deviations'
      if (Zero) write(LERR,*) 'Zeroing Dead traces'
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





