C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C	Name:		NEXT
C
C	Purpose:	To return arguments separated by a comma or
C				other delimiter.
C
C	Usage:		How do I use it?
C
C	Notes:		Returns output text to the next delimitor
C				or to the last non-blank character
C			
C
C	Author:		Chester A. Jacewicz	Cray
C
C	Revised:	29 Jun 1988
C			05 July 1988	no blanks in text
C			16Aug89 ...	fixed bug in output text
C					installed test for len(TEXTOT)
C			13Oct89 ...	allowed blanks as delimitor
C
C.............................................................................
C				
        SUBROUTINE NEXT(ISTART,DELIM,TEXTIN,TEXTOT)
C
c       IMPLICIT NONE
C
        CHARACTER * 1        DELIM
        CHARACTER * (*)        TEXTIN,TEXTOT
C
        EXTERNAL       BLANK,ISBLNK
C
        INTEGER       IDELIM,ILAST,ISTART
        INTEGER        LUNERR

        SAVE

        LUNERR=0
C
        CALL BLANK(TEXTOT)
        CALL ISBLNK(TEXTIN,ILAST)
C       WRITE(LUNERR,*)'ISBLNK ... ILAST:',ILAST
C
        IF(ISTART.GT.LEN(TEXTIN) .OR. ISTART.GT.ILAST .OR. 
     *          ILAST.EQ.0 ) THEN
                ISTART=0
                RETURN
                ENDIF
C
C	At this point the portion being examined contains non-blanks
C		but not necessarily DELIM
C
        IDELIM=INDEX(TEXTIN(ISTART:ILAST),DELIM)
C       WRITE(LUNERR,*)'INDEX ... IDELIM:',IDELIM
C
        IF(IDELIM.GT.0) THEN
C
C		Found it !!!
C
                TEXTOT=TEXTIN(ISTART:
     *                ISTART+MIN((IDELIM-1) -1,LEN(TEXTOT)-1) )
C
C               Point BEYOND last delimiter
                ISTART=ISTART+IDELIM
C
                ELSE
C
C		DELIM missing ... What to do ?
C				Return the remainder
C
                        TEXTOT=TEXTIN(ISTART:
     *                        ISTART+ (MIN(LEN(TEXTIN),LEN(TEXTOT))-1) )
                        ISTART=LEN(TEXTIN)+1
C 
                ENDIF
C
        RETURN
        END
