C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C	Name:		trched
C
C	Purpose:	dump/manipulate SIS header values
C
C	Usage:		trched [-Nntap] [-Ootap] [-re ending record] 
C				[-d:header value name]
C
C	Revision 1  initial release
C		28 June 1988 Chester A. Jacewicz
C		25 July 1988	removed references to RTAPE4
C		19 Sept 1988	set value to zero before SAVER
C				general debugging listing for every large trace
C				removed full path names of *.inc
C		20 Sept 1988	use SAVERX for TrHdId
C		11 Oct	1988	added trace sample dumps
C		26Dec88		added -mw,-mc for modular header counts
C		27Dec88		enabled -ns,-ne option
C		28Dec88		enabled -ri option for record increment
C		30Dec88		enabled -rs option for starting record
C		20Mar89		added -d option for log on changes
C		03Apr89		added -P mode to pass selected trace header
C					values
C		16Aug89	...	added OAC to manipulate header values
C		16Aug89 ...	added evaluate option e:
C               28Aug89 ... added { ... } conditional clause
C		            added -t tag option
C		05Oct89	...	moved to Sun,gmake	Paul Gutowski
C		06Oct89 ...	debugging Sun version
C		09Oct89	...	pass only 6 characterst to SAVER
C		13Oct89 ...	add -s" " special character for separator
C		18oct89 ...	archieved to trched_1
C			...	begin { expression .TEST. expression | expression }
C			...		no expression 1 ... use IREG(0)
C			...		no expression 2 ... use 0
C			...		no expression 3 ... noop
C			...	added STOP option
C		23oct89	...	added AND,OR,XOR 
C               26Oct89 ...     converted EXIT to STOP
C		30Oct89 ...     added KILL option
C		09Nov89 ...	minor fixes
C               09May90 ...     fixed test for remainder (%)
C                       ...     fixed good/bad code logic
C
C               06Nov90 ..      added SAVE statement for fix on Cray2
C                               Fixed IREG(100) to IREG(0:100)
C                               Cleanup source and printout
C               11aug93 ...     Fixed broken evaluation logic
C                               and convert to saver2,savew2
C                               and ~ for .NOT.
C
C	Amoco Proprietary Information
C
C...............................................................................
C
        PROGRAM       trhd
C
C	Conditional on Cray
C
        IMPLICIT NONE
C
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>

        INTEGER MAXMEM
        PARAMETER (MAXMEM=10)

        INTEGER NCODES
        PARAMETER (NCODES=120)

        INTEGER NCODE
        PARAMETER (NCODE=512)
C
C	VARIABLE TYPES FOLLOW
C
        CHARACTER*6     BADCOD
        CHARACTER * 512 CLINE
        CHARACTER*1     DELIM,DELIME
        CHARACTER * (NCODES) HDCODA,HDCODB,HDCODC,HDCODD
C       CHARACTER*256   HDCODE
        CHARACTER*(NCODE) HDCODE
        CHARACTER*120   HDCODM
        CHARACTER * 6   HDCOD1,HDCOD2
        CHARACTER * 4   HLHMSG
        CHARACTER*6     KILCOD
#include <f77/pid.h>
        character * 8   name
C
C	Input tape file spec
C
        CHARACTER * 120 NTAP
        CHARACTER*9     PGM
        CHARACTER*11     PGMNME
C
C		Output tape file spec
C
        CHARACTER * 120 OTAP
        CHARACTER*50        SAVMSG
C
C       Condtional test
C
        CHARACTER*2     TEST
        CHARACTER*120       TEXT
        CHARACTER*50    TAG
C
C	Title for GAMACO torch and oval
C	Outputs 66 long strings
C
        CHARACTER * 66 TITLE
C
        EXTERNAL ARGI4
        EXTERNAL ARGIS
        EXTERNAL BLANK
        EXTERNAL CHKFLG,CMDHLH,CMDLIN
        EXTERNAL GAMOCO
        EXTERNAL GETLN,GETPPS
        EXTERNAL HLHPRT
        
C
        EXTERNAL NEXT
C
c       EXTERNAL MODGLU
C
        EXTERNAL RTAPE,SAVER,SAVEW
        EXTERNAL SAVHLH,SPIN
        EXTERNAL UNITS,UNUSED
        EXTERNAL WRTAPE
C
C	Line header size
C
C
C	Pointers to Line header or Trace header structures
C
C
        INTEGER ARGIS, recnum, trcnum
        INTEGER ENDREC
        INTEGER ENDSAM
        INTEGER FORMAT
        INTEGER HDVALU
        INTEGER l_HDCOD1
        INTEGER l_HDCOD2
        INTEGER l_HDCODA (100), l_HDCODB (100)
        INTEGER l_HDCODC (100), l_HDCODD (100)
        INTEGER l_HDCODE (NCODE), l_HDCODM (100)

        INTEGER ifmt_TrcNum, ifmt_RecNum, ifmt_KILCOD
        INTEGER ifmt_HDCODD, ifmt_HDCODM
        INTEGER ln_TrcNum, ln_RecNum, ln_KILCOD
        INTEGER ln_HDCODD, ln_HDCODM

        INTEGER IFMTA(NCODES),LENA(NCODES)
        INTEGER IFMTB(NCODES),LENB(NCODES)
        INTEGER IFMTC(NCODES),LENC(NCODES)
        INTEGER IFMTD(NCODES),LEND(NCODES)
        INTEGER IFMTE(NCODE),LENE(NCODE)
        INTEGER IFMTM(NCODE),LENM(NCODE)
C
C	FIRST occurance of current header value
C       
        INTEGER IBONE
C
C       First occurence of changed header value
C
        INTEGER IBTWO
        INTEGER IDOTOO,IDBVAL
C
        INTEGER IONA,IONB,IONC,IOND,IONM
        INTEGER IOLD,IONE
C
C       Memory registers
C
        INTEGER IMEM(MAXMEM)
C
C       Arithmetic registers
C
        INTEGER IREG(0:100)
        INTEGER IERR,ITEMP
        INTEGER * 2 ITR2 (SZLNHD)
        INTEGER     ITR4 (SZLNHD)
        REAL        head (SZLNHD)
        INTEGER ITRACE,ITROUT
C
C       Value for a dead trace
C
        INTEGER KILVAL
C
C       Current memory location
C
        INTEGER KMEM
        INTEGER KMODER
C
C       Current arithmetic register
C
        INTEGER KREG
C
C       Left,right comparison registers
C  
        INTEGER KREGL,KREGR
        INTEGER KTRACE
        INTEGER LBYTE
C
C	Disk bytes
C
        INTEGER LBYTOT
C
        INTEGER LUNDMP
C
C	Standard Error
C
        INTEGER LUNERR
        INTEGER LUNIN
c       INTEGER LUNINP
        INTEGER LUNOT
        INTEGER LUNOUT
C
C	Logical printer
C
        INTEGER LUNPRT
C
	INTEGER MODER,MSGLEN
        INTEGER NBCMDL,NE,NRI,NRS,NS
C
C	Number of traces to skip in print out
C
        INTEGER NSKIP
        INTEGER OLDVAL
C
C	SIS line header variables
C
        INTEGER NUMREC
        INTEGER NUMSMP
        INTEGER NMRCIN,NMTRIN,NMTROT
        INTEGER PID,PPID
        INTEGER SAVER,SAVER2,SAVEW,SAVEW2,SMPINT
C
C	Misc. variables
C
        INTEGER I,J
        INTEGER IENDA,IENDB,IENDC,IENDD,IENDE,IENDM
        INTEGER ISTA,ISTB,ISTE
        INTEGER ISAVE,JERR,JJ
        INTEGER NRIK
        INTEGER L_KILCOD,L_RECNUM,L_TRCNUM
C
C	Logical variables
C
        LOGICAL CHKFLG,ICOND,IDEBUG
C
C       First time in e: logic
C
        LOGICAL IEONE
        LOGICAL ILOG,ILOGC,ILOGE
C
C       Inside a conditional
C
        LOGICAL INCOND
        LOGICAL ISAND,ISIOR,ISXOR,ISNOT
        LOGICAL ISPIN,ISTOP
        LOGICAL KCOND,GETVAL
        LOGICAL PUTVAL
        LOGICAL QUERY
        LOGICAL keep
        LOGICAL first

        equivalence (itr2(1), itr4(1), head(1))
C
C	Real variables
C
C
C	Now for initialization statements
C
        DATA DELIM/','/,INCOND/.FALSE./, delime/','/
        DATA HLHMSG/'TEST'/,KILCOD/'StaCor'/,PGM/'trched:   '/
        DATA IDEBUG/.TRUE./, keep/.false./
        DATA KILVAL/30000/,KREGL/1/,KREGR/2/
        DATA KMODER/0/,MSGLEN/4/
        data name/'TRCHED'/
C
c       DATA LUNDMP/66/
c       DATA LUNERR/0/
c       DATA LUNINP/5/,LUNOUT/6/
C
        DATA IEONE/.FALSE./,ISTOP/.FALSE./
        DATA first/.true./
C
C       SAVE is needed for Cray2
C
        SAVE
C
        LUNOUT = LER
C
        QUERY = ( ARGIS ('-?') .GT. 0 ) 
C
C
        IF(QUERY) THEN
C
                WRITE(LUNOUT,*)'HELP OPTION SELECTED'
                WRITE(LUNOUT,*)'Try "Man trched"'
                stop
        ENDIF
C
C	Setup
#include <f77/open.h>
C--------------------------------------------------------
c  get initial command line args
        call cmdln0 (ntap,otap,idbval,tag,ispin,LERR,
     1                     pgm,pgmnme,name)
C--------------------------------------------------------


        IF(IDBVAL.NE.0) THEN
                IDEBUG=.TRUE.
                ELSE
                IDEBUG=.FALSE.
                ENDIF
C
        IF(IDEBUG) THEN
                ITEMP=LER
                ELSE
                ITEMP=LERR
                ENDIF
C
        LUNPRT = ITEMP
        LUNERR = ITEMP
        LUNDMP = ITEMP
        LUNOUT = ITEMP
C
        WRITE(LUNOUT,*)PGMNME//' 12aug93a'
C
        SAVMSG='**** No such trace header code ****'
C
        CALL CMDLIN(CLINE,NBCMDL)
        write(lunout,*)' '
        WRITE(LUNOUT,*)'Command line:'
        WRITE(LUNOUT,*)CLINE(1:NBCMDL)
        write(lunout,*)' '
C
        CALL UNITS(LUNOUT,0,100) 
        CALL GETPPS(PID,PPID)
        WRITE(LUNOUT,*)PGMNME//'Parent Process ID; Child Process ID'
        WRITE(LUNOUT,*)PGMNME//'      ',PPID,'             ',PID
        ILOGC=.TRUE.
C
C	Body of the program
        TITLE = ' Output from trched'
C
C       Blowoff in GAMOCO
C       CALL GAMOCO(TITLE,1,LUNPRT)
C
C	READ PROGRAM PARAMETERS FROM COMMAND LINE
C
C	Test if help is desired
C
C	Fetch input file name from command line
C
C
        CALL GETLN ( LUNIN, NTAP, 'R',0 )
C	Read line header
C
        CALL RTAPE ( LUNIN, itr2, LBYTE)

C
        IF( LBYTE  .EQ. 0 ) THEN
                WRITE(LUNOUT,*) PGMNME//
     *        'NO LINE HEADER READ FROM UNIT: ',LUNIN
                GOTO 995
                ENDIF
C
        CALL GETLN ( LUNOT, OTAP, 'W',1 )
C
c-----------------------------------------------------------------
c  save values from line header
        ISAVE=SAVER ( ITR2, 'Format', FORMAT, LINHED )
        ISAVE=SAVER ( ITR2, 'NumRec', NMRCIN, LINHED )
        ISAVE=SAVER ( ITR2, 'NumSmp', NUMSMP, LINHED )
        ISAVE=SAVER ( ITR2, 'NumTrc', NMTRIN, LINHED )
        ISAVE=SAVER ( ITR2, 'SmpInt', SMPINT, LINHED )

        WRITE(LUNOUT,*)PGMNME//'Format: ',FORMAT
        WRITE(LUNOUT,*)PGMNME//'NumRec: ',NMRCIN
        WRITE(LUNOUT,*)PGMNME//'NumSmp: ',NUMSMP
        WRITE(LUNOUT,*)PGMNME//'NumTrc: ',NMTRIN
        WRITE(LUNOUT,*)PGMNME//'SmpInt: ',SMPINT
c-----------------------------------------------------------------


C
        text(1:1) = delim
c-----------------------------------------------------------------
c   main command line arguments
        call       cmdln (nmtrin,nmrcin,lunout,nskip,ns,ne,nrs,endrec,
     1                    nri,hdcoda,hdcodb,hdcodc,hdcodd,hdcode,hdcodm,
     2                    endsam,numsmp,text,delime,pgmnme,keep,moder)

        if (nskip .lt. 0) moder = 1

c-----------------------------------------------------------------
        delim = delime
c
C       First time through evaluation logic
C
        IF(HDCODE.NE.' ') IEONE=.TRUE.
C
        if (keep) then
           nrik = nri
           nri  = 1
        else
           nrik = 1
        endif

        ENDREC=MIN(NMRCIN,ENDREC)
        NUMREC=MIN(NMRCIN,1+( (ENDREC-NRS)/NRI ) )
        WRITE(LUNOUT,*)PGMNME//'Output number of records: ',NUMREC
C
        ISAVE=SAVEW(ITR2,'NumRec',NUMREC,LINHED)
C
C
        NUMSMP=ENDSAM
C
        ISAVE=SAVEW(ITR2,'NumSmp',NUMSMP,LINHED)
C
        WRITE(LUNOUT,*)PGMNME//'ENDSAM: ',ENDSAM
C
        IF(NE.LE.0) THEN
                NE=NMTRIN
                ENDIF
C
        NMTROT=1+NE-NS
        WRITE(LUNOUT,*)PGMNME//'Output number of traces: ',NMTROT
        ISAVE=SAVEW(ITR2,'NumTrc',NMTROT,LINHED)
C
C	Update line header with command line
C
c       WRITE(LUNDMP,*)PGMNME//
c    *        'LBYTE,LBYTOT before CMDHLH: ',LBYTE,LBYTOT
        CALL CMDHLH(ITR2,LBYTE,LBYTOT)
c       WRITE(LUNDMP,*)PGMNME//
c    *        'LBYTE,LBYTOT from CMDHLH: ',LBYTE,LBYTOT
C
C	Write out line header
C
        CALL WRTAPE(LUNOT,ITR2,LBYTOT)
C
C	Write line header to logical printer

        MSGLEN=0
c       WRITE(LUNPRT,*) PGMNME//'Updated header'
c       WRITE(LUNOUT,*)PGMNME//
c    *        'Before HLHPRT ... LBYTOT,MSGLEN: ',LBYTOT,MSGLEN
C
C	Note:	HLHPRT seems to overwrite previous output files.
C
 	CALL HLHPRT( ITR2,LBYTOT,HLHMSG,MSGLEN,LUNPRT )
c       WRITE(LUNOUT,*)PGMNME//
c    *        'After HLHPRT ............LBYTOT: ',LBYTOT
c       CALL HLHDMP(ITR2,LBYTOT,LUNPRT,80)
C
c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu( KILCOD ,ifmt_KILCOD,l_KILCOD,ln_KILCOD,TRACEHEADER)
      if (HDCODD(1:1) .ne. ' ')
     1 call savelu( HDCODD(1:6) ,ifmt_HDCODD,l_HDCODD,ln_HDCODD,
     2              TRACEHEADER)
      if (HDCODM(1:1) .ne. ' ')
     1 call savelu( HDCODM(1:6) ,ifmt_HDCODM,l_HDCODM,ln_HDCODM,
     2              TRACEHEADER)

      write(LERR,*)'Header Positions Read'
      write(LERR,*)' '

      IF (HDCODA .ne. ' ') THEN

         IONA = 1
         j = 0
         do  i = 1, 100
             CALL NEXT(IONA,DELIM,HDCODA,HDCOD1)
C
C------Check for valid codes--------------------------------------
C
        IF(HDCOD1(1:1).NE.'<' .AND.
     *     HDCOD1(1:1).NE.'>' .AND.
     *     HDCOD1(1:1).NE.'+' .AND.
     *     HDCOD1(1:1).NE.'-' .AND.
     *     HDCOD1(1:1).NE.'*' .AND.
     *     HDCOD1(1:1).NE.'/' .AND.
     *     HDCOD1(1:1).NE.'%' .AND.
     *     HDCOD1(1:1).NE.'[' .AND.
     *     HDCOD1(1:1).NE.']' .AND.
     *     HDCOD1(1:1).NE.'{' .AND.
     *     HDCOD1(1:1).NE.'}' .AND.
     *     HDCOD1(1:1).NE.'.' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'|' .AND.
     *     HDCOD1(1:1).NE.'^' .AND.
     *     HDCOD1(1:1).NE.'~' .AND.
     *     HDCOD1(1:1).NE.'!'      )  THEN

             if (ionA .eq. 0) then
                 iendA = j
                 go to 32
             endif
             j = j + 1
             call savelu ( HDCOD1,ifmta(j),l_HDCODA(j),lena(j),
     1                     TRACEHEADER)
             write(LERR,*)'A: I = ',j,' Mnemonic= ',HDCOD1,
     1       ' Position= ',l_HDCODA(j),' Format= ',ifmta(j),
     2       ' Length= ',lena(j)

             ENDIF
         enddo

32       continue
         write(LERR,*)'Total number mnemonics found =  ',iendA
      write(LERR,*)' '
      ENDIF
      IF (HDCODB .ne. ' ') THEN

         IONB = 1
         j = 0
         do  i = 1, 100
             CALL NEXT(IONB,DELIM,HDCODB,HDCOD1)
C
C------Check for valid codes--------------------------------------
C
        IF(HDCOD1(1:1).NE.'<' .AND.
     *     HDCOD1(1:1).NE.'>' .AND.
     *     HDCOD1(1:1).NE.'+' .AND.
     *     HDCOD1(1:1).NE.'-' .AND.
     *     HDCOD1(1:1).NE.'*' .AND.
     *     HDCOD1(1:1).NE.'/' .AND.
     *     HDCOD1(1:1).NE.'%' .AND.
     *     HDCOD1(1:1).NE.'[' .AND.
     *     HDCOD1(1:1).NE.']' .AND.
     *     HDCOD1(1:1).NE.'{' .AND.
     *     HDCOD1(1:1).NE.'}' .AND.
     *     HDCOD1(1:1).NE.'.' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'|' .AND.
     *     HDCOD1(1:1).NE.'^' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'!'      )  THEN

             if (ionb .eq. 0) then
                 iendb = j
                 go to 33
             endif
             j = j + 1
             call savelu ( HDCOD1,ifmtb(j),l_HDCODB(j),lenb(j),
     1                     TRACEHEADER)
             write(LERR,*)'B: I = ',j,' Mnemonic= ',HDCOD1,
     1       ' Position= ',l_HDCODB(j),' Format= ',ifmtb(j),
     2       ' Length= ',lenb(j)
             ENDIF
         enddo

33       continue
         write(LERR,*)'Total number mnemonics found =  ',iendb
      write(LERR,*)' '
      ENDIF
      IF (HDCODC .ne. ' ') THEN

         IONC = 1
         j = 0
         do  i = 1, 100
             CALL NEXT(IONC,DELIM,HDCODC,HDCOD1)
C
C------Check for valid codes--------------------------------------
C
        IF(HDCOD1(1:1).NE.'<' .AND.
     *     HDCOD1(1:1).NE.'>' .AND.
     *     HDCOD1(1:1).NE.'+' .AND.
     *     HDCOD1(1:1).NE.'-' .AND.
     *     HDCOD1(1:1).NE.'*' .AND.
     *     HDCOD1(1:1).NE.'/' .AND.
     *     HDCOD1(1:1).NE.'%' .AND.
     *     HDCOD1(1:1).NE.'[' .AND.
     *     HDCOD1(1:1).NE.']' .AND.
     *     HDCOD1(1:1).NE.'{' .AND.
     *     HDCOD1(1:1).NE.'}' .AND.
     *     HDCOD1(1:1).NE.'.' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'|' .AND.
     *     HDCOD1(1:1).NE.'^' .AND.
     *     HDCOD1(1:1).NE.'~' .AND.
     *     HDCOD1(1:1).NE.'!'      )  THEN

             if (ionC .eq. 0) then
                 iendC = j
                 go to 34
             endif
             j = j + 1
             call savelu ( HDCOD1,ifmtc(j),l_HDCODC(j),lenc(j),
     1                     TRACEHEADER)
             write(LERR,*)'C: I = ',j,' Mnemonic= ',HDCOD1,
     1       ' Position= ',l_HDCODC(j),' Format= ',ifmtc(j),' Length= ',
     2         lenc(j)
             ENDIF
         enddo

34       continue
         write(LERR,*)'Total number mnemonics found =  ',iendC
      write(LERR,*)' '
      ENDIF
      IF (HDCODD .ne. ' ') THEN

         IOND = 1
         j = 0
         do  i = 1, 100
             CALL NEXT(IOND,DELIM,HDCODD,HDCOD1)
C
C------Check for valid codes--------------------------------------
C
        IF(HDCOD1(1:1).NE.'<' .AND.
     *     HDCOD1(1:1).NE.'>' .AND.
     *     HDCOD1(1:1).NE.'+' .AND.
     *     HDCOD1(1:1).NE.'-' .AND.
     *     HDCOD1(1:1).NE.'*' .AND.
     *     HDCOD1(1:1).NE.'/' .AND.
     *     HDCOD1(1:1).NE.'%' .AND.
     *     HDCOD1(1:1).NE.'[' .AND.
     *     HDCOD1(1:1).NE.']' .AND.
     *     HDCOD1(1:1).NE.'{' .AND.
     *     HDCOD1(1:1).NE.'}' .AND.
     *     HDCOD1(1:1).NE.'.' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'|' .AND.
     *     HDCOD1(1:1).NE.'^' .AND.
     *     HDCOD1(1:1).NE.'~' .AND.
     *     HDCOD1(1:1).NE.'!'      )  THEN

             if (ionD .eq. 0) then
                 iendD = j
                 go to 35
             endif
             j = j + 1
             call savelu ( HDCOD1,ifmtd(j),l_HDCODD(j),lend(j),
     1                     TRACEHEADER)
             write(LERR,*)'D: I = ',j,' Mnemonic= ',HDCOD1,
     1       ' Position= ',l_HDCODD(j),' Format= ',ifmtd(j),' Length= ',
     2       lend(j)
             ENDIF
         enddo

35       continue
         write(LERR,*)'Total number mnemonics found =  ',iendD
      write(LERR,*)' '
      ENDIF
      IF (HDCODE .ne. ' ') THEN

         IONE = 1
         j = 0
         do  i = 1, NCODE

             j = IONE
             CALL NEXT(IONE,DELIM,HDCODE,HDCOD1)
C

             if (ionE .eq. 0) then
                 iende = j
                 go to 36
             endif

        IF(HDCOD1(1:1).NE.'<' .AND.
     *     HDCOD1(1:1).NE.'>' .AND.
     *     HDCOD1(1:1).NE.'+' .AND.
     *     HDCOD1(1:1).NE.'-' .AND.
     *     HDCOD1(1:1).NE.'*' .AND.
     *     HDCOD1(1:1).NE.'/' .AND.
     *     HDCOD1(1:1).NE.'%' .AND.
     *     HDCOD1(1:1).NE.'[' .AND.
     *     HDCOD1(1:1).NE.']' .AND.
     *     HDCOD1(1:1).NE.'{' .AND.
     *     HDCOD1(1:1).NE.'}' .AND.
     *     HDCOD1(1:1).NE.'.' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'|' .AND.
     *     HDCOD1(1:1).NE.'^' .AND.
     *     HDCOD1(1:1).NE.',' .AND.
     *     HDCOD1(1:1).NE.'!' .AND.
     *     HDCOD1(1:6) .NE. 'Consta' .AND.
     *     HDCOD1(1:6) .NE. 'Memory') THEN

             call savelu ( HDCOD1,ifmte(j),l_HDCODE(j),lene(j),
     1                     TRACEHEADER)
           ELSE
             ifmte(j) = 0
             lene(j)  = 0
           ENDIF
             write(LERR,*)'E: I = ',j,' Mnemonic= ',HDCOD1,
     1       ' Position= ',l_HDCODE(j),' Format= ',ifmte(j),
     2       ' Length= ',lene(j)

         enddo

36       continue
         write(LERR,*)'Total number mnemonics found =  ',iendE
      write(LERR,*)' '
      ENDIF
      IF (HDCODM .ne. ' ') THEN

         IONM = 1
         j = 0
         do  i = 1, 100
             CALL NEXT(IONM,DELIM,HDCODM,HDCOD1)
C
C------Check for valid codes--------------------------------------
C
        IF(HDCOD1(1:1).NE.'<' .AND.
     *     HDCOD1(1:1).NE.'>' .AND.
     *     HDCOD1(1:1).NE.'+' .AND.
     *     HDCOD1(1:1).NE.'-' .AND.
     *     HDCOD1(1:1).NE.'*' .AND.
     *     HDCOD1(1:1).NE.'/' .AND.
     *     HDCOD1(1:1).NE.'%' .AND.
     *     HDCOD1(1:1).NE.'[' .AND.
     *     HDCOD1(1:1).NE.']' .AND.
     *     HDCOD1(1:1).NE.'{' .AND.
     *     HDCOD1(1:1).NE.'}' .AND.
     *     HDCOD1(1:1).NE.'.' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'|' .AND.
     *     HDCOD1(1:1).NE.'^' .AND.
     *     HDCOD1(1:1).NE.'~' .AND.
     *     HDCOD1(1:1).NE.'!'      )  THEN

             if (ionM .eq. 0) then
                 iendM = j
                 go to 37
             endif
             j = j + 1
             call savelu ( HDCOD1,ifmtm(j),l_HDCODM(j),lenm(j),
     1                     TRACEHEADER)
             write(LERR,*)'M: I = ',j,' Mnemonic= ',HDCOD1,
     1       ' Position= ',l_HDCODM(j),' Format= ',ifmtm(j),' Length= ',
     2       lenm(j)
             ENDIF
         enddo

37       continue
         write(LERR,*)'Total number mnemonics found =  ',iendM
      write(LERR,*)' '
      ENDIF

C	Loop on traces
C
C
C
        WRITE(LUNOUT,*)PGMNME//'Unused command line arguments if any'
        CALL UNUSED(LUNOUT)
C
C
C	Setup DO WHILE loop
C
        ITRACE = 0
        KTRACE = 0
        ITROUT=0
C
        WRITE(LUNOUT,*)' '
C
c-------------------------------------------
C       Skip input records if requested
        call recskp (1,nrs-1,lunin,nmtrin,ITR2)
        ITRACE = nmtrin*(nrs-1)
c-------------------------------------------
C
C	Process next record
C        
      do  100  jj = nrs, endrec, nri
C
c-----------------------------------------------
c       Skip into current record if necessary
        call trcskp (jj,1,ns-1,lunin,nmtrin,ITR2)
        itrace = itrace + ns-1
c-----------------------------------------------
C
        DO 103 IDOTOO=NS,NE
C        
        LBYTE=0
        CALL RTAPE(LUNIN,ITR2,LBYTE)
c       isave = saver (ITR2, 'RecNum', recnum, TRCHED)
c       isave = saver (ITR2, 'TrcNum', trcnum, TRCHED)
c       recnum = itr2 (l_RecNum)
c       trcnum = itr2 (l_TrcNum)
        ierr = saver2(ITR2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              recnum, TRACEHEADER)
        ierr = saver2(ITR2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              trcnum, TRACEHEADER)


c--------------------

        IF (keep .and. mod(jj-1,nrik).eq.0 .OR. .not. keep) THEN

        ILOG=.FALSE.
        IF(LBYTE.LE.0) GOTO 900
        KTRACE=KTRACE+1
C
        ITRACE=ITRACE+1
C
C	Test changed values	(want to later consider EOF as change)
C
        IF(HDCODD.NE.' ') THEN
C
        
        ierr = saver2(ITR2,ifmt_HDCODD,l_HDCODD, ln_HDCODD,
     1                HDVALU, TRACEHEADER)

c       IF(SAVER(ITR2,HDCODD(1:6),HDVALU,TRCHED).EQ.0) THEN
        IF(ierr .EQ. 0) THEN
                BADCOD=HDCODD(1:6)
                GOTO 950
                ENDIF
C
        IBTWO=KTRACE
C
        IF(KTRACE.EQ.1) THEN
                OLDVAL=HDVALU+1
                IBONE=KTRACE
                IBTWO=KTRACE
                ENDIF
C
        IF(OLDVAL.NE.HDVALU) THEN
                ILOG=.TRUE.
C
                IF(KTRACE.NE.1) THEN
                        WRITE(LUNOUT,*)PGMNME//
     *                  'Trace count... d: ', ITRACE
     *                  ,' (',IBTWO-IBONE,')'
     *                        ,'  ',HDCODD(1:6)//': '
     *                        ,OLDVAL
                        ENDIF
C
                OLDVAL=HDVALU 
                IBONE=IBTWO
                ELSE
                ILOG=.FALSE.
                ENDIF
                ENDIF
C
                IONC=1
C
                IF(MOD(ITRACE,NSKIP).EQ.0.AND.(NSKIP.GT.0) ) ILOG=.TRUE.
C
C...............Log before headers changed if requested.................
C
        IF(ILOG) THEN
C
                IONB=1
                istb = 1
C
200             CONTINUE
C
                CALL NEXT (IONB,DELIM,HDCODB,HDCOD1)
                IF(IONB.EQ.0) GOTO 300
                        CALL NEXTLU(istb,iendb,l_HDCODB,l_HDCOD1)
C
c                       ISAVE=SAVER(ITR2,HDCOD1,HDVALU,TRCHED)
C                       HDVALU = itr2 (l_HDCOD1)
                        ISAVE=SAVER2(ITR2,IFMTB(ISTB-1),l_HDCOD1
     *                              ,LENB(ISTB-1),HDVALU,TRCHED)
                IF( ISAVE.EQ.0 )THEN
                     BADCOD=HDCOD1
                     GOTO 950
                     ENDIF

                write(lunout,*)' '
                write(lunout,*)'Trace Header Value before change'
                        WRITE(LUNOUT,*)PGMNME//' b: ','Count= ',ITRACE
     *          ,' Rec= ',recnum,' Trc= ',trcnum,'  ',HDCOD1//': '
     *          ,HDVALU
C    *          ,istb-1,l_HDCOD1
                write(lunout,*)' '
C
C
C		Continue to log header values.
C
                        GOTO 200
C
C			CONTINUE below is end of NEXT usage.
C
300                     CONTINUE
C
                ENDIF
C
C	Change header values in this loop
C
        IF(HDCODE(1:1).NE.' ') THEN
C
C............EVALUATION OPTION..........................................
C
        IF(ILOG) THEN
C 
                write(lunout,*)' '
                write(lunout,*)' '
                write(lunout,*)'Change Trace Header Value'
                write(lunout,*)PGMNME//' e: ','Count= ',ITRACE
     *                ,' Rec=  ',recnum,'   Trc=  ',trcnum
                write(lunout,*)' '
C
C		End of ILOG
C
         ENDIF
C
        IONE=1
        iste = 1
        IOLD=IONE
C
C       Default arithmetic register
C
        KREG=0
C
C       Not in conditional
C
        INCOND=.FALSE.
        KCOND=.FALSE.
C
        ISAND=.FALSE.
        ISIOR=.FALSE.
        ISXOR=.FALSE.
        ISNOT=.FALSE.
C
C       Log evaluation logic 
C
        ILOGE=ILOG.OR.IEONE
C
525     CONTINUE
C
C	Get next opcode/loc
C
C
        HDCOD1='      '
        IF(IDEBUG) WRITE(LUNOUT,*)'Before NEXT IONE: ',IONE
        IOLD=IONE
        CALL NEXT(IONE,DELIME,HDCODE,HDCOD1)
C
        IF(IDEBUG) THEN
                WRITE(LUNOUT,*)'After Next IONE: ',IONE
                WRITE(LUNOUT,*)HDCOD1
                ENDIF
C
        IF(IONE.EQ.0) THEN
C
C       End of parsing
C
                GOTO 550
                ENDIF
C
C
C-------Check on repeated separator-------------------------------
C
        IF(HDCOD1(1:1).EQ.DELIME(1:1)) GOTO 960
C
C
C-------STOP logic------------------------------------------------
C
        IF(HDCOD1(1:4).EQ.'STOP') THEN
                WRITE(LUNOUT,*)PGMNME//'Evaluation requested STOP'
                GOTO 900
                ENDIF
C
C
C-------WAIT logic------------------------------------------------
C
        IF(HDCOD1(1:4).EQ.'WAIT') THEN
                IF(ILOGE) THEN
                WRITE(LUNOUT,*)PGMNME//'Evaluation requested WAIT'
                ENDIF
                GOTO 103
                ENDIF
C
C-------KILL logic------------------------------------------------
C
        IF(HDCOD1(1:4).EQ.'KILL') THEN
                IF(ILOGE) THEN
                WRITE(LUNOUT,*)PGMNME//'Evaluation requested KILL'
                ENDIF
C
C       Set appropriate dead trace flag
C
c               ISAVE=SAVEW(ITR2,KILCOD,KILVAL,TRCHED)
c               itr2 (l_KILCOD) = KILVAL
                ISAVE = savew2(ITR2,ifmt_KILCOD,l_KILCOD, ln_KILCOD,
     1                         KILVAL, TRACEHEADER)
                IEONE=.FALSE.
                GOTO 103
                ENDIF
C
C
C-------DROP logic------------------------------------------------
C
        IF(HDCOD1(1:4).EQ.'DROP') THEN
                IF(ILOGE) THEN
                WRITE(LUNOUT,*)PGMNME//'Evaluation requested DROP'
                ENDIF
                IEONE=.FALSE.
                GOTO 103
                ENDIF
C
C------Check for valid codes--------------------------------------
C
        IF(HDCOD1(1:1).NE.'<' .AND.
     *     HDCOD1(1:1).NE.'>' .AND.
     *     HDCOD1(1:1).NE.'+' .AND.
     *     HDCOD1(1:1).NE.'-' .AND.
     *     HDCOD1(1:1).NE.'*' .AND.
     *     HDCOD1(1:1).NE.'/' .AND.
     *     HDCOD1(1:1).NE.'%' .AND.
     *     HDCOD1(1:1).NE.'[' .AND.
     *     HDCOD1(1:1).NE.']' .AND.
     *     HDCOD1(1:1).NE.'{' .AND.
     *     HDCOD1(1:1).NE.'}' .AND.
     *     HDCOD1(1:1).NE.'.' .AND.
     *     HDCOD1(1:1).NE.'&' .AND.
     *     HDCOD1(1:1).NE.'|' .AND.
     *     HDCOD1(1:1).NE.'^' .AND.
     *     HDCOD1(1:1).NE.'~' .AND.
     *     HDCOD1(1:1).NE.'!' .AND.
     *     .TRUE.) THEN
C
                WRITE(LUNERR,*)PGMNME//
     *                ' **** Unknown/unexpected code **** ',HDCOD1
                WRITE(LUNERR,*)PGMNME//
     *                ' Use one of: '//
     *                '< > + - * / % [ ] { } . & | ^ ~ ! '
                GOTO 990
                ENDIF
C
                IF(HDCOD1(1:1).EQ.'+'. OR.
     *             HDCOD1(1:1).EQ.'-'. OR.
     *             HDCOD1(1:1).EQ.'*'. OR.
     *             HDCOD1(1:1).EQ.'/' .OR.
     *             HDCOD1(1:1).EQ.'%' .OR.
     *             .FALSE. ) THEN
C
                        IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                        'Arithmetic code: '//HDCOD1(1:1)
                        ENDIF
C
        GETVAL=.FALSE.
        PUTVAL=.FALSE.
C
C       Setup a lookahead fetch on these operations
C
        IF(HDCOD1(1:1).EQ.'<' .OR.
     *     HDCOD1(1:1).EQ.'+' .OR.
     *     HDCOD1(1:1).EQ.'-' .OR.
     *     HDCOD1(1:1).EQ.'*' .OR.
     *     HDCOD1(1:1).EQ.'/' .OR.
     *     HDCOD1(1:1).EQ.'%' .OR.
     *     .FALSE.) GETVAL=.TRUE.
C
        IF(HDCOD1(1:1).EQ.'>')      PUTVAL=.TRUE.
C
C---------------LOAD a DATA VALUE---------------------------------------
C
C	 Load a data value
C
                IF(GETVAL) THEN
C
                        IF(ILOGE) WRITE(LUNOUT,*)PGMNME//
     *                        'Getting a value'
C
                        IOLD=IONE
                        IF(CHKFLG(IONE,DELIME,HDCODE,'Constant',ITEMP)) 
     *                          THEN
C
C.......................Constant........................................
C
                                IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                                'Loading Constant: ',ITEMP
C
                                IOLD=IONE
                               IF(IDEBUG) WRITE(LUNOUT,*)PGMNME//
     *        'chkflg ... IONE: ',IONE
C
C.......................Memory........................................
C
                                ELSEIF(
     *                          CHKFLG(IONE,DELIME,HDCODE,'Memory'
     *                                ,KMEM))
     *                          THEN
                                IF(IDEBUG) WRITE(LUNOUT,*)PGMNME//
     *        'chkflg ... IONE: ',IONE
C
                                IF(1.LE.KMEM .AND. KMEM.LE.MAXMEM) THEN
                                        ITEMP=IMEM(KMEM)
                                        ELSE
                                        WRITE(LUNERR,*)PGMNME//
     *                                  '**** BAD Memory number **** '
     *                                  ,KMEM 
                                        GOTO 995
                                                ENDIF
C
                                IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                            'Loading from Memory number ',KMEM
     *                                ,' the value: ',ITEMP
C
C.......................Trace Header Value........................................
C
                                ELSE
C
                                IOLD=IONE
                                iste=ione
                                CALL NEXT(IONE,DELIME,HDCODE,HDCOD2)
                                IF(IDEBUG) WRITE(LUNOUT,*)PGMNME//
     *                                'trace header ... IONE: ',IONE
                                IF(HDCOD1(1:1).EQ.DELIME(1:1)) GOTO 960

                                CALL NEXTLU (iste,iende,l_HDCODE,
     *                                       l_HDCOD2)
C                               WRITE(LUNERR,*)PGMNME,iste,' ',HDCOD2
C
C                               ITEMP = itr2 (l_HDCOD2)

                                IERR=SAVER2(ITR2,IFMTE(IOLD),l_HDCOD2
     *                               ,LENE(IOLD),ITEMP,TRCHED)
                                IF(IERR.EQ.0)
     *                                THEN
                                        BADCOD=HDCOD2
                                        WRITE(LUNERR,*)PGMNME//
     *               'iold,ifmte,lene,IERR: '
     *                ,IOLD,IFMTE(IOLD),LENE(IOLD),IERR
                                        GOTO 950
                                        ENDIF

c                               IF(SAVER(ITR2,HDCOD2,ITEMP,TRCHED).EQ.0)
c                               IF(iste.EQ.0)
c    *                                THEN
c                                       BADCOD=HDCOD2
c                                       GOTO 950
c                                       ENDIF
C
                                IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                           'Loading from '//HDCOD2//' the value: '
     *                           ,ITEMP
C
C                               Ends "CASE" structure
                                ENDIF 
C
                        IF(HDCOD1(1:1).EQ.'<') IREG(KREG)=ITEMP
C
C                       END of GETVAL
C
                        IF(IDEBUG) WRITE(LUNOUT,*)PGMNME//
     *                        'Getval ... IONE: ',IONE
C
C                       Ends GETVAL options
                        ENDIF
C
C-------------PERFORM ARITHMETIC----------------------------------------
C
C	Perform arithmetic +,-,*,/
C
                IF(HDCOD1(1:1).EQ.'+'. OR.
     *             HDCOD1(1:1).EQ.'-'. OR.
     *             HDCOD1(1:1).EQ.'*'. OR.
     *             HDCOD1(1:1).EQ.'/' .OR. 
     *             HDCOD1(1:1).EQ.'%' .OR. 
     *             .FALSE.) THEN
C
                IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                'Register Number ',KREG
     *                ,' has the current value:   ',IREG(KREG)
C
C               Note:	Lookahead fetch performed previously for data
C
                IF(HDCOD1(1:1).EQ.'+') THEN
                        IREG(KREG)=IREG(KREG)+ITEMP
                        ENDIF
C
                IF(HDCOD1(1:1).EQ.'-') THEN
                        IREG(KREG)=IREG(KREG)-ITEMP
                        ENDIF
C
                IF(HDCOD1(1:1).EQ.'*') THEN
                        IREG(KREG)=IREG(KREG)*ITEMP
                        ENDIF
C
                IF(HDCOD1(1:1).EQ.'/') THEN
C
                        IF(ITEMP.EQ.0) THEN
                                WRITE(LUNERR,*)PGMNME//
     *                                '**** zero divide **** '//
     *                                HDCOD2
                                GOTO 995
                                ENDIF
C
                        IREG(KREG)=IREG(KREG)/ITEMP
                        ENDIF
C
                IF(HDCOD1(1:1).EQ.'%') THEN
C
                        IF(ITEMP.EQ.0) THEN
                                WRITE(LUNERR,*)PGMNME//
     *                                '**** zero divide **** '//
     *                                HDCOD2
                                GOTO 995
                                ENDIF
C
                        IREG(KREG)=MOD(IREG(KREG),ITEMP)
                        ENDIF
C
                IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                'Register',KREG
     *                ,' with Operation '//HDCOD1(1:1)
     *                ,' and the result: ',IREG(KREG)
C
        IF(IDEBUG) WRITE(LUNOUT,*)'Arith ... IONE: ',IONE
                        GOTO 525
C
C                       Ends Arithmetic evaluation
                        ENDIF
C
C------------STORE A DATA VALUE-----------------------------------------
C
C
C	Store a data value
C
                IF(PUTVAL) THEN
C
                        IF(ILOGE) WRITE(LUNOUT,*)PGMNME//
     *                        'Putting a value'
C
                        IOLD=IONE
                        IF(CHKFLG(IONE,DELIME,HDCODE,'Memory',KMEM))
     *                        THEN
C
                                IF(KMEM.LT.1 .OR. KMEM.LE.MAXMEM) THEN
                                        IMEM(KMEM)=IREG(KREG)
                                        ELSE
                                        WRITE(LUNERR,*)PGMNME//
     *                                  '**** BAD Memory number ****'
                                                GOTO 995
                                                ENDIF
C
                                IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                                'Storing to Memory number '
     *                                ,KMEM,' the value:   ',IREG(KREG)
C
                                ELSE
C
                                IOLD=IONE
                                iste=IONE
                                CALL NEXT(IONE,DELIME,HDCODE,HDCOD1)
                                IF(HDCOD1(1:1).EQ.DELIME(1:1)) GOTO 960

                                CALL NEXTLU (iste,iende,l_HDCODE,
     *                                       l_HDCOD1)
C
C                               itr2 (l_HDCOD1) = IREG(KREG)
C               WRITE(LUNOUT,*)PGMNME//'l_HDCOD1,IREG(KREG): '
C    *                                 ,l_HDCOD1,IREG(KREG)

                                IERR=SAVEW2(ITR2,IFMTE(IOLD),l_HDCOD1
     *                               ,LENE(IOLD),IREG(KREG),TRCHED)

                                IF(IERR.EQ.0) THEN

                                        BADCOD=HDCOD1(1:6)
                                        WRITE(LUNERR,*)PGMNME//
     *            'iold,ifmte,l_hdcod1,lene,TRCHED,IERR: '
     *            ,IOLD,IFMTE(IOLD),l_HDCOD1,LENE(IOLD),TRCHED,IERR
                                        GOTO 950
                                        ENDIF

c                               IF(SAVEW(ITR2,HDCOD1,IREG(KREG),TRCHED)
c    *                                        .EQ.0) THEN
c                                       BADCOD=HDCOD1(1:6)
c                                       GOTO 950
c                                       ENDIF
C
                                IF(ILOGE) WRITE(LUNERR,*)PGMNME//
     *                            'Storing to '//HDCOD1//' the value: '
     *                            ,IREG(KREG)
     *                            ,IOLD,l_hdcod1
C        
C                               Ends PUTVAL cases
                                ENDIF
C
        IF(IDEBUG) WRITE(LUNOUT,*)'PUTVAL ... IONE: ',IONE
C
C                       Ends PUTVAL
                        ENDIF
C
C--------------FIRST TIME CLAUSE----------------------------------------
C
C
C	Start of first time clause
C
                IF(HDCOD1(1:1).EQ.'[') THEN
C
                        IF(ILOGE) THEN
C
                                WRITE(LUNERR,*)PGMNME//
     *                                'First time clause '//HDCOD1
                                ELSE
                                ENDIF
C
                        IF(.NOT.IEONE) THEN
C
                                IOLD=IONE
                                CALL NEXT(IONE,']',HDCODE,HDCOD1)
C
                                IF(IONE.EQ.0) THEN
C
                                        WRITE(LUNOUT,*)PGMNME//
     *                                        '**** No ] ****'
                                        WRITE(LUNOUT,*)PGMNME//
     *                      'cannot find end of first time clause'
C
                                        GOTO 900
                                        ENDIF
C
C                               bump past delimitor
C
                                IONE=IONE+1
C
                                IF(ILOGE) THEN
                                     WRITE(LUNERR,*)PGMNME//
     *                       'Skipped to end of first time clause '//']'
                                     IF(IDEBUG) WRITE(LUNERR,*)PGMNME//
     *                                        'IONE ...',IONE
                                        ENDIF
C
C                               END of .NOT.IEONE
C
                                ENDIF
C
C                       END of [
C
                        GOTO 525
                        ENDIF
C
C--------------END OF FIRST TIME CLAUSE----------------------------------------
C
        IF(HDCOD1(1:1).EQ.']'.AND.ILOGE) THEN
                WRITE(LUNERR,*)PGMNME//HDCOD1//
     *                        'End of first time clause'
                IF(IDEBUG) WRITE(LUNOUT,*)
     *                        'End of ]  ... IONE: ',IONE
                GOTO 525
                ENDIF
C
C---------------CONDITIONAL CLAUSE--------------------------------------
C
C
C	Start of first conditional clause
C
                IF(HDCOD1(1:1).EQ.'{') THEN
C
                        IF(INCOND) THEN
                                WRITE(LUNOUT,*)PGMNME//
     *                                '**** nested { ***'
                                GOTO 900
                                ENDIF
C
                        INCOND=.TRUE.
                        KREG=KREGL
                        IF(ILOGE) WRITE(LUNOUT,*)PGMNME//
     *                                'Conditional clause '//HDCOD1
                        IF(IDEBUG) WRITE(LUNOUT,*)
     *                                'Start of {  ... IONE: ',IONE
                        GOTO 525
C                       Ends {
                        ENDIF
C
C---------------START of CONDITIONAL TEST CODE----------------------------
C
        IF(HDCOD1(1:1).EQ.'.') THEN
C
        IF(INCOND) THEN
                ELSE
                WRITE(LUNOUT,*)PGMNME//
     *        '**** Test but not in conditional'
                GOTO 990
                ENDIF
C
C       Change arithmetic register
C
                KREG=KREGR
C
C       Check for valid conditional code
C
        IF(HDCOD1(2:3).NE.'LT' .AND.
     *     HDCOD1(2:3).NE.'LE' .AND.
     *     HDCOD1(2:3).NE.'EQ' .AND.
     *     HDCOD1(2:3).NE.'NE' .AND.
     *     HDCOD1(2:3).NE.'GE' .AND.
     *     HDCOD1(2:3).NE.'GT' 
     *         ) THEN
C
                WRITE(LUNERR,*)PGMNME//
     *                ' **** Unknown test **** ',HDCOD1
                WRITE(LUNERR,*)PGMNME//
     *                ' Use one of: LT,LE,EQ,NE,GE,GT'
                GOTO 990
                ENDIF
C
C       SAVE TEST
C
                TEST(1:2)=HDCOD1(2:3)
                IF(IDEBUG) WRITE(LUNOUT,*)
     *                        'Test ... IONE: ',IONE
                GOTO 525
C               Ends "." clause
                ENDIF
C
C
C
C---------------Evaluate CONDITIONAL ----------------------------
C
        IF( (HDCOD1(1:1).EQ.'&') .OR. 
     *      (HDCOD1(1:1).EQ.'|') .OR. 
     *      (HDCOD1(1:1).EQ.'^') .OR. 
     *      (HDCOD1(1:1).EQ.'!') .OR. 
     *        .FALSE.) THEN

          IF(IDEBUG) WRITE(LUNOUT,*)
     *                'Before test evaluation ... IONE: ',IONE
C
C       Now compare the conditional registers
C
C               Evaluate current condition (KCOND)
C
                KCOND=.FALSE.
C
                IF(TEST(1:2).EQ.'LT') THEN
                        IF(IREG(KREGL).LT.IREG(KREGR))
     *                        KCOND=.TRUE.
                        ENDIF
C
                IF(TEST(1:2).EQ.'LE') THEN
                        IF(IREG(KREGL).LE.IREG(KREGR))
     *                        KCOND=.TRUE.
                        ENDIF
C
                IF(TEST(1:2).EQ.'EQ') THEN
                        IF(IREG(KREGL).EQ.IREG(KREGR))
     *                        KCOND=.TRUE.
                        ENDIF
C
                IF(TEST(1:2).EQ.'NE') THEN
                        IF(IREG(KREGL).NE.IREG(KREGR))
     *                        KCOND=.TRUE.
                        ENDIF
C
                IF(TEST(1:2).EQ.'GE') THEN
                        IF(IREG(KREGL).GE.IREG(KREGR))
     *                        KCOND=.TRUE.
                        ENDIF
C
                IF(TEST(1:2).EQ.'GT') THEN
                        IF(IREG(KREGL).GT.IREG(KREGR))
     *                        KCOND=.TRUE.
                        ENDIF
C
                IF(ILOGE .OR. IDEBUG ) THEN
C
                                WRITE(LUNERR,*)PGMNME
     *                          ,IREG(KREGL),' '//TEST(1:2)//' '
     *                          ,IREG(KREGR),' ... ?'
C
                                IF(KCOND) THEN
C
                                        WRITE(LUNERR,*)PGMNME//
     *                                   'Conditional clause TRUE: '
     *                                        //TEST(1:2)
C
                                        ELSE
                        
                                        WRITE(LUNERR,*)PGMNME//
     *                                   'Conditional clause FALSE: '
     *                                        //TEST(1:2) 
C
C                                       Ends KCOND
                                        ENDIF
C
C                       Ends logging
                        ENDIF
C
C       Evaluate Combined Condition (ICOND)

        IF(ISAND) ICOND=ICOND.AND.KCOND
        IF(ISIOR) ICOND=ICOND.OR.KCOND
        IF(ISXOR) ICOND=ICOND.XOR.KCOND
        IF(ISNOT) KCOND=.NOT.KCOND

C       single conditon

        IF( .NOT.(ISAND.OR.ISIOR.OR.ISXOR) ) ICOND=KCOND
C
C       Ends type of conditional "&,|,^,~"
        ENDIF
C
C
C-------Set for next evaluation---------------------------------------
C
        IF(HDCOD1(1:1).EQ.'&') THEN
                IF(ILOGE) 
     *                WRITE(LUNOUT,*)PGMNME//'ANDing conditional'
                ISAND=.TRUE.
                KREG=1
                ENDIF
C
        IF(HDCOD1(1:1).EQ.'|') THEN
                IF(ILOGE) 
     *                WRITE(LUNOUT,*)PGMNME//'ORing conditional'
                WRITE(LUNOUT,*)PGMNME//'ORing conditional'
     *                ,'HDCOD1(1:1),KCOND,ICOND'
     *                ,HDCOD1(1:1),KCOND,ICOND

                ISIOR=.TRUE.
                KREG=1
                ENDIF
C
        IF(HDCOD1(1:1).EQ.'^') THEN
                IF(ILOGE) 
     *                WRITE(LUNOUT,*)PGMNME//'XORing conditional'
                ISXOR=.TRUE.
                KREG=1
                ENDIF
C
        IF(HDCOD1(1:1).EQ.'~') THEN
                IF(ILOGE) 
     *                WRITE(LUNOUT,*)PGMNME//'NOTing conditional'
                ISNOT=.TRUE.
                KREG=1
                ENDIF
C
C-------PERFORM or SKIP conditional action----------------------
C
        IF(HDCOD1(1:1).EQ.'!') THEN
C
                IF(ILOGE) THEN
                        WRITE(LUNOUT,*)PGMNME//'end of conditional'
                        WRITE(LUNOUT,*)PGMNME//'Combined test is : '
     *                        ,ICOND
                        ENDIF
C
                KREG=0
C
                IF(.NOT.ICOND) THEN
C
                        IOLD=IONE
                        CALL NEXT(IONE,'}',HDCODE,HDCOD1)
C
                                IF(IONE.EQ.0) THEN
C
                                        WRITE(LUNOUT,*)PGMNME//
     *                                        '**** No } ****'
                                        WRITE(LUNOUT,*)PGMNME//
     *                      'cannot find end of conditional clause'
C
                                        GOTO 900
C                                       Ends IONE
                                        ENDIF
C
C                               bump past comma
C
                                IONE=IONE+1
C
C                               Ends .NOT.ICOND
                                ENDIF
                GOTO 525
C               Ends "!"
                ENDIF
C
C---------------END OF CONDITIONAL CODE--------------------------------------
C
        IF(HDCOD1(1:1).EQ.'}'.AND.ILOGE) THEN
                WRITE(LUNERR,*)PGMNME//HDCOD1//
     *                        'End of conditional clause'
C
                GOTO 525
                ENDIF
C
        GOTO 525
C
C
C-------END of EVALUATION LOGIC-----------------------------------------
C
550     CONTINUE
C
        IF(ILOGE.AND.HDCODE.NE.' ') THEN
                WRITE(LUNOUT,*)PGMNME//'End of evaluation logic'
                ENDIF
C
C       No longer first time in e: logic
C
        IEONE=.FALSE.
C
C       Ends evaluation logic
        ENDIF
C
C.........................................................................
C
        ILOGC=.FALSE.
C
        IF(HDCODM.NE.' ') THEN
                WRITE(LUNOUT,*)PGMNME//'MODULO: '
                KMODER=MOD(KMODER+1,MODER)
                WRITE(LUNOUT,*)PGMNME//'KMODER: ',KMODER
C
                ierr = savew2(ITR2,ifmt_HDCODM,l_HDCODM, ln_HDCODM,
     1                        KMODER, TRACEHEADER)
c               IF(SAVEW(ITR2,HDCODM(1:6),KMODER,TRCHED).EQ.0) THEN
                IF(ierr .EQ. 0) THEN
                        BADCOD=HDCODM(1:6)
                        GOTO 950
                        ENDIF
C
                ENDIF
C
C	Headers have been changed by this point
C		now output and log them
C

                ITROUT=ITROUT+1
            ENDIF

                CALL WRTAPE(LUNOT,ITR2,LBYTE)
C
C
C...............Log after change if requested..........................
C
        IF (keep .and. mod(jj-1,nrik).eq.0 .OR. .not. keep) THEN

        IF(ILOG) THEN
C
                IONA=1
                ista = 1
C
210             CONTINUE
C
                CALL NEXT(IONA,DELIM,HDCODA,HDCOD1)
                IF(IONA .EQ.0) GOTO 310

                        CALL NEXTLU (ista,ienda,l_HDCODA,l_HDCOD1)
C
                        HDVALU=0
c                       ISAVE=SAVER(ITR2,HDCOD1,HDVALU,TRCHED)
C                       HDVALU = itr2 (l_HDCOD1)
                        ISAVE=SAVER2(ITR2,IFMTA(ISTA-1),l_HDCOD1
     *                              ,LENA(ISTA-1),HDVALU,TRCHED)
                IF( ISAVE.EQ.0 )THEN
                     BADCOD=HDCOD1
                     GOTO 950
                     ENDIF

                write(lunout,*)' '
                write(lunout,*)'Trace Header Value after change'
                        WRITE(LUNOUT,*)PGMNME//' a: ','Count= ',ITRACE
     *          ,' Rec= ',recnum,' Trc= ',trcnum,'  ',HDCOD1//': '
     *          ,HDVALU
C    *          ,ista-1,l_HDCOD1
                write(lunout,*)' '
C
C	Continue to log header values
C
                        GOTO 210
C
C			CONTINUE below is end of NEXT usage.
C
310                     CONTINUE
C
C               Ends log after change
                ENDIF

        ENDIF

C
C	End of trace read
C
103        CONTINUE
C
c-----------------------------------------------
c       Skip remainder of record if necessary
        call trcskp (jj,ne+1,nmtrin,lunin,nmtrin,ITR2)
        itrace = itrace + nmtrin-ne
c-----------------------------------------------
C
c-------------------------------------------
C       Skip input records if requested
        call recskp (jj+1,jj+nri-1,lunin,nmtrin,ITR2)
        ITRACE = itrace + nmtrin*(nri-1)
c-------------------------------------------
C
C
100    continue
C
900        CONTINUE
C
        IF(HDCODD.NE.' ') THEN
C
        IF(HDVALU.EQ.OLDVAL) THEN
C
C       This assumes no change on last time
C		Force printout
C
                 WRITE(LUNOUT,*)PGMNME//
     *          'Trace count... d: ', ITRACE,' (',1+IBTWO-IBONE,')'
     *                ,'  ',HDCODD(1:6)//': '
     *                ,HDVALU
                ELSE
C
C               Should have printed earlier
C
                WRITE(LUNOUT,*)PGMNME//' ... d: Change on last value'
C               Ends nochange logic
                ENDIF
C
C               Ends changed value printout
                ENDIF
C
        WRITE(LUNOUT,*)PGMNME//'Last LBYTE: ',LBYTE
C
        WRITE(LUNOUT,*)PGMNME//
     *        'End of data ... the number of input traces is:  ',ITRACE
C
        WRITE(LUNOUT,*)PGMNME//
     *        'End of data ... the number of output traces is: ',ITROUT
C
C	Spin the input to allow previous pipe step proper termination 
C
        IF(ISPIN) CALL SPIN(LUNIN,ITR2,LBYTE)
C
C	Close data files
C
        CALL LBCLOS(LUNIN)
C
        WRITE(LUNOUT,*)PGMNME//'LBCLOS: ',LUNOT
        CALL LBCLOS ( LUNOT)
C
        WRITE(LUNOUT,*)PGMNME//'Normal program completion'
        GOTO 999
C
950     CONTINUE
C
        WRITE(LUNOUT,*)PGMNME//SAVMSG
        WRITE(LUNOUT,*)PGMNME//BADCOD
        GOTO 900
C
960     CONTINUE
        WRITE(LUNOUT,*)PGMNME//
     *                '**** repeated separator ****'
C
990     CONTINUE
C
        WRITE(LUNERR,*)PGMNME//' current pointer(s): ',IOLD,IONE
C
        IONE=MIN(IOLD,IONE)
        IF(IONE.GT.2) THEN
                WRITE(LUNERR,*)PGMNME//'good code:'
                WRITE(LUNERR,*)HDCODE(1:
     *              MAX(1,MIN(IONE-2,LEN(HDCODE))))
                ENDIF
C
        IF(IONE.GT.1) THEN
                WRITE(LUNERR,*)PGMNME//'bad code:'
                WRITE(LUNERR,*)HDCODE(IONE-1:LEN(HDCODE))
                ENDIF
C
995      CONTINUE
C
         WRITE(LUNERR,*)PGMNME//
     *                '**** abnormal completion ****'
C
        GOTO 999
C
999      CONTINUE
C
C        EXIT/STOP here
C
        STOP
C
        END
