C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Cutoffs  ( Histogram, n, CutOffPercent, MinValue,  
     :     delta, MinCutOff, MaxCutOff , HistMax)

c variables passed from calling routine

      integer n
      
      real Histogram(n), MinCutOff, MaxCutOff, CutOffPercent
      real MinValue, delta

c local variables

      integer HistMax_Index
      real HistMax, HistCutOff, MaxValue, final_index

      logical still_looking

      still_looking = .true.

      call maxv ( Histogram, 1, HistMax, HistMax_Index, 100 )
      HistCutOff = ( CutOffPercent / 100.0 ) * HistMax

      call CutValue ( Histogram, n, HistCutOff, HistMax_Index, 1, -1, 
     :     MinValue, delta, MinCutOff )
      call CutValue ( Histogram, n, HistCutOff, HistMax_Index, n, 1, 
     :     MinValue, delta, MaxCutOff )

c don't report cutoffs outside histogram populated areas

      i = n
      do while ( still_looking .or. final_index .lt. 1.0 )
         if ( Histogram(i) .gt. 1.e-30 ) still_looking = .false.
         final_index = i-1
         i = i - 1
      enddo

      MaxValue = MinValue + ( delta * (final_index - 1.0))
      if ( MinCutOff .lt. MinValue ) MinCutOff = MinValue
      if ( MaxCutOff .gt. MaxValue ) MaxCutOff = MaxValue

      return
      end
