C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tau2t(twt,ntwt,dteql,minsamp,maxsamp,     
     1                 lefttwt,idiv,ndiv,lerr)
C
      real      twt(0:ntwt)       
      integer   lefttwt(minsamp:maxsamp)
      integer   idiv(minsamp:maxsamp)
c_________________________________________________________________________
c     twt		two way travel time at irregular depth grid.
c     lefttwt	 	irregular twt grid index that falls just to left of
c			an output equally spaced data point.
c     idiv		fractional sample offset between lefttwt and the
c			an output equally sampled data point.
c     dteql		output equal time increment.
c_________________________________________________________________________
c     initialize. lefttwt<0 will flag the interpolator that this sample
c     should be zero.
c_________________________________________________________________________
      do 10000 jteql=minsamp,maxsamp
       lefttwt(jteql)=-1
       idiv(jteql)=0
10000 continue
c
      istart=twt(0)/dteql 
      istart=max(istart,minsamp)
      lefttwt(0)=0
      idiv(0)=0
      do 60000 jtwt=1,ntwt
       iend=twt(jtwt)/dteql
       iend=min(iend,maxsamp)                       
       iend=max(iend,minsamp)                       
       do 50000 jteql=istart,iend
        teql=jteql*dteql
        lefttwt(jteql)=jtwt-1
        dtwt=twt(jtwt)-twt(jtwt-1)
        idiv(jteql)=nint(ndiv*(teql-twt(jtwt-1))/dtwt)
        if(idiv(jteql) .eq. ndiv) then
           idiv(jteql)=0
           lefttwt(jteql)=jtwt
        endif
50000  continue
       istart=iend+1
60000 continue
C
      return
      end
