C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine tstrsub(ueql,uirreg,icrp_seismic,
     1                   w,lefttwt,idiv,ndiv,
     2                   tapbuf,firstcrp,lastcrp,
     3                   ntr_seismic,nrec_seismic,
     3                   nz,minsamp,maxsamp,nteql,nzbuf,dteql,ITRWRD,
     4                   nbytes_out,iws,iwe,
     5                   lutwt,lureg,luirreg,stderr,lerr,
     6                   ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
c
      integer   firstcrp,lastcrp
      real      uirreg(-ITRWRD:nzbuf,ntr_seismic)
      real      ueql(minsamp:maxsamp,ntr_seismic)   
      real      tapbuf(-ITRWRD:nteql-1)
c
      integer   lefttwt(minsamp:maxsamp,firstcrp:lastcrp)
      integer   idiv(minsamp:maxsamp,firstcrp:lastcrp)
      integer   icrp_seismic(ntr_seismic)
      integer   ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER
c
      real      w(iws:iwe,0:ndiv) 
      integer   stderr
c______________________________________________________________________
c     uirreg		input seismic data on the irregular depth grid
c     ueql		output seismic data on an equal time grid.
c     w			interpolation weights.
c     lefttwt		depth index just to left of the point that maps
c                       to the output time index.
c     idiv   	 	fractional division index needed to interpolate.
c     icrp_seismic      crp index of the input seismic depth data.
c     ntr_seismic	number of seismic traces per gather.
c______________________________________________________________________
      do 90000 jrec=1,nrec_seismic             
C_______________________________________________________________________
C      read in a seismic record.                                 
C_______________________________________________________________________
       call rdseis(uirreg,icrp_seismic,ntr_seismic,ITRWRD,nzbuf,
     1             ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER,
     2             luirreg)
c
       do 30000 jtr=1,ntr_seismic
C_______________________________________________________________________
C       interpolate trace by trace 
c       to regular grid using a 6 point lagrange operator.
C_______________________________________________________________________
        kcrp=icrp_seismic(jtr)
        call mint6a(uirreg(-ITRWRD,jtr),ueql(minsamp,jtr),
     1              w,lefttwt(minsamp,kcrp),idiv(minsamp,kcrp),ndiv,
     2              ITRWRD,nz,nzbuf,minsamp,maxsamp,stderr)
30000  continue
C_______________________________________________________________________
C      copy trace headers from irregular traces to output buffer.
c      copy data from ueql to output buffer.
C      write out the buffer.
C_______________________________________________________________________
      do 60000 jtr=1,ntr_seismic
       do 51000 jh=-ITRWRD,-1
        tapbuf(jh)=uirreg(jh,jtr)
51000  continue
       kt=0
       do 52000 jt=minsamp,maxsamp
        tapbuf(kt)=ueql(jt,jtr)
        kt=kt+1
52000  continue
       call wrtape(lureg,tapbuf(-ITRWRD),nbytes_out)
60000 continue
 
90000 continue
      call lbclos(lureg)
      call lbclos(luirreg)
c
      return
      end
