C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gainap (ns, ntr, dt, dx, angles, gainmat, vism,
     1                   vrms)

      real   angles (ns, ntr), gainmat( ns, ntr), vism (ns), vrms (ns)
      real   dx (ntr)
      real   deg2rad

      deg2rad = .0174532925

      DO  j = 1, ntr

          x = dx (j)

          IF ( x .eq. 0.0 ) THEN

             vrms1 = vrms (1)
             do  i = 1, ns
                 t = dt * float(i-1)
                 sum = t * vrms(i)**2 / vrms1
                 gainmat (i,j) = sum
             enddo

          ELSE

             x2 = x * x
             sum = 0.
c            tan1 = tan (deg2rad * angles(1,j))
             do  i = 1, ns

                 rad = deg2rad * angles (i,j)
                 atn = atan (rad)
                 atn3 = atn * atn * atn
                 tanterm = vism (i) * atn3
                 sumi = sqrt (x2 + 2*x*dt * tanterm)
                 sum = sum + sumi
                 gainmat (i,j) = sqrt(sum)
             enddo

          ENDIF

      ENDDO


      return
      end
