C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-------------------------------------------------------------------------c
c            TTOTHEN -- do     alpha*t**n scaling of data                     
c                                                                         c
c     Author:                                                             c
c         P. R. Gutowski
c                                                                         c
c     Description:                                                        c
c         Based on the input values taken from the command line, this     c
c         program will compute a gain correction curve and apply this
c         to every trace read in on input
c                                                                         c
c     Variable list:                                                      c
c                 (integers -- all i*4)                                   c
c           LUIN  Logical unit number of input                            c
c          LUOUT  Logical unit number of output                           c
c         NBYTES  Number of bytes in trace record                         c
c         LBYTES  Number of bytes in input lineheader record     
c         LBYOUT  Number of bytes in new lineheader record
c          NSAMP  Number of samples in each trace                         c
c            NSI  Sampling interval                                       c
c           NTRC  Number of traces per record                             c
c           NREC  Number of records per line                              c
c            IRS  First record to process                                 c
c            IRE  Last record to process                                  c
c             NS  Starting trace number                                   c
c             NE  Ending trace number                                     c
c          NSKTR  Number of traces to skip                                c
c          IFORM  Input data format                                       c
c         NREOUT  Number of output records                                c
c         NTROUT  Number of output traces                                 c
c                 (logical)                                               c
c         VERBOS  If true, print verbos messages                          c
c          QUERY  If true, print query loop and end program               c
c                 (character)                                             c
c           NTAP  chr*120  Input file name from command line flag         c
c           OTAP  chr*120  Output file name from command line flag        c
c           NAME  chr*4    File name passed to HLH subroutine             c
c                                                                         c
c     Array list:                                                         c
c          ITR (8320)  i*2    Input data character stream                 c
c          TRI (4096)  r*4    Data trace                                  c
c         STRI (4096)  r*4    Stacked data trace                          c
c                                                                         c
c     Calls:                                                              c
c         (subroutines)                                                   c
c         RTAPE, LBOPEN, HLH, WRTAPE, SAVE, ARGSTR, ARGI4, ERROR          c
c                                                                         c
c         (functions)                                                     c
c         ARGIS                                                           c
c                                                                         c
c-------------------------------------------------------------------------c
c     program ttothen
c---------------------------------
c        declare variables
c---------------------------------
c        iounit defines all ascii i/o units used
c        sisdef defines the sis line & trace header structure
c        lhdrsz defines - trace header size (cray & sun)
c                       - max time dimension
c                       - max no. channels
c                       - sample size in bytes (cray & sun)
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
c________________________________
      integer npol
      PARAMETER (npol = 6)
      external fpoly

      integer     ITR (SZLNHD), itrhd
      integer     VTR (SZLNHD)
      integer     ARGIS
      integer     lbyout
      integer     LUIN, LUOUT, NBYTES, LBYTES, NSAMP, NSI, NTRC, NREC
      integer     IRS, IRE, NS, NE, NREOUT, NTROUT, IFORM
      integer     pipe, status, luvin
      integer     mode, emerg, trcnum, recnum
c
      real     TRI (SZLNHD), GAIN (SZLNHD), vri (SZLNHD)
      real     TRX (SZLNHD), WORK (SZLNHD)
      real     alpha, power, VelInit
      integer  imute (SZLNHD)

      pointer  (wkitrhd, itrhd(1))
      real     vel_array(1), t_array(1),dx(1)
      real     data(1), angles(1), gainmat(1)
      real     sig(1),vtrms(1),vsrms(1),vism(1),vit(1)
      integer  trhd(1)
      POINTER  (advel,vel_array),(adta,t_array)
      POINTER  (addx,dx)
      POINTER  (pdata, data), (adang, angles)
      POINTER  (adstk, gainmat), (adtrhd, trhd)
      POINTER  (adsig,sig),(advtrms,vtrms),(advsrms,vsrms)
      POINTER  (advism,vism),(advit,vit)
      real     coefs(NPOL),errparms(5)

c
      character name * 7, ntap * 256, otap * 256, vtap * 256

c     pid defines all variables necessary to open printout files
#include <f77/pid.h>
c
      logical verbos, query, invers, expon, IKP, vst, vrt
      logical angdiv, GN, NMOAP, dead(SZLNHD)
c
c
      data  name/'TTOTHEN'/
      data  pipe/3/
      data luvin/-1/
c------------------------------------
c        initialize variables
c------------------------------------
      nbytes = 0
      lbytes = 0
c-------------------------------------------------------------------
c        If '-?' flag is used in command line, execute query
c        loop and end program.
c-------------------------------------------------------------------
      query = ( argis ( '-?' ) .gt. 0 .or. argis('-h') .gt. 0)
      if ( query ) then
         call help()
         stop
      end if

      IKP = .false.
      if (in_ikp() .gt. 0) IKP = .true.
c      write(LER,*)'ttothen in ikp? ', IKP

c------------------------------------------------------------------------------
c        Read program input parameters from command line argument flags
c        Write to printout some of these guys
c------------------------------------------------------------------------------
      call cmdln(ntap,otap,ns,ne,irs,ire,alpha,power,verbos, GN,
     1           invers,expon,vtap, VelInit, vrt,angdiv,mode,emerg,
     2           saf, iord, NMOAP)


c-------------------------------------------
c        Open input and output files
c-------------------------------------------
c 
c added pipchk call and check on vtap parameter - jev - 4/22/98
c

      if (IKP .and. vtap .eq. ' ') then
          status = -1
          call pipchk (pipe, status)
          if (status .eq. 0) then 
              call sisfdfit (luvin, pipe)
          endif
      else
          if (vtap .ne. ' ') then 
              call getln (luvin, vtap, 'r', -1)
          endif
      endif

c 
c moved getln calls so pipchk would work - jev - 4/22/98
c 
      call getln ( luin, ntap, 'r', 0)
      call getln (luout, otap, 'w', 1)

c
c moved include and xtrarg so pipchk would work - jev - 4/22/98
c
c------------------------------------------------------------------------------
c  open printout file tagged with the parent & child process id's
c------------------------------------------------------------------------------

#include <f77/open.h>

c     call xtrarg (name, LER , .FALSE., .FALSE.)
c     call xtrarg (name, LERR, .TRUE., .FALSE.)

      if (luvin .lt. 0) then
         vst = .false.
         vrt = .false.
      else
         vst = .true.
      endif

      if (angdiv .and. .not.vst) then
         write(LERR,*)'FATAL ERROR in angle option:'
         write(LERR,*)'Unable to open velocity data set. Check'
         write(LERR,*)'existence/permissions.'
         write(LER ,*)'FATAL ERROR in angle option:'
         write(LER ,*)'Unable to open velocity data set. Check'
         write(LER ,*)'existence/permissions.'
      endif

c
c changed - 4/15/98 - jev
c
c if power was defaulted, set it to 1 if vtap specified, 2 otherwise
c

      if (power .eq. 0) then
          if (vst) then
              power = 1
          else
              power = 2
          endif
      endif
          
c     if ( verbos ) then
         write(LERR,*) ' Values read from command line'
         write(LERR,*) ' First record to process =  ', irs
         write(LERR,*) ' Last record to process  =  ', ire
         write(LERR,*) ' Starting trace number   =  ', ns
         write(LERR,*) ' Ending trace number     =  ', ne
         write(LERR,*) ' Multiplier (alpha)      =  ', alpha
         write(LERR,*) ' Exponent                =  ', power
         if (expon)
     1   write(LERR,*) ' Exponential curve'
         if (invers)
     1   write(LERR,*) ' Apply inverse of gain curve'
c     end if
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c----------------------------------------------------
c        Read line header and crapout if null file
c----------------------------------------------------
      lbytes=0
      call RTAPE (luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'TOTHEN: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif

      IF (vst) THEN

      lvbytes=0
      call RTAPE (luvin, vtr, lvbytes)
      if(lvbytes .eq. 0) then
         write(LERR,*)'TOTHEN: no header read on velocity tape ',luvin
         vst = .false.
      else
         call saver(vtr, 'NumSmp', nsampv, LINHED)
         call saver(vtr, 'NumTrc', ntrcv , LINHED)
         call saver(vtr, 'NumRec', nrecv , LINHED)
         nv = nsampv
         write(LERR,*)' '
         write(LERR,*)'velocity tape: # samps/trc = ',nsampv
         write(LERR,*)'velocity tape: # trcs/rec  = ',ntrcv
         write(LERR,*)'velocity tape: # recs      = ',nrecv
         write(LERR,*)'initial velocity divisor:  = ',VelInit
         write(LERR,*)' '
         if (nrecv .eq. 1 .AND. ntrcv .gt. 1) then
            nrecv = ntrcv
            ntrcv = 1
         endif

      endif

      ENDIF

c-----------------------------------------------------------
c        update historical line header
c        save.inc brings in -- nsamp = number samples/trace
c                               nsi  = sample interval (ms)
c                               ntrc = number traces/record
c                               nrec = number records
c
c        print out these values if desired
c-----------------------------------------------------------
      call HLHprt(itr, lbytes, name, 7, LERR)
      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      ntr = ntrc
      delt = float(nsi) * unitsc
      fsr  = nsi
      nsr  = fsr

c     if ( verbos ) then
         write(LERR,*) ' Values read from input data set lineheader'
         write(LERR,*) ' Number of Samples/Trace =  ', nsamp
         write(LERR,*) ' Sample Interval         =  ', nsi
         write(LERR,*) ' Traces per Record       =  ', ntrc
         write(LERR,*) ' Records per Line        =  ', nrec
         write(LERR,*) ' Format of Data          =  ', iform
         if (angdiv) then
         write(LERR,*) ' Angle-based spherical correction used'
         if (NMOAP) then
         write(LERR,*) ' NMO will be applied internally'
         else
         write(LERR,*) ' NMO has been applied upstream. Be sure to'
         write(LERR,*) ' remove this NMO after ttothen'
         endif
         else
         if (vst)
     1   write(LERR,*) ' V**2 * t scaling used)'
         if (vrt)
     1   write(LERR,*) ' SQRT (V**2 * t) scaling used)'
         endif
c     end if

c---------------------------------------------------------------------------
c        Check bounds of input parameters and set values to defaults
c---------------------------------------------------------------------------
      call cmdchk(ns, ne, irs, ire, ntrc, nrec)

c--------------------------------------------------
c        Modify line header for output file
c        this will put the local command line in the
c        historical line header
c--------------------------------------------------
      call savhlh( itr, lbytes, lbyout)

c---------------------------------------------------------------
c        nreout = number output records
c        ntrout = number output traces/rec
c---------------------------------------------------------------
      nreout = ire - irs + 1
      ntrout = ne - ns + 1

c---------------------------------------------------------------
c        alter line header with above values
c        write out line header
c---------------------------------------------------------------
      call savew(itr, 'NumTrc' , ntrout  , LINHED)
      call savew(itr, 'NumRec' , nreout  , LINHED)
      call WRTAPE (luout, itr, lbyout)

c-------------------------------------
c  alter sample interval if desired
 
      dt = real (nsi) * unitsc

c---------------------------------------------------------------------
c        compute gain curve or for angle options allocate memory
c---------------------------------------------------------------------

      IF (expon .and. .not.angdiv) THEN

         do 11 i = 1, nsamp
            gain(i) = alpha * exp ((dt* float(i)) * power )
            if (invers) gain(i) = 1. / gain(i)
   11    continue

      ELSEIF (.not.expon .and. .not.angdiv) THEN

         do 10 i = 1, nsamp
            gain(i) = alpha * (dt * float(i)) ** power
            if (invers) gain(i) = 1. / gain(i)
   10    continue

      ELSE

C +==================================+
C |   allocate the required memory   |
C +==================================+
         ierror = 0
         iabort = 0
         ner = 0
         iget =ITRWRD * ntrc * ISZBYT
         call galloc(wkitrhd,iget,ierror,iabort)
         if(ierror.ne.0)ner=ner+1
         iget =nsamp * ntrc * ISZBYT
         call galloc(pdata,iget,ierror,iabort)
         if(ierror.ne.0)ner=ner+1
         call galloc(adang, iget,ierror,iabort)
         if(ierror.ne.0)ner=ner+1
         call galloc(adstk  ,iget,ierror,iabort)
         if(ierror.ne.0)ner=ner+1

c        iget = nsamp * nang * ISZBYT
c        call galloc(adlive,iget,ierror,iabort)
c        if(ierror.ne.0)ner=ner+1
c        call galloc(adlast,iget,ierror,iabort)
c        if(ierror.ne.0)ner=ner+1
c        call galloc(adfirst,iget,ierror,iabort)
c        if(ierror.ne.0)ner=ner+1

         iget = ITRWRD * ntrc * ISZBYT
         call galloc(adtrhd,iget,ierror,iabort)
         if(ierror.ne.0)ner=ner+1
         iget = nang*ISZBYT
         iget = nsamp*ISZBYT
c        if(.not.Angles_in)then
             call galloc(adsig  ,iget,ierror,iabort)
             call galloc(advtrms,iget,ierror,iabort)
             call galloc(advsrms,iget,ierror,iabort)
             call galloc(advism ,iget,ierror,iabort)
             call galloc(advit  ,iget,ierror,iabort)
             call vclr (sig, 1, nsamp)
             call vclr (vtrms, 1, nsamp)
             call vclr (vsrms, 1, nsamp)
             call vclr (vism, 1, nsamp)
             call vclr (vit, 1, nsamp)
c        endif
         if(ierror.ne.0)ner=ner+1

         if(ner.ne.0)then
           write(LERR,*)' Memory allocation failed.  FATAL'
           go to 999
         endif

         ier = 0
         iget = nsamp*ISZBYT
         call galloc(advel ,iget,ier,0)
         call galloc(adta,iget,ier,0)
         iget = ntrc*ISZBYT
         call galloc(addx,iget,ier,0)
         if(ier.ne.0)then
            write(ler,*)'Memory allocation error for velocities. FATAL!'
            go to 999
         endif


         do  i = 1, nsamp
             t_array(i) = (i) * delt
         enddo
         vtmax = (nsamp-1) * delt


      ENDIF

c---------------------------------------------------------------------
c        Skip unwanted records if necessary.  Skipping is done
c        in groups of ntrc traces per record.
c---------------------------------------------------------------------
      call recskp(1,irs-1,luin,ntrc,itr)

c----------------------------------------------------------------------
c                    Main processing loop
c
c        From the first selected record (irs) to last selected
c           record (ire) do the following:
c           (1)  read input trace
c           (2)  multiply input trace by gain curve
c           (3)  write out output trace
c----------------------------------------------------------------------

c************
c  standard spherical divergence correction
c************

      IF ( .not. angdiv ) THEN

      do 200 J = irs, ire

         IF (vst) THEN
            nvbytes = 0
            call RTAPE (luvin, vtr, nvbytes)
            if(nvbytes .ne. 0) then
               call vmov (vtr(ITHWP1), 1, vri, 1, nsampv)
c
c------------------
c moved divide by VelInit to be after vri is squared - jev - 10/9/97
c------------------
c              call vsdiv (vri, 1, VelInit, vri, 1, nsampv) 
               if (nsampv .lt. nsamp) then
                   do  i = nsampv+1, nsamp
                       vri (i) = vri (nsampv)
                   enddo
               endif
               call vsq   (vri, 1, vri, 1, nsamp)
               call vsdiv (vri, 1, VelInit, vri, 1, nsamp) 
            endif
         ENDIF
c----------------------
c  skip to start trace
            call trcskp(J,1,ns-1,luin,ntrc,itr)

c        ------------------
            do 400 K = ns, ne

               nbytes = 0
               call RTAPE (luin, itr, nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',i,'  trace= ',k
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
c------
c     use previously derived pointers to trace header values
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)

c             -----------------------------------------
c             multiply trace by gain curve
c             -----------------------------------------
               IF (istatic .ne. 30000) THEN
                   if (vst) then
                      if (vrt) then
                        do   L = 1, nsamp
                           tri (L) = sqrt (vri (L)) * tri (L) * gain (L)
                        enddo
                      else
                        do   L = 1, nsamp
                           tri (L) = vri (L) * tri (L) * gain (L)
                        enddo
                      endif
                   else
                      do   L = 1, nsamp
                         tri (L) = tri (L) * gain (L)
                      enddo
                   endif
               ENDIF
c        ----------------------------------
c        write output trace
c        ----------------------------------
               call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
               call WRTAPE (luout, itr, nbytes)

  400       continue

c------------------------
c  skip to end of record
            call trcskp(J,ne+1,ntrc,luin,ntrc,itr)

  200 continue

c************
c  angle-based divergence correction
c************

      ELSE

      do 500 J = irs, ire

            nvbytes = 0
            call RTAPE (luvin, vtr, nvbytes)
            if(nvbytes .ne. 0) then
               call vmov (vtr(ITHWP1), 1, vel_array, 1, nsampv)
               if (nsampv .lt. nsamp) then
                   do  i = nsampv+1, nsamp
                       vel_array (i) = vel_array (nsampv)
                   enddo
               endif
               call fitvel(t_array, vel_array, nv, nsamp, delt, coefs,
     1                     sig, ch, vtrms, vsrms, vism, vit, iord, ier)
            else
               write(LERR,*)'WARNING from angle option:'
               write(LERR,*)'premature EOF on velocity data set. Last'
               write(LERR,*)'line velocity at LI ',ili,' DI ',idi
               write(LERR,*)'Will continue to use last live velocity'
               write(LER ,*)'WARNING from angle option:'
               write(LER ,*)'premature EOF on velocity data set. Last'
               write(LER ,*)'line velocity at LI ',ili,' DI ',idi
               write(LER ,*)'Will continue to use last live velocity'
            endif
c----------------------
c  skip to start trace
            call trcskp(J,1,ns-1,luin,ntrc,itr)

c        ------------------
            ic = 0
            do 600 K = ns, ne

               nbytes = 0
               call RTAPE (luin, itr, nbytes)
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input:'
                  write(LERR,*)'  rec= ',i,'  trace= ',k
                  go to 999
               endif
               call vmov (itr(ITHWP1), 1, tri, 1, nsamp)
               ic = ic + 1
               dead (ic) = .false.
c------
c     use previously derived pointers to trace header values
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(itr,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                        ili    , TRACEHEADER)
                  call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        idi    , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        idx    , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)

                 dx(ic) = idx
                 dxx    = idx
                 if (istatic .eq. 30000) then
                    dead (ic) = .true.
                    call vclr (trx, 1, nsamp)
                 else
                    if (NMOAP) then
                       call detmut (tri, imute(ic), nsamp)
                       call nmo (tri, vel_array, work, dxx, nsamp, dt,
     1                           trx, .false.)
                    else
                       call vmov (tri, 1, trx, 1, nsamp)
                    endif
                 endif
                 
                 istrc = (ic-1) * nsamp
                 ishdr = (ic-1) * ITRWRD
                 call vmov (itr, 1, itrhd(ishdr+1), 1, ITRWRD)
                 call vmov (trx, 1, data(istrc+1), 1, nsamp)

  600       continue


c             -----------------------------------------
c             compute gain matrix and
c             multiply trace by gain curve
c             -----------------------------------------
              call angmat (nsamp, coefs, data, angles, gainmat, dx,
     1                     ntrc, delt, t_array, vtrms, mode,
     2                     emerg, vtmax, ierr, errparms, vsrms, vism,
     3                     vit,  GN)
c             -----------------------------------------
c             -----------------------------------------

c        ----------------------------------
c        write output traces
c        ----------------------------------
            ic = 0
            do 601 k = 1, ntrout

                 ic = ic + 1
                 istrc = (ic-1) * nsamp
                 ishdr = (ic-1) * ITRWRD
                 call vmov (itrhd(ishdr+1), 1, itr, 1, ITRWRD)
                 call vmov (data(istrc+1), 1, tri, 1, nsamp)
                 if (dead(ic)) then
                    call vclr (trx, 1, nsamp)
                 else
                    if (NMOAP) then
                       call nmo (tri, vel_array, work, dx(ic), nsamp,dt,
     1                           trx, .true.)
                       call resmut (trx, imute(ic), nsamp)
                    else
                       call vmov (tri, 1, trx, 1, nsamp)
                    endif
                 endif

                 call vmov (trx, 1, itr(ITHWP1), 1, nsamp)
                 call WRTAPE (luout, itr, nbytes)

  601       continue

c------------------------
c  skip to end of record
            call trcskp(J,ne+1,ntrc,luin,ntrc,itr)

  500 continue

      ENDIF

c-------------------------------------------
c        Close files and end program
c-------------------------------------------
  999 continue
      call LBCLOS ( luin )
      call LBCLOS ( luout )
      if (vst) call LBCLOS ( luvin )
      write(LERR,*)'TTOTHEN: normal end'
      write(LER ,*)'TTOTHEN: normal end'
      END

c-------------------------------------------
c        online help
c-------------------------------------------
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     1 '***************************************************************'
         write(LER,*)
     1 'Run this program by typing: ttothen and the following arguments'
         write(LER,*)
     1 ' -N[ntap]    (no default)      : Input data file name'
         write(LER,*)
     1 ' -O[otap]    (no default)      : Output data file name'
         write(LER,*)' '
         write(LER,*)
     1 ' -v[vtap]    (no file)         : optional velocity file'
         write(LER,*)' '
         write(LER,*)
     1 ' -rs[irs] (default = 1)        : starting record'
         write(LER,*)
     1 ' -re[ire] (default=end)        : ending record'
         write(LER,*)
     1 ' -ns[ns] (default = 1)         : starting trace'
         write(LER,*)
     1 ' -ne[ne] (default=end of rec)  : ending trace'
         write(LER,*)'-----------------------'
         write(LER,*)'zero offset correction'
         write(LER,*)'-----------------------'
         write(LER,*)
     1 '                    (if input scaling will be V(t)**2 * t)'
         write(LER,*)
     1 ' -V0[vinit]  (1.0)             : optional velocity divisor'
         write(LER,*)
     1 '              (if input scaling will be ((V(t)**2) * t) / V0)'
         write(LER,*)
     1 ' -root       velocity scaling is sqrt [ v**2 * t ]'
         write(LER,*)
     1 ' -a[alpha] (default = 1.0)     : multiplier'
         write(LER,*)
     1 ' -exp[power] (default = 2.0)   : exponent'
         write(LER,*)
     1 '             (default = 1.0 if -v supplied)'
         write(LER,*)'-----------------------'
         write(LER,*)'angle-based correction'
         write(LER,*)'-----------------------'
         write(LER,*)
     1 ' -md[mode] (default = 0)       : ray tracing mode'
         write(LER,*)
     1 '           0 = straight ray, 1 = curved ray, 2 = perturbed ray'
         write(LER,*)
     1 ' -em[emerg] (default = 0)      : 0=incident angle; 1=emergence'
         write(LER,*)
     1 ' -iord[emerg] (default = no)   : velocity smooth order'
         write(LER,*)
     1 ' -A  use ray tracing to compute spherical divergence'
         write(LER,*)
     1 ' -G  [-A option] output gain surface only'
         write(LER,*)
     1 ' -NMOAP  apply internal NMO (not quite as good as bdnmo)'
         write(LER,*)
     1 '         assumes NMO applied upstream.  Be sure to unapply'
         write(LER,*)
     1 '         NMO after ttothen and also restore mute (mute -R)'
         write(LER,*)' '
         write(LER,*)'------'
         write(LER,*)'Flags'
         write(LER,*)'------'
         write(LER,*)
     1 ' -E  Do alpha*exp(power*t), else alpha*t**power'
         write(LER,*)
     1 ' -I  Apply inverse of gain curve'
         write(LER,*)
     1 ' -V  Verbose mode.  All command line and lineheader parameters'
         write(LER,*)
     1 '                    printed to standard error output'
         write(LER,*)' '
         write(LER,*)
     : 'USAGE:  ',
     : 'ttothen -N[ntap] -O[otap] -rs[irs] -re[ire] -ns[ns] -ne[ne]',
     : '       -a[] -exp[] [ -v[vtap] -root -V0 -E -A -G -NMOAP -I -V]'
         write(LER,*)
     1 '***************************************************************'
      return
      end

      subroutine cmdln(ntap,otap,ns,ne,irs,ire,alpha,power,verbos, GN,
     1           invers, expon, vtap, VelInit, vrt,angdiv,MODe,emerg,
     2           saf, iord, NMOAP)

#include <f77/iounit.h>

c-----
c     get command arguments
c
c     ntap  - C*100  input file name
c     otap  - C*100  output file name
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c    alpha  - R      multiplier
c    power  - R      exponent
c    invers - L      apply inverse curve
c    verbos - L      verbose output or not
c-----
      integer     argis, ns,ne,irs,ire,mode,emerg
      real        alpha, power, VelInit
      character   ntap*256, otap*256, vtap*256
      logical     verbos, invers, expon, vrt, angdiv,  GN, NMOAP
c------------------------------------------------------------------------------
c        ARGXXX has parameters
c             ( flag, variable name, default value, format error value )
c------------------------------------------------------------------------------
      NMOAP  = ( argis ('-NMOAP') .gt. 0 )
      call ARGSTR ('-N', ntap, ' ', ' ' )
      call ARGSTR ('-O', otap, ' ', ' ' )
      call ARGSTR ('-v', vtap, ' ', ' ' )
      call ARGR4 ('-V0', VelInit, 1.0, 1.0)
      call ARGI4  ('-ns', ns, 0, 0)
      call ARGI4  ('-ne', ne, 0, 0)
      call ARGI4  ('-rs', irs, 0, 0)
      call ARGI4  ('-re', ire, 0, 0)
      call argi4 ('-md',  mode, 0, 0)
      call argi4 ('-em',  emerg, 0, 0)
      call argi4 ('-iord', iord, 0, 0)
      if ( mode .gt. 2) mode = 0
      call ARGR4  ('-a', alpha, 1.0, 1.0)
c
c changed to default power to 0 in cmdln - 4/15/98 - jev
c in main will set power to 2 if no vtap or 1 if vtap
c
      call ARGR4  ('-exp', power, 0.0, 0.0)
c     call ARGR4  ('-exp', power, 2.0, 2.0)
c
      vrt    = ( argis ('-root') .gt. 0 )
      angdiv = ( argis ('-A') .gt. 0 )
      expon  = ( argis ('-E') .gt. 0 )
      invers = ( argis ('-I') .gt. 0 )
      GN     = ( argis ('-G') .gt. 0 )
      verbos = ( argis ('-V') .gt. 0 )

      return
      end
