C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine flint (xi, x, nx, yi, y, ny)

      real   xi (*), yi (*)
      real   x  (*), y  (*)

      i = 1
      if ( yi(1) .le. xi(i) ) then
         do  j = 1, ny
             if ( yi(j) .le. xi(i) ) then
                y (j) = x (i)
             else
                i = i + 1
                go to 1
             endif
         enddo
      endif

1     continue

      j1 = j

      do  j = j1, ny

          IF (yi(j) .le. xi(nx) ) THEN

             if ( yi(j) .ge. xi(i) ) then
                 i = i + 1
                 if (i .gt. nx) go to 2
             endif

             if ( yi(j) .ge. xi(i-1) .AND. yi(j) .le. xi(i) ) then
                dx = xi (i) - xi (i-1)
                da = x  (i) - x  (i-1)
                if (dx .gt. 0.0) then
                   s = da / dx
                else
                   s = 0.0
                endif
                y (j) = x (i-1) + s * ( yi (j) - xi (i-1) )
             endif

          ELSE

             go to 2
          ENDIF
      enddo

2     continue

      j2 = j + 1

      if (j2 .lt. ny) then
         do  j = j2, ny

             y (j) = x (nx)
         enddo
      endif

      return
      end
