C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine  tvboost (ns, N, N21, lslide, nwin, ovlp,
     1                     x, y,  amp, phz, workc, gain,
     2                     work, hold1, sumb, first)

      real     x (ns), amp (N), phz (N), gain (N21, nwin)
      real     y (ns), work (ns), hold1 (ns), sumb (ns)
      complex  workc (N)
      integer  ns, N, N21, lslide, nwin, ovlp
      integer  i,jj
      logical  first

C+---------------------------------------------------------+
C |                                                         |
C | Parameters are:                                         |
C |    x     - Data to be processed                         |
C |   ns     - Number of samples to process (total)         |
C |   lopp   - Operator length (samples)                    |
C |   pred   - Prediction length (samples or zero crossings)|
C |   pw     - Prewhitening (fraction)                      |
C |   lslide - Length of the sliding window                 |
C |   nwin   - Number of windows                            |
C |   ovlp   - Overlap between windows                      |
C |                                                         |
C +---------------------------------------------------------+

C +----------------------------------------------------+
C | COMPUTE AND REMOVE THE AVERAGE                     |
C +----------------------------------------------------+
      imid1 = 0
      DO  KK = 1, nwin
 
          if (kk .eq. 1) then
             nmove  = lslide + ovlp
             ilast  = lslide + ovlp
             ifirst = 1
             if(lslide .eq. ns) nmove = ns
             jmove  = nmove
          else
             nmove  = lslide + ovlp
             jmove  = nmove
             ifirst = ifirst + ovlp
             imid1  = ifirst
             ilast  = ifirst + nmove - 1
             if (ilast .gt. ns)then
                 jmove = ns - ifirst + 1
             endif
          endif
 
          xd = 0.
          xa = 0.
          do  i = 1, jmove
              xt = x (i + ifirst - 1)
              work (i) = xt
              xa = xa + xt
              xd = xd + xt * xt
          enddo
          xd = sqrt ( xd ) / float(jmove)
          xa = xa / float(jmove)
          do  i = 1, jmove
              work (i) = work (i) - xa
          enddo
          do  i = jmove+1, N
              work (i) = 0.
          enddo
 
          lwind  = jmove
C +----------------------------------------------------+
C | DO THE time varying frequency boosting             |
C +----------------------------------------------------+
          if (xd .gt. 1.e-30) then

             call vclr (workc, 1, N)

             call rfftb  (work, workc, N, +1)
             call rfftsc (workc, N, 3, 1)
 
             call cvabs  (workc, 2, amp, 1, N21)
             call cvphas (workc, 2, phz, 1, N21)

             adi = 0.
             do  i = 1, N21
                 adi = adi + amp (i)
             enddo

             call vmul   (amp, 1, gain(1,kk), 1, amp, 1, N21)

             ado = 0.
             do  i = 1, N21
                 ado = ado + amp (i)
             enddo

             amax = adi / ado
             call vsmul  (amp, 1, amax, amp, 1, N21)

             call cvmexp (phz, 1, amp, 1, workc, 2, N21)

             call rfftsc (workc, N, -3, 0)
             call rffti  (workc, work, N)

          else

             call vclr (work, 1, lwind)

          endif

           do  i = 1, lwind
               hold1 (i) = work (i)
           enddo


      IF (kk.eq.1) THEN
 
        do  i = 1, lwind
            sumb (i) = hold1 (i)
        enddo
 
      ELSE
 
        jj = imid1 - 1
        xj = ovlp
 
        do  i = 1, ovlp
            jj = jj + 1
            x1 = (i-1) / xj
            x2 = 1.0 - x1
            sumb(jj) = sumb(jj) * x2 + hold1(i) * x1
        enddo
 
        do  i = ovlp+1, jmove
            jj = jj + 1
            sumb (jj) = hold1 (i)
        enddo
 
      ENDIF

      ENDDO
 
      do  i = 1, ns
          y(i) = sumb (i)
      enddo
 
      first = .false.

      RETURN
      END

