C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c Program to scale data to any user defined range
c Originally this was rewquested as a landmark conversion
c so, the defaults are set to that.
c 
c Author: James M. Gridley USP Team
c 21 August 1995
c
c     Program Changes:
c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, nreco, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     ist, iend, irs, ire, argis
      integer     ivmax, ivmin

      character   ntap*255, otap*255, name*4

      logical     verbos, trc, rec, job	

c Program Specific _ dynamic memory variables

      integer RecordSize, HeaderSize, errcd1, errcd2, errcd3, abort
      integer Headers

      real    Record, Record_WorkSpace
      real    vmin, vmax, smin, smax, slope, intcpt

      pointer (memadr_Record, Record(200000))
      pointer (memadr_Space, Record_WorkSpace(200000))
      pointer (memadr_Headers, Headers(200000))

c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor

      integer hdr_index, tr_index, JJ, KK

c Initialize variables

      data abort/1/
      data name/"UDRS"/
      data trc/.false./
      data rec/.false./
      data job/.false./

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos, rec, trc, job, ivmin, ivmax )

	if (.not. rec .and. .not. job .and. .not. trc) then
         write(LER,*)'UDRS: no scaling type '
         write(LER,*)'Please check the command line arguments'
         write(LER,*)'and be sure you have one of the following'
         write(LER,*)'-job  -rec  -trace'
         write(LER,*)'Abnormal Completion'

         write(LERR,*)'UDRS: no scaling type '
         write(LERR,*)'Please check the command line arguments'
         write(LERR,*)'and be sure you have one of the following'
         write(LERR,*)'-job  -rec  -trace'
         write(LERR,*)'Abnormal Completion'

	stop
	endif

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'UDRS: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c print HLH to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      dtmsec = float(nsi)
      ist = nint ( float(ist) / dtmsec )
      iend = nint ( float(iend) / dtmsec )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1

c modify line header to reflect actual record configuration output
c NOTE: in this case the trace and sample limits are used to 
c       limit processing only.   All data within the selected record
c       range are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)

c number output bytes

      obytes = SZTRHD + SZSMPD * nsamp 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c set up pointers to header mnemonic StaCor

      call savelu ( 'StaCor', ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, dtmsec, ntrc, nrec, iform, 
     :     ist,iend, irs, ire, verbos,job,rec,trc,ivmax,ivmin)

c dynamic memory allocation:  

      RecordSize = ntrc * nsamp 
      HeaderSize = ntrc * ITRWRD 

      call galloc (memadr_Record, RecordSize * SZSMPD, errcd1, abort)
      call galloc (memadr_Space, RecordSize * SZSMPD, errcd2, abort)
      call galloc (memadr_Headers, HeaderSize * SZSMPD, errcd3, abort)
    
      if ( errcd1 .ne. 0 .or.
     :     errcd2 .ne. 0 .or.
     :     errcd3 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) 2*RecordSize+HeaderSize* SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
      call vclr ( Record, 1, RecordSize )
      call vclr ( Record_WorkSpace, 1, RecordSize )
      call vclr ( Headers, 1, HeaderSize )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )
c
	smax = Record(1)
	smin = Record(1)

      DO JJ = irs, ire

c load record to memory

         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD

          DO KK = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c set array load points for this trace 

           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD

c process only live traces and zero out dead traces

           call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :          TRACEHEADER )

           if ( StaCor .ne. 30000 ) then

c load trace to array Record[]

              call vmov ( itr(ITHWP1), 1, Record(tr_index), 1, nsamp )

           else
              call vclr ( Record(tr_index), 1, nsamp )
           endif

c load trace header to array Headers[]

            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )

         ENDDO

c==================================================================
c look for potential underflow errors

	do ii = 1, nsamp*ntrc
		if(abs(Record(ii)) .lt. 10E-30) then
		Record(ii) = 0.
		endif
	enddo
c==================================================================
	if(rec) then
         call srec ( Record, Headers, Record_WorkSpace, nsamp, ntrc, 
     :        ist, iend, ivmin, ivmax )
	endif

	if (trc) then	
      call strc (Record, Headers, Record_WorkSpace, nsamp, ntrc,
     : ist, iend, ivmin, ivmax )
	endif
	
	if (job) then

	do ii = 1, nsamp*ntrc
	  smax=max(smax,Record(ii))
	  smin=min(smin,Record(ii))
	enddo

	endif
c==================================================================
c reset array load points for this trace 

           tr_index = 1 - nsamp
           hdr_index = 1 - ITRWRD

c write output data

	if (.not. job) then

         DO KK = 1, ntrc

            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD

            call vmov ( Record(tr_index), 1, itr(ITHWP1), 1, nsamp )
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape (luout, itr, obytes)
 
         ENDDO
	endif

      ENDDO
c==================================================================
	if (job) then
	vmax=float(ivmax)
	vmin=float(ivmin)

               slope = (vmax-vmin)/(smax - smin)
               intcpt = vmax - ((slope)*smax)

         call rwd (luin)

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'UDRS: no header read from unit ',luin
         write(LER,*)'FATAL'
         stop
      endif
      DO JJ = irs, ire
 
c load record to memory
 
         tr_index = 1 - nsamp
         hdr_index = 1 - ITRWRD
 
          DO KK = 1, ntrc
 
            nbytes = 0
            call rtape( luin, itr, nbytes)
 
c if end of data encountered (nbytes=0) then bail out
 
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
 
c set array load points for this trace
 
           tr_index = tr_index + nsamp
           hdr_index = hdr_index + ITRWRD
 
c process only live traces and zero out dead traces
 
           call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor,
     :          TRACEHEADER )
           if ( StaCor .ne. 30000 ) then
 
c load trace to array Record[]
 
              call vmov ( itr(ITHWP1), 1, Record(tr_index), 1, nsamp )
 
           else
              call vclr ( Record(tr_index), 1, nsamp )
           endif
 
c load trace header to array Headers[]
 
            call vmov ( itr, 1, Headers(hdr_index), 1, ITRWRD )
 
         ENDDO
                DO ii = 1, nsamp*ntrc
                  Record(ii)= (Record(ii)*slope) + intcpt
                ENDDO
 
c reset array load points for this trace
 
           tr_index = 1 - nsamp
           hdr_index = 1 - ITRWRD
 
c write output data
 
         DO KK = 1, ntrc
 
            tr_index = tr_index + nsamp
            hdr_index = hdr_index + ITRWRD
 
            call vmov ( Record(tr_index), 1, itr(ITHWP1), 1, nsamp )
            call vmov ( Headers(hdr_index), 1, itr(1), 1, ITRWRD )
            call wrtape (luout, itr, obytes)
 
         ENDDO
      ENDDO

	endif
c==================================================================
c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'UDRS: Normal Termination'
      write(LER,*)'UDRS: Normal Termination'
      stop

 999  continue
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'UDRS: ABNORMAL Termination'
      write(LER,*)'UDRS: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for UDRS'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)' '
      write(LER,*)'-vmin[]-- minimum scaling range            (-128)'
      write(LER,*)'-vmax[]-- maximum scaling range            ( 127)'
      write(LER,*)' '
      write(LER,*)'-rec   -- record constant scaling'
      write(LER,*)'-trace -- trace constant scaling'
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'      udrs -N[] -O[] -s[] -e[] -rs[] -re[] '
      write(LER,*)'                -vmin[] -vmax[] [ -rec -trace -V ]'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, irs, ire, ist, iend, 
     :     name, verbos, rec, trc, job, ivmin, ivmax )

#include <f77/iounit.h>

      integer    ist, iend, irs, ire, argis
      integer    ivmin, ivmax

      character  ntap*(*), otap*(*), name*(*)

      logical    verbos, trc, rec, job

           trc = (argis('-trace') .gt. 0)

           call argi4 ( '-vmax', ivmax, 127, 127 )
           call argi4 ( '-vmin', ivmin, -128, -128 )

           job = (argis('-job') .gt. 0)

           rec = (argis('-rec') .gt. 0)

           call argi4 ( '-e', iend, 0, 0 )

           call argstr ( '-N', ntap, ' ', ' ' ) 

           call argstr ( '-O', otap, ' ', ' ' ) 

           call argi4 ( '-re', ire, 0, 0 )
           call argi4 ( '-rs', irs, 0, 0 )

           call argi4 ( '-s', ist, 1, 1 )

           verbos = (argis('-V') .gt. 0)

c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal( ntap, otap, nsamp, dtmsec, ntrc, nrec, iform, 
     :     ist,iend, irs, ire, verbos,job,rec,trc,ivmax,ivmin)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire
      integer    ivmax,ivmin

      real       dtmsec

      character  ntap*(*), otap*(*)

      logical    verbos,job,rec,trc

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', dtmsec
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name    =  ', otap
      write(LERR,*) ' start record            =  ', irs 
      write(LERR,*) ' end record              =  ', ire 
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)' '
	if (job) then
      write(LERR,*)' Job Constant Scaling '
	endif
	if (rec) then
      write(LERR,*)' Record Constant Scaling '
	endif
	if (trc) then
      write(LERR,*)' Trace Constant Scaling '
	endif
      write(LERR,*)' '
      write(LERR,*)'Minimum Scaling Range  =  ',ivmin
      write(LERR,*)'Maximum Scaling Range  =  ',ivmax
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end
