/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	the complete SIS interface for ufh
*/

#ifndef SISMEMBER_H
#define SISMEMBER_H

#include <usystype.h>

#ifndef CRAY
#define	HLHOFF	1000
#define	HLHINT	2
#else
#define	HLHOFF	2576
#define	HLHINT	8
#endif

/*
**	The first four fields of SISFieldInfo must exactly duplicate
**	the contents of 'struct hdr' in <save.h>.
*/

typedef enum {LineHeader, TraceHeader, VANLHeader, VSPNHeader}	SISHeaderType;
typedef enum {SISChar, SISShort, SISLong, SISFloat, SISFakeFloat, SISTrace,
		  SISHLHdr, SISHLHLine }
			SISFieldType;

typedef struct {
    char* 		fieldname;	/* NB: points to static storage */
    int 		fieldtype;
    int 		fieldposition;
    int			fieldlength;
    SISHeaderType	headertype;	/* new members begin here */
    SISFieldType	ftype;
    char*		schunk;		/* used during evaluation */
    int			hlhline;
} SISFieldInfo;

#endif
