/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
This replaces the old script for retrieving command line arguments within
a script. I wrote this code to allow for either tight or loose bindings
between the search key and the value associated with it.

Usage: usparg -key default arg1 arg2 arg3 ... argn

If the key is found, the associated value is printed out. If no value is
found ( next arg is of -key form ), a null value is printed.
*/

#include <stdio.h>

void main(argc,argv)
int argc;
char **argv;
{
	int i,j,length;
	char *def,*option,*value;
	option = argv[1];
	length = strlen(option);
	def = argv[2];
	for (i=3; i<argc; i++) {
	  if (strncmp(argv[i],option,length) == 0) {
	     if (strlen(argv[i]) != length) {	/* tight bound arg found */
	       value = argv[i] + length;
	       printf("%s\n",value);
	       exit(0);
	       }
	     else {				/* check next arg if possible */
	       if (i + 1 < argc) {
		 if (*argv[i+1] != '-') {
		   printf("%s\n",argv[i+1]);
		   exit(0);
		   }
		 else {		 /* first char is "-", is it a neg. number? */
		   for (j=1; j<strlen(argv[i+1]); j++) {
		     if (isdigit(*(argv[i+1]+j)) == 0) {
		       printf("\n");
		       exit(0);
		       }
		     }
		   printf("%s\n",argv[i+1]);
		   exit(0);
		   }
	         }
	       }
	     printf("\n");
	     exit(0);
	     }
	  }
	printf("%s\n",def);
        exit(0);
}
