C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-------------
c   Routine to do seismic data processing a` la` image processing using
c   a moving window.  This window should have a rectangular shape.  The
c   size and the degree of overlapping can be determined by the user.
c   Subroutine "locvel" is called to estimate coherency using the semblance
c   method.  
c   For a given window the slowness corresponding to max coherency is
c   assigned to array "outcome" and the max cohereny itself is assigned
c   to "coh".  These arrays are returned.
c-------------

      subroutine  movwin (dt, dx, smax, smin, sstep,
     1                    nrows, ncols, nrows2, ncols2,
     2                    nsearch, vel,
     3                    nsamp, ntrc, wt, wx,
     4                    win, data, outcome, coh,verbos)

#include <f77/iounit.h>

      real      win (nrows,ncols), data (nsamp+nrows, ntrc+ncols)
      real      outcome (nsamp, ntrc), coh (nsamp, ntrc)
      real      wt(nrows), wx(ncols)
      logical   verbos

      rad2deg = 180. / 3.14159265
      a0 = .5
      a1 = .25

c-------------
c  we search local slope w.r.t. the center point in the data window;
c  odd number of nrows & ncols are preferred.  If not so, the progm 
c  will have changed them to odd
c-------------

c-------------
c  noverrows/cols:  # of overlapped rows/cols for parallel windows
c  smin/max      :  min/max slownesses
c  step          :  slowness search step
c-------------

      step    = (smax - smin) / (nsearch - 1)

      do  i = 1, ntrc
          do j = 1, nsamp

             coh (j,i) = 0.
          enddo
      enddo

c-------------
c  coh records the max coherency for the (j,i)th window
c  if the new coherency is > stored one, the old coherency
c  value is replaced by the new one and the new estimate of
c  slowness is assigned to outcome (j,i)
c-------------

      DO  K = 1, nsearch

          slowness = smin + (k-1) *step
          slope = slowness * dx / dt

      if(verbos)
     : write(LERR,*)'K= ',k,slowness, slope, rad2deg*asin(slowness*vel)

          do  i = 1, ntrc

              ii = i + ncols2

              do  j = 1, nsamp

                  jj = j + nrows2

                  do  i1 = 1, ncols
                      wxx = wx(i1)
                      i11 = ii - ncols2 + i1
                      do  j1 = 1, nrows
                          j11 = jj - nrows2 + j1
                          wtx = wxx * wt(j1)
                          win (j1, i1) = wtx * data (j11, i11)
                      enddo
                  enddo

c----------
c   data in mask stored in work
c   next, compute semblance coherency
c----------


                  coherency = 0.
                  sum = 0.

                  ib = 0
                  do  ix = 1, ncols

                      iy = slope * (ix - ncols2) + nrows2
                      if (iy .ge. 1 .AND. iy .le. nrows) then
                          ib = ib + 1
                          wrki = win (iy, ix)
                          sum  = sum + wrki
                          coherency = coherency + wrki * wrki
                      endif
                  enddo

                  if (coherency .ne. 0.) then
                      coherency = sum * sum / coherency
                      coherency = coherency /  ib
                  endif


                  if (coh(j,i) .le. coherency) then
                      coh (j,i) = coherency

                      if(coh(j,i).gt.1.e-30)then
                         outcome (j,i) = rad2deg * asin (slowness * vel) 
                      else
                         outcome (j,i) = 0.
                      endif

                  endif

              enddo
          enddo


      ENDDO


         do  j = 1, ntrc
             do  i = 2, nsamp-1

                 coh (i,j) = a1 * coh (i-1,j) + a0 * coh (i,j) +
     1                       a1 * coh (i+1,j)
             enddo
             coh (1,j)     = .5 * (coh(1,j) + coh (2,j))
             coh (nsamp,j) = .5 * (coh(nsamp,j) + coh (nsamp-1,j))
         enddo

         do  i = 1, nsamp
             do  j = 2, ntrc-1

                 coh (i,j) = a1 * coh (i,j-1) + a0 * coh (i,j) +
     1                       a1 * coh (i,j+1)
             enddo
             coh (i,1)     = .5 * (coh(i,1) + coh(i,2))
             coh (i,ntrc)  = .5 * (coh(i,ntrc) + coh(i,ntrc-1))
         enddo


      return
      end
