C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XSDInitialize ( luvel, NumberOfSegments, 
     :     PicksPerSegment, XSDSampleUnits, XSDSampleOffset, 
     :     XSDVelocityUnits, XSDVelocityOffset, 
     :     recpik )

c routine to find number segments in XSD pick file
c and to count the number of picks in each segment 
c [note: this is not required with new XSD pick format but
c is required with old pick format].  It is also determined
c if the pick file is indexed wrt single trace or multi trace
c records.

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c subroutine arguments from calling routine

      integer  luvel, NumberOfSegments, PicksPerSegment(*)
      integer  XSDSampleUnits, XSDSampleOffset

      real     XSDVelocityUnits, XSDVelocityOffset

      logical  recpik

c internal subroutine variables 
    
      integer  irecz0(SZSMPM), itrcz0(SZSMPM), itz0(SZSMPM)
      integer  nrec, ntrc, nsmp, nsegments, maxpicks, NumberOfPicks

      real     rjunk, dum1, fac, rr, tr, tt
      real     recunit, trcunit, smpunit, recoff, trcoff, smpoff

      character junk*1

c initilize integer memory

      do i=1,SZSMPM
         irecz0(i) = 0
         itrcz0(i) = 0
         itz0(i) = 0
      enddo

c read pick file header assuming new XSD format.

      read ( luvel, 100, err = 200 , end = 911 ) recunit, trcunit, 
     :     smpunit, nrec, ntrc, nsmp, recoff, trcoff, smpoff, nsegments,
     :     maxpicks

 100  format ( 6x, f12.6, 1x, f12.6, 1x, f12.6, 1x, i5, 1x, i5, 1x, i5, 
     :     7x, f12.6, 1x, f12.6, 1x, f12.6, 8x, i5, 1x, i5 )

      XSDSampleOffset = nint ( smpoff )
      XSDSampleUnits = nint ( smpunit )
      XSDVelocityUnits = trcunit
      XSDVelocityOffset = trcoff

      goto 300

 200  continue

c try using old XSD format, if it still fails then exit

      rewind ( luvel )
      read(luvel, 101, err=900 ) junk, dum1, XSDVelocityUnits, rjunk

 101  format(a1,4x,f13.6,f13.6,f13.6)

      XSDSampleOffset = 0
      XSDSampleUnits = nint ( rjunk )

 300  continue

c count segments and number of picks in each segment

      NumberOfSegments = 1
      NumberOfPicks = 0

      read(luvel, '(a1)', err=900, end = 912) junk
 1    read(luvel, '(a1)', err=900, end = 910) junk

      if(junk .ne. 'S') then
         NumberOfPicks = NumberOfPicks + 1
         go to 1
      else
         PicksPerSegment(NumberOfSegments) = NumberOfPicks
         NumberOfSegments = NumberOfSegments + 1
         NumberOfPicks = 0
         go to 1
      endif

 910  continue

      PicksPerSegment(NumberOfSegments) = NumberOfPicks

 912  continue

      fac = 1.

      do i = 1, NumberOfSegments
         fac = fac * float(PicksPerSegment(i))
      enddo

c POLICEMAN: If user has used vxos and not indicated new picks he may
c            output a pick file with nothing in the segment but with
c            a pick file header.  This check will catch this error.

      if(NumberOfSegments .eq. 1 .and. fac .eq. 0.) then
         write(LERR,*)'VELIN: XSD pick file starts with an empty'
         write(LERR,*)'        segment. Fix this and rerun.'
         write(LERR,*)'FATAL'
         stop
      endif

      rewind luvel

c read down to first horizon

      read(luvel, '(a1)', err=900) junk

c scan down thru all segments to check whether segments are restricted
c to records or not

      itest = 1

      DO j = 1, NumberOfSegments
         read(luvel,'(a1)', err=900) junk

         do i = 1, PicksPerSegment(j)
            read(luvel, 102, err=900) rr, tr, tt
 102        format( 1x,f12.6,1x,f12.6,1x,f12.6)

            itrcz0(i) = ifix(tr)
            irecz0(i) = ifix(rr)

            if (i .ge. 2) then
               if (irecz0(i) .ne. irecz0(i-1)) then
                  itz0(j) = 0
                  go to 4
               else
                  itz0(j) = 1
               endif
            endif
         enddo
         
 4       itest = itest * itz0(j)
      ENDDO

      if (itest .eq. 1) then
         recpik = .true.
         write(LERR,*)'picks are made within records'
      else
         recpik = .false.
         write(LERR,*)'picks are made across record boundaries'
      endif

c for one segment pass read down to input segment

      rewind luvel
      read(luvel,'(a1)', err=900) junk
      return

 900  continue
      write(LERR,*)'VELIN: Error reading XSD pick file'
      write(LERR,*)'       Fix pick file and rerun.'
      write(LERR,*)'FATAL'
      stop

 911  continue
      write(LERR,*)'VELIN: Empty XSD pick file '
      write(LERR,*)'FATAL'
      stop
      end
