C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----------------routine VELIN--------------------------
c
c   Changes:
c
c      May 1 2001: fixed a declaration in vfile.F where nsamp was used
c                  but not passed from the main.  Also stuck implicit none
c                  into a few routines to check for undeclared variables
c      Garossino
c
c      May 20, 1999: reworked usp input option to allow interpolation with
c                    USP input format.  Previously only did conversion but
c                    no interpolation.
c
c         Aug 16 1994  Paul G. A. Garossino
c
c	* vfile.F (vfile): improved error message for bad flat file format.
c
c Mods P.G.A. Garossino, TRC, 1991
c
c Complete refit P.G.A. Garossino APR, 1993
c
c Original by  R.B. Herrmann, Saint Louis University, 1986
c
c velin reads (sample,velocity) data in various formats, converts to 
c a user specified (sample,velocity) format and generates a velocity 
c dataset in USP format for use with programs bdnmo, anmo and dipnmo.  The input
c may be sampled in depth or time, while the input velocity may be interval
c average or rms.  The output may be any combination of the above. 
c
c Input velocity function format may be :
c
c       USP velocity dataset (the default)
c       hmig (Sattlegger) velocity computation (EVMIG Option 16)
c       tensor  
c       tdfn
c       xsd pickfile
c       xvos pickfile 
c       flatfile 
c       disco handvel cards [right or left justified]
c
c All velocity conversions are calculated using Dix so all Dix 
c limitations apply.
c-----------------------------------------------------------------------

c platform dependant variables

      implicit none
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>

c standard USP variables 

      integer    lhed( SZLNHD )
      integer    nsamp, nsi, ntrc, nrec, nreco,iform 
      integer    lvhed( SZLNHD )
      integer    nsampv, nsiv, ntrcv, nrecv
      integer    luin, luout, luvel
      integer    nbytes, obytes, lbytes, lbyout
      integer    lentap, leotap, pipe, argis
 
      real       tri( SZLNHD )

      character  ntap*256, otap*256

      logical    verbos, rnmo

c variable used in dynamic memory allocation

      integer     sizeVelFunctions, abortVelFunctions, errcdVelFunctions

      real        VelFunctions
      pointer     (VelFunctionsadr, VelFunctions(1))

c program specific variables

      integer    InputVelocityIndex(2*SZLNHD), InputDataIndex(2*SZLNHD)
      integer    PicksPerSegment(2*SZLNHD)
      integer    VelSequentialRecordNumber(2*SZLNHD)
      integer    XSDSampleUnits, XSDSampleOffset, XSDSampleUnitsOverride
      integer    nsiOverride, osi, XSDsegmentNumber
      integer    MBSdx, MBSdy, MBSdz
      integer    InitialInputDataIndex
      integer    NumTotalVelFcns
      integer    RecNum, StaCor, leptap, lupick
      integer    TrcNum, Index, VelFunctionsIndex
      integer    l_RecNum, l_TrcNum, l_Index, l_StaCor
      integer    ln_RecNum, ln_Index, ln_StaCor, ln_TrcNum
      integer    fmt_RecNum, fmt_StaCor, fmt_Index, fmt_TrcNum

      integer i, jerr, lenth, ierr, iformv, JJ, irec, k, KK, ll

      real       XSDVelocityUnits, XSDVelocityOffset
      real       XSDVelUnitsOverride, XSDInitVelOverride
      real       SlopeAdjustmentFactor

      character  sin*1, vin*1, sout*1, vout*1
      character  vtap*256, name*5  ,iwd*6, ptap*256

      logical    single, EndFunctionReadFlag
      logical    src, rcvr, cdp, pri
      logical    ReverseIndexOrder, regular, recpik, ilis
      logical    hmig, tensor, flat, tdfn, tape, disco, xsd
      logical    XSDHeaderWritten, Force
 
c initialize  variables

      data name/'VELIN'/
      data lbytes/0/
      data nbytes/0/
      data lbyout/0/
      data pipe/3/
      data tape/.false./
      data ilis/.false./
      data ReverseIndexOrder/.false./
      data EndFunctionReadFlag/.false./
      data abortVelFunctions/0/
      data XSDHeaderWritten/.false./
      data XSDsegmentNumber/0/

c check for help request from user

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-H' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c initialize memory

      do i = 1,2*SZLNHD
         InputVelocityIndex(i) = 0
         InputDataIndex(i) = 0
         VelSequentialRecordNumber(i) = 0
         PicksPerSegment(i) = 0
      enddo

c open printout files
 
#include <f77/open.h>
 
c read command line parameters

      call cmdln ( ntap, otap, vtap, ptap, single, regular, 
     :     iwd, src, rcvr, cdp, pri,
     :     disco, hmig, tensor, xsd, flat, tdfn, 
     :     XSDInitVelOverride, XSDVelUnitsOverride,
     :     XSDSampleUnitsOverride,
     :     nsiOverride, osi,
     :     sin, vin, sout, vout, 
     :     MBSdx, MBSdy, MBSdz,
     :     ilis,
     :     SlopeAdjustmentFactor, Force, verbos, rnmo)

c open input and output datasets

      lentap = lenth ( ntap )
      leotap = lenth ( otap )

      call getln ( luin , ntap , 'r' , 0 )
      call getln ( luout , otap , 'w' , 1 )

c open output XSD pickfile dataset if output of XSD pickfile requested

      if ( ptap .ne. ' ' ) then
         call alloclun ( lupick )
         leptap = lenth(ptap)
         open ( unit = lupick, file = ptap(1:leptap), 
     :        status = 'unknown', iostat = ierr )
         if(ierr .ne. 0) then
            write(LER,*)'VELIN: Could not open output file ',
     :           ptap(1:leptap)
            write(LER,*)'       Check write permissions in output '
            write(LER,*)'        directory'
            write(LER,*)'FATAL'
            stop
         endif
      endif

c handle large I/O buffer determination

      if ( luin .ne. 0 ) call sislgbuf ( luin, 'off' )

c read input dataset line header

      lbytes = 0
      call rtape ( luin, lhed, lbytes )
      if(lbytes .eq. 0) then
	 if (lentap .gt. 0) then
           write(LERR,*)'VELIN: no line header read on ',
     :		ntap(1:lentap)
	 else
           write(LERR,*)'VELIN: no line header read on stdin'
	 endif
         write(LERR,*)'FATAL'
         stop
      endif

c record Historical Line Header in printout file

      call hlhprt ( lhed, lbytes, name, 5, LERR )

c assign standard usp variables (nsi,ntrc etc.)

      call saver ( lhed, 'NumSmp', nsamp , LINHED )
      call saver ( lhed, 'SmpInt', nsi   , LINHED )
      call saver ( lhed, 'NumTrc', ntrc  , LINHED )
      call saver ( lhed, 'NumRec', nrec  , LINHED )
      call saver ( lhed, 'Format', iform , LINHED )

c open input velocity file using appropriate format and set initiation
c parameters

      call vfile ( luvel, vtap, nsi,  
     :     lvhed,  nsampv, nsiv, ntrcv, nrecv, iformv,
     :     disco, hmig, tensor, xsd, flat, tdfn, tape,
     :     XSDVelocityUnits, XSDSampleUnits, 
     :     XSDVelocityOffset, XSDSampleOffset, PicksPerSegment,
     :     XSDInitVelOverride, XSDVelUnitsOverride, 
     :     XSDSampleUnitsOverride, nsamp,
     :     NumTotalVelFcns,recpik, verbos )

c if there is only one function set the single flag to true, this will
c obviate the need for -S on the command line.

      if ( NumTotalVelFcns .eq. 1 ) single = .true.

c build pointers for later access of trace header entries

      call savelu ( 'RecNum', fmt_RecNum, l_RecNum, ln_Recnum, 
     :     TRACEHEADER )
      call savelu ( 'StaCor', fmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER )
      call savelu ( 'TrcNum', fmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :     TRACEHEADER )
 
c form line header for output dataset 

      call savhlh ( lhed, lbytes, lbyout )
      nreco = nrec
      if ( single ) nreco = 1

      call savew ( lhed, 'NumTrc',   1   , LINHED )
      call savew ( lhed, 'Dx1000',  MBSdx,  LINHED )
      call savew ( lhed, 'Dy1000',  MBSdy,  LINHED )
      call savew ( lhed, 'Dz1000',  MBSdz,  LINHED )
      call savew ( lhed, 'NumRec', nreco , LINHED )

c handle output sample interval override

      if ( osi .ne. nsi .and. osi .ne. 0 ) then
         call savew ( lhed, 'SmpInt', osi, LINHED )
      endif

c write lineheader to output velocity dataset

      call wrtape ( luout, lhed, lbyout )
      
c dynamic memory allocation for velocity array VelFunctions() 

      sizeVelFunctions = ( nsamp * ( NumTotalVelFcns + 1 ) )

      call galloc ( VelFunctionsadr, sizeVelFunctions * SZSMPD,
     :     errcdVelFunctions, abortVelFunctions )

      if ( errcdVelFunctions .ne. 0 ) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) sizeVelFunctions,'  bytes'
         write(LERR,*)'FATAL ........... '
         write(LER,*)' '
         write(LER,*)'VOMIT: '
         write(LER,*)' Unable to allocate workspace:'
         write(LER,*)  sizeVelFunctions,'  bytes'
         write(LER,*)'FATAL'
         write(LER,*)' '
         stop
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) sizeVelFunctions,'  bytes'
         write(LERR,*)' '
      endif

c initialize memory

      call vclr ( VelFunctions, 1, sizeVelFunctions)

c assign index variable as defined by user

      if ( iwd .eq. ' ' ) then
         if ( src ) then
            iwd = 'SrcLoc'
         elseif ( rcvr ) then
            iwd = 'RecInd'
         elseif ( cdp ) then
            iwd = 'DphInd'
         elseif ( pri ) then
            iwd = 'PrRcNm'
         else
            iwd = 'RecNum'
         endif
      endif

      call savelu ( iwd, fmt_Index, l_Index, ln_Index, TRACEHEADER )

c print global program parameters to printout file

      call verbal ( nsamp, nsi, ntrc, nrec, nrecv, iform, nsampv, nsiv,
     :     ntrcv, iformv, iwd, sin, sout, vin, vout, nsiOverride, ilis,
     :     osi, vtap, ntap, otap, ptap, tape, SlopeAdjustmentFactor, 
     :     Force)

c load InputDataIndex() with appropriate trace header information.  If
c regular numbering option chosen then read first Index value and
c increment by one for number of input records in the seismic dataset.
c If default then read first trace of every input seismic record 
c and record the appropriate Index in the InputDataIndex() array.

      nbytes = 0
      
      IF ( .not. regular ) then

         DO jj = 1, nrec

            call rtape ( luin, lhed, nbytes )

            if ( nbytes .eq. 0 .and. jj .eq. 1 ) then
	       if (lentap .gt. 0) then
                 write(LERR,*)'VELIN: No data found in ',
     :			ntap(1:lentap)
	       else
                 write(LERR,*)'VELIN: No data found on stdin'
	       endif
               write(LERR,*)'FATAL'
               stop
            elseif ( nbytes .eq. 0 ) then
               write(LERR,*)'VELIN: Premature EOF encountered at ',
     :                             'sequential record= ',jj
               write(LERR,*)'       Will continue with short dataset'
               write(LERR,*)'WARNING'
               nrec = jj-1
               go to 100
            endif

            obytes = nbytes

            if ( src ) then
               call saver2( lhed, fmt_Index, l_Index, ln_Index, Index,
     :              TRACEHEADER )
               InputDataIndex(jj) = Index / 10
            else
               call saver2 ( lhed, fmt_Index, l_Index, ln_Index,
     :              InputDataIndex(jj), TRACEHEADER )
            endif

c skip past remaining traces 

            if ( ntrc .ge. 2 ) 
     :           call trcskp ( jj, 2, ntrc, luin, ntrc, lhed )
           
         ENDDO
 100     continue

      ELSE

c regular numbering in effect 

         call rtape ( luin, lhed, nbytes )
         if(nbytes .eq. 0) then
	    if (lentap .gt. 0) then
              write(LERR,*)'VELIN: No data found in ',
     :			ntap(1:lentap)
	    else
              write(LERR,*)'VELIN: No data found on stdin'
	    endif
            write(LERR,*)'FATAL'
            stop
         endif

         obytes = nbytes

c get initial index from first trace of first record

         if ( src ) then
            call saver2 ( lhed, fmt_Index, l_Index, ln_Index, Index,
     :           TRACEHEADER )
            InitialInputDataIndex = Index / 10
         else
            call saver2 ( lhed, fmt_Index, l_Index, ln_Index,
     :           InitialInputDataIndex, TRACEHEADER )
         endif

c build rest of InputDataIndex() based on unit increment

         do  jj = 1, nrec
            InputDataIndex(jj) = InitialInputDataIndex + jj - 1
         enddo

         call lbclos ( luin )

      ENDIF

c POLICEMAN: watch out for InputDataIndex decrementing

      if ( InputDataIndex(1) .lt. InputDataIndex(nrec) ) then
         ReverseIndexOrder = .false.
      else
         ReverseIndexOrder = .true.
      endif

c POLICEMAN: if input StaCor entry is 30000 change it to zero on
c            output velocity dataset [we don't want any velocity traces flagged 
c            dead by accident]

      call saver2 ( lhed, fmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :     TRACEHEADER )
      if ( StaCor .eq. 30000 ) StaCor = 0
      call savew2 ( lhed, fmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :     TRACEHEADER )

c apply sample increment override if requested

      if ( nsiOverride .ne. 0 ) nsi = nsiOverride

      IF ( single ) then

c SINGLE VELOCITY FUNCTION:  -S  on command line
c
c     read single velocity function
c     generate one output trace per input record using this function
c     make sure trace header entry for RecNum is appropriate

         write(LERR,*)'VELIN: Using single velocity function'

c   load velocity data to tri() array

         call velinp ( tri, nsamp, nsi, vtap, luvel, lvhed, nsampv, 
     :        osi, tensor, xsd, disco, hmig, flat, tdfn, tape,
     :        XSDInitVelOverride, XSDVelUnitsOverride,
     :        XSDSampleUnits,XSDSampleOffset,
     :        XSDVelocityUnits, XSDVelocityOffset,
     :        PicksPerSegment, ptap, lupick, 
     :        1, irec, EndFunctionReadFlag, 
     :        sin, vin, sout, vout,
     :        ilis, XSDHeaderWritten, XSDsegmentNumber,
     :        nrec, ntrc,
     :        SlopeAdjustmentFactor, Force, verbos, rnmo)

c clear the output trace header so that only pertinent output information
c may be loaded.  This will hopefully prevent confusion on indexing on
c the output velocity data.

         call vclr ( lhed, 1, ITRWRD )

         do k = 1, nreco

c update RecNum and TrcNum on output trace

            RecNum = InputDataIndex(k)
            call savew2 ( lhed, fmt_RecNum, l_RecNum, ln_RecNum, RecNum,
     :           TRACEHEADER )
            TrcNum = 1
            call savew2( lhed, fmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum,
     :           TRACEHEADER )

c update trace header index for index used if other than RecNum

            if ( src ) then
               call savew2 ( lhed, fmt_Index, l_Index, ln_Index, 
     :              RecNum*10, TRACEHEADER )
            else
               call savew2 ( lhed, fmt_Index, l_Index, ln_Index, 
     :              RecNum, TRACEHEADER )
            endif

c write out single velocity function to entire output dataset

            call vmov ( tri(1), 1, lhed(ITHWP1), 1, nsamp )
            call wrtape ( luout, lhed, obytes )

         enddo

c finished, branch to normal termination

         go to 999

      ELSE

c MULTIPLE VELOCITY FUNCTIONS: 
c
c     read in all velocity functions
c     extrapolate / interpolate velocity traces as required
c     make sure trace header entry for RecNum is appropriate

         NumTotalVelFcns = 1
         EndFunctionReadFlag = .false.

 110     continue

c initialize record number prior to function read 
         
         irec = 0

c load next velocity function to tri() array

         call velinp ( tri, nsamp, nsi, vtap, luvel, lvhed, nsampv,
     :        osi, tensor, xsd, disco, hmig, flat, tdfn, tape,
     :        XSDInitVelOverride, XSDVelUnitsOverride, 
     :        XSDSampleUnits, XSDSampleOffset, 
     :        XSDVelocityUnits, XSDVelocityOffset,
     :        PicksPerSegment, ptap, lupick, 
     :        NumTotalVelFcns, irec, EndFunctionReadFlag,
     :        sin, vin, sout, vout,
     :        ilis, XSDHeaderWritten, XSDsegmentNumber,
     :        nrec, ntrc,
     :        SlopeAdjustmentFactor, Force, verbos , rnmo)

c POLICEMAN: test VelFunctions memory requirements
c if user has been editting the input dataset it is often the case that 
c the sizeVelFunctions variable used to dynamically allocate the memory 
c for VelFunctions
c was not big enough.  This could happen if the user somehow got a 1 record 
c stack of a lot of traces and asks for a velocity tape with a
c lot of functions.  In this instance nrec*nsamp = nsamp which might
c not be big enough to hold all velocity functions resulting in
c a segmentation fault on the next vmov.  

         if ( .not. tape ) then
            if ( ( ( 1 + nsamp * ( NumTotalVelFcns - 1 ) ) .gt. 
     :           ( ( 1 + nrec ) * nsamp ) ) 
     :           .and.
     :           ( nrec .gt. SZLNHD ) ) then
               write(LERR,*)' VELIN: not enough memory to contain'
               write(LERR,*)' velocity data.  Call Garossino at'
               write(LERR,*)' APR[3932].'
               write(LERR,*)'  '
               write(LERR,*)' FATAL'
               stop
            endif
         endif

c load index of this velocity function to InputVelocityIndex() array
 
         InputVelocityIndex(NumTotalVelFcns) = irec

c store velocity data in VelFunctions() array

         VelFunctionsIndex = 1 + nsamp * ( NumTotalVelFcns - 1 )
         call vmov ( tri, 1, VelFunctions(VelFunctionsIndex), 1, nsamp )

         if ( EndFunctionReadFlag ) then

c decrement NumTotalVelFcns if required and end function read

            if ( tdfn .and. irec .eq. 0 )then 
               NumTotalVelFcns = NumTotalVelFcns - 1 
            elseif ( irec .eq. 0 ) then 
               NumTotalVelFcns = NumTotalVelFcns - 1 
            elseif( .not. hmig .and. xsd )then
               NumTotalVelFcns = NumTotalVelFcns - 1
            endif
            go to 120
         else

c increment NumTotalVelFcns then read next function
 
            NumTotalVelFcns = NumTotalVelFcns + 1
            go to 110
         endif

 120     continue

c sort VelFunctions() according to indexing of data.  This will allow 
c the user to input the velocity functions in any order 
c [useful in pick file input especially]

         call SortVelFunctions ( InputVelocityIndex, VelFunctions, 
     :        NumTotalVelFcns, nsamp )

c All velocity functions and their reference locations have now been loaded
c into memory
c
c Here is where I start new coding:  the old code was a mess of indices 
c apparently designed to reduce the number of functions to be scanned
c to find the ones to interpolate between.  Not only didn't it work
c but it was a NIGHTMARE to debug every time it broke.  The new code
c simply gets an index from the InputDataIndex(), interpolates a velocity
c on one side or the other (as a function to InputDataIndex incrementing
c or decrementing) and goes on to the next.  The last function on either
c end will be used to extrapolate outside the portion of the line covered
c by the velocity function control set InputVelocityIndex().

         TrcNum = 1

         do 1000 kk = 1, nreco
               
            RecNum = InputDataIndex(kk)

            if ( RecNum .le. InputVelocityIndex(1) ) then
                     
c record before first velocity function [remember functions have been sorted
c into increasing order so even if input indices are reverse still have to 
c search through functions in increasing order

               call vmov ( VelFunctions, 1, tri, 1, nsamp )
               goto 500
            elseif( RecNum .ge. InputVelocityIndex(NumTotalVelFcns))then
                  
c record after last velocity function

               VelFunctionsIndex  = (NumTotalVelFcns - 1) * nsamp + 1
               call vmov ( VelFunctions(VelFunctionsIndex), 1, tri, 
     :              1, nsamp )
               goto 500
            else

c interpolation required

               do ll = 2, NumTotalVelFcns
                  if( RecNum .lt. InputVelocityIndex(ll) ) then
                     call VelInterp( RecNum, InputVelocityIndex, ll, 
     :                    VelFunctions, tri, nsamp )
                     goto 500
                  endif
               enddo
            endif
 500        continue

c clear the output trace header so that only pertinent output information
c may be loaded.  This will hopefully prevent confusion on indexing on
c the output velocity data.

            call vclr ( lhed, 1, ITRWRD )
         
            call savew2 ( lhed, fmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

c carry index in original location as well

            if ( src ) then
               call savew2 ( lhed, fmt_Index, l_Index, ln_Index, 
     :              RecNum*10, TRACEHEADER )
            else
               call savew2 ( lhed, fmt_Index, l_Index, ln_Index, 
     :              RecNum, TRACEHEADER )
            endif

            call savew2 ( lhed, fmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

c write out velocity trace for this input record

            call vmov ( tri, 1, lhed(ITHWP1), 1, nsamp )
            call wrtape ( luout, lhed, obytes )

 1000    continue

      ENDIF

c End of program [should be a normal termination] close input / output
c units and report on termination

 999  continue

      if ( .not. tape ) then
         close ( luvel )
      else
         call lbclos ( luvel )
      endif

      if ( .not. regular ) call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)
      write(LERR,*)'Normal Completion'
      write(LERR,*)'Processed ',nrec,' records'

      write(LER,*)'velin: Normal Completion'

      stop
      end

