C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vfile ( luvel, vtap, nsi, 
     :     lvhed, nsampv, nsiv, ntrcv, nrecv, iformv,
     :     disco, hmig, tensor, xsd, flat, tdfn, tape, 
     :     XSDVelocityUnits, XSDSampleUnits, 
     :     XSDVelocityOffset, XSDSampleOffset, PicksPerSegment,
     :     XSDInitVelOverride, XSDVelUnitsOverride,
     :     XSDSampleUnitsOverride, nsamp,
     :     NumTotalVelFcns,recpik, verbos )  

      implicit none

#include <f77/iounit.h>
#include <f77/sisdef.h>
#include <f77/lhdrsz.h>
#include <save_defs.h>

c declare variables passed from calling routine

      integer     luvel, nsi, XSDSampleUnits, XSDSampleOffset
      integer     PicksPerSegment(*), XSDSampleUnitsOverride
      integer     NumTotalVelFcns, length
      integer     nsampv, nsiv, ntrcv, nrecv, iformv
      integer     lvhed(SZLNHD)

      real       XSDVelocityUnits, XSDVelocityOffset
      real       XSDInitVelOverride, XSDVelUnitsOverride

      character   vtap*(*) 

      logical    disco, hmig, tensor, xsd, flat, tdfn, tape
      logical    recpik, verbos

c declare variables unique to subroutine

      integer    ierr, ijunk, levtap, lvbytes
      integer lenth, nsamp
      
      real       rjunk,rjunk1,rjunk2

      character  junk*1, junker*8

c initialize variables

      NumTotalVelFcns = 0

c print velocity banner to Printout file

      write(LERR,*)'  '
      write(LERR,*)'         Input Velocity Function Control '
      write(LERR,*)'  '

c determine input format and act appropriately

      IF (xsd) then

         write(LERR,*)'Using XSD pickfile format'

c open input pick file

         call alloclun(luvel)
         open(unit=luvel, file=vtap, status='old', iostat=ierr)

         if(ierr .ne. 0) then
            length = lenth(vtap)
	    if (length .gt. 0) then
              write(LERR,*)'VELIN: Could not open velocity file', 
     :           vtap(1:length)
      	    else
              write(LERR,*)'VELIN: velocity file not specified'
	    endif
            write(LERR,*)'       Check existence/permissions'
            write(LERR,*)'  '
            write(LERR,*)'       If your file starts with in...'
            write(LERR,*)'       velin may be interpreting the -v entry'
            write(LERR,*)'       as the -vin  command line parameter.'
            write(LERR,*)'       If this is the case rename your input'
            write(LERR,*)'       velocity function set and try again'
            write(LERR,*)'FATAL'
            stop
         endif

c fill out NumTotalVelFcns, PicksPerSegment() and determine the units
c and offsets to use in reading trace and sample input from pick file
c also determine if pick file is indexed within records or across record
c boundaries

         call XSDInitialize (luvel, NumTotalVelFcns, PicksPerSegment, 
     :        XSDSampleUnits, XSDSampleOffset,  
     :        XSDVelocityUnits, XSDVelocityOffset, 
     :        recpik )

c handle pick file velocity units override if user requested

         if ( (XSDVelUnitsOverride - 1.0) .gt. 1.e-32 ) 
     :        XSDVelocityUnits = XSDVelUnitsOverride

c handle pick file sample units override if user requested

         if ( XSDSampleUnitsOverride .ne. 0 )
     :        XSDSampleUnits = XSDSampleUnitsOverride 


         write(LERR,*)'Pick file sample units used = ', XSDSampleUnits

c report on offset and units to be used in this run

         if(XSDInitVelOverride.gt.1.e-30) then 
            write(LERR,*)'Initial velocity from command line -sv = ',
     :           XSDInitVelOverride
         else
            write(LERR,*)'Velocity offset in XSD pick file = ',
     :           XSDVelocityOffset
         endif

         if ( (XSDVelUnitsOverride - 1.0) .gt. 1.e-30 ) then
            write(LERR,*)'Velocity increment from command line -dv = ',
     :           XSDVelUnitsOverride
         else
            write(LERR,*)'Velocity units in XSD pick file = ',
     :           XSDVelocityUnits
         endif
            
      ELSEIF (tensor) then

         write(LERR,*)'Using TENSOR format '

         call alloclun(luvel)
         open(unit=luvel, file=vtap, status='old', iostat=ierr)

         if(ierr .ne. 0) then
            length = lenth(vtap)
	    if (length .gt. 0) then
              write(LERR,*)'VELIN: Could not open velocity file', 
     :           vtap(1:length)
      	    else
              write(LERR,*)'VELIN: velocity file not specified'
	    endif
            write(LERR,*)'       Check existence/permissions'
            write(LERR,*)'  '
            write(LERR,*)'       If your file starts with in...'
            write(LERR,*)'       velin may be interpreting the -v entry'
            write(LERR,*)'       as the -vin  command line parameter.'
            write(LERR,*)'       If this is the case rename your input'
            write(LERR,*)'       velocity function set and try again'
            write(LERR,*)'FATAL'
            stop
         endif

c read first line and make sure something is in file

         read (luvel,'(1x,a1)', end= 910) junk

         if(junk .eq. 'L') then
            NumTotalVelFcns = NumTotalVelFcns + 1
            go to 15
         else
            write(LERR,*)'VELIN: Error reading Tensor format'
            write(LERR,*)'       Fix velocity file and rerun'
            write(LERR,*)'FATAL'
            stop
         endif

c count total number of functions in file 

 15      read (luvel,'(1x,a1)', end= 20) junk
         if ( junk .eq. 'L' ) NumTotalVelFcns = NumTotalVelFcns + 1
         goto 15

 20      continue
         
c move pointer to begining of velocity dataset and return

         rewind luvel
         return

      ELSEIF (hmig) then

         write(LERR,*)'Using SATTLEGGER format'
         call alloclun(luvel)
         open(unit=luvel, file=vtap, status='old', iostat=ierr)
         
         if(ierr .ne. 0) then
            length = lenth(vtap)
	    if (length .gt. 0) then
              write(LERR,*)'VELIN: Could not open velocity file', 
     :           vtap(1:length)
      	    else
              write(LERR,*)'VELIN: velocity file not specified'
	    endif
            write(LERR,*)'       Check existence/permissions'
            write(LERR,*)'  '
            write(LERR,*)'       If your file starts with in...'
            write(LERR,*)'       velin may be interpreting the -v entry'
            write(LERR,*)'       as the -vin  command line parameter.'
            write(LERR,*)'       If this is the case rename your input'
            write(LERR,*)'       velocity function set and try again'
            write(LERR,*)'FATAL'
            stop
         endif

c move pointer to start of velocity data 

         read(luvel,'(////////////////////////)', end = 910 )

c count number of input functions 

 25      read ( luvel, '( a1 )' , end = 30 ) junk
         if ( junk .eq. 'I' ) NumTotalVelFcns = NumTotalVelFcns + 1
         goto 25

 30      continue
         rewind luvel
         read(luvel,'(////////////////////////)')
         return

      ELSEIF (tdfn) then

         if(verbos)write(LERR,*)'Using TDFN format '
         
         call alloclun(luvel)
         open(unit=luvel, file=vtap, status='old', iostat=ierr)
         
         if(ierr .ne. 0) then
            length = lenth(vtap)
	    if (length .gt. 0) then
              write(LERR,*)'VELIN: Could not open velocity file', 
     :           vtap(1:length)
      	    else
              write(LERR,*)'VELIN: velocity file not specified'
	    endif
            write(LERR,*)'       Check existence/permissions'
            write(LERR,*)'  '
            write(LERR,*)'       If your file starts with in...'
            write(LERR,*)'       velin may be interpreting the -v entry'
            write(LERR,*)'       as the -vin  command line parameter.'
            write(LERR,*)'       If this is the case rename your input'
            write(LERR,*)'       velocity function set and try again'
            write(LERR,*)'FATAL'
            stop
         endif

c count number of functions in file

 35      read ( luvel, '( i1 )', end = 40 ) ijunk
         if ( ijunk .eq. 9 ) NumTotalVelFcns = NumTotalVelFcns + 1
         goto 35

 40      continue
         if ( NumTotalVelFcns .eq. 0 ) goto 910
         rewind luvel
         return

      ELSEIF (flat) then

         if(verbos)write(LERR,*)'Using FLAT FILE format'

         call alloclun(luvel)
         open(unit=luvel, file=vtap, status='old', iostat=ierr)

         if(ierr .ne. 0) then
            length = lenth(vtap)
	    if (length .gt. 0) then
              write(LERR,*)'VELIN: Could not open velocity file', 
     :           vtap(1:length)
      	    else
              write(LERR,*)'VELIN: velocity file not specified'
	    endif
            write(LERR,*)'       Check existence/permissions'
            write(LERR,*)'  '
            write(LERR,*)'       If your file starts with in...'
            write(LERR,*)'       velin may be interpreting the -v entry'
            write(LERR,*)'       as the -vin  command line parameter.'
            write(LERR,*)'       If this is the case rename your input'
            write(LERR,*)'       velocity function set and try again'
            write(LERR,*)'FATAL'
            stop
         endif

c count number of functions in file

 45      read ( luvel, *, end = 50 ) rjunk, rjunk1, rjunk2 
         if ( rjunk .lt. 0. ) NumTotalVelFcns = NumTotalVelFcns + 1
         goto 45

 50      continue
         if ( NumTotalVelFcns .eq. 0 ) then
            write(lerr,*)' VELIN: Number of functions read from input'
            write(lerr,*)'        is less than one.  This could occur'
            write(lerr,*)'        if the file is empty or more likely'
            write(lerr,*)'        if the input format is not legal.'
            write(lerr,*)'        Check the input format and retry'
            write(lerr,*)' FATAL '
            stop
         endif

         rewind luvel
         return

      ELSEIF (disco) then

         if(verbos)write(LERR,*)'Using HANDVEL format'

         call alloclun(luvel)
         open(unit=luvel, file=vtap, status='old', iostat=ierr)

         if(ierr .ne. 0) then
            length = lenth(vtap)
	    if (length .gt. 0) then
              write(LERR,*)'VELIN: Could not open velocity file', 
     :           vtap(1:length)
      	    else
              write(LERR,*)'VELIN: velocity file not specified'
	    endif
            write(LERR,*)'       Check existence/permissions'
            write(LERR,*)'  '
            write(LERR,*)'       If your file starts with in...'
            write(LERR,*)'       velin may be interpreting the -v entry'
            write(LERR,*)'       as the -vin  command line parameter.'
            write(LERR,*)'       If this is the case rename your input'
            write(LERR,*)'       velocity function set and try again'
            write(LERR,*)'FATAL'
            stop
         endif

c count number of functions then move pointer to first HANDVEL card
c and return

 55    read( luvel, '(a8)', err=900, end=60 ) junker
       if ( junker(1:7) .eq. 'HANDVEL' ) 
     :      NumTotalVelFcns = NumTotalVelFcns + 1
       goto 55

 60    continue
       if ( NumTotalVelFcns .eq. 0 ) goto 910
       rewind luvel
 65    read( luvel, '(a8)', err=900, end=60 ) junker
       if(junker(1:7).ne.'HANDVEL')goto 65
       backspace(luvel)
       return

      ELSE
        
         write(LERR,*)'Using a USP dataset'
         tape = .true.
c open input velocity dataset if required

         levtap = lenth(vtap)
         call getln ( luvel, vtap, 'r', -1 )
         if  ( luvel .lt. 0 )   then
            if (levtap .gt. 0) then
              write(LERR,*)'VELIN: input velocity dataset ',
     :           vtap(1:levtap),' not accessible'
              write(LERR,*)'       Check existence/permissions '
	    else
              write(LERR,*)'VELIN: input velocity dataset ',
     :           ' not specified'
	    endif
            write(LERR,*)'FATAL'
            if (levtap .gt. 0) then
              write(LER,*)'VELIN: input velocity dataset ',
     :           vtap(1:levtap),' not accessible'
              write(LER,*)'       Check existence/permissions '
	    else
              write(LER,*)'VELIN: input velocity dataset ',
     :           ' not specified'
	    endif
            write(LER,*)'FATAL'
            stop
         endif

c read velocity dataset line header and check compatability with 
c input seismic dataset

         call rtape ( luvel, lvhed, lvbytes )
         if ( lvbytes .eq. 0 ) then
            write(LERR,*)'VELIN: no line header read on ',vtap(1:levtap)
            write(LERR,*)'FATAL'
            stop
         endif
         
         call saver ( lvhed, 'NumSmp', nsampv, LINHED )
         call saver ( lvhed, 'SmpInt', nsiv  , LINHED )
         call saver ( lvhed, 'NumTrc', ntrcv , LINHED )
         call saver ( lvhed, 'NumRec', nrecv , LINHED )
         call saver ( lvhed, 'Format', iformv, LINHED )
        
c POLICEMAN: make certain that number of samples in input velocity
c            function equals that of the control dataset.  Otherwise
c            post a warning
       
         if ( nsampv .lt. nsamp ) then
            write(LERR,*)'VELIN: Potential Velocity Error .......'
            write(LERR,*)' '
            write(LERR,*)'       velocity trace(s) too short; contains '
     &           ,nsampv,'samples'
            write(LERR,*)'       input data contains ',nsamp,' samples'
            write(LERR,*)'       velocity data will be padded out to  ',
     &           nsi*nsamp,' ms '
         endif

         if ( ntrcv .gt. 1 ) then
            write(LERR,*)'VELIN: Your input USP velocity dataset has'
            write(LERR,*)'       more than 1 trace per record.  This'
            write(LERR,*)'       is not a valid USP velocity dataset.'
            write(LERR,*)'       If you are coming from the MBS world'
            write(LERR,*)'       you can recover from this by running'
            write(LERR,*)'       the following to correct the problem'
            write(LERR,*)'  '
            write(LERR,*)'      utop -N',vtap(1:levtap),' -O',
     :           vtap(1:levtap),' -R',ntrcv,' -L1'
            write(LERR,*)'  '
            write(LERR,*)'FATAL'
            write(LER,*)'VELIN: Your input USP velocity dataset has'
            write(LER,*)'       more than 1 trace per record.  This'
            write(LER,*)'       is not a valid USP velocity dataset.'
            write(LER,*)'       If you are coming from the MBS world'
            write(LER,*)'       you can recover from this by running'
            write(LER,*)'       the following to correct the problem'
            write(LER,*)'  '
            write(LER,*)'      utop -N',vtap(1:levtap),' -O',
     :           vtap(1:levtap),' -R',ntrcv,' -L1'
            write(LER,*)'  '
            write(LER,*)'FATAL'
            stop
         endif

         NumTotalVelFcns = nrecv

      ENDIF

c velocity format determined and appropriate action taken to
c position file pointer to start of velocity data

      return

c error messages

 900  continue
      write(lerr,*)'VELIN: error reading velocity file'
      write(lerr,*)'FATAL'
      stop

 910  continue
      write(lerr,*)' VELIN: empty input velocity file'
      write(lerr,*)' FATAL '
      stop

      end




