C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE  VMULT:  vertical multiply
C
C**********************************************************************C
C
C VMULT READS SEISMIC TRACE DATA FROM TWO INPUT FILES,
C vertically multiplies       them sample-to-sample, trace-to-trace, and
C WRITES THE RESULTS TO AN OUTPUT FILE
C
C SUBROUTINE CALLS: RTAPE, HLH, WRTAPE, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      INTEGER  ITR1( SZLNHD ), ITR2( SZLNHD )
      INTEGER     NSAMP, NSI, NTRC, NREC, IFORM
      INTEGER     LUIN , LUOUT, LBYTES, NBYTES,obytes
      integer     argis, pipe
      integer     length, lenth
      REAL        xtr1( SZLNHD )
      REAL        xtr2( SZLNHD )
      CHARACTER   NAME * 5,  ntap2 * 256, ntap1* 256, otap * 256
#include <f77/pid.h>
      logical     verbos,div,query, sqr, ssqr, stream1, stream2
 
      DATA NAME     /'VMULT'/
      DATA LUIN / 1 /, LUOUT  / 2 /, LBYTES / 0 /, NBYTES / 0 /
      DATA  obytes / 0 /
      data verbos/.false./, div/.false./, pipe/3/
      data stream1/.false./
      data stream2/.false./

c------------------------------------
c  get online help if necessary
c------------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
           call help ()
          stop
      endif

c------------------------------------
c  open printout
c------------------------------------
#include <f77/open.h>

c------------------------------------
c  get command line parameters
c------------------------------------
      call cmdln (ntap1,ntap2,otap,ist,iend,nst,ned,
     &               nrst,nred,div,verbos,sqr,ssqr,amp)
C**********************************************************************C
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      call getln (luin1, ntap1, 'r', 0 )
      if (ntap1 .eq. ' ') then
          stream1 = .true.
      endif

      if(ntap2 .eq. ' ') then
        write(LERR,*)'VMULT assumed to be running inside ikp'
        call sisfdfit (luin2, pipe)
        nst = 0
        ned = 0
        nrst = 1
        nred = 0
        stream2 = .true.
      else
        call getln (luin2, ntap2, 'r', 0 )
        stream2 = .false.
      endif
      write(LERR,*)'For data set2 stream= ',stream2
      if (luin2 .lt. 0) then
        write(LERR,*)'VMULT fatal error - data set 2 not accessible'
        write(LERR,*)'Please check existence of this file'
        stop
      endif

      call getln (luout, otap,  'w', 1 )

      write(LERR,*)'luin1, luin2, luout= ',luin1, luin2, luout

      lbytes1=0
      CALL RTAPE ( LUIN1, ITR1, LBYTES1         )
      if(lbytes1 .eq. 0) then
         write(LERR,*)'VMULT: no header read on unit ',ntap1
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      lbytes2=0
      CALL RTAPE ( LUIN2, ITR2, LBYTES2         )
      if(lbytes2 .eq. 0) then
         write(LERR,*)'VMULT: no header read on unit ',ntap2
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c---------------------------------------
c  save key header values
      call saver(itr1, 'NumSmp', nsamp , LINHED)
      call saver(itr1, 'SmpInt', nsi   , LINHED)
      call saver(itr1, 'NumTrc', ntrc  , LINHED)
      call saver(itr1, 'NumRec', nrec  , LINHED)
      call saver(itr1, 'Format', iform , LINHED)
      call saver(itr2, 'NumSmp', nsamp2, LINHED)
      call saver(itr2, 'SmpInt', nsi2  , LINHED)
      call saver(itr2, 'NumTrc', ntrc2 , LINHED)
      call saver(itr2, 'NumRec', nrec2 , LINHED)
      call saver(itr2, 'Format', iform , LINHED)
      CALL HLHprt ( ITR1, LBYTES1, NAME, 5, LERR        )

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if(nsamp .ne. nsamp2) then
        write(LERR,*)'FATAL ERROR in vmult:'
        write(LERR,*)'Both data sets must have same trace length'
        write(LERR,*)'Found ',nsamp,' in DSN1 and ',nsamp2,' in DSN2'
        write(LER ,*)'FATAL ERROR in vmult:'
        write(LER ,*)'Both data sets must have same trace length'
        write(LER ,*)'Found ',nsamp,' in DSN1 and ',nsamp2,' in DSN2'
        stop
      endif
      if(nrec .ne. nrec2 .and. nrec2 .ne. 1) then
        if (nred .eq. 0 .or. nred .gt. nrec2) then
           write(LERR,*)'FATAL ERROR in vmult:'
           write(LERR,*)'DSN 1 & DSN 2 number of records mismatch'
           write(LERR,*)'# recs DSN1 = ',nrec,' # recs DSN2= ',nrec2
           write(LERR,*)'For N2 # recs must either be 1 or ',nrec
           write(LERR,*)'Use utop to fix up DSN 1 or 2'
           write(LER ,*)'FATAL ERROR in vmult:'
           write(LER ,*)'DSN 1 & DSN 2 number of records mismatch'
           write(LER ,*)'# recs DSN1 = ',nrec,' # recs DSN2= ',nrec2
           write(LER ,*)'For N2 # recs must either be 1 or ',nrec
           write(LER ,*)'Use utop to fix up DSN 1 or 2'
           stop
        endif
      endif
      if(ntrc2 .ne. ntrc .and. ntrc2 .ne. 1) then
        write(LERR,*)'FATAL ERROR in vmult:'
        write(LERR,*)'DSN 1 & DSN 2 number of traces mismatch'
        write(LERR,*)'# trcs DSN1 = ',ntrc,' # trcs DSN2= ',ntrc2
        write(LERR,*)'For N2 # traces must be 1 or ',ntrc
        write(LERR,*)'Use utop to fix up DSN 1 or 2'
        write(LER ,*)'FATAL ERROR in vmult:'
        write(LER ,*)'DSN 1 & DSN 2 number of traces mismatch'
        write(LER ,*)'# trcs DSN1 = ',ntrc,' # trcs DSN2= ',ntrc2
        write(LER ,*)'For N2 # traces must be 1 or ',ntrc
        write(LER ,*)'Use utop to fix up DSN 1 or 2'
        stop
      endif

      iflag=0
      if(nrec2.eq.1 .and. ntrc2.eq.1) iflag=1
      if(nrec2.eq.1 .and. ntrc2.eq.ntrc .and. nrec.ne.1) iflag=2
      if(ntrc2.eq.1 .and. nrec2.eq.nrec .and. ntrc.ne.1) iflag=3

      if (ntap2(1:1) .eq. ' ') then
         if (iflag .eq. 2) then
            write(LERR,*)'FATAL ERROR in vmult:'
            write(LERR,*)'Cannot have ntap2 with 1 record, multiple'
            write(LERR,*)'traces when piping into N2.  Do a rept in'
            write(LERR,*)'the pipeline before the N2 input so that'
            write(LERR,*)'the N2 data set has same number records as N1'
            stop
         endif
      endif
      write(LERR,*)'iflag= ',iflag
      if(nsamp .gt. SZLNHD) nsamp=SZLNHD

c------------------------------------
c  check defaults
      call cmdchk (nst,ned,nrst,nred, ntrc, nrec)
      ntr   = ned-nst+1
      nrecc = nred-nrst+1

       call savew( itr1, 'NumTrc', ntr  , LINHED)
       call savew( itr1, 'NumRec', nrecc, LINHED)

c-------------------------------
c  verbos printout
        write(LERR,*)
        write(LERR,*)' Values read from input data set line header'
        write(LERR,*)
	length = lenth(ntap1)
        if (length .gt. 0) then
          write(LERR,*) ' Read Input File  -N1 =  ',ntap1(1:length)
        else
          write(LERR,*) ' Read Input File  -N1 =  stdin'
        endif
	length = lenth(ntap2)
        if (length .gt. 0) then
          write(LERR,*) ' Read Input File  -N2 =  ',ntap2(1:length)
        else
          write(LERR,*) ' Read Input File  -N2 =  pipe'
        endif
	length = lenth(otap)
        if (length .gt. 0) then
          write(LERR,*) ' Write Output File -O =  ',otap(1:length)
        else
          write(LERR,*) ' Write Output File -O =  stdout'
        endif
        write(LERR,*) ' # of Samples/Trace =  ', nsamp
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntrc 
        write(LERR,*) ' Records per Line   =  ', nrec 
        write(LERR,*) ' Format of Data     =  ', iform
        if (div) then
        write(LERR,*) ' Division scaler       =  ',amp
        else
        write(LERR,*) ' Multiplication scaler =  ',amp
        endif
        if (sqr)
     1  write(LERR,*) 'Take square root of division (or product)'
        if (ssqr)
     1  write(LERR,*) 'Take signed square root of division (or product)'

C**********************************************************************C
C     CHECK CARD DEFAULTS AND SET PARAMETERS
C**********************************************************************C
      iend=iend/nsi + .5
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      nsampo=iend-ist+1
      call savew( itr1, 'NumSmp', nsampo, LINHED)
      obytes = SZTRHD + SZSMPD * nsampo

c--------------------------------------------------
c  update historical line header & write header
      call savhlh ( itr1, lbytes1, lbyout )
      CALL WRTAPE ( LUOUT, ITR1, LBYOUT                 )

c-------------------------------
c  verbos printout
      if( verbos ) then
        write(LERR,*)
        write(LERR,*)' Line header values after default check '
        write(LERR,*)
        write(LERR,*) ' # of Samples/Trace =  ', nsampo
        write(LERR,*) ' Sample Interval    =  ', nsi  
        write(LERR,*) ' Traces per Record  =  ', ntr 
        write(LERR,*) ' Records per Line   =  ', nrecc
        write(LERR,*) ' Format of Data     =  ', iform
        write(LERR,*) ' Flag               =  ', iflag
      endif

c-----------------------------------------
c  skip to start record
      if (nrst .gt. 1) then
         call unitrs (1,nrst-1,luin1,ntrc,itr1,stream1)
         if (iflag .eq. 0)
     1   call unitrs (1,nrst-1,luin2,ntrc2,itr2,stream2)
      endif

C**********************************************************************C
C
C     READ TRACE, MULTIPLY TRACES, WRITE TO OUTPUT FILE
C
C**********************************************************************C

      DO 100 JJ = NRST, NRED

c--------------------------------------
c  skip to start traces - do skip on DSN2
c  only if it is exactly the same size as
c  DSN1
            call unitts (jj,1,nst-1,luin1,ntrc,itr1,stream1)
            if     (iflag .eq. 0) then
                   call unitts (jj,1,nst-1,luin2,ntrc2,itr2,stream2)
            elseif (iflag .eq. 2) then
                   call rwd (luin2)
                   call rtape (luin2, itr2, lbytes)
            endif

    
          DO 99 KK = nst, ned
               nbytes = 0
               CALL RTAPE  ( LUIN1 , ITR1, NBYTES         )
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input1:'
                  write(LERR,*)'  rec= ',i,'  trace= ',k
                  write(LERR,*)'  iflag= ',iflag
                  go to 999
               endif
               call vmov (itr1(ITHWP1), 1, xtr1, 1, nsamp)
               call saver2(itr1,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istat1, TRACEHEADER)

c----------------------------
c  deal with different sizes
c  of DSN2

c---------------------
c both DSNs same size
               if     (iflag.eq.0) then
                    CALL RTAPE  ( LUIN2 , ITR2, NBYTES         )
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input2:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       write(LERR,*)'  iflag= ',iflag
                       go to 999
                    endif
                    call vsmul (itr2(ITHWP1), 1, amp, xtr2, 1, nsamp)

c------------------------
c DSN2 has 1 rec of 1 trc
c read him once
               elseif (iflag.eq.1 .and. jj.eq.nrst .and. kk.eq.nst) then
                    CALL RTAPE  ( LUIN2 , ITR2, NBYTES         )
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input2:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       write(LERR,*)'  iflag= ',iflag
                       go to 999
                    endif
                    call vsmul (itr2(ITHWP1), 1, amp, xtr2, 1, nsamp)

c---------------------
c DSN2 has 1 rec same
c size as DSN1 recs
               elseif (iflag.eq.2 .and. kk.ge.nst) then
                    CALL RTAPE  ( LUIN2 , ITR2, NBYTES         )
                    if (verbos)
     1              write(LERR,*)'JJ= ',jj,' kk= ',kk,itr2(106),
     2                            itr2(107), nbytes
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input2:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       write(LERR,*)'  iflag= ',iflag
                       go to 999
                    endif
                    call vsmul (itr2(ITHWP1), 1, amp, xtr2, 1, nsamp)

c--------------------
c DSN2 has 1 trc recs
c # eq to nrec1
               else if(iflag.eq.3 .and. kk.eq.nst) then
                    CALL RTAPE  ( LUIN2 , ITR2, NBYTES         )
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input2:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       write(LERR,*)'  iflag= ',iflag
                       go to 999
                    endif
                    call vsmul (itr2(ITHWP1), 1, amp, xtr2, 1, nsamp)

               endif

               call saver2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     istat2, TRACEHEADER)
c----------------------
c  move data & multiply
               if(istat1 .eq. 30000) then
                  call vclr (xtr1,1,nsampo)
               else if(istat2 .eq. 30000) then
                  call vclr (xtr1,1,nsampo)
               else
                  if(.not.div)
     1               call vmul (xtr1(ist),1,xtr2(ist),1,xtr1,1,nsampo)
                  if(div)
     1               call vdivz (xtr1(ist),1,xtr2(ist),1,0.0,xtr1,1,
     2                           nsampo)
                  if (sqr) then

                     call vabs  (xtr1, 1, xtr1, 1, nsampo)
                     call vsqrt (xtr1, 1, xtr1, 1, nsampo)

                  elseif (ssqr) then

                     do  i = 1, nsampo
                         sgn = sign (1.0, xtr1(i))
                         xtr1 (i) = sgn * sqrt ( abs(xtr1(i)) )
                     enddo

                  endif
               endif

               call vmov (xtr1, 1, itr1(ITHWP1), 1, nsampo)
               call wrtape(luout,itr1,obytes)

 
   99     CONTINUE

c--------------------------------------
c  skip to end record - do skip on DSN2
c  only if it is exactly the same size as
c  DSN1
          if (ned .lt. ntrc) then
            call unitts (jj,ned+1,ntrc,luin1,ntrc,itr1,stream1)
            if     (iflag .eq. 0) then
                   call unitts (jj,ned+1,ntrc2,luin2,ntrc2,itr2,stream2)
            endif
          endif

          if(verbos) then
             write(LERR,*)'Output Record ',jj
          endif
  100 CONTINUE

  999 continue
       call lbclos(luin1)
       call lbclos(luin2)
       call lbclos(luout)
      END

c------------------------------------------
c  online help section
c------------------------------------------
      subroutine  help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for VMULT: vertical divide'
        write(LER,*)'                                         multiply'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N1,2[ntap] -- input data set names'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-s[ist]    -- start time                    (0 ms)'
        write(LER,*)'-e[iend]   -- end time                 (last samp)'
        write(LER,*)'-ns[nst]   -- start trace number        (first tr)'
        write(LER,*)'-ne[ned]   -- end trace number           (last tr)'
        write(LER,*)'-rs[nrst]  -- start record             (first rec)'
        write(LER,*)'-re[nred]  -- end record                (last rec)'
        write(LER,*)'-amp[amp]  -- N2 data set multiplier         (1.0)'
        write(LER,*)'-D         -- divide N1/N2'
        write(LER,*)'              Note: if operating with one trace on'
        write(LER,*)'              multiple trace data set N2 must be'
        write(LER,*)'              the single trace data set'
        write(LER,*)'-R         -- take sqroot of the product/division'
        write(LER,*)'-RR        -- signed sqrt of the product/division'
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      vmult -N1[] -N2[] -O[] -amp[] -s[] -e[]'
        write(LER,*)'            -ns[] -ne[] -rs[] -re[] [-R -RR -D -V]'
        write(LER,*)' '

      return
      end

c-----
c     get command arguments
c
c     ntap1 - C*100  input file name
c     ntap2 - C*100  input file name
c     otap  - C*100  output file name
c     ist   - I      start sample
c    iend   - I      stop sample
c     nst   - I      start trace
c     ned   - I      stop end trace
c    nrst   - I      start record
c    nred   - I      stop end record
c     div   - L      if present divide
c    verbos - L      verbose output or not
c-----
      subroutine cmdln (ntap1,ntap2,otap,ist,iend,nst,ned,
     &               nrst,nred,div,verbos,sqr,ssqr,amp)
#include <f77/iounit.h>
      character  ntap1*(*), ntap2*(*), otap*(*)
      integer    argis,ist,iend,nst,ned,nrst,nred
      logical    div, verbos, sqr, ssqr

          call argstr('-N1',ntap1,' ',' ')
          call argstr('-N2',ntap2,' ',' ')
          call argstr('-O',otap,' ',' ')
          call argi4('-s',ist,1,1) 
          call argi4('-e',iend,0,0) 
          call argi4('-ns',nst,0,0)
          call argi4('-ne',ned,0,0)
          call argi4('-rs',nrst,1,1)
          call argi4('-re',nred,0,0)
          call argr4('-amp',amp,1.0,1.0)
          div  = ( argis( '-D' ) .gt. 0 )
          ssqr = ( argis( '-RR' ) .gt. 0 )
          sqr  = ( argis( '-R' ) .gt. 0 )
          verbos = ( argis( '-V' ) .gt. 0 )

      return
      end
