C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine MakeVelocity (Velocity, N, Xsd_VelUnit,
     :        Xsd_VelOffset, Xsd_VelUnitOverride,
     :        Xsd_VelOffsetOverride )
 
      integer N
 
      real Velocity(N), Xsd_VelUnit, Xsd_VelOffset, Xsd_VelUnitOverride
      real Xsd_VelOffsetOverride
 
c handle velocity conversions from trace to m/sec or ft/sec.  If
c Xsd_VelUnit is not equal to unity then skip this as the user
c has used the appropriate offset and units to make velocity
c correct as it sits in the pick file.  At least this is the
c assumption inherent in vomit.
 
      if ( (Xsd_VelUnit - 1.0 ) .gt. 1.e-32 ) then
         return
      elseif ( abs(Xsd_VelUnitOverride) .gt. 1.e-30 ) then
         vfact = Xsd_VelUnitOverride
      else
         vfact = Xsd_VelUnit
      endif
 
      if ( Xsd_VelOffset .gt. 1.e-32 ) then
         return
      elseif ( abs(Xsd_VelOffsetOverride) .gt. 1.e-30 ) then
         voff = Xsd_VelOffsetOverride
      else
         voff = Xsd_VelOffset
      endif
 
      call vsmsa( Velocity, 1, vfact, voff, Velocity, 1, N )
 
      return
      end
 
 
 
