C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Units( FormatIn, sin, Unit, N, Xsd_SmpUnit,
     :     Xsd_SmpOffset, Xsd_SmpUnitOverride, nsi, UnitSc )
 
#include <f77/iounit.h>
 
c convert Unit() array to seconds from input milliseconds
 
c variables passed from calling routine
 
      integer N, nsi
 
      real    Unit(N), Xsd_SmpUnit, Xsd_SmpOffset
      real    Xsd_SmpUnitOverride, UnitSc
 
      character sin*1, FormatIn*20
 
c local variables
 
      real tfact, toffset
 
c initialize variables
 
      if ( FormatIn .eq. 'agip' .or.
     :     FormatIn .eq. 'digicon' .or.
     :     FormatIn .eq. 'disco' .or.
     :     FormatIn .eq. 'disco3d' .or.
     :     FormatIn .eq. 'disco3dxy' .or.
     :     FormatIn .eq. 'disco3d1' .or.
     :     FormatIn .eq. 'essov2' .or.
     :     FormatIn .eq. 'flat3d' .or.
     :     FormatIn .eq. 'flat3d1' .or.
     :     FormatIn .eq. 'flat' .or.
     :     FormatIn .eq. 'geco' .or.
     :     FormatIn .eq. 'kelman' .or.
     :     FormatIn .eq. 'landmark' .or.
     :     FormatIn .eq. 'landmark2' .or.
     :     FormatIn .eq. 'omnivel' .or.
     :     FormatIn .eq. 'promax' .or.
     :     FormatIn .eq. 'tdfn' .or.
     :     FormatIn .eq. 'ukooa' .or.
     :     FormatIn .eq. 'ukooa1' .or.
     :     FormatIn .eq. 'ukooa2' .or.
     :     FormatIn .eq. 'vds3d' .or.
     :     FormatIn .eq. 'vip' .or.
     :     FormatIn .eq. 'western3d' .or.
     :     FormatIn .eq. 'western3d1' ) then
 
c milliseconds --> seconds
 
         call vsmul ( Unit, 1, 0.001, Unit, 1, N )
 
      elseif ( FormatIn .eq. 'xsd' .or. FormatIn .eq. 'vxos' ) then
 
         tfact = Xsd_SmpUnitOverride / 1000.0
 
         call vsmul ( Unit, 1, tfact, Unit, 1, N )
 
      elseif ( FormatIn .eq. 'xsdheader' ) then
 
c samples --> seconds
 
         tfact = Xsd_SmpUnit / 1000.0
         toffset = Xsd_SmpOffset / 1000.0
         call vsmsa ( Unit, 1, tfact, toffset, Unit, 1, N )
 
      elseif ( FormatIn .eq. 'usp' ) then
 
c Unit() array comes in as samples and will now be converted to
c seconds using the sample interval and units scalar of the input dataset
c or defaults.
 
         tfact = float ( nsi ) *  UnitSc

         call vsmul ( Unit, 1, tfact, Unit, 1, N )
 
      elseif ( FormatIn .eq. 'charisma' ) then

         call vsmul ( Unit, 1, UnitSc, Unit, 1, N )
 
      endif
 
      return
      end
 
