C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine VxosReadPicks(luvel, Record, Velocity, Unit,
     :     N, NumEntries, Xsd_SegNum, Xsd_SegName, Xsd_SegColor )
 
c XSDRead reads one velocity function from an attached pick file
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
 
c declare variables passed from calling routine
 
      integer luvel, NumEntries, N
 
      real   Record(NumEntries), Velocity(NumEntries), Unit(NumEntries)
 
c declare variables used in subroutine
 
      integer     counter, Xsd_SegNum, Xsd_SegColor
 
      real        RecordIndexBuffer(SZSMPM), VelocityIndexBuffer(SZSMPM)
      real        UnitIndexBuffer(SZSMPM)
 
      character   Xsd_SegName*20
 
c initialize memory
 
      call vclr(RecordIndexBuffer,1,NumEntries)
      call vclr(VelocityIndexBuffer,1,NumEntries)
      call vclr(UnitIndexBuffer,1,NumEntries)
      counter = 0
 
c read segment header
 
c      read(luvel,'(10x,i5,6x,a20,10x,i5,9x,i5)', err=900, end=901)
c     :     Xsd_SegNum, Xsd_SegName, Xsd_SegColor, N

c cannot read N yet as Marilyn hasn't changed vxos segment header 
c when she does then use the above line and get rid of the Vxos_NumPicks array

      read(luvel,'(10x,i5,6x,a20,10x,i5)', err=900, end=901)
     :     Xsd_SegNum, Xsd_SegName, Xsd_SegColor 

c read velocity function picks
 
      do k = 1, N
         read(luvel, '(f12.6,1x,f12.6,1x,f12.6)', err=900, end=1001)
     :        RecordIndexBuffer(k), VelocityIndexBuffer(k),
     :        UnitIndexBuffer(k)
      enddo
 
c build first output (record, velocity, Unit) entry
 
      counter = 1
      Velocity(counter) = VelocityIndexBuffer(counter)
      Record(counter) = RecordIndexBuffer(counter)
      Unit(counter) = UnitIndexBuffer(counter)
 
c POLICEMAN: watch out for duplicate picks in the pickfile
 
      do j = 2, N
 
         if ( RecordIndexBuffer(j) .eq. Record(j-1)
     :        .and.
     :        VelocityIndexBuffer(j) .eq. VelocityIndexBuffer(j-1)
     :        .and.
     :        UnitIndexBuffer(j) .eq. Unit(j-1) ) then
 
            write(LERR,*)' '
            write(LERR,*)'Duplicate entry occurred in Pickfile'
            write(LERR,*)'at record & Velocity entries: '
     :           ,RecordIndexBuffer(j), VelocityIndexBuffer(j)
            write(LERR,*)'Will fix by deleting 2nd occurrence'
            write(LERR,*)' '
 
         else
 
            counter = counter + 1
            Record(counter) = RecordIndexBuffer(j)
            Velocity(counter) = VelocityIndexBuffer(j)
            Unit(counter) = UnitIndexBuffer(j)
 
         endif
      enddo
 
      N = counter
 
c sort picks based on increasing unit so that user can pick in
c any order either up or down or in between
 
      call hsort3 (N, Unit, Velocity, Record)
      return
 
1001  continue
 
      write(LERR,*)' VOMIT: What is happening here???
     :     Do I need a sort'
      N = counter
      return
 
 900  continue
      write(LERR,*)' '
      write(LERR,*)' VOMIT: Error reading input velocity function set'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' VOMIT: Error reading input velocity function set'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop
 
  901  continue
      write(LERR,*)' '
      write(LERR,*)' VOMIT: Premature EOF on input velocity dataset'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' VOMIT: Premature EOF on input velocity dataset'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop
 
      end
