C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XsdReadHeader ( luin, Record, Velocity, Unit,
     :     N, Xsd_SegName, Xsd_SegColor, Xsd_mnemonic, NumEntries )
 
c routine to read xsd header value at pick file to
c retrieve velocity function picks.  Assumption is made
c that user has detected DsgSgn as well as the defaults.
c also the file pointer should by now be at the first Segment
c line in the headerfile.
 
#include <f77/iounit.h>
 
c variables passed from calling routine
 
      integer luin, NumEntries, N, Xsd_SegColor
 
      real Record(NumEntries), Velocity(NumEntries), Unit(NumEntries)
 
      character Xsd_SegName*20, Xsd_mnemonic*6
 
c local variables
 
      integer count, last
 
      real value
 
      character key*10
 
c initialize variables
 
      N = 0
      last = 0
      count = 0
 
      DO while(1.eq.1)
 
         read( luin,'(a10,1x,f17.6)', err=900, end=901 ) key, value
 
         if ( key .eq. 'Segment' ) then
            read ( luin, '(a10,1x,a20)', err=900, end=901 )
     :           key, Xsd_SegName
         endif
 
           if ( key .EQ. 'Picks' ) then
              N = nint(value)
           endif
 
           if ( key .EQ. 'Color' ) then
              Xsd_SegColor = nint(value)
           endif
 
c get sample value of pick
 
           if ( key .EQ. 'Sample' ) then
              Unit(count) = value
           endif
 
c get record value of pick allowing user to reference any
c trace header mnemonic
 
           if ( Xsd_mnemonic .eq. ' ' ) then
              if ( key .EQ. 'Record' ) then
                 Record(count) = value
              endif
           else
              if ( key .EQ. Xsd_mnemonic ) then
                 Record(count) = value
              endif
           endif
 
c get velocity value of pick
 
           if ( key .EQ. 'DstSgn' ) then
              Velocity(count) = value
           endif
 
 
c Increment pick counter
 
           if ( key .EQ. 'Pick' ) then
              count = count+1
              if ( count .eq. N ) then
 
                 do while ( 1 .eq. 1 )
 
                    read( luin,'(a10,1x,f17.6)', err=900, end=901 )
     :                   key, value
 
c get sample value of pick
 
                    if ( key .EQ. 'Sample' ) then
                       Unit(count) = value
                       last = last + 1
                    endif
c get record value of pick
 
                    if ( key .EQ. 'Record' ) then
                       Record(count) = value
                       last = last + 1
                    endif
 
c get velocity value of pick
 
                    if ( key .EQ. 'DstSgn' ) then
                       Velocity(count) = value
                       last = last + 1
                    endif
 
c if last pick is completely read return and leave file pointer
c at next Segment card
 
                    if ( last .eq. 3 ) return
 
                 enddo
              endif
           endif
      ENDDO
 
 900  continue
      write(LERR,*)' '
      write(LERR,*)' VOMIT: Error reading input velocity file'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' VOMIT: Error reading input velocity file'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop
 
 901  continue
      write(LERR,*)' '
      write(LERR,*)' VOMIT: Premature EOF reading input velocity file'
      write(LERR,*)' FATAL'
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' VOMIT: Premature EOF reading input velocity file'
      write(LER,*)' FATAL'
      write(LER,*)' '
      stop
 
      end
 
 
 
 
