C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine drms2t ( rt, rv, nn )
 
c drms2t converts an input RMS velocity function in DEPTH to TIME.
c To do this it solves the quadratic required and uses the root greater
c than the last time for the solution.  I really don't understand this
c fully yet and am not sure if both roots might not be greater or less
c than the last time.
c
c This routine assumes increasing time.
c
c it is assumed that:
c
c  rt() = Depth in units
c  rv() = RMS velocity in units/second
c
c on output rv() = RMS velocity in units/second
c on output rt() = 2-way TIME in seconds
c  velocity is referenced to the bottom of the interval
c  first time sample is at time zero
 
#include <f77/lhdrsz.h>
 
c declare variables passed from calling routine
 
      integer nn
 
      real    rt(nn), rv(nn)
 
c declare variables specific to this subroutine
 
      integer i
 
      real A, B, C
      real Time(SZLNHD)
 
c initialize memory
 
      call vclr ( Time, 1, SZLNHD )
 
c first RMS velocity  equals first INTERVAL velocity
 
      Time(1) = ( rt(1) / rv(1) )
 
      DO i = 2, nn
         A = rv(i)**2
         B = -1. * Time(i-1) * ( rv(i-1)**2 + rv(i)**2 )
         C = rv(i-1)**2 * Time(i-1)**2 - ( rt(i) - rt(i-1) )**2
 
c solve quadratic - watch out if b**2-4.*A*C is negative
c if this becomes a problem put the same logic as the
c checker in tr2ti.F into this routine.
 
         root1 = ( -1. * B + sqrt( B**2 - 4. * A * C ) ) / ( 2. * A )
         root2 = ( -1. * B - sqrt( B**2 - 4. * A * C ) ) / ( 2. * A )
 
         if ( root1 .ge. root2 ) then
            Time(i) = root1
         else
            Time(i) = root2
         endif
      ENDDO
 
      DO i = 1, nn
 
c load 2-way times out
 
        rt(i) = Time(i) * 2.
      ENDDO
 
      return
      end
