C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ti2da ( rt, rv, nn, MaxTime, MaxDepth )
 
c ti2da converts an input TIME INTERVAL velocity function
c to AVG velocity in DEPTH using Dix Equation. The algorithm used is:
c
c vavg = [sum(1,nn)[vint(i)*TimeInterval(i)]/sum(1,nn)TimeInterval(i)]
c from Applied Geophysics, pp271.
c
c it is assumed that:
c
c  rt() = 2way TIME in seconds
c  rv() = INTERVAL velocity in units/second
c  velocity is referenced to the bottom of the interval
c  first time sample is at time zero
c
c on output rv() = AVERAGE velocity in units/second
c on output rt() = DEPTH in units
c
c MaxTime is maximum time on input dataset
c MaxDepth is maximum required depth on output dataset
 
 
#include <f77/lhdrsz.h>
 
c declare variables passed from calling routine
 
      integer nn
 
      real    rt(*), rv(*), MaxTime, MaxDepth
 
c declare variables unique to subroutine
 
      integer i
 
      real vavg(SZLNHD)
      real TimeInterval, CummulativeTime, Depth(SZLNHD)
 
c initialize memory
 
      call vclr( vavg, 1, SZLNHD )
      call vclr( Depth, 1, SZLNHD )
 
c first AVGERAGE velocity  equals first INTERVAL velocity
 
      vavg(1) = rv(1)
      Depth(1) = rv(1) * rt(1) / 2.
 
c initialize and CummulativeTime
 
      CummulativeTime = rt(1) / 2.
 
      DO i = 2, nn
         TimeInterval = ( rt(i) - rt(i-1) ) / 2.
         Depth(i) = Depth(i-1) + rv(i) * TimeInterval
         CummulativeTime = CummulativeTime + TimeInterval
         vavg(i) = Depth(i) / CummulativeTime
      ENDDO
 
c form vavg for last sample if required
 
      IF ( Depth(nn) .lt. MaxDepth ) then
 
         if ( rt(nn) .lt. MaxTime ) then
            Depth(nn + 1) = MaxDepth
            TimeInterval = ( MaxDepth - Depth(nn) ) / rv(nn)
            CummulativeTime = CummulativeTime + TimeInterval
 
c add one to the number of elements in input function
c and form average velocity at maximum time.  Here MaxTime
c is required in seconds.
 
            nn = nn + 1
            vavg(nn) = Depth(nn) / CummulativeTime
         endif
 
      ENDIF
 
      call vmov ( vavg, 1, rv, 1, nn )
      call vmov ( Depth, 1, rt, 1, nn )
 
      return
      end
