C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ti2tr (rt,rv,nn,MaxTime,nsi,VelocityAtTimeZero)
 
c ti2tr converts an input INTERVAL velocity function
c to RMS using Dix Equation. The algorithm used is:
c
c vrms = sqrt[sum(1,nn)[vint(i)**2*tint(i)]/sum(1,nn)tint(i)]
c
c from Applied Geophysics, pp271.
c
c it is assumed that:
c
c  rt() = 2way TIME in seconds
c  rv() = INTERVAL velocity in units/second
c  velocity is referenced to the bottom of the interval
c  first time sample is at time zero
c
c on output rv() = RMS velocity in units/second
 
#include <f77/lhdrsz.h>
 
      integer nn, i, nsi
 
      real rt(*), rv(*), vrms(SZLNHD), Numerator
      real TimeInterval, CummulativeTime, MaxTime, VelocityAtTimeZero
 
c initialize memory
 
      call vclr( vrms, 1, SZLNHD )
 
c POLICEMAN: check to see if MaxTime is huge [happens sometimes if sinD]
 
      if( MaxTime.gt.10.)MaxTime = MaxTime/1000.
 
c first RMS velocity  equals first INTERVAL velocity
 
      vrms(1) = rv(1)
 
c initialize Numerator and CummulativeTime
 
      Numerator = rv(1)**2 * rt(1) / 2.
      CummulativeTime = rt(1) / 2.
 
      DO i=2,nn
         TimeInterval = ( rt(i) - rt(i-1) ) / 2.
         Numerator = Numerator + rv(i)**2 * TimeInterval
         CummulativeTime = CummulativeTime + TimeInterval
         vrms(i) = sqrt( Numerator / CummulativeTime )
      ENDDO
 
c form vrms for last sample
 
      IF ( rt(nn) .lt. MaxTime ) then
 
         TimeInterval = ( MaxTime - rt(nn) ) / 2.
         Numerator = Numerator + rv(nn)**2 * TimeInterval
         CummulativeTime = CummulativeTime + TimeInterval
 
c increase number of elements in input function
 
         nn = nn+1
         vrms(nn) = sqrt(Numerator/CummulativeTime)
 
c assign time for new velocity table entry
 
         rt(nn) = MaxTime
      ENDIF
 
      call vmov( vrms, 1, rv, 1, nn )
 
c account for VelocityAtTimeZero if specified by user
 
      if( rt(1) .lt. ( float(nsi) / 1000. )
     :     .and. VelocityAtTimeZero .gt. 1.e-6 )
     :     rv(1) = VelocityAtTimeZero
 
      return
      end
