C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
       subroutine getzeta(slow,zeta,sfine,savg,
     1                    lenhed,dzgrid,dzeql,zmin,zmax,
     2                    nxgrid,nzgrid,nz,fref,
     3                    pclambda,maxzeta,nfine,lerr)
C
      real slow(-lenhed:nzgrid,nxgrid)
c
      real savg(0:nzgrid)
      real sfine(0:nfine*nzgrid)
      real zeta(0:maxzeta)
c
      integer   lerr
c
      zeta(0)=zmin
      if(dzeql .eq. 0.) then
c_____________________________________________________________________
c        optimal, irregular velocity resampling.                 
c_____________________________________________________________________
         dzfine=dzgrid/nfine
c_____________________________________________________________________
c        calculate average slowness in each horizontal strip
c_____________________________________________________________________
         do 20000 izgrid=0,nzgrid
         slowmax=0.
         do 10000 ix=1,nxgrid
          slowmax=max(slow(izgrid,ix),slowmax)
10000    continue
         savg(izgrid)=slowmax     
20000   continue
c_____________________________________________________________________
c       Resample the data slowness profile nfine times finer.  
c______________________________________________________________________
        do 30000 izgrid=0,nzgrid-1
         slope=(savg(izgrid+1)-savg(izgrid))/nfine
         do 25000 jfine=1,nfine
          izfine=izgrid*nfine+jfine
          sfine(izfine)=savg(izgrid)+jfine*slope
25000    continue
30000   continue
c______________________________________________________________________
c       Discretize the vertical axis in units of pclambda wavelengths. 
c______________________________________________________________________
        izeta=0
        zeta(0)=zmin   
        izfine=0
40000   dlambda=0.
50000     izfine=izfine+1 
          jzfine=min(izfine,nzgrid*nfine)
          dlambda=dlambda+dzfine*sfine(jzfine)*fref 
          if(dlambda .lt. pclambda) go to 50000
c______________________________________________________________________
c          we have accumulated pclambda of a wavelength.
c          make this position a new grid point.
c______________________________________________________________________
           izeta=izeta+1
           if(izeta .gt. maxzeta) go to 90000
           zeta(izeta)=zmin+izfine*dzfine
           if(zeta(izeta) .gt. zmax) go to 60000
           go to 40000
60000    nz=izeta-1
         zeta(nz)=zmax
      else                   
c_____________________________________________________________________
c        forced, regular velocity sampling.                      
c_____________________________________________________________________
         nz=nint((zmax-zmin)/dzeql)
         do 71000 izeta=0,nz   
          zeta(izeta)=zmin+izeta*dzeql
71000    continue
      endif
c
      return
c
90000 write(lerr,*) 'dimension error in routine getzeta'
      write(lerr,*) 'resampling depth arrays exceeded' 
      write(lerr,*) 'last depth sample izeta = ',izeta-1,' was ',
     1                 zeta(izeta-1)
      write(lerr,*) 'desired depth zmax = ',zmax                 
      write(lerr,*) 'maxzeta = ',maxzeta
      write(lerr,*) 'dump irregular depth samples to maxzeta:'
      write(lerr,'(2a20)') 'izeta','zeta(izeta)'              
      write(lerr,'(i20,f20.6)') (izeta,zeta(izeta),izeta=1,maxzeta)
      write(lerr,*) 'check input parameters, units, etc'
      write(lerr,*) 'increase maxzeta after -maxzeta argument'
      close(lerr)
      call exitfu(666)
      end

