C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vsampsub(slow,twtgrid,v,twt,zeta,zetamid,           
     1                    zdatum,twtdatum,
     2                    ITRWRD,dxgrid,dzgrid,zmin,
     3                    nxgrid,nzgrid,nzgrid_extend,nz,lerr)
C
      real slow(-ITRWRD:nzgrid,nxgrid)
      real twtgrid(0:nzgrid_extend,nxgrid)
C
      real v(-ITRWRD:nz,nxgrid)
      real twt(-ITRWRD:nz+1,nxgrid)
c
      real zeta(0:nz)
      real zetamid(0:nz+1)
      real zdatum(nxgrid)
      real twtdatum(nxgrid)
c
      integer   lerr
      logical   first
c
      zbot=zmin+nzgrid_extend*dzgrid
c_____________________________________________________________________
c     calculate zetamid at the midpoint between the irregular depth 
c     sample points.
c_____________________________________________________________________
      zetamid(0)=zeta(0)
      do 72000 izeta=1,nz
       zetamid(izeta)=.5*(zeta(izeta)+zeta(izeta-1))
72000 continue
      zetamid(nz+1)=zeta(nz)
c______________________________________________________________________
c     calculate two way travel time on the original grid. 
c______________________________________________________________________
      do 75000 ix=1,nxgrid
c______________________________________________________________________
c      integrate the two way travel time from the top of the model
c      down to the bottom.
c      velocities lying above topography need to be reasonable.
c______________________________________________________________________
       twtgrid(0,ix)=0.
       do 73500 iz=1,min(nzgrid,nzgrid_extend)
        twtgrid(iz,ix)=twtgrid(iz-1,ix)
     1                 +.5*2.*dzgrid*(slow(iz,ix)+slow(iz-1,ix))
73500  continue
c______________________________________________________________________
c      output grid extends beyond the input velocity worktape.
c______________________________________________________________________
       do 74500 iz=nzgrid+1,nzgrid_extend
        twtgrid(iz,ix)=twtgrid(iz-1,ix)+2.*dzgrid*slow(nzgrid,ix)
74500  continue
75000 continue
c______________________________________________________________________
c     resample the regularly gridded two way travel time to be
c     sampled at the irregular midpoint depth grid (zetamid).
c______________________________________________________________________
      do 80000 izeta=1,nz+1
       if(zetamid(izeta) .lt. zbot) then
          izgrid1=(zetamid(izeta)-zmin)/dzgrid
          izgrid1=max(izgrid1,0) 
          izgrid1=min(izgrid1,nzgrid_extend)
          izgrid2=min(izgrid1+1,nzgrid_extend)
          zgrid=zmin+izgrid1*dzgrid
          wgt2=(zetamid(izeta)-zgrid)/dzgrid
          wgt1=1.-wgt2
          do 70000 ix=1,nxgrid
           twt(izeta,ix)=wgt1*twtgrid(izgrid1,ix)
     1                  +wgt2*twtgrid(izgrid2,ix)
70000     continue
       else
          write(lerr,*) 'tried to extend beyond extended input grid!'
          write(lerr,*) 'izeta,zetamid(izeta) : ',izeta,zetamid(izeta)
          write(lerr,*) 'zbot :                 ',zbot                 
          close(lerr)
          call exitfu(666)
       endif
80000 continue
       write(lerr,*) 'after 80000 iz,zeta,twt'
       write(lerr,'(i10,2f12.6)') (iz,zetamid(iz),twt(iz,1),
     1                 iz=0,10)
c______________________________________________________________________
c     convert from twt sampled  back to velocities.               
c______________________________________________________________________
      do 85000 ix=1,nxgrid
       twt(0,ix)=0.
       first=.true.
       do 84000 izeta=0,nz
        deltwt=twt(izeta+1,ix)-twt(izeta,ix)
        v(izeta,ix)=2.*(zetamid(izeta+1)-zetamid(izeta))/deltwt
84000  continue
85000 continue
c______________________________________________________________________
c     interpolate the twt from the top of the model to the output datum
c     location.
c______________________________________________________________________
      do 92000 ix=1,nxgrid
       izgrid1=(zdatum(ix)-zmin)/dzgrid
       izgrid1=max(izgrid1,0)
       izgrid1=min(izgrid1,nzgrid_extend)
       izgrid2=min(izgrid1+1,nzgrid_extend)
       zgrid=izgrid1*dzgrid+zmin
       wgt2=(zdatum(ix)-zgrid)/dzgrid
       wgt1=1.-wgt2
       twtdatum(ix)=wgt1*twtgrid(izgrid1,ix)+wgt2*twtgrid(izgrid2,ix)
92000 continue
c______________________________________________________________________
c     interpolate the twt to the irregular output grid, zeta.  
c     this time will be used to map output back to the time domain
c     corrected to a floating depth datum, zdatum.
c     save result in ms.
c______________________________________________________________________
      do 95000 izeta=1,nz
       if(zetamid(izeta) .lt. zbot) then
          izgrid1=(zeta(izeta)-zmin)/dzgrid
          izgrid1=max(izgrid1,0)
          izgrid1=min(izgrid1,nzgrid_extend)
c
          izgrid2=min(izgrid1+1,nzgrid_extend)
c
          zgrid=zmin+izgrid1*dzgrid
          wgt2=(zeta(izeta)-zgrid)/dzgrid
          wgt1=1.-wgt2
          do 94000 ix=1,nxgrid
           twt(izeta,ix)=1000.*(wgt1*twtgrid(izgrid1,ix)
     1                          +wgt2*twtgrid(izgrid2,ix)
     2                          -twtdatum(ix))
94000     continue
       else
          write(lerr,*) 'tried to extend beyond extended input grid!'
          write(lerr,*) 'izeta,zeta(izeta) : ',izeta,zeta(izeta)
          write(lerr,*) 'zbot :              ',zbot
          close(lerr)
          call exitfu(2666)
       endif
95000 continue
c_____________________________________________________________________
c     move headers from s into v and twt.
c_____________________________________________________________________
      do 87000 ix=1,nxgrid
       do 86000 jh=-ITRWRD,-1
        v(jh,ix)=slow(jh,ix)
        twt(jh,ix)=slow(jh,ix)
86000  continue
87000 continue
c
      return
      end

