C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine interph(xin,zin,zout,nxin,nxout,xorigin,dxout)
c
      real    xin(nxin),zin(nxin),zout(0:nxout)
C__________________________________________________________________
c     extrapolate (copy) last pick to the left  
C___________________________________________________________________
      istart=1
      do 80000 ixout=0,nxout
       xout=xorigin+ixout*dxout
       if(xout .lt. xin(1)) then
C__________________________________________________________________
c         set xout to be the value of the leftmost input point.         
C___________________________________________________________________
          zout(ixout)=zin(1)
       elseif(xout .gt. xin(nxin)) then
C__________________________________________________________________
c         set xout to be the value of the rightmost input point.         
C___________________________________________________________________
          zout(ixout)=zin(nxin)
       else
C__________________________________________________________________
c         general interpolation case.                                    
C___________________________________________________________________
          do 50000 ixin=istart,nxin-1
           if(xout .gt. xin(ixin)) then
C__________________________________________________________________
c             keep searching.
C___________________________________________________________________
           else
C__________________________________________________________________
c             interpolate.
C___________________________________________________________________
              del=xin(ixin+1)-xin(ixin)
              wgt2=(xout-xin(ixin))/del                         
              wgt1=1.-wgt2
              zout(ixout)=wgt1*zin(ixin)+wgt2*zin(ixin+1)
              istart=ixin
              go to 80000
           endif
50000     continue
       endif
80000 continue
c
      return
      end
