C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function alftmm (luprt , alphap, nmix  , ntwind, ntlive,
     *                      b     , livetr, itotal)
c
c     implement the alpha trimmed mean algorithm for finding the
c     representative value of ntwind points in vector b.  parameter
c     alpha determines the number of extreme points in the ordered
c     elements of b which will not be included in the average.
c     (100 - alphap) per cent of the points on the two extremes
c     of the median are discarded from the average.
c
      logical livetr(ntwind), oddntl
      real b(ntwind), median
      data iprint/0/
c
c     convert alphap from per cent to decimal.  determine the
c     number of data values to be excluded from the sum based
c     on nmix, the maximum possible value for ntlive.  print
c     this information on the first entry to the function.
c
      if (iprint .eq. 0) then
         iprint = 1
         itotal = 0
         nmd2 = nmix/2
         nmd2p1 = nmd2 + 1
         alpha = alphap/100.
         if (mod(nmix,2) .eq. 1) then
            nex = (1.0 - alpha)*(nmd2p1 - 1)
          else
            nex = (1.0 - alpha)*(nmd2 - 1)
         endif
c        write (luprt,1200) nmix, nex, alphap, nmd2, nmd2p1
c1200    format(/' ALFTMM:  nmix = ',i2,3x,'nex = ',i2,3x,
c   *           'alpha = ',f6.1/9x,'nmix/2 = ',i2,3x,
c   *           '(nmix/2)+1 = ',i2/)
      endif
c
c     set alftmm to zero if ntwind < 1 or ntwind > nmix or ntlive < 1
c
      if ((ntwind .lt. 1) .or. (ntwind .gt. nmix) .or.
     *    (ntlive .lt. 1)) then
         alftmm = 0.0
         return
      endif
c
c     set alftmm to b(ntwind) if ntwind = 1.
c
      if (ntwind .eq. 1) then
         alftmm = b(ntwind)
         itotal = itotal + 1
         return
      endif
c
c     move any elements of b corresponding to dead traces
c     to the end of b.  it is assumed that at least one
c     trace is live.
c
      if (ntlive .lt. ntwind) then
         do 120 k = 1, ntlive
            if (.not. livetr(k)) then
               do 100 l = ntwind, k+1, -1
                  if (livetr(l)) then
                     b(k) = b(l)
                     b(l) = 0.0
                     livetr(k) = .true.
                     livetr(l) = .false.
                     go to 120
                  endif
  100          continue
            endif
  120    continue
      endif
c
c     sort the ntlive elements of b
c
      call sortqk (ntlive, b)
c
c     find center index of array b (if ntlive is odd, nd2p1 is center;
c     if ntlive is even, nd2 and nd2p1 are the center 2 values)
c
      nd2 = ntlive/2
      nd2p1 = nd2 + 1
c
c     find the median value of the data in b
c
      oddntl = mod(ntlive,2) .eq. 1
      if (oddntl) then
         median = b(nd2p1)
       else
         median = 0.5*(b(nd2) + b(nd2p1))
      endif
c
c     determine the number of the ntlive data values to be
c     excluded from the sum.  this is the alpha trim.
c
      if (oddntl) then
         nexcld = (1.0 - alpha)*(nd2p1 - 1)
       else
         nexcld = (1.0 - alpha)*(nd2 - 1)
      endif
c
c     sum the elements of b which have values in the
c     k = nexcld+1 to ntlive-nexcld range.  at least one value
c     (median) is guaranteed to be in this interval, even
c     if alpha = 0.0.
c     itotal counts the total number of elements summed
c     since the function was first called.  it is used
c     to judge the value assigned to parameter q.
c
      alftmm = 0.0
      do 200 k = nexcld+1, ntlive-nexcld
         alftmm = alftmm + b(k)
  200 continue
      nadd = ntlive - 2*nexcld
      alftmm = alftmm/float(nadd)
      itotal = itotal + nadd
      return
      end
