C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      real function asrtmm (luprt , alphap, nmix  , ntwind, ntlive,
     *                      b     , livetr, itotal)
c
c     implement the asymmetric range trimmed mean algorithm for
c     finding the representative value of ntwind points in vector b.
c     parameter alphap determines a percentage of the range to each
c     side of the median (max value minus median to plus side,
c     median minus min value to minus side).  all members of b lying
c     within that partial range of the median of b are averaged to
c     compute the representation of the ntwind points of b.  the
c     remaining points are ignored.
c
      logical livetr(ntwind)
      real b(ntwind), median, medpqp, medmqn
      data iprint/0/
c
c     convert alpha from per cent to decimal.
c     print function name and value of alpha on first entry.
c
      if (iprint .eq. 0) then
         iprint = 1
         itotal = 0
         alpha = alphap/100.
         write (luprt,1200) nmix, alphap
 1200    format(/' ASRTMM:  nmix = ',i2,3x,'alpha = ',f7.2/)
      endif
c
c     set asrtmm to zero if ntwind < 1 or ntwind > nmix or ntlive < 1
c
      if ((ntwind .lt. 1) .or. (ntwind .gt. nmix) .or.
     *    (ntlive .lt. 1)) then
         asrtmm = 0.0
         return
      endif
c
c     set asrtmm to b(ntwind) if ntwind = 1.
c
      if (ntwind .eq. 1) then
         asrtmm = b(ntwind)
         itotal = itotal + 1
         return
      endif
c
c     move any elements of b corresponding to dead traces
c     to the end of b.  it is assumed that at least one
c     trace is live.
c
      if (ntlive .lt. ntwind) then
         do 120 k = 1, ntlive
            if (.not. livetr(k)) then
               do 100 l = ntwind, k+1, -1
                  if (livetr(l)) then
                     b(k) = b(l)
                     b(l) = 0.0
                     livetr(k) = .true.
                     livetr(l) = .false.
                     go to 120
                  endif
  100          continue
            endif
  120    continue
      endif
c
c     sort the ntlive elements of b
c
      call sortqk (ntlive, b)
c
c     find center index of array b (if ntlive is odd, nd2p1 is center;
c     if ntlive is even, nd2 and nd2p1 are the center 2 values)
c
      nd2 = ntlive/2
      nd2p1 = nd2 + 1
c
c     find the median value of the data in b
c
      if (mod(ntlive,2) .eq. 1) then
         median = b(nd2p1)
       else
         median = 0.5*(b(nd2) + b(nd2p1))
      endif
c
c     compute the plus range of b (maximum value - median)
c     and the negative range of b (median - minimum value).
c     from these compute qplus and qneg, which are the
c     range boundaries.
c
      rangep = b(ntlive) - median
      rangen = median - b(1)
      qplus = alpha*rangep
      qneg = alpha*rangen
c
c     calculate the median - qneg and median + qplus interval
c
      medpqp = median + qplus
      medmqn = median - qneg
c
c     sum the elements of b which have values in the
c     (median-qneg, median+qplus) interval.  at least one value
c     (median) is guaranteed to be in this interval, even
c     if alpha = 0.0.  itotal counts the total number of
c     elements summed since the function was first
c     called.  it is used to judge the value assigned
c     to parameter alpha.
c
      kcount = 0
      asrtmm = 0.0
      do 200 k = 1, ntlive
         bk = b(k)
         if ((bk .ge. medmqn) .and. (bk .le. medpqp)) then
            kcount = kcount + 1
            asrtmm = asrtmm + bk
         endif
  200 continue
      if (kcount .gt. 0) then
         asrtmm = asrtmm/float(kcount)
       else
         asrtmm = median
         kcount = 1
      endif
      itotal = itotal + kcount
      return
      end
