C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdparm (luso  , luprt , lucard, cardid, mxnmix, name  ,
     *                   ntap  , otap1 , otap2 , cfile , mode  , ialgor,
     *                   nmix  , lmix  , range , idiff , condst, icard ,
     *                   ikp, verbos)

      integer argis

      character*4 cardid, name
      character icard * 80
      character ntap*(*), otap1*(*), otap2*(*)
      character cfile*(*)

      logical condst
      logical verbos, ikp

c
c     read help command line entry if present
c
      if ( argis('-h') .gt. 0 .or. 
     :     argis('-?') .gt. 0 .or. 
     :     argis('-help') .gt. 0) then
         write (luso,1000)
 1000    format(/
     *     ' vsmx:  robust mixing for vertical seismic profiling or'/
     *     '        other applications'//
     *     ' usage:'/
     *     '    vsmx -N{ntap} -O1{otap1} -O2{otap2} -C{parmfile}'/
     *     '         -L{listfile} -V'/
     *     ' or'/
     *     '    vsmx -N{ntap} -O1{otap1} -O2{otap2} -L{listfile} -V'/
     *     '         -dff{dfflag} -cdf{cdflag} -mod{mode}'/
     *     '         -alg{algor} -nmx{nmix} -lmx{lmix} -rng{range}'/
     *     ' -flag{value}..................(default)'/
     *     ' replace {value} with desired value.  if {value} is not'/
     *     ' present, use (default).'//)
         write (luso,1010)
1010     format(
     *     ' -? or -h or -help     -- print this help section and stop'/
     *     ' -N{ntap}     -- input data file (stdin)'/
     *     ' -O1{otap1}   -- output data file 1 (stdout)'/
     *     ' -O2{otap2}   -- output data file 2 (stdout)'/
     *     '                 used if flag dff is 0.  if so,'/
     *     '                 -O1 and -O2 cannot both be stdout.'/
     *     ' -C{parmfile} -- file containing test parameters.  If -C'/
     *     '                 is present on the command line with no'/
     *     '                 argument, the input parameters are read'/
     *     '                 in-line from the job script file using'/
     *     '                 the STARTJOB syntax.  The flag used to'/
     *     '                 mark the in-line parameters is "-vsmx.crd"'/
     *     '                 If the -C flag is not present on the'/
     *     '                 command line, then the program will scan'/
     *     '                 the command line for the -dff -cdf -mod'/
     *     '                 -alg -nmx -lmx -rng flags below')
         write (luso,1015)
1015     format(
     *     ' -L{listfile} -- file to receive program the listing.  If'/
     *     '                 -L is present on the command line with no'/
     *     '                 argument, the listing goes to file'/
     *     '                 VSMX.xxx.yyy, where xxx and yyy are'/
     *     '                 numbers obtained from the PID and PPID'/
     *     '                 of this job.  If -L is not present on'/
     *     '                 on the command line, the listing file'/
     *     '                 name is generated using the startjob'/
     *     '                 convention, for use with that system.'/
     *     ' -V           -- verbose program run listing'/)
         write (luso,1020)
1020     format(
     *     ' the following are read if -C is not present:'/
     *     ' -dff{dfflag} -- difference flag (1)'/
     *     '                 0:  output both mixed data, O1, and'/
     *     '                     input minus mixed data, O2'/
     *     '                 1:  output O1 is mixed data'/
     *     '                 2:  output O1 is input minus mixed data'/
     *     ' -cdf{cdflag} -- constant distance flag (1)'/
     *     '                 0:  mixing window covers constant'/
     *     '                     distance'/
     *     '                 otherwise:  mixing window covers a'/
     *     '                   constant number of live traces'/
     *     ' -mod{mode}   -- mixing mode (1)'/
     *     '                 1:  sequential by line'/
     *     '                 2:  sequential by record')
         write (luso,1030)
1030     format(
     *     ' -alg{algor}  -- stacking algorithm (1)'/
     *     '                 1:  median'/
     *     '                 2:  alpha trimmed mean'/
     *     '                 3:  range trimmed mean'/
     *     '                 4:  double window range trimmed mean'/
     *     '                 5:  asymmetric range trimmed mean'/
     *     '                 6:  modified trimmed mean'/
     *     '                 7:  double window modified trimmed mean'/
     *     ' -nmx{nmix}   -- mixing window size (11)'/
     *     '                 if using double window algorithm,'/
     *     '                 this is the outer window size'/
     *     ' -lmx{lmix}   -- inner mixing window size (5)'/
     *     '                 valid when using a double window'/
     *     '                 algorithm'/
     *     ' -rng{range}  -- trim range for trimmed mean'/
     *     '                 algorithms in per cent (0.)'//)
         stop
      endif
c
c     read parameter file name (cfile) if present
c
      call argstr ('-C' , cfile, 'inline', ' ')
c
c     read input and output file names if present
c
      call argstr ('-N' , ntap  , ' ', ' ')
      call argstr ('-O1', otap1 , ' ', ' ')
      call argstr ('-O2', otap2 , ' ', ' ')
      verbos = ( argis ('-V') .gt. 0 )
      ikp = ( argis ('-ikp') .gt. 0 )
c
c     get processing parameters
c
      if (cfile .eq. ' ') then
c
c        read parameters from command line (numcrd and name
c        set explicitly)
c
         if (verbos) write (luprt,*) 'Parameters from command line'
         call argi4 ('-dff', idiff , 1 , 1)
         call argi4 ('-cdf', iconds, 0 , 0)
         call argi4 ('-mod', mode  , 2 , 2)
         call argi4 ('-alg', ialgor, 1 , 1)
         call argi4 ('-nmx', nmix  , 11, 11)
         call argi4 ('-lmx', lmix  , 5 , 5)
         call argr4 ('-rng', range , 0., 0.)
         numcrd = 1
         name = 'VSMX'
       else if (cfile .eq. 'inline') then
c
c        parameters will be read in-line with execution statement
c
         ncfile = icopen ('-vsmx.crd', lucard)
         if (ncfile .eq. 0) then
            write (luprt,1100)
 1100       format(' -Error setting up in-line parameters.'/
     *             '  If operating on SUN workstation, this mode',
     *             ' of parameter input is not operable.'/
     *             ' -Execution terminated'//)
            stop 1100
         endif
       else
c
c        read parameters from unit lucard if cfile
c        is not blank string
c
c        open the file from which to read processing parameters
c
         if (verbos) write (luprt,1200) cfile
 1200    format(/' Get processing parameters from input parameter',
     *          ' file:'/5x,a16/)
         open (lucard, file=cfile, iostat=ios)
         rewind lucard
         if (ios .ne. 0) then
            write (luprt,1220) cfile
 1220       format(/' -Error opening input parameter card file ',a16/
     *             ' -Execution terminated'//)
            stop 1220
         endif
      endif
      if (cfile .ne. ' ') then
         read (lucard,1240,end=9000) numcrd, name, idiff, iconds,
     *                      mode, ialgor, nmix, lmix, range, icard
 1240    format (i1,a4,6i5,f5.0,t1,a80)
c
c        print image of input data card
c
         if (verbos) write (luprt,1260) icard
 1260    format(/////,' -1VSMX card image:'//1x,'|---:----1',
     *          '----:----2----:----3----:----4----:----5----:----6',
     *          '----:----7----:---'/1x,a80)
c
c        close the input parameter file
c
         close (lucard, iostat=ios)
      endif
c
c     set defaults on parameters iconds, mode, ialgor, nmix, and lmix
c
      if (iconds .eq. 0) then
         condst = .true.
       else
         condst = .false.
      endif
      if (mode .eq. 0)   mode = 2
      if (ialgor .eq. 0) ialgor = 1
      if (nmix .eq. 0)   nmix = 11
      if (lmix .eq. 0)   lmix = 5
c
c     impose limits on range
c
      if (range .lt. 0) range = 0.0
      if ((ialgor .ge. 2) .and. (ialgor .le. 5)) then
         range = amin1 (range, 100.0)
      endif
c
c     error checking
c
c
c        data card number and name
c
      if ((numcrd .ne. 1) .and. (name .ne. cardid)) then
         write (luprt,2000)
 2000    format(' -Input data card is not a 1VSMX card.'/
     *          ' -Execution terminated')
         stop 2000
      endif
c
c        mixing mode
c
      if ((mode .lt. 1) .or. (mode .gt. 2)) then
         write (luprt,2300)
 2300    format(' -Entry for mixing mode is not 1 or 2.'/
     *          ' -Execution terminated')
         stop 2300
      endif
c
c     mixing algorithm
c
      if ((ialgor .lt. 1) .or. (ialgor .gt. 7)) then
         write (luprt,2400)
 2400    format(' -Error in selecting type of mixing algorithm.'/
     *          ' -Execution terminated')
         stop 2400
      endif
c
c        mixing window size nmix
c
      if ((nmix .lt. 3) .or. (nmix .gt. mxnmix)) then
         write (luprt,2500) mxnmix
 2500    format(' -No. of traces in lateral mixing window is not',
     *          ' gt or eq to 3 and lt or eq to ',i2/
     *          ' -Execution terminated')
         stop 2500
      endif
      if (mod(nmix,2) .ne. 1) then
         write (luprt,2600)
 2600    format(' -No. of traces in lateral mixing window is not',
     *          ' an odd number'/' -Execution terminated')
         stop 2600
      endif
c
c        mixing window size lmix
c
      if (((lmix .lt. 3) .or. (lmix .gt. nmix)) .and.
     *   ((ialgor .eq. 4) .or. (ialgor .eq. 7))) then
         write (luprt,2700) nmix
 2700    format(' -No. of traces in small mixing window is not',
     *          ' gt or eq to 3 and lt or eq to nmix = ',i2/
     *          ' -Execution terminated')
         stop 2700
      endif
      if ((mod(lmix,2) .ne. 1) .and. ((ialgor .eq. 4) .or.
     *   (ialgor .eq. 7))) then
         write (luprt,2800)
 2800    format(' -No. of traces in small mixing window is not',
     *          ' an odd number'/' -Execution terminated')
         stop 2800
      endif
c
c     print image of input data card, and interpreted and defaulted
c     card parameters.
c
      if (verbos) then
         write (luprt,3100)
 3100    format(/////,' Parameter summary after defaulting:'/)
         write (luprt,3200) mode
 3200    format(' Mixing mode:  ',i2/5x,'(1=sequential by line)'/
     *          5x,'(2=sequential by record)'/)
         write (luprt,3300) ialgor
 3300    format(' Mixing algorithm:  ',i2/5x,'(1=median)'/
     *          5x,'(2=alpha trimmed mean)'/
     *          5x,'(3=range trimmed mean)'/
     *          5x,'(4=double window range trimmed mean)'/
     *          5x,'(5=asymmetric range trimmed mean)'/
     *          5x,'(6=modified trimmed mean)'/
     *          5x,'(7=double window modified trimmed mean)'/)
         if (ialgor .eq. 1) then
            write (luprt,3400) nmix
 3400       format(' Median:'/5x,'number of traces in mixing',
     *             ' window = ',i2/)
         endif
         if (ialgor .eq. 2) then
            write (luprt,3500) range, nmix
 3500       format(' Alpha trimmed mean:  alpha = ',f6.1/5x,
     *             'number of traces in mixing window = ',i2/)
         endif
         if (ialgor .eq. 3) then
            write (luprt,3600) range, nmix
 3600       format(' Range trimmed mean:  alpha = ',1pe11.4/5x,
     *             'number of traces in mixing window = ',i2/)
         endif
         if (ialgor .eq. 4) then
            write (luprt,3700) range, nmix, lmix
 3700       format(' Double window range trimmed mean:  ',
     *             'alpha = ',1pe11.4/5x,
     *             'number of traces in large window = ',i2/5x,
     *             'number of traces in small window = ',i2/)
         endif
         if (ialgor .eq. 5) then
            write (luprt,3800) range, nmix
 3800       format(' Asymmetric range trimmed mean:  alpha = ',
     *             1pe11.4/5x,'number of traces in mixing window = ',
     *             i2/)
         endif
         if (ialgor .eq. 6) then
            write (luprt,3900) range, nmix
 3900       format(' Modified trimmed mean:  q = ',1pe11.4/5x,
     *             'number of traces in mixing window = ',i2/)
         endif
         if (ialgor .eq. 7) then
            write (luprt,4000) range, nmix, lmix
 4000       format(' Double window modified trimmed mean:  ',
     *             'q = ',1pe11.4/5x,
     *             'number of traces in large window = ',i2/5x,
     *             'number of traces in small window = ',i2/)
         endif
         write (luprt,6900) idiff
 6900    format(' Output option:  ',i2/5x,'(0=both)'/
     *          5x,'(1=input data after mixing)'/
     *          5x,'(2=difference between input and input after'/
     *          5x,'   mixing)'/)
         if (condst) then
            write (luprt,6920)
 6920       format(' Mixing window:  constant depth'/////)
          else
            write (luprt,6930)
 6930       format(' Mixing window:  constant trace count'/////)
         endif
      endif
      return
c
c     error exit for end of data set when reading card
c
 9000 write (luprt,9100)
 9100 format(' -Input 1VSMX card is missing.'/' -Execution terminated')
      stop 9100
      end
