C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ENTRY POINTS:                                                       *
C      VSPRAY  (V,Z,TO,T,X,ANGLE,RANGE,D,M,RTT,MUFLAG)                 *
C  ARGUMENTS:                                                          *
C      V       REAL     INPUT   (65) - INTERVAL VELOCITY ARRAY         *
C      Z       REAL     INPUT   (65) - LAYER THICKNESS ARRAY           *
C      TO      REAL     OUTPUT  (65) - VERTICAL 2 WAY TIME FROM LAYER  *
C                                      TO SURFACE                      *
C      T       REAL     OUTPUT  (65) - TRAVEL TIME FROM SURFACE SOURCE *
C                                      TO REFLECTOR TO VSP DETECTOR    *
C      X       REAL     OUTPUT  (65) - REFLECTION POINT LATERAL OFFSET *
C                                      FROM VSP WELL                   *
C      ANGLE   REAL     OUTPUT  (65) - ANGLE OF RAY INTO FIRST LAYER   *
C                                      FOR RAY TRACING EACH EVENT      *
C      RANGE   REAL     INPUT        - LATERAL OFFSET OF SOURCE FROM   *
C                                      VSP WELL                        *
C      D       REAL     INPUT        - DEPTH OF DETECTOR IN WELL       *
C      M       INTEGER  INPUT        - NUMBER OF LAYERS REPRESENTED IN *
C      RTT     REAL     ??IOU*       -                                 *
C      MUFLAG  INTEGER  OUTPUT       - FLAG =0 IF RAYS ARE CALCULATED  *
C                                      FLAG=1 IF DETECTOR IS BELOW ALL *
C                                      LAYERS AND NO RAYS ARE CALC.    *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR: DADREON RITCHIE                      ORIGIN DATE: 86/04/11  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 89/04/11  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  =============================== DATE: 89/01/24 ==================   *
C      RTT     FLOATING INPUT        - RAY TRACING TOLERANCE TO WHICH  *
C                                      THE RAYS WILL BE CALCULATED     *
C                                      IF INPUT BLANK OR ZERO DEFAULT=5*
C                                      THE V,Z  DATA                   *
C***********************************************************************
      SUBROUTINE VSPRAY(V,Z,TO,T,X,ANGLE,RANGE,D,M,RTT,MUFLAG)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      DIMENSION V(*),Z(*),TO(*),T(*),X(*),THETA(SZLNHD),ANGLE(*)

c     write(0,*)'M= ',m
c     write(0,*)(z(i),i=1,m)
c     write(0,*)(v(i),i=1,m)
c     write(0,*)(TO(i),i=1,m)
c     write(0,*)'D,range= ',d,range,rtt

      MUFLAG=0
      PLITLE=0.
      PBIG=3.1415927/2.
      P=89.7*3.1415927/180.
C
      CALL MOVE(0,T,0,m*SZSMPD)
      CALL MOVE(0,THETA,0,m*SZSMPD)
      CALL MOVE(0,X,0,m*SZSMPD)
      CALL MOVE(0,ANGLE,0,m*SZSMPD)
C
      ZZ=0
      DO 17 I=1,M
      ZD=D-ZZ
      ZZ=ZZ+Z(I)

c     write(0,*)'I= ',i,' D,ZZ,Zi= ',D,ZZ,Z(I)
C
      IF(D.LT.ZZ)GO TO 16
   17 CONTINUE
      WRITE(LER,*)'vspstk(vspray):'
      WRITE(LER,*)'THE DETECTOR IS BELOW ALL THE SPECIFIED LAYERS; NO RE
     1FLECTIONS ARE CALCULATED.'
      MUFLAG=1
      GO TO 2
C
   16 N=I
C
      MM = M-N+1
C     MM = THE NUMBER OF REFLECTING LAYERS BELOW THE DETECTOR
c     WRITE(0,*)'D,ZD,M,N,MM= ',D,ZD,M,N,MM

      DO 15 I=N,M
C
    4 CONTINUE
C
      THETA(1)=P
C
C      LOOP 19 CALCULATES THE INCIDENT ANGLES FROM THE SURFACE DOWN
C      THROUGH THE PARTICULAR REFLECTING LAYER,I, WE ARE LOOKING AT

      DO 19 J=2,I
      TH=(V(J)/V(J-1))*SIN(THETA(J-1))
      IF(TH.GT.1)GO TO 8
C      THETA= THE REFRACTION ANGLE INTO THE NEXT LAYER
      THETA(J)=ASIN(TH)
   19 CONTINUE
C      LOOPS 20,21,22 CALC THE LATERAL DISTANCE THE REFLECTED WAVE
C      HAS TRAVELED
C
      X1=0.
      X2=0.
      DO 20 J=1,I
   20 X1=X1+Z(J)*TAN(THETA(J))
C
      MN=N+1

      DO 21 J=MN,I
      X2=X2+(Z(J)*TAN(THETA(J)))
   21 CONTINUE
   33 ZN=0
      DO 22 J=1,N
   22 ZN=ZN+Z(J)
      X3=(ZN-D)*TAN(THETA(N))
      XNEW=X1+X2+X3
C
      DEL=RANGE-XNEW
CC    WRITE(0,31)DEL,I,M,N,THETA(1)
c  31 FORMAT(1X,' DEL=',F12.4,',I,M,N=',3I5,' THETA(1)=',F10.5)
      POLD=0
      IQUIT=0
      IF(IQUIT.EQ.1)GO TO 11
      IF(ABS(DEL).LT.RTT)GO TO 11
      IF(DEL.GT.0)GO TO 5
    8 CONTINUE
      POLD=P
      PBIG=P
      P=((P-PLITLE)/2.)+PLITLE

      GO TO 4
C
C
C      WHEN YOU FIND THE ANGLE THAT GIVES XNEW WITHIN 1 FOOT OF THE
C      SOURCE TO RECEIVER LATERAL OFFSET, THEN CANCULATE THE TIME FROM
C      THE SOURCE TO THE RECEIVER, REFLECTION POINT OFFSET FROM THE
C      RECEIVER AND THE CORRESPONDING VERTICAL TIME TO.
   11 X(I)=X2+X3
c     write(0,*)'I: DEL,X2,X3,P= ',i,DEL,X2,X3,P
      XCK=X2+X3
      ANGLE(I)=P
      P=THETA(1)
      IF(V(I+1).LT.V(I))P=89.7*3.1415927/180.
      PLITLE=0.0

      T1=0
      DO 23 J=1,I
   23 T1=T1+(Z(J)/(V(J)*COS(THETA(J))))
      T2=(ZN-D)/(V(N)*COS(THETA(N)))
      T3=0.

      DO 24 J=MN,I
CC    WRITE(0,37) MN,N
c  37 FORMAT(1X,'MN=',I5,' N=',I5)
      T3=T3+(Z(J)/(V(J)*COS(THETA(J))))
   24 CONTINUE
   35 T(I)=T1+T2+T3
      TCK=T1+T2+T3

      NN=N-1

      GO TO 15
    5 CONTINUE

      POLD=P
      PLITLE=P
      P=((PBIG-P)/2.)+P
      IF(P.LT.0.0)GO TO 41
      GO TO 4

   15 CONTINUE

   41 CONTINUE

   40 CONTINUE

    2 continue

c     do  i = 1, m
c        write(0,*)'I: T,X= ',T(i),X(i)
c     enddo

      RETURN
      END
