C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs vsp combo nmo/stack & 
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer     itr ( 2*SZLNHD )
      integer     nsamp, nsiw, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
      integer     iz(2*SZLNHD)

      real        Tn(2*SZLNHD), vintar(2*SZLNHD), Zn(2*SZLNHD)
      real        Vn(2*SZLNHD)
      real        twt(2*SZLNHD), xrng(2*SZLNHD), tint(2*SZLNHD)
      real        xint(2*SZLNHD), angle(2*SZLNHD) 
      real        sig(2*SZLNHD)
      real        tabl1 (2*SZLNHD), tabl2(2*SZLNHD)
      real        zz(8*SZLNHD)

c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      real        xs, ys, bigar2, bigar3
      pointer     (wkadrx,     xs(1))
      pointer     (wkadry,     ys(1))
      pointer     (wkadr2, bigar2(1))
      pointer     (wkadr3, bigar3(1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum
      integer     srcloc, recind, dphind, dstsgn, stacor
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( 2*SZLNHD )
      character   ntap * 255, otap * 255, name*6, vtap * 255
      character   hdrwrd * 6
      logical     verbos, query, heap1, heap2
      logical     rms, ave, int, tdfn, owt, tzero
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----

      data lbytes / 0 /, nbytes / 0 /, name/'VSPSTK'/
 
      deg = 180./3.14159265
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,frac,srcxi,srcyi,
     1             lunfil,vtap, xmin, xmax, dx,verbos, nsiw,
     2             rms, ave, int,itstep,tscl,tdfn,owt,hdrwrd,tzero)
 


      if     (xmin .ne. 0. .AND. xmax .ne. 0.) then
             nbins = nint ( (xmax - xmin)/dx + 1.0)
      elseif (abs(xmin) .ne. 0. .AND. xmax .eq. 0.) then
             nbins =  nint (xmin / dx + 1.0)
      elseif (xmin .eq. 0. .AND. xmax .ne. 0.) then
             nbins = nint (xmax / dx + 1.0)
      endif
      write(LERR,*)'nbins= ',nbins

c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'VSPSTK: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers 
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu(hdrwrd,ifmt_hdrwrd,l_hdrwrd,ln_hdrwrd,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

c  devlopers are wise to allow some freedom of the user to stake out
c  these slots so he can avoid trashing something he needs. 
c  in the 2 cases below we grab the last 2 T-V pairs (for 2 reals)

      call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)

      write(LERR,*)'MutVel,ifmt,l_MutVel,length= ',
     1             ifmt_MutVel,l_MutVel,ln_MutVel
      write(LERR,*)'WatVel,ifmt,l_WatVel,length= ',
     1             ifmt_WatVel,l_WatVel,ln_WatVel
      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt_TrcNum,l_TrcNum,ln_TrcNum
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt_RecNum,l_RecNum,ln_RecNum
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt_DphInd,l_DphInd,ln_DphInd
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt_DstSgn,l_DstSgn,ln_DstSgn
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c     if (nbins .gt. ntrc) then
c        write(LER,*)'nbins = ',nbins,' > ',ntrc
c        stop
c     endif

      nsampi = nsamp
      nsamp  = 1.5 * nsamp
      nsampw = 2 * nsi * nsamp / nsiw
      tmax   = nsiw * nsampw
      nsampm = max (nsampw, nsamp)

      do  i = 1, nsampm
          tabl1 (i) = float (i) * nsi
      enddo
      do  i = 1, nsampm
          tabl2 (i) = float (i) * nsiw
      enddo
      icinit = 1



      call velfin (Vn, Tn, Zn, numbn, tmax, vintar, tscl,
     1             lunfil, ave, int, rms, nsiw, nsampw, itstep,
     2             tdfn, owt)


c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      dt = real (nsiw) * unitsc
      dz = dt * vmin
 
 
c---------------------------------------------------
c  malloc only space we're going to use
      heap1 = .true.
      heap2 = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      item1 = ntrc   * nrec   * SZSMPD
      item2 = nbins  * nsampw * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
      call galloc (wkadrx, item1, errcdx, abortx)
      call galloc (wkadry, item1, errcdy, aborty)
      call galloc (wkadr2, item2, errcd2, abort2)
      call galloc (wkadr3, item2, errcd3, abort3)
 
      if (errcdx .ne. 0.) heap1 = .false.
      if (errcdy .ne. 0.) heap1 = .false.
      if (errcd2 .ne. 0.) heap2 = .false.
      if (errcd3 .ne. 0.) heap2 = .false.
 
      if (.not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item2,'  bytes'
         write(LERR,*) item2,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
      endif

c---------------------------------------------------
      si = nsiw
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', nbins, LINHED)
      call savew(itr, 'NumSmp', nsamp, LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout  )
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,srcyi,
     1                  frac,srcxi,xmin,xmax,dx,itstep,nbins,
     1                  vtap,ntap,otap,rms, ave, int, tdfn, owt)
c     end if
 
c--------------------------------------------------
      do  i = 1, nrec
          sig (i) = 1.0
      enddo
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      do  i = 1, nbins*nsamp
          bigar2 (i) = 0.
          bigar3 (i) = 0.
      enddo

c------
c first read thru data extracting src Xs & Ys for all live traces
c------
      is = 0
      DO  JJ = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            ic = 0
            do  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)
                  call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                        isrcx  , TRACEHEADER)
                  call saver2(itr,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                        isrcy  , TRACEHEADER)

                  IF (stacor .ne. 30000) THEN
                     ic = ic + 1
                     is = is + 1
                     srcx    = float (isrcx) - srcxi
                     srcy    = float (isrcy) - srcyi
                     xs (is) = srcx
                     ys (is) = srcy
                  ENDIF

            enddo
      ENDDO

c------
c for all src Xs & Ys fit a line thru points and get the slope
c the slope is used to rotate the Xs & Ys to orient the X axis
c along the actual shooting line
c the new src Xs are computed; if the Ys lie off the line somewhat
c then so be it
c------
      xs0 = xs (1)
      ys0 = ys (1)
      itoo = 0
      do  i = 2, is
          if (xs(i).eq.xs0 .and. ys0.eq.ys0) then
             itoo = itoo + 1
          endif
      enddo
      if (itoo+1 .lt. is) then
         call lfit (xs,ys,is,sig,0,B,A,sa,sb,chi,q)
         theta = atan ( A )
         write(LERR,*)' '
         write(LERR,*)'Linear fit slope= ',A,' intercept= ',B,
     1                ' slope(deg)= ',deg*theta
         do  j = 1, is
             xp =  xs (j) * cos (theta) + (ys (j) -B) * sin (theta)
             yp = -xs (j) * sin (theta) + (ys (j) -B) * cos (theta)
             if (verbos)
     1       write(LERR,*)'Input src x,y= ',xs(j),ys(j),
     2                    ' Output src xp,yp= ',xp,yp
             xs (j) = xp
         enddo
         write(LERR,*)' '
      endif

c------
c rewind data and read line header
c------
      call rwd (luin)
      call rtape (luin, itr, lbytes)
      call recskp(1,irs-1,luin,ntrc,itr)

c------
c now go thru the data reading trace data and doing the binned stack
c------
      is = 0
      DO  JJ = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            ic = 0
            icinit = 1
            do  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  call vmov (itr(ITHWP1), 1, tri, 1, nsampi)
                  call vclr (sig, 1, nsampw)
                  call fcuint (tabl1, tri, nsampi, tabl2, sig, nsampw,
     1                         iz, zz, icinit)
                  icinit = 0

 
c------
c     use previously derived pointers to trace header values
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        srcloc , TRACEHEADER)
                  call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        recind , TRACEHEADER)
                  call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        dstsgn , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)
                  call saver2(itr,ifmt_hdrwrd,l_hdrwrd, ln_hdrwrd,
     1                        idepth , TRACEHEADER)

                  IF (stacor .eq. 30000) THEN
                     call vclr (tri,1,nsamp)
 
                  ELSE
c----------------------
c  pack data into array
                     ic = ic + 1
                     is = is + 1
                     zr    = iabs (idepth)
                     srcx  = xs (is)
                     if (verbos) then
                     write(LERR,*)'Rec/trc= ',JJ, KK,
     1               ' rcvr depth= ',zr,' source offset= ',srcx
                     write(LER ,*)'Rec/trc= ',JJ, KK,
     1               ' rcvr depth= ',zr,' source offset= ',srcx
                     endif

                     call subs (nsampw, sig, bigar2, bigar3, kk,
     1                         xmin, xmax, frac, numbn, nbins, srcx, zr,
     2                         Vn, Tn, Zn, vintar, twt, xrng, xint,
     3                         angle, tint, tmax, nsiw, dx, dz, dt,
     4                         tzero)
                  ENDIF

c-----------------------
            enddo
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
      ENDDO

c--------
c normalize the binned samples according to how many times a particular
c bin at each sample was "hit"
c--------
      call snorm (nsampw, nbins, bigar2, bigar3)

c---------------------
c  extract traces from
c  output array and
c  write output data
            irec = 1
            icinit = 1
            do 1002 kk = 1, nbins
 
                  istrc = (kk-1) * nsampw
                  ishdr = (kk-1) * ITRWRD
                  call vmov (bigar2(istrc+1),1,sig,1, nsampw)
                  call vclr (tri, 1, nsampw)
                  call fcuint (tabl2, sig, nsampw, tabl1, tri, nsamp,
     1                         iz, zz, icinit)
                  icinit = 0

                  call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
                  call savew2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        irec   , TRACEHEADER)
                  call savew2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        kk     , TRACEHEADER)
                  call wrtape (luout, itr, obytes)
 
 
 1002             continue
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
 
      write(LERR,*)'end of vspstk, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER ,*)'end of vspstk, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'vspstk does a combination VSP nmo & stack into horizontal bins'
        write(LER,*)' '
        write(LER,*)
     :'execute vspstk by typing vspstk and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)        : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)        : output data file name'
        write(LER,*)
     :' -v [vtap]    (no default)        : input RMS vel flat file'
        write(LER,*)
     :'              (must be 2 columns  : time velocity)'
        write(LER,*) ' '
        write(LER,*)
     :' -dx[dx]      (default = none)    : horizontal bin size (ft,m)'
        write(LER,*)
     :' -sx[wrcx]    (default = 0)       : horiz well X-offset (ft,m)'
        write(LER,*)
     :' -sy[wrcy]    (default = 0)       : horiz well Y-offset (ft,m)'
        write(LER,*)
     :' -xmin[xmin]  (default = 0)       : min distance from well to ima
     :ge'
        write(LER,*)
     :' -xmax[xmax]  (default = none)    : max distance from well to ima
     :ge'
        write(LER,*)
     :' -f[frac]     (default = 5.0)     : ray tracing tolerance (ft,m)'
        write(LER,*)
     :' -ts[step]    (default = 250ms)   : resample input vel func at th
     :is time step'
        write(LER,*)
     :' -Hw [hdrwrd] (default = GrpElv)  : hdr wrd where sonde depth is'
        write(LER,*)
     :'                                    (must be positive number)'
        write(LER,*) ' '
        write(LER,*) ' '
        write(LER,*)
     :' -owt  include on command line if velocity file is 1-way time'
        write(LER,*)
     :' -T  include on command line if velocity file is TDFN format,'
        write(LER,*)
     :' -ZT correct to T0 of zero offset S-R ray path'
        write(LER,*)
     :'     else file is 2-col format: time-velocity'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   vspstk -N[] -O[] -v[] -Hw[] -dx[] -xmin[] -xmax[]'
        write(LER,*)
     :'                 -f[] -sx[] -sy[] -ts[] [ -rms -ave -int -owt -T 
     : -ZT -V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,frac,srcxi,srcyi,
     1                  lunfil,vtap,xmin,xmax,dx,verbos, nsiw,
     2                  rms, ave, int,itstep,tscl,tdfn,owt,hdrwrd,tzero)
c-----
c     get command arguments
c
c     ntap  - C*255    input file name
c     otap  - C*255    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), vtap*(*), hdrwrd*6
      integer     ns, ne, irs, ire, nsiw
      real        dx,xmin,xmax,frac,srcxi, tscl
      logical     verbos, rms, ave, int, tdfn, owt, tzero
      integer     argis

      lunfil = 57
      rms  = .false.
      ave  = .false.
      int  = .false.
      tdfn = .false.
      owt  = .false.
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program vspstk might be invoked in the following way:
 
c     vspstk  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into vspstk and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            if (ntap(1:1) .eq. ' ') then
               write(LER,*)'FATAL ERROR: vspstk: cannot pipe in'
               write(LER,*)'Rerun with -N[]'
               stop 666
            endif
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-v', vtap, ' ', ' ' )
            if (vtap(1:1) .eq. ' ') then
               write(LER,*)'FATAL ERROR: vspstk: must enter velocity'
               write(LER,*)'flat file using -v[] cmd line argument'
               stop 666
            else
               open (unit=lunfil, file=vtap,status='old',iostat=ierr)
               if (ierr .ne. 0) then
                  write(LERR,*)'Could not open velocity file ',vtap
                  write(LERR,*)'Check existence'
                  stop 666
               endif
            endif
            call argstr( '-Hw', hdrwrd, 'GrpElv', 'GrpElv' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-ts', itstep ,   0  ,  0    )
            call argi4 ( '-dt', nsiw ,   2  ,  2    )
            call argr4 ( '-tmul', tscl, 1.0, 1.0)
            call argr4 ( '-f', frac, 5.0, 5.0)
            call argr4 ( '-sx', srcxi, 0., 0.)
            call argr4 ( '-sy', srcyi, 0., 0.)
            call argr4 ( '-dx', dx, 0., 0.)
            if (dx .eq. 0.) then
               write(LER,*)'FATAL ERROR: vspstk: must enter horz bin sz'
               write(LER,*)'flat file using -dx[] cmd line argument'
               stop 666
            endif
            call argr4 ( '-xmin', xmin, 0., 0.)
            call argr4 ( '-xmax', xmax, 0., 0.)
            if (xmin .eq. 0. .AND. xmax .eq. 0.) then
               write(LER,*)'FATAL ERROR: vspstk: both xmin & xmax cannot
     1 be both zero'
               stop 666
            endif

            rms    =   (argis('-rms') .gt. 0)
            ave    =   (argis('-ave') .gt. 0)
            int    =   (argis('-int') .gt. 0)
            tdfn   =   (argis('-T') .gt. 0)
            owt    =   (argis('-owt') .gt. 0)
            tzero  =   (argis('-ZT') .gt. 0)

            if (.not. int .AND. .not. ave) rms = .true.
            if ((int .and. rms) .OR. (int .and. ave) .OR.
     1          (rms .and. ave)) then
                write(LER,*)'FATAL ERROR in vspstk:'
                write(LER,*)'Must specify 1 type of velocity function:'
                write(LER,*)' -rms or -ave or -int'
                stop 666
            endif
            
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,srcyi,
     1                  frac,srcxi,xmin,xmax,dx,itstep,nbins,
     2                  vtap,ntap,otap,rms, ave, int, tdfn, owt)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*255   input file name
c     otap  - C*255   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*), vtap*(*)
      logical     rms, ave, int, tdfn, owt
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' ray tolerance (ft,m)        = ',frac
            write(LERR,*) ' X-origin           =  ', srcxi
            write(LERR,*) ' Y-origin           =  ', srcyi
            write(LERR,*) ' min dist from well =  ', xmin
            write(LERR,*) ' max dist from well =  ', xmax
            write(LERR,*) ' max horz survey dist (ft,m) = ',xmax
            write(LERR,*) ' hoizontal bin size (ft,m)   = ',dx
            write(LERR,*) ' number of hoizontal bins    = ',nbins
            write(LERR,*) ' resample input vel func at ',itstep,' samps'
            write(LERR,*) ' velocity input func rms?    = ',rms
            write(LERR,*) ' velocity input func ave?    = ',ave
            write(LERR,*) ' velocity input func int?    = ',int
            write(LERR,*) ' velocity input func owt?    = ',owt
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' input velocity file =  ', vtap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
