C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XgraphOut(luout,irs,ire,Curve1,Curve2,Curve3,X)

c -----
c
c     Routine to build and output xgraph format file plottable using 
c     xgraph 
c
c -----

      integer luout,irs,ire,nelem

      real Curve1(*), Curve2(*), Curve3(*), X(*)

      nelem = ire - irs + 1

c -----
c
c     output curve 1 
c
c -----
      write(luout,*)'"Interval Velocity (ft,m/s)'

      do i = irs,ire
         write(luout,100) X(i), Curve1(i)
 100     format(f15.3,2x,f15.3)
      enddo
      write(luout,110)
 110  format(/)

c -----
c
c     output curve 2
c
c -----

      write(luout,*)'"RMS Velocity (ft,m/s)'
      do i = irs,ire
         write(luout,100) X(i), Curve2(i)
      enddo
      write(luout,110)

c -----
c
c     output curve 3
c
c -----

      write(luout,*)'"Average Velocity (ft,m/s)'
      do i = irs,ire
         write(luout,100) X(i), Curve3(i)
      enddo
      write(luout,110)


      return
      end
