C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c reads picks from a vsp data set run thru picker, and uses
c the sonde depths to compute velocities and
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c-----
      integer     itr  ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
      integer     luntab, lunxgr
 
c------
      real        velint(SZLNHD), velrms(SZLNHD), velave(SZLNHD)
      real        zr(SZLNHD), zh(SZLNHD), times(SZLNHD)
      real        timev(SZLNHD), tmp1(SZLNHD), tmp2(SZLNHD)
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     recnum, trcnum
      integer     srcloc, recind, dphind, dstsgn, stacor
      real        unit1, unit2
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      real        tri ( SZLNHD )
      character   ntap * 255, name*6, xgfile * 255
      character   vtap * 255, vtab * 255, stawrd1*6, stawrd2*6
      logical     verbos, query
      integer     argis
 
c initialize variables

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'VSPVEL'/
      data luntab/59/
      data lunxgr/58/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,vtap,vtab,ns,ne,irs,ire,iord,it0,
     1             stawrd1, stawrd2, unit1, unit2, verbos,xgfile,
     2             isrcx0)

c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read r or write w designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = xxx
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)

      if (vtap(1:1) .ne. ' ') then
         call getln(luvel, vtap, 'w', 1)
      endif

      if (vtab(1:1) .ne. ' ') then
         open (unit=luntab, file= vtab, status = 'unknown', iostat=ierr)
            if (ierr .ne. 0) then
               write(LERR,*)'Could not open velocity flat file ',vtab
               write(LERR,*)'Check directory permissions'
               stop
            endif
      endif
      if (xgfile(1:1) .ne. ' ') then
         open (unit=lunxgr, file= xgfile,status = 'unknown',iostat=ierr)
            if (ierr .ne. 0) then
               write(LERR,*)'Could not open xgraph fmt flat file ',
     1                       xgfile
               write(LERR,*)'Check directory permissions'
               stop
            endif
      endif

 
c-----
c     read line header of inputa DSN (rtape reads data into vector itr
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'VSPVEL: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('MutVel',ifmt_MutVel,l_MutVel,ln_MutVel, LINEHEADER)
      call savelu('WatVel',ifmt_WatVel,l_WatVel,ln_WatVel, LINEHEADER)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu(stawrd1,ifmt_stawrd1,l_stawrd1,ln_stawrd1,TRACEHEADER)
      call savelu(stawrd2,ifmt_stawrd2,l_stawrd2,ln_stawrd2,TRACEHEADER)

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

c  devlopers are wise to allow some freedom of the user to stake out
c  these slots so he can avoid trashing something he needs. 
c  in the 2 cases below we grab the last 2 T-V pairs (for 2 reals)

      call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)

      write(LERR,*)'MutVel,ifmt,l_MutVel,length= ',
     1             ifmt_MutVel,l_MutVel,ln_MutVel
      write(LERR,*)'WatVel,ifmt,l_WatVel,length= ',
     1             ifmt_WatVel,l_WatVel,ln_WatVel
      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt_TrcNum,l_TrcNum,ln_TrcNum
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt_RecNum,l_RecNum,ln_RecNum
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt_DphInd,l_DphInd,ln_DphInd
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt_DstSgn,l_DstSgn,ln_DstSgn
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
 
c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records).  This guards against
c     zero start values or values that are greater than those specified
c     in the line header
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = ire - irs + 1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr   = ne - ns + 1
      call savew(itr, 'NumTrc', 3    , LINHED)
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector itr and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      if (vtap(1:1) .ne. ' ') then
         call wrtape ( luvel, itr, lbyout  )
      endif
 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if (ntrc .eq. 1) then
          write(LERR,*) ' '
          write(LERR,*) 'WARNING: input has single trc records'
          write(LERR,*) 'and vspvel requires multi-trc records.'
          write(LERR,*) 'Will change internally to read as if'
          write(LERR,*) 'data was 1 rec of ',nrec,' trace'
          write(LERR,*) ' '
          ntrc = nrec
          nrec = 1
      endif
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,vtap)
c     end if
 
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      si = nsi
      dt = real (nsi) * unitsc
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
 
c-----
c     process desired trace records
c-----
      write(LERR,*) ' '
      do 1000 jj = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            ic = 0
            do 1001  kk = ns, ne
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if youre processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

 
c------
c     use previously derived pointers to trace header values
                  call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(itr,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                        srcloc , TRACEHEADER)
                  call saver2(itr,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                        recind , TRACEHEADER)
                  call saver2(itr,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                        dphind , TRACEHEADER)
                  call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                        dstsgn , TRACEHEADER)
                  call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

                  IF (stacor .ne. 30000) THEN
                     ic = ic + 1
                  call saver2(itr,ifmt_stawrd1,l_stawrd1, ln_stawrd1,
     1                        istawrd1, TRACEHEADER)
                  call saver2(itr,ifmt_stawrd2,l_stawrd2, ln_stawrd2,
     1                        istawrd2, TRACEHEADER)
                  call saver2(itr,ifmt_GrpElv,l_GrpElv, ln_GrpElv,
     1                        idepth , TRACEHEADER)
                  call saver2(itr,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                        isrcx  , TRACEHEADER)
                     srcx = iabs (isrcx - isrcx0 )
                     times (ic) = float(istawrd1) * unit1  +
     1                            float(istawrd2) * unit2  +
     2                            it0
                     zh    (ic) = iabs (idepth)
                     zr    (ic) = sqrt (zh(ic) **2 + srcx **2)

                     if (verbos) then
                     write(LERR,*)'rec/trc= ',recnum,trcnum,
     1               ' stat words1,2= ',istawrd1,istawrd2,
     2               ' depth, src dist= ',idepth,isrcx,
     3               ' total time, dist= ',times(ic),zr(ic)
                     endif
                  ENDIF



1001        continue

            live = ic
           call vmov (times, 1, tri, 1, live)
           if (iord .gt. 1)
     1     call SmoothFit (times, live, iord)

c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
            vsqt = 0.
            t    = 0.

            lastj = 1
            ic    = 1
c-----
c   set up starting values
c-----
            tmp1 (1)  = zr (1)
            tmp2 (1)  = zh (1)
            timev (1) = times (1)
c           v0 = 1000. * zr (1)/ timev (1)
            v0 = zr (1)/ (timev (1) * unitsc)
            velint (1) = v0
c-----
c   compute interval velocity using
c   distance differences and time diffs
c   tmp1 & tmp2 will contain the unique
c   depths & distances
c   velint will contain the unique interval
c   vels
c-----
            do  j = 2, live

                delt = times (j) - times (lastj)
                dz   = zr(j) - zr(lastj)

                if ( delt .gt. 0. .AND. dz .gt. 0.) then

                   ic = ic + 1
                   timev (ic) = times (j)
                   tmp1  (ic) = zr (j)
                   tmp2  (ic) = zh (j)
c                  delt = (times (j) - times (lastj)) / 1000.
                   delt = (times (j) - times (lastj)) * unitsc
                   dz   = zr (j) - zr (lastj)

                   velint (ic) = dz / delt
   
                   vsqt = vsqt + velint (j)**2 * delt

                   lastj = j
                endif
            enddo
            nvel = ic
c-----
c    store unique depths & dists
c-----
            do  j = 1, nvel

                zr (j) = tmp1 (j)
                zh (j) = tmp2 (j)
            enddo
c-----
c    compute average velocity
c-----
            do  j = 1, nvel
c               velave (j) = 1000 * zr (j) / timev (j)
                velave (j) = zr (j) / (timev (j) * unitsc)
                times  (j) = timev (j)
            enddo
c-----
c    compute RMS velocity
c-----
            tsum  = 0.
            vsqrt = 0.
            do  i = 1, nvel
c               ti = times (i) / 1000.
                ti = times (i) * unitsc
                vsqi = velint (i) ** 2 * ti
                vsqrt = vsqrt + vsqi
                tsum  = tsum + ti
                velrms (i) = sqrt ( vsqrt / tsum )
            enddo

            IF (vtab .ne. ' ') THEN
               write(luntab,*)'Depth(ft,m)  Time(ms)  Dist(ft,m)  Vint  
     1     Vrms     Vave'
               do j = 1, nvel
                  write(luntab,'(6f10.0)') zh(j),timev(j),zr(j),
     1            velint(j),velrms(j),velave(j)
               enddo
            ENDIF

            IF (vtap .ne. ' ') THEN
               call vel (timev, velint, nsamp, si, nvel, itr(ITHWP1))
               call wrtape (luvel, itr, nbytes)
               call vel (timev, velrms, nsamp, si, nvel, itr(ITHWP1))
               call wrtape (luvel, itr, nbytes)
               call vel (timev, velave, nsamp, si, nvel, itr(ITHWP1))
               call wrtape (luvel, itr, nbytes)
            ENDIF

            IF (xgfile(1:1) .ne. ' ') THEN
               call XgraphOut (lunxgr, 1, nvel, velint, velrms, velave,
     1                         zr)
            ENDIF

 1000       continue
 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      if (vtap(1:1) .ne. ' ') call lbclos ( luvel )
      if (vtab(1:1) .ne. ' ') close ( luntab )
 
      write(LERR,*)'end of vspvel, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'vspvel does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute vspvel by typing vspvel and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)     : input data file name'
        write(LER,*)
     :' -v [vtap]    (optional)       : output velocity tape name'
        write(LER,*)
     :' -f [vtab]    (optional)       : output velocity table name'
        write(LER,*)
     :'              (outputs time depth IntVel RmsVel AveVel)'
        write(LER,*)
     :' -X [xtap]    (no file)        : xgraph format file'
        write(LER,*)
     :' -ns[ns]      (default = first): start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last) : end trace number'
        write(LER,*)
     :' -rs[irs]     (default = first): start record number'
        write(LER,*)
     :' -re[ire]     (default = last) : end record number'
        write(LER,*) ' '
        write(LER,*)
     :' -sw1[swrd1]  (default = none) : first input trc hdr word'
        write(LER,*)
     :' -u1[unit1]  (default = 1.0)   : scale factor for 1st word'
        write(LER,*)
     :' -sw2[swrd2]  (default = none) : second input trc hdr word'
        write(LER,*)
     :' -u2[unit2]  (default = 1.0)   : scale factor for 2nd word'
        write(LER,*)
     :' -st[it0]  (default = 0.0)     : start time shift (ms)'
        write(LER,*)
     :' -sx[srcx0] (default = 0.0)    : X-origin of well (ft,m)'
        write(LER,*)
     :' -so[iord] (def = .1 # depths) : length smoothing window (pts)'
        write(LER,*) ' '
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   vspvel -N[ntap] -v[vtap] -f[vtab] [ -X[xtap] ]'
        write(LER,*)
     :'                 -ns[ns] -ne[ne] -rs[irs] -re[ire] -sx[]'
        write(LER,*)
     :'                 -sw1[] -u1[] -sw2[] -u2[] -st[] -so[] [ -V ]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,vtap,vtab,ns,ne,irs,ire,iord,it0,
     1                  stawrd1,stawrd2, unit1,unit2, verbos,xgfile,
     2                  isrcx0)
c-----
c     get command arguments
c
c     ntap  - C*255    input file name
c     vtap  - C*255    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), vtap*(*), vtab*(*), xgfile*(*)
      character   stawrd1*6,stawrd2*6
      integer     ns, ne, irs, ire
      real        unit1, unit2
      logical     verbos
      integer     argis
 
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program vspvel might be invoked in the following way:
 
c     vspvel  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into vspvel and associated with the variable
c     ntap
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-v', vtap, ' ', ' ' )
            call argstr( '-f', vtab, ' ', ' ' )
            call argstr( '-X', xgfile, ' ', ' ' )
            call argr4 ( '-sx', srcx0 , 0.0  , 0.0   )
            call argstr( '-sw1', stawrd1, ' ', ' ' )
            call argr4 ( '-u1', unit1 , 1.0  , 1.0   )
            call argstr( '-sw2', stawrd2, ' ', ' ' )
            call argr4 ( '-u2', unit2 , 1.0  , 1.0   )

            isrcx0 = srcx0

            if (stawrd1(1:1) .eq. ' ') then
               write(LER,*)'vspstk: ERROR'
               write(LER,*)'Must enter first pick header word using -sw1
     1[]'
               stop
            endif
            if (stawrd2(1:1) .eq. ' ') then
               write(LER,*)'vspstk: ERROR'
               write(LER,*)'Must enter second pick header word using -sw
     12[]'
               stop
            endif
            call argi4 ( '-so', iord ,   0  ,  0    )
            call argi4 ( '-st', it0 ,   0  ,  0    )

            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            verbos =   (argis('-V') .gt. 0)
 
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't
 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*255   input file name
c     otap  - C*255   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
