C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Get_Area(tri, space, N, start, end, 
     :     Number_Windows, iwin_sample, run)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c variables passed from calling routine

      integer N, start, end

      real tri(N), space(N), temp(SZLNHD),temp2(SZLNHD)
      logical run
c initialize variables


c     process data
     
c=====================================================================
c Windows in series 
     
      if (.not. run) then
         Do j = 1, Number_Windows
            space(j) = 0.
            
            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1          
               temp(i - (j-1)*iwin_sample + start + 1 ) = (tri(i))
            enddo
           call vsimps(temp,1,temp2,1,iwin_sample,1.)
           space(j)=temp2(iwin_sample)
         enddo
      endif
c=====================================================================
c Running Window
      if(run) then
         do j = start-start+1, end-start+1
       
            space(j) = 0.

c do this like a role-in / role-out

            istart =  (j - (iwin_sample/2)) + start - 1
            iend   =  (j + (iwin_sample/2)) + start - 1
           
 
            if (istart .lt. start) istart = start
            if (iend .gt. end) iend = end
          
            do i = istart, iend

              temp(i-istart+1)= (tri(i))  
                
            enddo
            call vsimps(temp,1,temp2,1,iend-istart+1,1.)
            space(j)=temp2(iend-istart+1)
           
         enddo
      endif
c=====================================================================
      return
      end
