C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Get_Max_Value(tri, space, N, start, end, 
     :     Number_Windows, iwin_sample, run)

c variables passed from calling routine

      integer N, start, end

      real tri(N), space(N)
      logical run
c initialize variables


c     process data
     
c=====================================================================
c Windows in series 
     
      if (.not. run) then
         Do j = 1, Number_Windows
            space(j) = -1.e30
            
            DO  i= (j-1)*iwin_sample + start,
     :           ((j-1)*iwin_sample+start+iwin_sample)-1
 
               if ((tri(i)) .gt. (space(j))) space(j)=tri(i)
           
            ENDDO

         enddo
      endif
c=====================================================================
c Running Window
      if(run) then
c j=window number         
         do j = start-start+1, end-start+1
            space(j) = -1.e30

c do this like a role-in / role-out

            istart =  (j - (iwin_sample/2)) + start - 1
            iend   =  (j + (iwin_sample/2)) + start - 1

         

            if (istart .lt. start) istart = start
            if (iend .gt. end) iend = end
         
            do i = istart, iend

               if (tri(i) .gt. space(j) ) space(j)=tri(i)    
                  
            enddo
           
         enddo
      endif
c=====================================================================
      return
      end
