C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c program wax : Window Attribute eXtraction
c
c
c          James M. Gridley
c          Spring 1997
c          USP Team
c
c     Program Changes:

c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin , luout, lbytes, nbytes, lbyout, obytes
      integer     ist, iend, irs, ire, ns, ne, argis, wc, nf

      real        tri ( SZLNHD )
      real        temp(SZLNHD)
      real        q(SZLNHD), f(SZLNHD)
      real        pie,thresh

      character   ntap*255, otap*255, name*4

      logical     verbos, run
      logical     max, min, maa, avg, sd, area, skew
      logical     kurt, range, median, envelope
      logical     sum_of_amplitudes, Absolute,carrier
      logical     quadrature,inst_phase,response_phase
      logical     inst_freq, response_freq,zero_phase
      logical     ninety_phase,response_amp
      logical     response_length,envelope_skewness
      logical     envelope_rise,inst_band
      

c Program Specific _ dynamic memory variables

      integer TraceSize, errcd1, abort, iwin

      real    Trace_WorkSpace(SZLNHD),dum(SZLNHD)
      real    dummy(SZLNHD)

    

c Program Specific _ static memory variables

      integer ifmt_RecNum,l_RecNum,ln_RecNum, RecNum
      integer ifmt_TrcNum,l_TrcNum,ln_TrcNum, TrcNum
      integer ifmt_DstSgn,l_DstSgn,ln_DstSgn, DstSgn
      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor

c Initialize variables

      data abort/1/
      data name/"WAX"/
      pie= 4.0 * atan(1.0)
    
c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, iwin,run,max,maa,min,avg,sd,area,
     :     skew,kurt,range, median, envelope,sum_of_amplitudes,
     :     Absolute,carrier,quadrature,inst_phase,response_phase,
     :     inst_freq,response_freq,thresh,zero_phase,
     :     ninety_phase, response_amp, response_length,
     :     envelope_skewness,envelope_rise, inst_band)
      
      if (carrier .or. envelope .or. quadrature .or. inst_phase
     :     .or. response_phase .or. inst_freq .or. response_freq
     :    .or. zero_phase .or. ninety_phase .or.
     :     response_amp .or. response_length  .or.
     :     envelope_skewness  .or. envelope_rise .or. 
     :     inst_band) then
         run = .true.
      endif

c open input and output files

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'WAX: no line header on input dataset',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
         write(LERR,*)'********************************************'
         write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
         write(LERR,*)'         will set to .001 (millisec default)'
         write(LERR,*)'********************************************'
         unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
       endif

       samp = float(nsi) * unitsc

c define pointers to header words required by your routine

      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c update historical line header and print to printout file 

      call hlhprt (itr, lbytes, name, 4, LERR)

c check user supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp

      nreco = ire - irs + 1
      ntrco = ne - ns + 1

      if (iwin .eq. -99999) iwin = nsamp*nsi
  

      iwin_sample =  int(iwin / nsi)
      if (.not. run) then
c     get the correct number of samples in the analysis window
              

         Number_Windows = ((iend - ist + 1)/iwin_sample)
         
         if (Number_Windows*iwin_sample .lt. nsi) then
            Number_Windows = Number_Windows +1 
                   
            endif
          
         endif
         
      if(run) then
         Number_Windows = (iend - ist + 1) 
      endif
c========================================================================

c modify line header to reflect actual record configuration output
c NOTE: in this case the sample limits ist and iend are used to 
c       limit processing only.   All data samples are actually passed.

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)
      call savew(itr, 'NumSmp', Number_Windows, LINHED)

c number output bytes
      obytes = SZTRHD + SZSMPD * Number_Windows
              
 

c save out hlh and line header

      call savhlh  ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c verbose output of all pertinent information before processing begins

      call verbal ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, iwin,run,max,maa,min,avg,sd,area,skew,
     :     kurt, range,median,envelope,sum_of_amplitudes,Absolute,
     :     carrier,quadrature,inst_phase,response_phase,inst_freq,
     :     response_freq,thresh,zero_phase,ninety_phase,
     :     response_amp, response_length, envelope_skewness,
     :     envelope_rise,inst_band)


c dynamic memory allocation:  

      TraceSize = nsamp 
      call galloc (wkadr1, TraceSize * SZSMPD, errcd1, abort)
    
      if ( errcd1 .ne. 0 )then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) TraceSize * SZSMPD, '  bytes'
         write(LER,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) TraceSize * SZSMPD, '  bytes'
         write(LERR,*)' '
      endif

c initialize memory
         
c      call vclr ( Trace_WorkSpace, 1, TraceSize )

c BEGIN PROCESSING 

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_RecNum, l_RecNum, ln_RecNum, 
     :           RecNum, TRACEHEADER )

            call saver2( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum, 
     :           TrcNum, TRACEHEADER )

            call saver2( itr, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

c process only live traces

            if ( StaCor .ne. 30000) then

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]
c load trace portion of itr[] to real array tri[]
 
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
c=====================================================================
c     take absolute value of time series if wanted by user

               if (Absolute) then
                  do i = 1, nsamp
                     tri(i)=abs(tri(i))
                  enddo
               endif
c=====================================================================
               if (max) 
     :          call Get_Max_Value ( tri, Trace_WorkSpace, nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)

               if (min)
     :          call Get_Min_Value ( tri, Trace_WorkSpace, nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)

               if(avg)
     :              call Get_Avg_Value ( tri, Trace_WorkSpace, 
     :              nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)

               if(sd)
     :              call Get_Stan_Dev ( tri, Trace_WorkSpace, 
     :              nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)

               if(area)
     :              call Get_Area ( tri, Trace_WorkSpace, nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)
               
               if(skew)
     :              call Get_Skew ( tri, Trace_WorkSpace, nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)

               if(kurt)
     :              call Get_Kurtosis ( tri, Trace_WorkSpace, 
     :              nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)

               if(range)
     :              call Get_Range ( tri, Trace_WorkSpace, 
     :              nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)
               
               if(median) 
     :              call Get_Median ( tri, Trace_WorkSpace,
     :              nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run)     
               
               if(sum_of_amplitudes)
     :              call Calc_Sum_Amplitudes
     :              (tri, Trace_WorkSpace,
     :              nsamp, 
     :              ist, iend,
     :              Number_Windows, iwin_sample, run) 


c---------------------------------------------------------------------

               wc = 3
               nf = 101
               
               if (carrier) then                 
                  nsamp = iend - ist + 1
                  Number_Windows = nsamp
                  call Calculate_Carrier (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend)                
               endif

               if (quadrature) then
                  nsamp = iend - ist + 1
                  Number_Windows = nsamp
                  call Calculate_Quadrature (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend)
               endif
               
               
               if (envelope) then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Envelope (tri,Trace_WorkSpace,
     :              samp,nsamp,wc,nf,ist,iend)
               endif
               
               
               if(inst_phase) then
                  nsamp = iend -ist + 1
                   Number_Windows = nsamp
                  call Calculate_Inst_Phase
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend)
               endif
                  
               
               if (response_phase) then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Response_Phase   
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend)
               endif
               
                     
               if (inst_freq) then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Inst_Frequency  
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend,nsi)
               endif
              
               if (response_freq)  then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Response_Frequency  
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend,nsi,
     :                 thresh)
                
               endif

               if (zero_phase) then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
               call Zero_Phase_Decomp(tri,Trace_WorkSpace,
     :              samp, nsamp, wc, nf, ist, iend, nsi)
            endif

               if (ninety_phase) then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
               call Ninety_Phase_Decomp(tri,Trace_WorkSpace,
     :              samp, nsamp, wc, nf, ist, iend, nsi)
            endif

               if (response_amp)  then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Response_Amplitude  
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend,nsi,
     :                 thresh)
               endif

               if (response_length)  then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Response_Length  
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend,nsi)

               endif
               if (envelope_skewness)  then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Envelope_Skewness  
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend,nsi)

               endif

               if (envelope_rise)  then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Envelope_Rise  
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend,nsi)

               endif
                if (inst_band) then
                  nsamp = iend -ist + 1
                  Number_Windows = nsamp
                  call Calculate_Inst_Band      
     :                 (tri,Trace_WorkSpace,
     :                 samp,nsamp,wc,nf,ist,iend,nsi)

               endif
c               
c=====================================================================

               
               call vmov ( Trace_WorkSpace, 1, itr(ITHWP1), 
     :              1, Number_Windows)

c     stacor endif
            endif
c write output data

            call wrtape (luout, itr, obytes)
 
         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

c close data files 

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'wax: Normal Termination'
      write(LER,*)'wax: Normal Termination'
      stop

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'wax: ABNORMAL Termination'
      write(LER,*)'wax: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for WAX: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input......................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                     (stdin)'
      write(LER,*)'-O[]   -- output data set                   (stdout)'
      write(LER,*)'-s[]   -- process start time (ms)                (1)'
      write(LER,*)'-e[]   -- process end time (ms)        (last sample)'
      write(LER,*)'-ns[]  -- start trace number                     (1)'
      write(LER,*)'-ne[]  -- end trace number              (last trace)'
      write(LER,*)'-rs[]  -- start record                           (1)'
      write(LER,*)'-re[]  -- end record                   (last record)'
      write(LER,*)' '
      write(LER,*)'           Time Series Preparation'
      write(LER,*)' '
      write(LER,*)'-abs   -- Take Absolute value of time series prior'
      write(LER,*)'          to any calculations'
      write(LER,*)'-thresh[]  -- threshold             ( default =0.15)'
      write(LER,*)' '
      write(LER,*)'           Analysis Type'
      write(LER,*)' '
      write(LER,*)'-run -- Apply a running window analysis (use -win[])'
      write(LER,*)'-win[]   -- window length (default=data length)'
      write(LER,*)' '
      write(LER,*)'   Attributes with Running Window Capability'
      write(LER,*)' '
      write(LER,*)'-avg                -- average'
      write(LER,*)'-median             -- median'
      write(LER,*)'-area               -- area'
      write(LER,*)'-sd                 -- standard deviation'
      write(LER,*)'-sum                -- sum of data window'
      write(LER,*)'-max                -- maximum'
      write(LER,*)'-min                -- minimum'
      write(LER,*)'-range              -- range'
      write(LER,*)'-skew               -- skewness'
      write(LER,*)'-kurt               -- kurtosis'
      write(LER,*)' '
      write(LER,*)'   Attributes with NO Running Window Capability'
      write(LER,*)' '
      write(LER,*)'-quadrature         -- quadrature'
      write(LER,*)'-carrier            -- carrier'
      write(LER,*)'-envelope           -- envelope'
      write(LER,*)'-envelope_skewness  -- envelope skewness'
      write(LER,*)'-envelope_rise      -- envelope rise'
      write(LER,*)'-inst_freq          -- instantaneous frequency'
      write(LER,*)'-inst_phase         -- instantanous phase'
      write(LER,*)'-inst_band          -- instantaneous bandwidth'
      write(LER,*)'-zero_phase         -- 0 degree phase'
      write(LER,*)'-ninety_phase       -- 90 degree phase'
      write(LER,*)'-response_length    -- response length'
      write(LER,*)'-response_amp       -- response amplitude'
      write(LER,*)'-response_freq      -- response frequency'
      write(LER,*)'-response_phase     -- response phase'
      write(LER,*)' '    
      write(LER,*)'-V     -- verbos printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       wax -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'            -re[] -V -run -win[] -thresh[] -abs'
      write(LER,*)'            -area -avg -carrier -envelope_skewness'
      write(LER,*)'            -envelope_rise -envelope -inst_phase'
      write(LER,*)'            -inst_band -inst_freq -kurt -median '
      write(LER,*)'            -min -max -ninety_phase -zero_phase'
      write(LER,*)'            -quadrature -response_length'
      write(LER,*)'            -response_freq -response_amp'
      write(LER,*)'            -response_phase -range -skew -sum -sd'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 
      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, iwin,run,max,maa,min,avg,sd,area,skew,
     :     kurt, range,median,envelope,sum_of_amplitudes, Absolute,
     :     carrier,quadrature,inst_phase,response_phase,inst_freq,
     :     response_freq,thresh,zero_phase,ninety_phase,
     :     response_amp, response_length, envelope_skewness,
     :     envelope_rise,inst_band)
    

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis, iwin
      real       thresh
      character  ntap*(*), otap*(*), name*(*)

      logical    verbos, run,max,maa,min,avg,sd,area,skew
      logical    kurt, range, median,envelope,sum_of_amplitudes
      logical    Absolute,carrier,quadrature,inst_phase
      logical    response_phase,inst_freq,response_freq
      logical    zero_phase,ninety_phase,response_amp
      logical    response_length,envelope_skewness
      logical    envelope_rise, inst_band

      Absolute = (argis('-abs') .gt. 0)
      area = (argis('-area') .gt. 0)
      avg = (argis('-avg') .gt. 0)

      carrier = (argis('-carrier') .gt. 0)
      envelope_skewness = (argis('-envelope_skewness') .gt. 0)
      envelope_rise = (argis('-envelope_rise') .gt. 0)
      envelope = (argis('-envelope') .gt. 0)
     
      inst_phase = (argis('-inst_phase') .gt. 0)
      inst_band = (argis('-inst_band') .gt. 0)
      inst_freq = (argis('-inst_freq') .gt. 0)
      call argi4 ( '-e', iend, 0, 0 )

      kurt = (argis('-kurt') .gt. 0)

      median = (argis('-median') .gt. 0)

  
      max = (argis('-max') .gt. 0)
      min = (argis('-min') .gt. 0)

      ninety_phase = (argis('-ninety_phase') .gt. 0)

      call argi4 ( '-ne', ne, 0, 0 )
      call argi4 ( '-ns', ns, 0, 0 )
      call argstr ( '-N', ntap, ' ', ' ' ) 
      
      call argstr ( '-O', otap, ' ', ' ' ) 

      quadrature = (argis('-quadrature') .gt. 0)
      response_length = (argis('-response_length') .gt. 0)
      response_freq = (argis('-response_freq') .gt. 0)
      response_amp  = (argis('-response_amp') .gt. 0)
      response_phase = (argis('-response_phase') .gt. 0)
      range = (argis('-range') .gt. 0)

      run = (argis('-run') .gt. 0)
    
      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )

      call argr4 ( '-thresh', thresh, 0.15, 0.15 )

      skew = (argis('-skew') .gt. 0)
      sum_of_amplitudes = (argis('-sum') .gt. 0)
      sd = (argis('-sd') .gt. 0)

      call argi4 ( '-s', ist, 1, 1 )
      
      verbos = (argis('-V') .gt. 0)
      call argi4 ( '-win', iwin, -99999, -99999 )
      zero_phase = (argis('-zero_phase') .gt. 0)
c     check for extraneous arguments and abort if found to
c     catch all manner of user typo's
      
      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )

           
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars

      subroutine verbal ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, verbos, iwin,run,max,maa,min,avg,sd,area,skew,
     :     kurt, range,median,envelope,sum_of_amplitudes, Absolute,
     :     carrier,quadrature,inst_phase,response_phase,inst_freq,
     :     response_freq,thresh,zero_phase,ninety_phase,
     :     response_amp, response_length, envelope_skewness,
     :     envelope_rise,inst_band)

#include <f77/iounit.h>
      integer    ist, iend, ns, ne, irs, ire, argis, iwin
      real       thresh
      character  ntap*(*), otap*(*), name*(*)

      logical    verbos, run,max,maa,min,avg,sd,area,skew
      logical    kurt, range, median,envelope,sum_of_amplitudes
      logical    Absolute,carrier,quadrature,inst_phase
      logical    response_phase,inst_freq,response_freq
      logical    zero_phase,ninety_phase,response_amp
      logical    response_length,envelope_skewness
      logical    envelope_rise, inst_band

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' '
      write(LERR,*) ' Window Length           = ',iwin
      write(LERR,*) ' Threshold               = ',thresh
c      if(abs) write(LERR,*)'Using Absolute Value of Time Series'
c      if( .not. abs) write(LERR,*)'No Absolute Value Chosen'
      write(LERR,*) ' '
      if (avg)
     : write(LERR,*)' Calculating average value'
      if (median)
     : write(LERR,*)' Calculating median value'
      if (area)
     : write(LERR,*)' Calculating area'
      if (sd)
     : write(LERR,*)' Calculating standard deviation'
      if (sum_of_amplitudes)
     : write(LERR,*)' Calculating time series summation'
      if(max)
     : write(LERR,*)' Finding Maximum Value'
      if(min)
     : write(LERR,*)' Finding Minimum Value'
      if(range)
     : write(LERR,*)' Finding Range'
      if(skew)
     : write(LERR,*)' Calculating Skew'
      if(kurt)
     : write(LERR,*)' Calculating Kurtosis'
      if(quadrature)
     : write(LERR,*)' Calculating Quadrature'
      if(carrier)
     : write(LERR,*)' Calculating Carrier'
      if(envelope)
     : write(LERR,*)' Calculating Envelope'
      if(envelope_skewness)
     : write(LERR,*)' Calculating Envelope Skewness'
      if(envelope_rise)
     : write(LERR,*)' Calculating Envelope Rise'
      if(inst_freq)
     : write(LERR,*)' Calculating Inst Freq'
      if(inst_phase)
     : write(LERR,*)' Calculating Inst Phase'
      if(inst_band)
     : write(LERR,*)' Calculating Inst Band'
      if(zero_phase)
     : write(LERR,*)' Calculating Zero Phase'
      if(ninety_phase)
     : write(LERR,*)' Calculating Ninety Phase'
      if(response_length)
     : write(LERR,*)' Calculating Response Length'
      if(response_freq)
     : write(LERR,*)' Calculating Response Frequency'
      if(response_phase)
     : write(LERR,*)' Calculating Response Phase'
      if ( verbos )  write(LERR,*) ' verbose printout requested'
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end


      FUNCTION PHAS(FR,FI)
C
C  JH BODINE    7/28/81
C
C  PROGRAM CALCULATES PHASE IN RADIANS ZERO TO 2*PI
C  FROM ENTERED REAL AND IMAGINARY COMPONENTS.
C
      PHAS = 0.
      PI=3.14159265
      A = (FR**2 + FI**2)**.5
      IF(A.EQ.0.) GO TO 10
      ARG = ABS(FI)/A
      IF(ARG.GT.1.) ARG=1.
C
C  0 TO PI/2
      IF(FI.GT.0. .AND. FR.GE.0.) PHAS=ASIN(ARG)
C
C  PI/2 TO PI
      IF(FI.GE.0. .AND. FR.LT.0.) PHAS=PI - ASIN(ARG)
C
C  PI TO 3*PI/2
      IF(FI.LT.0. .AND. FR.LE.0.) PHAS=PI + ASIN(ARG)
C
C  3*PI/2 TO 2*PI
      IF(FI.LT.0. .AND. FR.GT.0.) PHAS=2*PI - ASIN(ARG)
C
   10 RETURN
      END
C

      FUNCTION XFREQ(R,Q,DX,NPT,M)
C
C  JH BODINE  7/28/81
C
C  CALCULATES INSTANTANEOUS FREQUENCY FOR ANALYTIC
C  TRACE ANALYSIS USING FINITE DIFFERENCE APPROXIMATIONS
C  (SEE TANER ET AL., 1979, GEOPHYSICS, V44 NO.6, P1041.).
C
C      R, Q = REAL AND QUADRATURE TRACES
C       NPT = NUMBER OF POINTS IN THE TRACE ARRAYS
C        DX = SAMPLE INTERVAL
C         M = CURRENT CENTRAL DIFFERENCE POSITION
C
      DIMENSION R(2),Q(2)
      PI = 3.14159265
C
      XFREQ = 0.
      IF(R(M).EQ.0. .AND. Q(M).EQ.0.) GO TO 10
C
      RLST = R(2)
      QLST = Q(2)
      RMST = R(NPT-1)
      QMST = Q(NPT-1)
C
      IF(M.LT.NPT) RMST = R(M+1)
      IF(M.LT.NPT) QMST = Q(M+1)
      IF(M.GT.1) RLST = R(M-1)
      IF(M.GT.1) QLST = Q(M-1)
C
      XFREQ = (R(M)*(QMST-QLST)/(2.*DX)
     1 - Q(M)*(RMST-RLST)/(2.*DX))
     2 /(R(M)**2 + Q(M)**2)
C
   10 RETURN
      END
	subroutine findpk1(trifrq,rdata,nsamp,trires,factor)
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
	dimension vp(SZSMPM), vv(SZSMPM), ip(SZSMPM), iv(SZSMPM)
	dimension imin(SZSMPM),imax(SZSMPM)
	dimension trifrq(*), trires(*), rdata(*)
c
c	find maximum absolute value applyong threshold
c
	call maxv(rdata,1,amaxval,lc,nsamp)
c		
c	set threshold to catch only peak amplitudes greater than thresh
c
	thresh =  factor *amaxval
c
c	pick peaks and determine maximum
c
	call pkval1(rdata ,trifrq,nsamp,0,vp,ip,np)
	call maxv(vp   ,1,amaxpk ,lc,np   )
c
c	pick valleys (troughs) and determine maximum
c
	call pkval1(rdata ,trifrq,nsamp,1,vv,iv,nv)
	call maxv(vv   ,1,amaxpk ,lc,nv   )
c
c	zero out final output vector
c
	call vclr (trires,1,nsamp)
c
c	bracket the peaks by determining the adjacent troughs imin, imax
c
	do 50 i = 1,np
		imin(i) = 0
		imax(i) = 0
		do 55 j = 2, nv
			if(iv(j-1) .lt. ip(i) .and.
     :			   iv(j  ) .gt. ip(i)) then
				imin(i) = iv(j-1)
				imax(i) = iv(j  )
				go to 50
			endif
55		continue
50	continue
c
c	find the true (computed) x-location by fitting a parabola
c	thru the peak and its nearest neighbors.
c
c	loop over all peaks
c
	do 60 i = 1,np
		if (imin(i) .eq. 0 .or. imax(i) .eq. 0 ) go to 60
		index = ip(i)
c
c	restrict data to peaks that exceed the threshold
c
		if ( rdata(index) .gt. thresh) then
c
c	compute parabola fit to data
c
       		call parab(rdata(index-1),rdata(index),
     *			rdata(index+1),xmax,fmax)
c
c	check interpolated value for bounds
c
		if ( abs (xmax) .gt. 1.0 ) xmax = 0.0

c
c	compute secondary function at location of primary peak.
c
		call vqint ( trifrq(index-2),5,2.0+xmax,1,vp(i),1,1)
c
c	store the computed function from lobe-to-lobe of the primary funtion
c
		do 70 j = imin(i), imax(i)
       		   if (rdata(index) .gt. thresh) trires(j) = vp(i)
70		continue
		endif
60	continue
	return
	end

	subroutine pkval1(rdata,trifrq,nsamp,iflag,vp,ip,np)
	dimension vp(*),ip(*),trifrq(*),rdata(*)
	j = 0
	call vclr(vp,1,nsamp)
	call vclr(vv,1,nsamp)
	do 100 i = 3,nsamp-2
	if (iflag .eq. 0 ) then
		if (rdata  (i-1) .lt. rdata  (i)
     :		.and. rdata  (i) .gt. rdata  (i+1)) then
			j = j + 1
			vp(j) = trifrq(i)
			ip(j) = i
		endif
	else
		if (rdata  (i-1) .gt. rdata  (i)
     :			.and. rdata  (i) .lt. rdata  (i+1)) then
			j = j + 1
			vp(j) = trifrq(i)
			ip(j) = i
		elseif (rdata  (i-1) .ge. rdata  (i)
     :                  .and. rdata  (i) .lt. rdata  (i+1)) then
                         j = j + 1
                         vp(j) = trifrq(i)
                         ip(j) = i
	        elseif (rdata  (i-1) .gt. rdata  (i)
     :                  .and. rdata  (i) .le. rdata  (i+1)) then
                        j = j + 1
                        vp(j) = trifrq(i)
                        ip(j) = i
		endif
	endif
100	continue
	np = j
	return
	end
      SUBROUTINE PARAB(C1,C2,C3,X,Y)
	x = 0.0
	y = c2
      A=0.5*(C1+C3-2.*C2)
      B=0.5*(C3-C1)
      C=C2
      IF(A .EQ. 0.0 ) return
	X=-B/(2.*A)
      Y=A*X**2+B*X+C
      RETURN
      END
