C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       MAIN
C                 PROGRAM WESH IS FOR WAVELET ESTIMATION AND SHAPING
C                 ON COMMON-SOURCE RECORDS
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHORS:      M. T. TANER and G. M. RUCKGABER
C  ORIGIN DATE:  81JANUARY
C                82MAY (MAIN REWRITTEN BY G. M. RUCKGABER)
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      AUTCOR   -         AUTOCORRELATION.
C      BUTTER   -         BUTTERWORTH FILTER COMPUTATION.
C      CONVOL   -         CONVOLUTION.
C      EXPSCL   -         EXPONENTIAL SCALING.
C      DPHAMN   -         MINIMUM-PHASE WAVELET DESIGN.
C      DSHPWV   -         WAVELET SHAPING.
C      TAPER    -         BUTTERWORTH-TYPE TAPER COMPUTATION.
C      WAVEST   -         WAVELET ESTIMATION.
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  THIS IS A DOUBLE-PRECISION VERSION OF A
C                        SINGLE-PRECISION VERSION OF WESH.
C
C                        PROGRAM WESH USES A HIGHLY-AVERAGED
C                        AUTOCORRELATION FUNCTION COMPUTED OVER EACH
C                        COMMON-SOURCE INPUT RECORD TO DETERMINE THE
C                        SOURCE WAVELET IN EACH RECORD.  AN OPERATOR
C                        IS THEN COMPUTED AND APPLIED TO EACH RECORD TO
C                        SHAPE THE DETERMINED WAVELET TO A DESIRED
C                        (BUTTERWORTH) WAVELET.
C
C                        THE DATA IS FIRST EXPONENTIALLY-SCALED TO MAKE
C                        THE (POSSIBLY SLIGHTLY MIXED-PHASE) SOURCE
C                        WAVELET INTO A MINIMINUM-PHASE WAVELET.  AN
C                        AVERAGE AUTOCORRELATION FUNCTION IS THEN
C                        DETERMINED BY SUMMING AUTOCORRELATIONS COMPUTED
C                        OVER SUCCESSIVE OVERLAPPING WINDOWS DOWN EACH
C                        TRACE AND OVER SELECTED TRACES OF THE RECORD.
C                        NEXT, THE WIENER-LEVINSON ALGORITHM AND
C                        SYNTHETIC DIVISION ARE USED TO COMPUTE A
C                        MINIMUM-PHASE WAVELET FROM THE AVERAGE
C                        AUTOCORRELATION.  INVERSE EXPONENTIAL SCALING
C                        THEN PRODUCES THE MIXED-PHASE SOURCE WAVELET
C                        SOUGHT FOR EACH COMMON-SOURCE RECORD.  FINALLY,
C                        EACH WAVELET IS SHAPED TO A BUTTERWORTH WAVELET
C                        (ZERO-PHASE OR MINIMUM-PHASE).
C
C  NOTE:                 THE INPUT TAPE SHOULD CONTAIN COMMON-SOURCE
C                        (OR COMMON-RECEIVER) RECORDS.
C                        THE INPUT TAPE FORMAT MUST BE SIS FORMAT 1 OR 3
C                        AND CONTAIN NO MORE THAN 1024 TRACES/RECORD AND
C                        6000 SAMPLES/TRACE.
C
C
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
#include <save_defs.h>
      INTEGER*2 ILH(3000), IX(12128)
      INTEGER*4 NLH(1500), NX(6064)
	character*4 crdida,crdidb,crdidc,zero,minm,ncrdid
      REAL*4 RX(6064), A(6000), SUMAC(1000), ACOR(1000), WAV(1000), SHAP
     *(500), OPR(1000)
      character*80 LCARD
      character*1 PARR(66)
      character*1 JARR(35)
      character*1 KARR(35)
      character*1 LARR(35)
      character*1 MARR(35)
      character*1 NARR(35)
	character*9 aval
	character*5 bval
	character*4 cval,dval,fval
cmam.....................................................................
	character*1 clh(6000)
	character*8 jobtp
cmam	character*8 jobtp, jobcd
      character   ntape*256, otape*256, cardin*256
        logical query, faze
        integer argis
	character*4 name
	integer imute(1)
        pointer(kmute,imute)
cmam.....................................................................
      EQUIVALENCE (NLH(1),ILH(1)), (NX(1), IX(1)), (RX(1),IX(1))
	equivalence (nlh(1),clh(1))
	equivalence (jarr(26),aval),(karr(21),bval),(narr(13),cval)
	equivalence (marr(6),dval),(narr(29),fval)
	data PARR/2*' ','W','E','S','H',' ','-',' ','W','A','V',
     *         'E','L','E','T',' ','E','S','T','I','M','A','T','I','O',
     *         'N',' ','A','N','D',' ','S','H','A','P','I','N','G',' ',
     *         'O','N',' ','C','O','M','M','O','N','-','S','O','U','R',
     *         'C','E',' ','R','E','C','O','R','D','S',2*' '/
	data JARR/'W','E','S','H','(','E','X','P',' ','S','C',
     *          'A','L','I','N','G',' ','F','A','C','T','O','R','=',
     *          10*' ',')'/
	data KARR/4*' ','(','W','A','V','E','L','E','T',' ','L',
     *          'E','N','G','T','H','=',5*' ','M','S',7*' ',')'/
	data LARR/4*' ','(','O','U','T','P','U','T',' ','W','A',
     *          'V','E','L','E','T',' ','S','H','A','P','E','D',' ','T',
     *          'O',5*' ',')'/
	data MARR/4*' ','(',4*' ','-','P','H','A','S','E',' ',
     *          'B','U','T','T','E','R','W','O','R','T','H',7*' ',')'/
	data NARR/4*' ','(','L','O','W','C','U','T','=',4*' ',
     *          'H','Z',',',' ','H','I','G','H','C','U','T','=',4*' ',
     *          'H','Z',')'/
	data CRDIDA/'1WES'/, CRDIDB/'2WES'/,CRDIDC/'3WES'/,
     *		ZERO/'ZERO'/, MINM/'MINM'/
	data name/'WESH'/
C
C   DEFINE LOGICAL UNITS AND PARAMETER MAXIMUMS, CALL BANNER PAGE, OPEN
C   INPUT TAPE, READ LINE HEADER, CHECK THAT INPUT TAPE MEETS
C   REQUIREMENTS, AND DEFINE PARAMETERS.
C
#include <f77/pid.h>
cc       check for help flag
 
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
         call help1()
         stop
      endif
cc
      LUNTAP = 10
      LUOTAP = 11
      LUPRNT = LERR
      NLUDSK = 1
      MXNTPR = 1024
      MXNSPT = 6000
      MXSHAP = 500
      MXNOPR = 1000
#include <f77/open.h>
      CALL GAMOCO (PARR, 1, LUPRNT)
cmam.......................................................................
      call argstr ('-N', ntape, ' ', ' ')
      call argstr ('-O', otape, ' ', ' ')
      call argstr ('-C',cardin, ' ', ' ')
cmam.....061193....added command line arguments....
cmam...............if these are present, they override the value
cmam...............from the card file images
	call argi4('-lwv',kengwv,-99999,-99999)
	call argr4('-scl',xscal,-99999.,-99999.)
	call argi4('-lfr',kflow,-99999,-99999)
	call argi4('-hfr',kfhigh,-99999,-99999)
	call argi4('-ldb',krlow,-99999,-99999)
	call argi4('-hdb',krhigh,-99999,-99999)
	call argi4('-st1',ktime1,-99999,-99999)
	call argi4('-lwn',ktleng,-99999,-99999)
	call argi4('-sti',kstinc,-99999,-99999)
	call argi4('-nw',kwndws,-99999,-99999)
	call argr4('-vel',xelwnd,-99.99,-99.99)
	call argi4('-nr',krang1,-99999,-99999)
	call argi4('-fr',krang2,-99999,-99999)
c	call argi4('-ph',kphase,0,0)
	faze = (argis ('-Z') .gt. 0)
	if (faze) then
		kphase = 1
	else
		kphase = 0
	endif
C *------------------------------------------------------------------* C
C *  If ntape specified, open it, otherwise set lui to standard
C *  input (= pipe in)
C *------------------------------------------------------------------* C
      if (ntape.ne.' ')then
        call getln (LUNTAP , ntape, 'r', 0)
      else
        LUNTAP = 0
      endif
       if (LUNTAP .lt. 0) then
         write (LERR,*) 'Could not open input ',ntape
         call ccexit(100)
      endif
C *------------------------------------------------------------------* C
C *  If otape specified, open it, otherwise set luo to standard
C *  output (= pipe out)
C *------------------------------------------------------------------* C
      if (otape.ne.' ')then
        call getln (LUOTAP, otape, 'w', 1)
      else
        LUOTAP = 1
      endif
c
      if (cardin(1:1) .ne. ' ') then
         open (unit=LUCARD, file= cardin, status='old',
     1         form='formatted',access='sequential')
cmam.......allow command arguments to replace card file..........
cmam  else
cmam     write(LERR,*)'No card input file name given -- FATAL'
cmam     write(LERR,*)'Use -C[] on command line to input file name'
cmam     stop 911
cmam..............................................................
      endif
cmam.......................................................................
cmam  CALL LBOPEN (LUNTAP)
      LBYTES = 0
      CALL RTAPE (LUNTAP, ILH, LBYTES)
      IF (LBYTES.EQ.0) GO TO 901
	call saver(ilh,'Format',nfmt,0)
	if(nfmt.ne.3) go to 902
    1	call saver(nlh,'NumTrc',ntpr,0)
	if(ntpr.GT.MXNTPR) GO TO 903
	call saver(nlh,'NumSmp',nspt,0)
	if(nspt.GT.MXNSPT) GO TO 904
	call saver(nlh,'JobNum',jobtp,0)
	call saver(nlh,'NumRec',nrecs,0)
	call saver(nlh,'SmpInt',nsi,0)
C
C   READ 1WESH, 2WESH, 3WESH DATA CARDS, INTERPRET CARD PARAMETERS,
C   CHECK FOR WRONG CARD IDENTIFIERS, PREPARE ARRAY FOR HLH, CALL HLH,
C   PRINT CARD IMAGES, DEFAULT MISSING CARD PARAMETERS, AND CHECK FOR
C   UNREASONABLE CARD PARAMETERS.
C
cmam...............read card image file if cardin(1:1) ne ' '
      if (cardin(1:1) .ne. ' ') then
      READ (LUCARD,2,END=905) LCARD
    2 FORMAT (A80)
c...........read 1WESH card
	read(lcard,3)ncrdid,lengwv,rscal,nflow,nrlow,nfhigh,nrhigh
    3	format(a4,1x,i5,11x,f4.0,7x,4(i3,1x))
      WRITE (LUPRNT,5)
    5 FORMAT (/////,'-CARD IMAGES:',/)
      WRITE (LUPRNT,6)
    6 FORMAT (1X,'----:---1|----:---2|----:---3|----:---4|----:---5|----
     *:---6|----:---7|----:---8|',/)
      WRITE (LUPRNT,7) LCARD
    7 FORMAT (1X,A80)
      IF (NCRDID.NE.CRDIDA) GO TO 906
c...........read 2WESH card
      READ (LUCARD,2,END=905) LCARD
	read(lcard,8)ncrdid,ntime1,ntleng,nstinc,nwndws,velwnd,
     *		nrang1,nrang2,iphase
    8	format(a4,2x,i5,2i4,i1,f4.0,1x,2i6,7x,i1)
      WRITE (LUPRNT,7) LCARD
      IF (NCRDID.NE.CRDIDB) GO TO 909
	endif
cmam.....................end of reading card image file
cmam........command line arguments override card file arguments
	if(kengwv.ne.-99999) lengwv = kengwv
	if(xscal.ne.-99999.) rscal = xscal
	if(kflow.ne.-99999) nflow = kflow
	if(krlow.ne.-99999) nrlow = krlow
	if(kfhigh.ne.-99999) nfhigh = kfhigh
	if(krhigh.ne.-99999) nrhigh = krhigh
	if(ktime1.ne.-99999) ntime1 = ktime1
	if(ktleng.ne.-99999) ntleng = ktleng
	if(kstinc.ne.-99999) nstinc = kstinc
	if(kwndws.ne.-99999) nwndws = kwndws
	if(xelwnd.ne.-99.99) velwnd = xelwnd
	if(krang1.ne.-99999) nrang1 = krang1
	if(ktang2.ne.-99999) nrang2 = ktang2
	if(kphase.ne.0) iphase = kphase
c...................................
      IF (RSCAL.EQ.0.0) RSCAL = 0.98
      IF ((RSCAL.LE.0.0).OR.(RSCAL.GT.1.0)) GO TO 908
	write(aval,4) rscal
    4 FORMAT (F9.7)
      CALL HLHprt (ILH, LBYTES, JARR, 35,lerr)
      IF (LENGWV.LE.0) LENGWV = 200
      NCOR = LENGWV/NSI
      IF (NCOR.GT.1000) GO TO 911
      IF (NRANG1.LT.0) NRANG1 = 0
      IF (NRANG2.LE.0) NRANG2 = 999999
      IF (NRANG2.LE.NRANG1) GO TO 912
      IF (NTIME1.LT.0) NTIME1 = 0
cmam  IF (NTIME2.LT.0) NTIME2 = 0
      IF (NTLENG.LE.0) NTLENG = 1000
      LWIN = NTLENG/NSI
      IF (LWIN.GT.NSPT) GO TO 913
      IF (NTLENG.LT.(5*LENGWV)) GO TO 914
      IF (NSTINC.LE.0) NSTINC = 200
      IF (NWNDWS.LE.0) NWNDWS = 3
      IF (NFLOW.LT.0) NFLOW = 0
      IF (NFHIGH.LT.0) NFHIGH = 0
      NFNYQ = 500/NSI
      IF (NFLOW.GT.NFNYQ) NFLOW = NFNYQ
      IF (NFHIGH.GT.NFNYQ) NFHIGH = NFNYQ
      IF (NRLOW.LE.0) NRLOW = 24
      IF (NRHIGH.LE.0) NRHIGH = 24
cmam  IF ((IWVOPT.LT.0).OR.(IWVOPT.GT.1)) IWVOPT = 0
	if(iphase.eq.1) then
		iwvopt = 0
	else
		iwvopt = 1
	endif
cmam .. default this to 9999....if(velwnd.eq.0.0) go to 920
	if(velwnd.eq.0.0) velwnd = 99.99
C
C   PRINT SUMMARY OF INTERPRETED, DEFAULTED, AND EDITED CARD PARAMETERS.
C
      WRITE (LUPRNT,10)
   10 FORMAT (/////,'-PARAMETER SUMMARY AFTER DEFAULTING AND EDITING:',/
     *)
      WRITE (LUPRNT,11) RSCAL
      WRITE (LUPRNT,12) LENGWV
      WRITE (LUPRNT,13) NRANG1
      WRITE (LUPRNT,14) NRANG2
      WRITE (LUPRNT,15) NTIME1
cmam  WRITE (LUPRNT,16) NTIME2
      WRITE (LUPRNT,17) NTLENG
      WRITE (LUPRNT,18) NSTINC
      WRITE (LUPRNT,19) NWNDWS
      WRITE (LUPRNT,20) NFLOW
      WRITE (LUPRNT,21) NRLOW
      WRITE (LUPRNT,22) NFHIGH
      WRITE (LUPRNT,23) NRHIGH
      WRITE (LUPRNT,24) IWVOPT
	write(luprnt,29) velwnd
cmam  WRITE (LUPRNT,25) JOBCD
   11 FORMAT (' EXPONENTIAL SCALING FACTOR = ',F9.7)
   12 FORMAT (' WAVELET LENGTH IN MS = ',I5)
   13 FORMAT (' NEAR RANGE LIMIT IN FEET FOR COMPUTING AUTOCORRELATIONS
     *= ',I6)
   14 FORMAT (' FAR RANGE LIMIT IN FEET FOR COMPUTING AUTOCORRELATIONS =
     * ',I6)
   15 FORMAT (' START TIME IN MS (AT NEAR RANGE LIMIT) OF FIRST DATA WIN
     *DOW FOR COMPUTING AUTOCORRELATIONS = ',I5)
   16 FORMAT (' START TIME IN MS (AT FAR RANGE LIMIT) OF FIRST DATA WIND
     *OW FOR COMPUTING AUTOCORRELATIONS = ',I5)
   17 FORMAT (' WINDOW LENGTH IN MS OF DATA WINDOWS FOR COMPUTING AUTOCO
     *RRELATIONS = ',I5)
   18 FORMAT (' START TIME INCREMENT IN MS OF DATA WINDOWS FOR COMPUTING
     * AUTOCORRELATIONS = ',I4)
   19 FORMAT (' NUMBER OF SUCCESSIVE DATA WINDOWS FOR COMPUTING AUTOCORR
     *ELATIONS = ',I1)
   20 FORMAT (' LOWER CUTOFF FREQUENCY IN HZ OF OUTPUT BUTTERWORTH WAVEL
     *ET = ',I5)
   21 FORMAT (' CUTOFF RATE IN DB/OCT AT LOWER CUTOFF FREQUENCY OF OUTPU
     *T BUTTERWORTH WAVELET = ',I5)
   22 FORMAT (' UPPER CUTOFF FREQUENCY IN HZ OF OUTPUT BUTTERWORTH WAVEL
     *ET (0=NO UPPER CUTOFF) = ',I5)
   23 FORMAT (' CUTOFF RATE IN DB/OCT AT UPPER CUTOFF FREQUENCY OF OUTPU
     *T BUTTERWORTH WAVELET = ',I5)
   24 FORMAT (' PHASE OF OUTPUT BUTTERWORTH WAVELET (0=ZERO,1=MINIMUM) =
     * ',I1)
   25 FORMAT (' JOB NUMBER ON 1WESH CARD (AND THE INPUT TAPE) =', A8,///
     *//)
   29 FORMAT (' VELOCITY TO ADJUST START TIME OF DESIGN WINDOW =',f9.3,
     *' ft/ms or m/ms',/////)
cmam...   29 FORMAT (' EXPONENTIAL SCALING FACTOR =',f9.3,/////)
C
C   FINISH UPDATING THE LINE HEADER, CALL HLH AND ACCOUNTING ROUTINE.
C
      WRITE (bval,26) LENGWV
   26 FORMAT (I5)
      IF (IWVOPT.EQ.0) WRITE (dval,27) ZERO
      IF (IWVOPT.EQ.1) WRITE (dval,27) MINM
   27 FORMAT (A4)
      WRITE (cval,28) NFLOW
   28 FORMAT (I4)
      WRITE (fval,28) NFHIGH
      CALL HLHprt (ILH, LBYTES, KARR, 35, lerr)
      CALL HLHprt (ILH, LBYTES, LARR, 35, lerr)
      CALL HLHprt (ILH, LBYTES, MARR, 35, lerr)
      CALL HLHprt (ILH, LBYTES, NARR, 35, lerr)
C
C   OPEN OUTPUT TAPE, WRITE LINE HEADER TO OUTPUT TAPE.
C
cmam  CALL LBOPEN (LUOTAP)
	call savhlh(ilh,lbytes,lbyto)
      CALL WRTAPE (LUOTAP, ILH, lbyto)
C
C   OPEN DISK WORK SPACE.
C
      IBYTES = SZSMPD*NSPT
      JBYTES = IBYTES + SZTRHD
      KBYTES = SZSMPD*NCOR
      NBYTOT = JBYTES
	ntptrk = ntpr
	ntrks = 1
      CALL DAOPEN (NTPTRK, NTRKS, JBYTES, LUDISK, NLUDSK)
        iwant = ntpr*SZSMPD
        call galloc(kmute,iwant,errcd,abort)
        if(errcd.ne.0) then
           write(LERR,*) 'ERROR: '
           write(LERR,*) 'Unable to allocate workspace for ISPBUF'
           write(LERR,*) 'FATAL'
        endif
	call move(0,imute,0,iwant)

C
C   SET UP DESIRED OUTPUT SHAPE, DESIGN BUTTERWORTH FILTER.
C
      FLOW = NFLOW
      DBLOW = NRLOW
      FHIGH = NFHIGH
      DBHIGH = NRHIGH
      NSHAP = -401
      TSI = 0.001*NSI
      CALL BUTTER (SHAP, NSHAP, FLOW, DBLOW, FHIGH, DBHIGH, TSI)
      IF (NSHAP.GT.MXSHAP) GO TO 915
      IPSHAP = (NSHAP/2) + 1
C
C   CHECK TO SEE IF MINIMUM-PHASE OUTPUT IS REQUESTED.
C
      IF (IWVOPT.EQ.0) GO TO 110
C
C   DESIGN MINIMUM-PHASE BUTTERWORTH WAVELET.
C
      IPSHAP = 1
      CALL DPHAMN (SHAP, NSHAP, OPR, NSHAP)
      CALL MOVE (1, SHAP, OPR, SZSMPD*NSHAP)
  110 CONTINUE
C
C   SHAP(I) ARRAY NOW CONTAINS DESIRED OUTPUT SHAPE.  DEFINE PARAMETERS
C   AND CLEAR A(I) ARRAY.
C
cmam  SCALE = (NTIME2 - NTIME1)/FLOAT(NRANG2 - NRANG1)
	scale = 1./velwnd
      IDST = NSTINC/NSI
      ITAPS = 0.80*NCOR
      NOTAPS = 20
      CALL MOVE (0, A, 0, IBYTES)
C
C   START MAIN WAVELET ESTIMATION AND SHAPING LOOP FOR EACH COMMON-
C   SOURCE RECORD.
C
      DO 280 NR = 1,NRECS
C
C   CLEAR AVERAGE AUTOCORRELATION ARRAY AND START LOOP FOR AVERAGING
C   AUTOCORRELATIONS OVER THE TRACES OF A RECORD.
C
      CALL MOVE (0, SUMAC, 0, KBYTES)
      DO 160 NTR = 1,NTPR
      NBYTES = 0
      CALL RTAPE (LUNTAP, IX, NBYTES)
      IF (NBYTES.EQ.0) GO TO 901
	call saver(ix,'RecNum',nrecno,1)
  120 CALL DAWRTE (NTR, IX, LUDISK)
	call saver(ix,'StaCor',istat,1)
      IF (istat.EQ.30000) then
	imute(ntr) = nspt
	GO TO 160
      else
	do 121 ii = ithwp1,ithwp1+nspt-1
	if(rx(ii).ne.0.0) then
	   imute(ntr) = ii-ithwp1
	   go to 122
	endif
  121	continue
	imute(ntr) = nspt
  122	continue
      endif
cmam  IF (istat.EQ.30000) GO TO 160
	call saver(ix,'DstUsg',idist,1)
      IF ((idist.LT.NRANG1).OR.(idist.GT.NRANG2)) GO TO 160
      NSTART = (NTIME1 + (SCALE*(idist - NRANG1)))/NSI
cmam.........potential danger here if nstart is zero.........
cmam............addressing will be off
	if(nstart.eq.0) nstart = 1
      CALL MOVE (1, A, NX(ITHWP1), IBYTES)
C
C   DATA IS IN A(I) ARRAY.  START LOOP TO APPLY EXPONENTIAL DECAY AND
C   COMPUTE AUTOCORRELATION OVER SUCCESSIVE WINDOWS ALONG THE TRACE.
C
      DO 150 KK = 1,NWNDWS
cmam.........nwend SHOULD be = nstart + lwin - 1
cmam.............changed so check will be valid
cmam  NWEND = NSTART + LWIN
      NWEND = NSTART + LWIN - 1
      IF (NWEND.GT.NSPT) GO TO 160
      CALL EXPSCL (A(NSTART), LWIN, RX(ITHWP1), RSCAL)
      CALL AUTCOR (RX(ITHWP1), LWIN, ACOR, NCOR)
      IF (ACOR(1).LE.0.0) GO TO 140
      DO 130 I = 1,NCOR
      SUMAC(I) = SUMAC(I) + (ACOR(I)/ACOR(1))
  130 CONTINUE
  140 CONTINUE
      NSTART = NSTART + IDST
  150 CONTINUE
C
C   THIS TRACE IS DONE, GET ANOTHER TRACE.
C
  160 CONTINUE
      ZLGAAC = SUMAC(1)
      IF (ZLGAAC.GT.0.0) GO TO 180
      WRITE (LUPRNT,170) NRECNO
  170 FORMAT (6X,'ZERO-LAG VALUE OF AVG. AUTOCOR. IS LESS THAN OR EQUAL
     *TO ZERO FOR RECORD ',I5,'--THIS RECORD PASSED TO OUTPUT TAPE UNCHA
     *NGED')
      NWAVPR = 0
      NOPRPR = 0
      GO TO 240
  180 CONTINUE
C
C   AVERAGE AUTOCORRELATION IS COMPUTED, NOW TAPER IT.
C
      CALL TAPER (SUMAC, NCOR, ITAPS, NOTAPS)
C
C   COMPUTE WAVELET ESTIMATE.
C
      NWAV = NCOR
      CALL WAVEST (SUMAC, NCOR, WAV, NWAV, RSCAL, A, A(1001))
      NWAVPR = NWAV
      IF (NWAV.GT.0) GO TO 200
      WRITE (LUPRNT,190) NRECNO
  190 FORMAT (6X,'SUBROUTINE WAVEST UNABLE TO DETERMINE WAVELET FOR RECO
     *RD ',I5,'--THIS RECORD PASSED TO OUTPUT TAPE UNCHANGED')
      NOPRPR = 0
      GO TO 240
  200 CONTINUE
C
C   ESTIMATED WAVELET IS IN WAV(I) ARRAY, APPLY TAPER.
C
      CALL TAPER (WAV, NWAV, ITAPS, NOTAPS)
C
C   COMPUTE WAVELET SHAPING OPERATOR.
C
      CALL DSHPWV (WAV, NWAV, OPR, NOPR, IOPR, SHAP, NSHAP, IPSHAP,NCOR)
C
C   SHAPING OPERATOR IS IN OPR(I) ARRAY, CHECK FOR STABILITY.
C
      NOPRPR = NOPR
      IF (NOPR.GT.0) GO TO 220
      WRITE (LUPRNT,210) NRECNO
  210 FORMAT (6X,'SHAPING OPERATOR IS UNSTABLE FOR RECORD ',I5,'--THIS R
     *ECORD PASSED TO OUTPUT TAPE UNCHANGED')
      GO TO 240
  220 CONTINUE
      IF (NOPR.GT.MXNOPR) GO TO 916
C
C   SHAPING OPERATOR IS STABLE, NOW APPLY THE OPERATOR TO DATA.
C
      DO 230 NTR = 1,NTPR
      CALL DAREAD (NTR, IX, LUDISK)
      CALL MOVE (1, A, nX(ITHWP1), IBYTES)
C
C   APPLY SHAPING OPERATOR.
C
      CALL CONVOL (A, NSPT, OPR, NOPR, IOPR, RX(ITHWP1), NSPT)
C
C   OUTPUT IS IN RX(I) ARRAY, WRITE TO TAPE.
C
	if(imute(ntr).gt.0) call vclr(rx(ithwp1),1,imute(ntr))
  225 CALL WRTAPE (LUOTAP, IX, NBYTOT)
  230 CONTINUE
      GO TO 260
  240 DO 250 NTR = 1,NTPR
      CALL DAREAD (NTR, IX, LUDISK)
	if(imute(ntr).gt.0) call vclr(rx(ithwp1),1,imute(ntr))
  245 CALL WRTAPE (LUOTAP, IX, NBYTOT)
  250 CONTINUE
  260 WRITE (LUPRNT,270) IX(106), ZLGAAC, NWAVPR, NOPRPR
  270 FORMAT (' PROCESSED RI ',I5,9X,'ZERO-LAG AVG AUTOCOR = ',F14.7,5X,
     *'EST WAVELET LENG = ',I5,' SAMP',5X,'SHAPING OPR LENG = ',I5,' SAM
     *P')
  280 CONTINUE
	call gfree(kmute)
	call lbclos(luntap)
	call lbclos(luotap)
      CALL DACLOS (LUDISK)
      WRITE (LUPRNT,290)
  290 FORMAT ('-EXECUTION COMPLETE')
      STOP
C
C   ERROR MESSAGES
C
  901 WRITE (LUPRNT,1901)
 1901 FORMAT ('-EOF ENCOUNTERED ATTEMPTING TO READ INPUT TAPE--EXECUTION
     * TERMINATED')
      STOP 901
  902 WRITE (LUPRNT,1902)
 1902 FORMAT ('-INPUT TAPE IS NOT SIS FORMAT 3--EXECUTION TERMINATED')
      STOP 902
  903 WRITE (LUPRNT,1903) MXNTPR
 1903 FORMAT ('-NO. OF TRACES/RECORD ON INPUT TAPE IS GREATER THAN ',I4,
     *'--EXECUTION TERMINATED')
      STOP 903
  904 WRITE (LUPRNT,1904) MXNSPT
 1904 FORMAT ('-NO. OF SAMPLES/TRACE ON INPUT TAPE IS GREATER THAN ',I4,
     *'--EXECUTION TERMINATED')
      STOP 904
  905 WRITE (LUPRNT,1905)
 1905 FORMAT ('-ONE OR MORE INPUT DATA CARDS ARE MISSING--EXECUTION TERM
     *INATED')
      STOP 905
  906 WRITE (LUPRNT,1906)
 1906 FORMAT ('-FIRST INPUT DATA CARD IS NOT A 1WESH CARD--EXECUTION TER
     *MINATED')
      STOP 906
c 907 WRITE (LUPRNT,1907) JOBCD, JOBTP
 1907 FORMAT ('-JOB NUMBER ON 1WESH CARD (', A8,') DOES NOT AGREE WITH J
     &OB NUMBER ON INPUT TAPE (', A8,')--warning only')
cmam  STOP 907
  908 WRITE (LUPRNT,1908) RSCAL
 1908 FORMAT ('-EXPONENTIAL SCALING FACTOR = ',E15.8,' IS NOT ALLOWED--E
     *XECUTION TERMINATED')
      STOP 908
  909 WRITE (LUPRNT,1909)
 1909 FORMAT ('-SECOND INPUT DATA CARD IS NOT A 2WESH CARD--EXECUTION TE
     *RMINATED')
      STOP 909
  910 WRITE (LUPRNT,1910)
 1910 FORMAT ('-THIRD INPUT DATA CARD IS NOT A 3WESH CARD--EXECUTION TER
     *MINATED')
      STOP 910
  911 WRITE (LUPRNT,1911) NCOR
 1911 FORMAT ('-WAVELET LENGTH = (',I5,' SAMPLES) IS GREATER THAN 1000 S
     *AMPLES--EXECUTION TERMINATED')
      STOP 911
  912 WRITE (LUPRNT,1912) NRANG2, NRANG1
 1912 FORMAT ('-FAR RANGE LIMIT FOR COMPUT. AUTOCORRELNS. (=',I6,' FT) I
     *S NOT GREATER THAN THE NEAR RANGE LIMIT (=',I6,' FT)--EXECUTION TE
     *RMINATED')
      STOP 912
  913 WRITE (LUPRNT,1913) NTLENG
 1913 FORMAT ('-DATA WINDOW LENGTH FOR AUTOCORRELATIONS (=',I5,' MS) IS
     *GREATER THAN THE TRACE LENGTH--EXECUTION TERMINATED')
      STOP 913
  914 WRITE (LUPRNT,1914) NTLENG, LENGWV
 1914 FORMAT ('-DATA WINDOW LENGTH FOR AUTOCORRELATIONS (=',I5,' MS) IS
     *NOT AT LEAST 5 TIMES THE WAVELET LENGTH (=',I5,' MS)--EXECUTION TE
     *RMINATED')
      STOP 914
  915 WRITE (LUPRNT,1915) NSHAP, MXSHAP
 1915 FORMAT ('-BUTTERWORTH WAVELET LENGTH (',I5,' SAMPLES) RETURNED FRO
     *M SUBROUTINE BUTTER IS GREATER THAN ',I5,' SAMPLES--EXECUTION TERM
     *INATED')
      STOP 915
  916 WRITE (LUPRNT,1916) NOPR, MXNOPR
 1916 FORMAT ('-SHAPING OPERATOR LENGTH (',I5,' SAMPLES) RETURNED FROM S
     *UBROUTINE DSHPWV IS GREATER THAN ',I5,' SAMPLES--EXECUTION TERMINA
     *TED')
      STOP 916
  920 WRITE (LUPRNT,1920) velwnd
 1920 FORMAT ('-VELOCITY TO ADJUST START TIME OF DESIGN WINDOW (',I5,
     *' ft/ms or m/ms) CANNOT EQUAL ZERO -- NO DEFAULT -- EXECUTION TERM
     *INATED')
      STOP 920
      END
      SUBROUTINE AUTCOR(WIN,NIN,ACOR,NCOR)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       AUTCOR
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      To compute the autocorrelation of input data.
C  CALLING PARAMETERS:  CALL AUTCOR(WIN,NIN,ACOR,NCOR)
C  ARGUMENTS:
C      Name                    Length   Description
C      WIN   R*4  I  ( 1 )     NIN      Input array containing data.
C      NIN   I*4  I            1        Length of WIN
C      ACOR  R*4  O  ( 1 )     NCOR     Returned ACOR array.
C                                       ACOR(1) is the zero lag.
C      NCOR  I*4  I            1        Number of output points desired.
C  CATEGORY:  UTILITY
C  KEYWORDS:  AUTOCORRELATION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHORS:    M. TURHAN TANER                 ORIGIN DATE:  81/04/30
C              (modified by) CECIL N. JONES
C
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      APAM     -       Array processor
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  The input data is correlated by itself. Subrou-
C                        tine will not run over the end of input data.
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF THE SUBROUTINE:  NONE
C  ERROR MESSAGES:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WIN(1),ACOR(1)
      DO 20    I=1,NCOR
      K=1
      SM=0.0
      DO 10    J=I,NIN
      SM=SM+WIN(J)*WIN(K)
      K=K+1
   10 CONTINUE
      ACOR(I)=SM
   20 CONTINUE
C
C     DO THE AUTOCORRELATION IN THE ARRAY PROCESSOR
C
cmam  CALL APAM('CVM*',1, ACOR,NCOR,4,0, WIN,NIN,4,0, WIN,NIN,4,0)
C
      RETURN
      END
      SUBROUTINE BUTTER(BUT,NBUT,FL,DBL,FH,DBH,SAMP)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       BUTTER
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      Design zero-phase Butterworth-type low-pass, high-pass or band-
C      pass filters with user controlled passband and roll-off rates.
C  CALLING PARAMETERS:  CALL BUTTER(BUT,NBUT,FL,DBL,FH,DBH,SAMP)
C  ARGUMENTS:
C      Name                   Length   Description
C      BUT   R*4  O  ( 1 )    NBUT     Butterworth filter array.
C      NBUT  I*4  I           1        Number of Butterworth filter val-
C                                      ues to generate.
C      FL    R*4  I           1        Low-cut (1/2 power) point,
C                                      cycles/second.
C      DBL   R*4  I           1        Low-cut roll-off rate,
C                                      dB/octave.
C      FH    R*4  I           1        High-cut (1/2 power)point,
C                                      cycles/second.
C      DBH   R*4  I           1        High-cut roll-off rate;
C                                      dB/octave.
C      SAMP  R*4  I           1        Filter sample rate, sec-
C                                      onds/sample.
C  CATEGORY:  UTILITY
C  KEYWORDS:  FILTER, BUTTERWORTH
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/05/04
C  LANGUAGE:  FORTRAN IV                          MODIFIED:  81/10/08
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  FORTRAN SUPPLIED PROCEDURES:
C      ABS
C      ALOG
C      COS
C      SQRT
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:
C  Subroutine computes the amplitude spectrum of the filter, then, the
C  time-domain response of filter is computed by cosine transform.  Re-
C  sulting filter is zero phase where center of array represents the
C  zero-lag point of the filter.
C  SUBROUTINES USED:  NONE
C  AUXILIARY STORAGE USED:  NONE
C  ERROR RETURNS:  NONE
C  NOTE:
C  If FL=0.0 no low cut is designed.  If FH=0.0 no high cut is designed.
C  Subroutine returns a zero phase filter where the center of array
C  NBUT/2+1 is the zero-lag point.  If minimum phase Butterworth filter
C  is required, user should call subroutine PHAMIN after call to BUTTER.
C  The subroutine will return minimum-phase Butterworth wavelet in the
C  same BUT array of NBUT points long.
C  The zero lag point of minimum phase wavelet is the first sample.
C  If NBUT is a large negative number, subroutine will automatically
C  compute optimum filter length, generally shorter (recommend
C  NBUT=-20 for 4 msec sample interval).
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION BUT(1)
      FLAG=0.0
      IF (NBUT.GT.0) GO TO 5
      FLAG=1.0
      NBUT=-NBUT
    5 CONTINUE
      CH=10.**((-3.0-ABS(DBH))/10.)
      CL=10.**((-3.0-ABS(DBL))/10.)
      AN=ALOG((1.0-CH)/CH)/(2.0*ALOG(2.0))
      AM=ALOG((1.0-CL)/CL)/(2.0*ALOG(2.0))
      NN=AN+0.999
      MM=AM+0.999
      NN=2*NN
      MM=2*MM
      MIDL=((NBUT+3)/4)*2+1
      NBUT=MIDL*2-1
      NFR=MIDL-1
      CONST=1./(2.0*NFR+1.0)
      CON=CONST
      IF(FL.GT.0.0) CON=0.0
      IF(FH.EQ.0.0) FH=1000000.0
      FFOLD=0.5/SAMP
      DFR=1.0/(SAMP*NBUT)
      DO 10    I=1,NBUT
   10 BUT(I)=CON
      FR=DFR
      APOW=CON
      DO 30    I=1,NFR
      AMP=1.0
      IF(FL.GT.0.)AMP=AMP/(1.0+(FL/FR)**MM)
      IF(FH.LE.FFOLD)AMP=AMP/(1.0+(FR/FH)**NN)
      T=0.0
      APOW=APOW+2.*AMP*CONST
      AMP=CONST*SQRT(AMP)*2.0
      W=6.2831852*FR
      DO 20    J=1,MIDL
      BUT(MIDL+J-1)=BUT(MIDL+J-1)+AMP*COS(W*T)
      T=T+SAMP
   20 CONTINUE
      FR=FR+DFR
   30 CONTINUE
C      CHECK TO SEE IF AUTOMATIC FILTER LENGTH IS REQUESTED
      IF(FLAG.NE.0.0) GO TO 35
      II=MIDL
      GO TO 50
   35 CONTINUE
C      COMPUTE TOTAL POWER FROM FREQUENCY DOMAIN.  SELECT LENGTH FOR
C      0.99 OF POWER.
      SUM=0.99*APOW-BUT(MIDL)*BUT(MIDL)
      II=2
      KK=MIDL+1
   40 CONTINUE
      SUM=SUM-(BUT(KK)*BUT(KK)*2.0)
      IF(SUM.LE.0.0) GO TO 50
      II=II+1
      KK=KK+1
      IF(II.LT.MIDL) GO TO 40
   50 CONTINUE
C      LENGTH IS ESTABLISHED, NOW TAPER ENDS.
      LEN=II
      NHPT=0.80*II
      CALL TAPER (BUT(MIDL),LEN,NHPT,20)
C      GENERATE TWO-SIDED FILTER
      NBUT=2*LEN-1
      BUT(LEN)=BUT(MIDL)
      DO 60 I=2,LEN
      AA=BUT(MIDL+I-1)
      BUT(LEN+I-1)=AA
      BUT(LEN-I+1)=AA
   60 CONTINUE
      RETURN
      END
      SUBROUTINE CONVOL(WIN,NIN,OP,NOP,IPO,WOT,NOUT)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       CONVOL
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      To perform a convolution operation on two vectors.
C  CALLING PARAMETERS:  CALL CONVOL(WIN,NIN,OP,NOP,IPO,WOT,NOUT)
C  ARGUMENTS:
C      Name                   Length   Description
C      WIN   R*4  I  ( 1 )    NIN      Input data array(operand)
C      NIN   I*4  I           1        Length of WIN.
C      OP    R*4  I  ( 1 )    NOP      Input operator.
C      NOP   I*4  I           1        Length of OP.
C      IPO   I*4  I           1        Index pointing to zero
C                                      lag sample of OP array.
C                                        =1 if it is minimum phase
C                                        = NOP/2+1 if it is zero
C                                          phase.
C      WOT   R*4  O  ( 1 )    NOUT     Result of convolution.
C      NOUT  I*4  I           1        Number of output points.
C  CATEGORY:  UTILITY
C  KEYWORDS:  CONVOLUTION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION: The routine reverses the OP array and correlates
C                       two input vectors.
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE:  NONE
C  LIMITATIONS OF THE SUBROUTINE:  NONE
C  ERROR MESSAGES:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WIN(1),OP(1),WOT(1)
      DO 30    I=1,NOUT
      IP=IPO+I
      SM=0.0
      DO 20    J=1,NOP
      IP=IP-1
      IF(IP.LT.1) GO TO 25
      IF(IP.GT.NIN) GO TO 20
      SM=SM+OP(J)*WIN(IP)
   20 CONTINUE
   25 WOT(I)=SM
   30 CONTINUE
      RETURN
      END
      SUBROUTINE CRSCOR(AA,NA,IPA,BB,NB,IPB,CCOR,NCOR,ILAG)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       CRSCOR
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      To perform a cross-correlation on two vectors.
C  CALLING PARAMETERS:  CALL CRSCOR(AA,NA,IPA,BB,NB,IPB,CCOR,NCOR,ILAG)
C  ARGUMENTS:
C      Name                   Length   Description
C      AA    R*4  I  ( 1 )    NA       Input data array.
C      NA    I*4  I           1        Length of AA.
C      IPA   I*4  I           1        Sample index for zero lag
C                                      on AA array
C                                        = 1 for minimum phase
C                                        = NA/2+1 for zero phase
C      BB    R*4  I  ( 1 )    NB       Input operator array.
C      NB    I*4  I           1        Length of BB.
C      IPB   I*4  I           1        Sample index for zero lag on
C                                      BB array.
C      CCOR  R*4  O  ( 1 )    NCOR     Cross-correlation array.
C      NCOR  I*4  I           1        Length of CCOR
C      ILAG  I*4  I           1        Zero lag for cross-correlation
C                                      function.
C  CATEGORY:  UTILITY
C  KEYWORDS:  CROSSCORRELATION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF SUBROUTINE:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION AA(1),BB(1),CCOR(1)
      IPO=IPA-IPB+1+ILAG
      DO 40    I=1,NCOR
      SM=0.0
      K=IPO
      DO 20    J=1,NB
      IF(K.LT.1) GO TO 10
      IF(K.GT.NA) GO TO 30
      SM=SM+AA(K)*BB(J)
   10 K=K+1
   20 CONTINUE
   30 IPO=IPO+1
      CCOR(I)=SM
   40 CONTINUE
      RETURN
      END
      SUBROUTINE DAUTCR(WIN,NIN,ACOR,NCOR)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       DAUTCR
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      To compute the autocorrelation of input data.
C  CALLING PARAMETERS:  CALL DAUTCR(WIN,NIN,ACOR,NCOR)
C  ARGUMENTS:
C      Name                    Length   Description
C      WIN   R*8  I  ( 1 )     NIN      INPUT ARRAY CONTAINING DATA.
C      NIN   I*4  I            1        Length of WIN
C      ACOR  R*8  O  ( 1 )     NCOR     RETURNED ACOR ARRAY.
C                                       ACOR(1) is the zero lag.
C      NCOR  I*4  I            1        Number of output points desired.
C  CATEGORY:  UTILITY
C  KEYWORDS:  AUTOCORRELATION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHORS:    M. TURHAN TANER                 ORIGIN DATE:  81/04/30
C              (modified by) CECIL N. JONES
C
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      APAM     -       Array processor
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  The input data is correlated by itself. Subrou-
C                        tine will not run over the end of input data.
C                        THIS IS A DOUBLE-PRECISION VERSION OF
C                        SUBROUTINE AUTCOR.
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF THE SUBROUTINE:  NONE
C  ERROR MESSAGES:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WIN(1),ACOR(1)
      double precision SM,WIN,ACOR
cmam  REAL*8 SM,WIN,ACOR
      DO 20    I=1,NCOR
      K=1
      SM=0.0
      DO 10    J=I,NIN
      SM=SM+WIN(J)*WIN(K)
      K=K+1
   10 CONTINUE
      ACOR(I)=SM
   20 CONTINUE
C
C     DO THE AUTOCORRELATION IN THE ARRAY PROCESSOR
C
C     CALL APAM('CVM*',1, ACOR,NCOR,4,0, WIN,NIN,4,0, WIN,NIN,4,0)
C
      RETURN
      END
      SUBROUTINE DCRSCR(AA,NA,IPA,BB,NB,IPB,CCOR,NCOR,ILAG)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       DCRSCR
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      To perform a cross-correlation on two vectors.
C  CALLING PARAMETERS:  CALL DCRSCR(AA,NA,IPA,BB,NB,IPB,CCOR,NCOR,ILAG)
C  ARGUMENTS:
C      Name                   Length   Description
C      AA    R*8  I  ( 1 )    NA       INPUT DATA ARRAY.
C      NA    I*4  I           1        Length of AA.
C      IPA   I*4  I           1        Sample index for zero lag
C                                      on AA array
C                                        = 1 for minimum phase
C                                        = NA/2+1 for zero phase
C      BB    R*8  I  ( 1 )    NB       INPUT OPERATOR ARRAY.
C      NB    I*4  I           1        Length of BB.
C      IPB   I*4  I           1        Sample index for zero lag on
C                                      BB array.
C      CCOR  R*8  O  ( 1 )    NCOR     CROSS-CORRELATION ARRAY.
C      NCOR  I*4  I           1        Length of CCOR
C      ILAG  I*4  I           1        Zero lag for cross-correlation
C                                      function.
C  CATEGORY:  UTILITY
C  KEYWORDS:  CROSSCORRELATION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  THIS IS A DOUBLE-PRECISION VERSION OF
C                        SUBROUTINE CRSCOR
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF SUBROUTINE:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION AA(1),BB(1),CCOR(1)
      double precision AA,BB,CCOR,SM
cmam  REAL*8 AA,BB,CCOR,SM
      IPO=IPA-IPB+1+ILAG
      DO 40    I=1,NCOR
      SM=0.0
      K=IPO
      DO 20    J=1,NB
      IF(K.LT.1) GO TO 10
      IF(K.GT.NA) GO TO 30
      SM=SM+AA(K)*BB(J)
   10 K=K+1
   20 CONTINUE
   30 IPO=IPO+1
      CCOR(I)=SM
   40 CONTINUE
      RETURN
      END
      SUBROUTINE DMINVR(WIN,NIN,WAV,NAV)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       DMINVR
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      Compute the inverse of a given minimum-phase wavelet by
C      synthetic division.
C  CALLING PARAMETERS:    CALL DMINVR (WIN, NIN, WAV, NAV)
C  ARGUMENTS:
C      Name                  Length  Description
C      WIN  R*8  I  ( 1 )    NIN     MINIMUM-PHASE INPUT WAVELET.
C      NIN  I*4  I           1       Length of input wavelet.
C      WAV  R*8  O  ( 1 )    NAV     OUTPUT ARRAY.
C      NAV  I*4  I           1       Length of the inverse (output)
C                                    wavelet to be computed.
C  CATEGORY:  UTILITY
C  KEYWORDS:  WAVELET PHASE INVERSE
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/05/04
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  Synthetic division is performed as term by term
C                        RECURSIVE COMPUTATION.
C                        THIS IS A DOUBLE-PRECISION VERSION OF
C                        SUBROUTINE MINVER.
C  SUBROUTINES USED:  NONE
C  AUXILIARY STORAGE:  NONE
C  ERROR HANDLING:  Subroutine does not have any error checking proced-
C                   ure.  Since the output is generated by synthetic
C                   division by a recursive algorithm, it may not al-
C                   ways be stable.  Stability is expected only if out-
C                   put wavelet is minimum-phase.  For maximum-phase
C                   wavelets, user should reverse the wavelet before
C                   calling the subroutine.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WIN(1),WAV(1)
      double precision WIN,WAV,SM
cmam  REAL*8 WIN,WAV,SM
      WAV(1)=1./WIN(1)
      DO 30    I=2,NAV
      SM=0.0
      DO 10    K=2,I
      IF(K.GT.NIN) GO TO 20
      SM=SM+WIN(K)*WAV(I+1-K)
   10 CONTINUE
   20 WAV(I)=-SM/WIN(1)
   30 CONTINUE
      RETURN
      END
      SUBROUTINE DPHAMN(WAVS,NAV,WMIN,NMIN)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       DPHAMN
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      Design the minimum-phase wavelet corresponding to a given
C      wavelet of arbitrary phase characteristics
C  CALLING PARAMETERS:
C      CALL DPHAMN (WAVS, NAV, WMIN, NMIN)
C  ARGUMENTS:
C      Name                    Length  Description
C      WAV   R*4  I  ( 1 )     NAV     INPUT WAVELET OF ARBITRARY
C                                      shape.
C      NAV   I*4  I            1       Number of input wavelet
C                                      points.
C      WMIN  R*4  O  ( 1 )     NMIN    MINIMUM PHASE WAVELET,NMIN
C                                      number of points in length.
C                                      The zero lag pointer is the
C                                      first sample.
C      NMIN  I*4  I            1       Number of points of output
C                                      minimum phase wavelet to
C                                      design.
C  CATEGORY:  UTILITY
C  KEYWORDS:  WAVELET PHASE
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/05/04
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      DAUTCR   -         AUTOCORRELATION COMPUTATION.
C      DWIENR   -         WIENER-LEVINSON ALGORITHM FOR MINIMUM
C                         phase inverse computation.
C      DMINVR   -         INVERSE OF MINIMUM-PHASE WAVELET COM-
C                         putation.
C  AUXILIARY ARRAYS:
C      AC      TYPE = R*8   LENGTH = 500   AUTOCORRELATION STORAGE.
C      BOB     TYPE = R*8   LENGTH = 500   TEMPORARY STORAGE.
C  FORTRAN SUPPLIED PROCEDURES:
C      SQRT
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  THIS IS A DOUBLE-PRECISION VERSION OF
C                        SUBROUTINE PHAMIN.
C  LIMITATIONS:  Subroutine will handle wavelets up to 500 points in
C                length.  If longer wavelet is used, then programmer
C                should change the dimensions of AC and BOB arrays.
C  NOTE:         Subroutine allows input and output arrays be the same
C                or different arrays.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WAVS(1),AC(500),WMIN(1),BOB(500),WAV(500),WIN(500)
      double precision AC,BOB,WAV,ACC,ACB,WIN,SCA
cmam  REAL*8 AC,BOB,WAV,ACC,ACB,WIN,SCA
      DO 5    I=1,NAV
      WAV(I)=WAVS(I)
    5 CONTINUE
C         COMPUTE MIN-PHASE WAVELET EQUIVALENT TO A GIVEN WAVELET
      CALL DAUTCR(WAV,NAV,AC,NAV)
      ACC = AC(1)
      NOG=0
      CALL DWIENR(AC,AC,NOG,WAV,WIN,NAC,BOB)
      CALL DMINVR(WAV,NAC,AC,NMIN)
C         EQUALIZE POWER
      ACB=0.
      DO 10    I=1,NMIN
      ACB=ACB+AC(I)*AC(I)
   10 CONTINUE
      SCA=DSQRT(ACC/ACB)
      DO 20    I = 1,NMIN
      WMIN(I)=AC(I)*SCA
   20 CONTINUE
      RETURN
      END
      SUBROUTINE DSHPWV(WAV,NAV,OPR,NOPR,IOPR,SHAP,NSHAP,IPS,NOC)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       DSHPWV
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      Design a wavelet shaping operator, which, when convolved with the
C      given seismic source wavelet, produces a desired wavelet shape.
C  CALLING PARAMETERS:
C      CALL DSHPWV(WAV,NAV,OPR,NOPR,IOPR,SHAP,NSHAP,IPS,NOC)
C  ARGUMENTS:
C      Name                     Length   Description
C      WAV    R*4  I  ( 1 )     NAV      Given wavelet.
C      NAV    I*4  I            1        Number of wavelet points
C      OPR    R*4  O  ( 1 )     NOPR     Convolutional shaping
C                                        operator.
C      NOPR   I*4  O            1        Number of points of the
C                                        shaping operator.
C      IOPR   I*4  O            1        Zero-lag pointer of the
C                                        shaping operator.
C      SHAP   R*4  I  ( 1 )     NSHAP    Desired output wavelet
C                                        shape.
C      NSHAP  I*4  I            1        Number of desired output
C                                        wavelet shape points.
C      IPS    I*4  I            1        Zero-lag pointer for de-
C                                        sired output wavelet.
C      NOC    I*4  I            1        Number of shaping opera-
C                                        tor points to compute.
C                                        This is usually kept be-
C                                        tween NAV and 2* NAV.
C  CATEGORY:  UTILITY
C  KEYWORDS:  WAVELET SHAPING
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      CRSCOR   -    PERFORM A CROSS-CORRELATION ON TWO VECTORS.
C      DAUTCR   -    AUTOCORRELATION COMPUTATION.
C      DCRSCR   -    PERFORM A CROSS-CORRELATION ON TWO VECTORS.
C      DWIENR   -    WIENER-LEVINSON ALGORITHM FOR MINIMUM-PHASE
C                    inverse computation.
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:
C  The method used in this subroutine is given by Wood et. al. (1978)
C  in a paper published in Geophysics, where a shaping operator of the
C  autocorrelation of the wavelet is computed.  This operator is, then,
C  correlated with the wavelet to form the final shaping operator.
C  THIS IS A DOUBLE-PRECISION VERSION OF SUBROUTINE SHPWAV
C  INTERNAL STORAGE USED:
C  ACOR    TYPE = R*8   LENGTH = 1000      WAVELET AUTOCORRELATION.
C  AC      TYPE = R*8   LENGTH = 1000      AUTOCOR OF AUTOCORRELATION.
C  CCOR    TYPE = R*8   LENGTH = 1000      CROSS CORRELATION.
C  BOB     TYPE = R*8   LENGTH = 1000      AUXILIARY ARRAY FOR WIENER.
C  CON     TYPE = R*8   LENGTH = 1000      AUXILIARY ARRAY.
C  DOPR    TYPE = R*8   LENGTH = 1000      AUXILIARY ARRAY.
C  TEM     TYPE = R*4   LENGTH = 1000      AUXILIARY ARRAY.
C  LIMITATIONS OF SUBROUTINE:  NONE
C  ERROR HANDLING:  If operator design fails, SHPWAV will return a nega-
C                   tive NOPR.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WAV(1),SHAP(1),OPR(1),ACOR(1000),AC(1000),CCOR(1000),BOB
     1(1000),CON(1000)
      DIMENSION TEM(1000)
      double precision ACOR,AC,CCOR,BOB,CON,DOPR(1000)
cmam  REAL*8 ACOR,AC,CCOR,BOB,CON,DOPR(1000)
C
      MIDL=NOC/2+1
      DO 5    I=1,NAV
      BOB(I)=WAV(I)
    5 CONTINUE
      CALL DAUTCR(BOB,NAV,ACOR(MIDL),MIDL)
      DO 10    I=2,MIDL
   10 ACOR(MIDL+1-I)=ACOR(MIDL+I-1)
      CALL DAUTCR(ACOR,NOC,AC,NOC)
      DO 15  I=1,NSHAP
   15 CON(I)=SHAP(I)
      LAGS=1-MIDL
      CALL DCRSCR(ACOR,NOC,MIDL,CON,NSHAP,IPS,CCOR,NOC,LAGS)
      NOPR=NAV+NOC-1
      NCA=NOC
      NCB=NOC
      CALL DWIENR (AC,CCOR,NCA,DOPR,CON,NCB,BOB)
      IF (NCA.EQ.NOC) GO TO 20
      NOPR=-NOPR
      RETURN
   20 CONTINUE
      LAGS=1-NAV
      DO 25    I=1,NOC
   25 TEM(I)=CON(I)
      CALL CRSCOR(TEM,NOC,1,WAV,NAV,1,OPR,NOPR,LAGS)
      IOPR=MIDL+NAV-1
      RETURN
      END
      SUBROUTINE DWIENR(AC,GG,NOG,WIN,OPR,NOP,BB)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       DWIENR
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      To solve a set of Toeplitz-type linear equations using the
C      Wiener-Levinson algorithm.
C  CALLING PARAMETERS:  CALL DWIENR(AC,GG,NOG,WIN,OPR,NOP,BB)
C  ARGUMENTS:
C      Name                    Length   Description
C      AC   R*8  I  ( 1 )      NOP      INPUT AUTOCORRELATION FUNCTION.
C      GG   R*8  I  ( 1 )      NOP      R.H.S. OF THE EQUATIONS.
C                                         Not used if NOG=0.
C      NOG  I*4  I             1        Flag indicates type.
C                                         0 - Case I, 1 - Case II
C      WIN  R*8  O  ( 1 )      NOP      UNIT-STEP PREDICTION ERROR OPER-
C                                       ator for both cases.
C      OPR  R*8  O  ( 1 )      NOP      COMPUTED SOLUTIONS USED ONLY IF
C                                       NOP=1.
C      NOP  I*4  I             1        Length of AC, GG, WIN, OPR, BB.
C      BB   R*8  I  ( 1 )      NOP      WORK BUFFER.
C  CATEGORY:  UTILITY
C  KEYWORDS:  WEINER PREDICTION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  This routine solves two types of equations:
C                        (I) only first element of R.H.S. vector is non-
C                            zero.
C                       (II) at least two elements of R.H.S. vector are
C                            non-zeros.
C                        The subroutine multiplies AC(1) by 1.005 and
C                        reiterates if unstable and negative parameters
C                        are encountered.  It sets the first element of
C                        the output array to zero and gives up after
C                        five trials.
C                        THIS IS A DOUBLE-PRECISION VERSION OF
C                        SUBROUTINE WIENER.
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF SUBROUTINE:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION AC(1),GG(1),WIN(1),OPR(1),BB(1)
      double precision AC,GG,WIN,OPR,BB,ALP,DENOM,BETA,QU,ALPB,SCAL
cmam  REAL*8 AC,GG,WIN,OPR,BB,ALP,DENOM,BETA,QU,ALPB,SCAL
      WIN(1)=1.0
      BB(1)=1.0
      NITER=0
    3 CONTINUE
      WIN(2)=-AC(2)/AC(1)
      BB(2)=WIN(2)
      ALP=AC(1)-AC(2)*AC(2)/AC(1)
      IF(NOG.EQ.0) GO TO 5
      DENOM=AC(1)*AC(1)-AC(2)*AC(2)
      OPR(1)=(GG(1)*AC(1)-GG(2)*AC(2))/DENOM
      OPR(2)=(GG(2)*AC(1)-GG(1)*AC(2))/DENOM
    5 CONTINUE
      DO 50    I=3,NOP
      BETA=AC(I)
      KK=I-1
      IF(NOG.GT.0)GAMMA=AC(I)*OPR(1)
      DO 10    K=2,KK
      BETA=BETA+AC(I-K+1)*WIN(K)
      BB(K)=WIN(K)
      IF(NOG.GT.0)GAMMA=GAMMA+OPR(K)*AC(I-K+1)
   10 CONTINUE
      QU=-BETA/ALP
      ALPB=AC(1)+AC(I)*QU
      WIN(I)=QU
      DO 20    K=2,KK
      WIN(K)=WIN(K)+BB(I+1-K)*QU
      ALPB=ALPB+WIN(K)*AC(K)
   20 CONTINUE
      IF(ALPB.GT.0.0) GO TO 30
      IF(NITER.GT.5) GO TO 25
      NITER=NITER+1
      AC(1)=1.005*AC(1)
      GO TO 3
   30 CONTINUE
      ALP=ALPB
      IF(NOG.EQ.0) GO TO 50
      SCAL=(GG(I)-GAMMA)/ALP
      OPR(I)=0.0
      DO 40    K=1,I
      OPR(K)=OPR(K)+SCAL*WIN(I+1-K)
   40 CONTINUE
   50 CONTINUE
      RETURN
   25 CONTINUE
      NOP=I
      RETURN
      END
      SUBROUTINE EXPSCL(WIN,NIN,WOT,DR)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       EXPSCL
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE: Exponential scaling of an input array.
C  CALLING PARAMETERS:  CALL EXPSCL (WIN, NIN, WOT, DR)
C  ARGUMENTS:
C      Name                  Length   Description
C      WIN  R*4  I  ( 1 )    NIN      Input array containing data.
C      NIN  I*4  I           1        Length of WIN.
C      WOT  R*4  O  ( 1 )    NIN      Scaled data.
C      DR   R*4  I           1        Decay ratio.
C  CATEGORY:  UTILITY
C  KEYWORDS:  EXPONENTIAL SCALING
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION: The input data is scaled sample by sample.
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF THE SUBROUTINE:  NONE
C  ERROR MESSAGES: NONE
C  NOTE:  Input and output array can be the same.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WIN(1),WOT(1)
      SC=1.0
      DO 10    I=1,NIN
      WOT(I)=SC*WIN(I)
      SC=SC*DR
   10 CONTINUE
      RETURN
      END
      SUBROUTINE MINVER(WIN,NIN,WAV,NAV)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       MINVER
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      Compute the inverse of a given minimum-phase wavelet by
C      synthetic division.
C  CALLING PARAMETERS:    CALL MINVER (WIN, NIN, WAV, NAV)
C  ARGUMENTS:
C      Name                  Length  Description
C      WIN  R*4  I  ( 1 )    NIN     Minimum-phase input wavelet.
C      NIN  I*4  I           1       Length of input wavelet.
C      WAV  R*4  O  ( 1 )    NAV     Output array.
C      NAV  I*4  I           1       Length of the inverse (output)
C                                    wavelet to be computed.
C  CATEGORY:  UTILITY
C  KEYWORDS:  WAVELET PHASE INVERSE
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/05/04
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  Synthetic division is performed as term by term
C                        recursive computation.
C  SUBROUTINES USED:  NONE
C  AUXILIARY STORAGE:  NONE
C  ERROR HANDLING:  Subroutine does not have any error checking proced-
C                   ure.  Since the output is generated by synthetic
C                   division by a recursive algorithm, it may not al-
C                   ways be stable.  Stability is expected only if out-
C                   put wavelet is minimum-phase.  For maximum-phase
C                   wavelets, user should reverse the wavelet before
C                   calling the subroutine.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION WIN(1),WAV(1)
      WAV(1)=1./WIN(1)
      DO 30    I=2,NAV
      SM=0.0
      DO 10    K=2,I
      IF(K.GT.NIN) GO TO 20
      SM=SM+WIN(K)*WAV(I+1-K)
   10 CONTINUE
   20 WAV(I)=-SM/WIN(1)
   30 CONTINUE
      RETURN
      END
      SUBROUTINE TAPER(AA,NAA,IHP,NN)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       TAPER
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE: This routine applies a Butterworth-type taper to the data.
C  CALLING PARAMETERS:  CALL TAPER (AA, NAA, IHP, NN)
C  ARGUMENTS:
C      Name                 Length  Description
C      AA   R*4  I  ( 1 )   NAA     Data array to be tapered.
C      NAA  I*4  I          1       Length of AA.
C      IHP  I*4  I          1       Half-power point of the taper.
C      NN   I*4  I          1       Exponential constant to control
C                                   the steepness of taper function
C                                   (usually between 10 and 20).
C      AA   R*4  O  ( 1 )   NAA     Returned tapered data.
C  CATEGORY:  UTILITY
C  KEYWORDS:  BUTTERWORTH TAPER
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION: Steepness of taper is controlled by the exponent
C                       NN. The taper function is continuous; therefore,
C                       it does not have an adverse effect in the fre-
C                       quency domain or on Wiener-Levinson algorithm.
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF THE SUBROUTINE:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION AA(1)
C         TAPER APPLICATION, BUTTERWORTH TYPE.
      SCP=IHP
      BB=1.0
      DO 10    I=2,NAA
      SCA=1./(1.0+(BB/SCP)**NN)
      AA(I)=SCA*AA(I)
      BB=BB+1.0
   10 CONTINUE
      RETURN
      END
      SUBROUTINE WAVEST (AC,NAC,WAV,NWAV,DR,WIN,BOB)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       WAVEST
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      Subroutine estimates a causal wavelet corresponding to a given
C      autocorrelation function.
C  CALLING PARAMETERS:  CALL WAVEST (AC,NAC,WAV,NWAV,DR,WIN,BOB)
C  ARGUMENTS:
C      Name                   Length   Description
C      AC    R*4  I  ( 1 )    NAC      Autocorrelation array.
C                                      AC(1) is the zero lag.
C      NAC   I*4  I           1        Length of AC.
C      WAV   R*4  O  ( 1 )    NWAV     Array containing the esti-
C                                      mated wavelet (one-sided-
C                                      causal).
C      NWAV  I*4  I           1        Length of wavelet to be
C                                      estimated.
C      DR    R*4  I           1        Decay ratio (usually less
C                                      than 1.0). Exponential decay
C                                      applied to the data before
C                                      autocorrelation function is
C                                      computed. This ratio is used
C                                      to scale minimum phase wavelet.
C      WIN   R*4  I  ( 1 )    NWAV     Work buffer.
C      BOB   R*4  I  ( 1 )    NWAV     Work buffer.
C  CATEGORY:  UTILITY
C  KEYWORDS:  WAVELET ESTIMATION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/27
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |                 EXTERNAL ENVIRONMENT                 |
C       +------------------------------------------------------+
C  ROUTINES CALLED:
C      WIENER   -       Wiener-Levinson algorithm for minimum-phase
C                       inverse computation.
C      MINVER   -       Inverse of minimum-phase wavelet computation.
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:
C  Given the autocorrelation function, subroutine calls WIENER subrou-
C  tine which returns in WIN(I) array minimum-phase inverse of a mini-
C  mum-phase wavelet whose autocorrelation is the AC(I) function. WIN(I)
C  array is inserted to subroutine MINVER to compute its inverse by syn-
C  thetic division.  MINVER returns the minimum-phase wavelet (NWAV num-
C  ber of points) in WAV(I) array. AC(I) autocorrelation function is the
C  autocorrelation function of WAV(I) wavelet.
C  ADDITIONAL INTERNAL STORAGE USED:  NONE
C  LIMITATIONS OF THE SUBROUTINE:  NONE
C  ERROR HANDLING:  If autocorrelation is unstable, WIENER will not com-
C                   plete the inverse computation.  Then subroutine will
C                   return a negative NWAV.
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION AC(1),WAV(1),WIN(1),BOB(1)
      NOG = 0
      NN=NAC
      CALL WIENEx(AC,AC,NOG,WIN,WAV,NN,BOB)
cmam  CALL WIENER(AC,AC,NOG,WIN,WAV,NN,BOB)
      IF (NN.EQ.NAC) GO TO 5
      NWAV=-NWAV
      RETURN
    5 CONTINUE
      CALL MINVER(WIN,NAC,WAV,NWAV)
      SCA = 1.0/DR
      DO 10    I=2,NWAV
      WAV(I)=WAV(I)*SCA
      SCA=SCA/DR
   10 CONTINUE
      RETURN
      END
      SUBROUTINE WIENEx(AC,GG,NOG,WIN,OPR,NOP,BB)
cmam  SUBROUTINE WIENER(AC,GG,NOG,WIN,OPR,NOP,BB)
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C                                                                      *
C***********************************************************************
C  ROUTINE:       WIENER
C  ROUTINE TYPE:  SUBROUTINE  (SINGLE-ENTRY)
C  PURPOSE:
C      To solve a set of Toeplitz-type linear equations using the
C      Wiener-Levinson algorithm.
C  CALLING PARAMETERS:  CALL WIENER(AC,GG,NOG,WIN,OPR,NOP,BB)
C  ARGUMENTS:
C      Name                    Length   Description
C      AC   R*4  I  ( 1 )      NOP      Input autocorrelation function.
C      GG   R*4  I  ( 1 )      NOP      R.H.S. of the equations.
C                                         Not used if NOG=0.
C      NOG  I*4  I             1        Flag indicates type.
C                                         0 - Case I, 1 - Case II
C      WIN  R*4  O  ( 1 )      NOP      Unit-step prediction error oper-
C                                       ator for both cases.
C      OPR  R*4  O  ( 1 )      NOP      Computed solutions used only if
C                                       NOP=1.
C      NOP  I*4  I             1        Length of AC, GG, WIN, OPR, BB.
C      BB   R*4  I  ( 1 )      NOP      Work buffer.
C  CATEGORY:  UTILITY
C  KEYWORDS:  WEINER PREDICTION
C       +------------------------------------------------------+
C       |               DEVELOPMENT INFORMATION                |
C       +------------------------------------------------------+
C  AUTHOR:    M. TURHAN TANER                  ORIGIN DATE:  81/04/30
C  LANGUAGE:  FORTRAN IV
C       +------------------------------------------------------+
C       |             OTHER DOCUMENTATION DETAILS              |
C       +------------------------------------------------------+
C  GENERAL DESCRIPTION:  This routine solves two types of equations:
C                        (I) only first element of R.H.S. vector is non-
C                            zero.
C                       (II) at least two elements of R.H.S. vector are
C                            non-zeros.
C                        The subroutine multiplies AC(1) by 1.005 and
C                        reiterates if unstable and negative parameters
C                        are encountered.  It sets the first element of
C                        the output array to zero and gives up after
C                        five trials.
C  EXTERNAL REFERENCES:  NONE
C  ADDITIONAL STORAGE USED:  NONE
C  LIMITATIONS OF SUBROUTINE:  NONE
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      DIMENSION AC(1),GG(1),WIN(1),OPR(1),BB(1)
      WIN(1)=1.0
      BB(1)=1.0
      NITER=0
    3 CONTINUE
      WIN(2)=-AC(2)/AC(1)
      BB(2)=WIN(2)
      ALP=AC(1)-AC(2)*AC(2)/AC(1)
      IF(NOG.EQ.0) GO TO 5
      DENOM=AC(1)*AC(1)-AC(2)*AC(2)
      OPR(1)=(GG(1)*AC(1)-GG(2)*AC(2))/DENOM
      OPR(2)=(GG(2)*AC(1)-GG(1)*AC(2))/DENOM
    5 CONTINUE
      DO 50    I=3,NOP
      BETA=AC(I)
      KK=I-1
      IF(NOG.GT.0)GAMMA=AC(I)*OPR(1)
      DO 10    K=2,KK
      BETA=BETA+AC(I-K+1)*WIN(K)
      BB(K)=WIN(K)
      IF(NOG.GT.0)GAMMA=GAMMA+OPR(K)*AC(I-K+1)
   10 CONTINUE
      QU=-BETA/ALP
      ALPB=AC(1)+AC(I)*QU
      WIN(I)=QU
      DO 20    K=2,KK
      WIN(K)=WIN(K)+BB(I+1-K)*QU
      ALPB=ALPB+WIN(K)*AC(K)
   20 CONTINUE
      IF(ALPB.GT.0.0) GO TO 30
      IF(NITER.GT.5) GO TO 25
      NITER=NITER+1
      AC(1)=1.005*AC(1)
      GO TO 3
   30 CONTINUE
      ALP=ALPB
      IF(NOG.EQ.0) GO TO 50
      SCAL=(GG(I)-GAMMA)/ALP
      OPR(I)=0.0
      DO 40    K=1,I
      OPR(K)=OPR(K)+SCAL*WIN(I+1-K)
   40 CONTINUE
   50 CONTINUE
      RETURN
   25 CONTINUE
      NOP=I
      RETURN
      END
c...............................................................................
      subroutine help1
#include <f77/iounit.h>
 
          write(LER,*)
     :'***************************************************************'
         write(LER,*)'PROGRAM wesh......Wavelet Estimation & Shaping'
         write(LER,*)'...................on Common Source Records'
         write(LER,*)' '
         write(LER,*)'   wesh allows parameters to be input via a named'
         write(LER,*)'   card image file, by command line arguments, or'
         write(LER,*)'   a combination of both.  If a parameter is'
         write(LER,*)'   input on the command line, and a card image'
         write(LER,*)'   file is also specified, the command line'
         write(LER,*)'   argument takes precedence.  This allows the'
         write(LER,*)'   user to utilize a standard setup file, but'
         write(LER,*)'   override a few parameters with the command'
         write(LER,*)'   line arguments.'
         write(LER,*)' '
         write(LER,*)
     :' -N[ntap]   (default: pipe in)   : Input data file name'
         write(LER,*)
     :' -O[otap]   (default: pipe out)  : Output data file name'
         write(LER,*)
     :' -C[cardin] (not required)       : Card data file name'
         write(LER,*)
     :'   the file cardin must contain these card images:'
         write(LER,*)
     :'    1WESH : required'
         write(LER,*)
     :'    2WESH : required'
         write(LER,*)
     :' -lwv[lengwv] (default: 200)   : wavelet length in ms'
         write(LER,*)
     :' -scl[rscal]  (default: .98)   : exponential scaling factor'
         write(LER,*)
     :' -lfr[nflow]  (default: 0 or nyquist): lower cutoff frequency',
     :'             in HZ of output Butterworth wavelet'
         write(LER,*)
     :' -ldb[nrlow]  (default: 24)    : cutoff rate in dB/oct at',
     :'             lower cutoff frequency of output Butterworth',
     :' wavelet'
         write(LER,*)
     :' -hfr[nfhigh] (default: 0 or nyquist): upper cutoff frequency',
     :'             in HZ of output Butterworth wavelet'
         write(LER,*)
     :' -hdb[nrlow]  (default: 24)    : cutoff rate in dB/oct at',
     :'             upper cutoff frequency of output Butterworth',
     :' wavelet'
         write(LER,*)
     :' -st1[ntime1] (default: 0)     : start time in ms (at near',
     :'             range limit) of first data window for computing',
     :'             autocorrelations'
         write(LER,*)
     :' -lwn[ntleng] (default: 1000)  : window length in ms of data',
     :'             windows for computing autocorrelations'
         write(LER,*)
     :' -sti[nstinc] (default: 200)   : start time increment in ms',
     :'             of data windows for computing autocorrelations'
         write(LER,*)
     :' -nw[nwndws]  (default: 3)     : number of successive data',
     :'             windows for computing autocorrelations'
         write(LER,*)
     :' -vel[velwnd] (default: 99.99) : velocity in ft/ms or m/ms',
     :'             to adjust start time of design window'
         write(LER,*)
     :' -nr[nrang1]  (default: 0)     : near range limit in feet',
     :'             for computing autocorrelations'
         write(LER,*)
     :' -fr[nrang2]  (default: 999999): far range limit in feet',
     :'             for computing autocorrelations'
c        write(LER,*)
c    :' -ph[iphase]  (default: minimum): phase of output Butterworth',
c    :'             wavelet (0 or blank=minimum phase, 1=zero phase)'
         write(LER,*)
     :' -Z (default: no zero phase, use minimum): phase of output',
     :'                Butterworth wavelet'
       write(LER,*)
     :'Usage:  ',
     :' wesh -N[ntap] -O[otap] -C[cardin]'
       write(LER,*)
     :'***************************************************************'
      return
      end
