C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine process(tracebuf,uin,uquad,
     1     wbuf,uout,nbytes_out,nbytes_out_aug,
     2     lenhed,nt,nfft,live,lenuout,maxtracebuf,
     3     pipelen,calc,lunit,luout,wrout,
     4     nstream,nsi,in_ss,in_se,horizons,uh,lh,uw,lw,
     5     ifmt_uh,l_uh,ln_uh,ifmt_lh,l_lh,ln_lh,
     6     tstart_orig,nsamp_in,null_value,
     7     lower_threshold, upper_threshold, lerr,cputim,waltim)

      implicit none
c
#include <save_defs.h>
c
      integer  lenhed, nt, nfft, nsi, nsamp_in
      integer  lenuout, maxtracebuf
      integer  ifmt_uh,l_uh,ln_uh,ifmt_lh,l_lh,ln_lh
      integer nbytes_out, nbytes_out_aug, lerr

      real     tracebuf(-lenhed:maxtracebuf)
      real     uin(0:nfft-1)
      real     uquad(0:nfft-1)
      real     wbuf(0:nfft-1)
      real     uout(0:lenuout-1)
      real     tstart_orig
      real     tmin, sr
      real     lower_threshold, upper_threshold
c
      integer  pipelen, luout, nstream
      integer  lunit(pipelen)
      logical  calc(pipelen), wrout(pipelen)
      logical live

      integer  ss, se, in_ss, in_se
      real uw, lw
      real r_ss, r_se
      integer i_ss, i_se
      logical  horizons
      character*(*) uh, lh

      real     r, null_value
      logical  null
      integer  reduction

c Function definitions from reduce.F
      real     avgsmp, avgabs, peak, trough, avgpos, avgneg,
     1     avgphs, phs180, phsmag, avgdif, totdif, energy,
     2     peakt, trought, peakp, troughp, parab, avg180,
     3     abssum, adecay, ptr, ptrpos, stddev, stdpos,
     4     stdneg, stdabs, medval, medpos, medneg, medabs,
     5     maxabs, maxabst, numsbt

      external avgsmp, avgabs, peak, trough, avgpos, avgneg,
     1     avgphs, phs180, phsmag, avgdif, totdif, energy,
     2     peakt, trought, peakp, troughp, parab, avg180,
     3     abssum, adecay, ptr, ptrpos, stddev, stdpos,
     4     stdneg, stdabs, medval, medpos, medneg, medabs,
     5     maxabs, maxabst, numsbt

c Grab the declarations for the process identifiers
#include "initproc.h"

      real     cputim(*),waltim(*)

c_______________________________________________________________
c     If the user has specified upper and lower header words,
c     reset the start and end samples.
c_______________________________________________________________
      ss = in_ss
      se = in_se
      null = .FALSE.

      if (horizons) then
         if (uh .ne. '*NONE*') then
c           Check to see if the header word is 4-byte float or 2-byte int
            if (ifmt_uh .eq. SAVE_FLOAT_DEF .or.
     1          ifmt_uh .eq. SAVE_FKFLT_DEF) then
               call saver2(tracebuf(-lenhed), ifmt_uh, l_uh, ln_uh,
     1                     r_ss, TRACEHEADER)
            else
               call saver2(tracebuf(-lenhed), ifmt_uh, l_uh, ln_uh,
     1                     i_ss, TRACEHEADER)
               r_ss = real(i_ss)
            endif
            if (r_ss .ne. null_value) then
               ss = int(0.5 + (r_ss - tstart_orig)/real(nsi)) +
     :              nint(uw/float(nsi))
               if (ss .le. 0) ss = 0
            else
               null = .TRUE.
            endif
         endif
         if (lh .ne. '*NONE*') then
c           Check to see if the header word is 4-byte float or 2-byte int
            if (ifmt_lh .eq. SAVE_FLOAT_DEF .or.
     1          ifmt_lh .eq. SAVE_FKFLT_DEF) then
               call saver2(tracebuf(-lenhed), ifmt_lh, l_lh, ln_lh,
     1                     r_se, TRACEHEADER)
            else
               call saver2(tracebuf(-lenhed), ifmt_lh, l_lh, ln_lh,
     1                     i_se, TRACEHEADER)
               r_se = real(i_se)
            endif
            if (r_se .ne. null_value) then
               se = int(0.5 + (r_se - tstart_orig)/real(nsi)) + 
     :              nint( lw / float(nsi) )
               if (se .gt. (nsamp_in-1)) se = nsamp_in - 1
            else
               null = .TRUE.
            endif
         endif
      endif

c     If the top and bottom are backwards, we assume that they crossed.
      if (se .lt. ss) then
         se = ss
         null = .TRUE.
      endif

c_______________________________________________________________
c Reduction calculations
c_______________________________________________________________
      reduction = 0

      if (calc(pmava)) then
         if (null) then
            r = null_value
         else
            r = avgsmp(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmava)) then
            tracebuf(0) = r
            call wrtape(lunit(pmava),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmaaa)) then
         if (null) then
            r = null_value
         else
            r = avgabs(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmaaa)) then
            tracebuf(0) = r
            call wrtape(lunit(pmaaa),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmlpv)) then
         if (null) then
            r = null_value
         else
            r = peak(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmlpv)) then
            tracebuf(0) = r
            call wrtape(lunit(pmlpv),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmlnv)) then
         if (null) then
            r = null_value
         else
            r = trough(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmlnv)) then
            tracebuf(0) = r
            call wrtape(lunit(pmlnv),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmapv)) then
         if (null) then
            r = null_value
         else
            r = avgpos(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmapv)) then
            tracebuf(0) = r
            call wrtape(lunit(pmapv),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmanv)) then
         if (null) then
            r = null_value
         else
            r = avgneg(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmanv)) then
            tracebuf(0) = r
            call wrtape(lunit(pmanv),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pma36)) then
         if (null) then
            r = null_value
         else
            r = avgphs(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pma36)) then
            tracebuf(0) = r
            call wrtape(lunit(pma36),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pma18)) then
         if (null) then
            r = null_value
         else
            r = phs180(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pma18)) then
            tracebuf(0) = r
            call wrtape(lunit(pma18),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmpmg)) then
         if (null) then
            r = null_value
         else
            r = phsmag(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmpmg)) then
            tracebuf(0) = r
            call wrtape(lunit(pmpmg),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmaad)) then
         if (null) then
            r = null_value
         else
            r = avgdif(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmaad)) then
            tracebuf(0) = r
            call wrtape(lunit(pmaad),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmsad)) then
         if (null) then
            r = null_value
         else
            r = totdif(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmsad)) then
            tracebuf(0) = r
            call wrtape(lunit(pmsad),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmess)) then
         if (null) then
            r = null_value
         else
            r = energy(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmess)) then
            tracebuf(0) = r
            call wrtape(lunit(pmess),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmtlp)) then
         if (null) then
            r = null_value
         else
            tmin = 0.
            sr = nsi
            r = peakt(uin, 0, nfft-1, ss, se, tmin, sr, 0.)
         endif
         if (wrout(pmtlp)) then
            tracebuf(0) = r
            call wrtape(lunit(pmtlp),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmtln)) then
         if (null) then
            r = null_value
         else
            tmin = 0.
            sr = nsi
            r = trought(uin, 0, nfft-1, ss, se, tmin, sr, 0.)
         endif
         if (wrout(pmtln)) then
            tracebuf(0) = r
            call wrtape(lunit(pmtln),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmp12)) then
         if (null) then
            r = null_value
         else
            tmin = 0.
            sr = nsi
            r = peakp(uin, 0, nfft-1, ss, se, tmin, sr, 0.)
         endif
         if (wrout(pmp12)) then
            tracebuf(0) = r
            call wrtape(lunit(pmp12),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmp13)) then
         if (null) then
            r = null_value
         else
            tmin = 0.
            sr = nsi
            r = troughp(uin, 0, nfft-1, ss, se, tmin, sr, 0.)
         endif
         if (wrout(pmp13)) then
            tracebuf(0) = r
            call wrtape(lunit(pmp13),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmsav)) then
         if (null) then
            r = null_value
         else
            r = abssum(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmsav)) then
            tracebuf(0) = r
            call wrtape(lunit(pmsav),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmdav)) then
         if (null) then
            r = null_value
         else
            r = adecay(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmdav)) then
            tracebuf(0) = r
            call wrtape(lunit(pmdav),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmlad)) then
         if (null) then
            r = null_value
         else
            r = ptr(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmlad)) then
            tracebuf(0) = r
            call wrtape(lunit(pmlad),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmltd)) then
         if (null) then
            r = null_value
         else
c        ptrpos returns the number of samples between the max
c        peak and min trough.  Multiply by sample interval to
c        get the time difference.
            r = nsi * ptrpos(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmltd)) then
            tracebuf(0) = r
            call wrtape(lunit(pmltd),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmstd)) then
         if (null) then
            r = null_value
         else
            r = stddev(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmstd)) then
            tracebuf(0) = r
            call wrtape(lunit(pmstd),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmsdp)) then
         if (null) then
            r = null_value
         else
            r = stdpos(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmsdp)) then
            tracebuf(0) = r
            call wrtape(lunit(pmsdp),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmsdn)) then
         if (null) then
            r = null_value
         else
            r = stdneg(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmsdn)) then
            tracebuf(0) = r
            call wrtape(lunit(pmsdn),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmsda)) then
         if (null) then
            r = null_value
         else
            r = stdabs(uin, 0, nfft-1, ss, se, 0.)
         endif
         if (wrout(pmsda)) then
            tracebuf(0) = r
            call wrtape(lunit(pmsda),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmmed)) then
         if (null) then
            r = null_value
         else
            r = medval(uin, 0, nfft-1, ss, se, wbuf)
         endif
         if (wrout(pmmed)) then
            tracebuf(0) = r
            call wrtape(lunit(pmmed),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmmdp)) then
         if (null) then
            r = null_value
         else
            r = medpos(uin, 0, nfft-1, ss, se, wbuf)
         endif
         if (wrout(pmmdp)) then
            tracebuf(0) = r
            call wrtape(lunit(pmmdp),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmmdn)) then
         if (null) then
            r = null_value
         else
            r = medneg(uin, 0, nfft-1, ss, se, wbuf)
         endif
         if (wrout(pmmdn)) then
            tracebuf(0) = r
            call wrtape(lunit(pmmdn),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

      if (calc(pmmda)) then
         if (null) then
            r = null_value
         else
            r = medabs(uin, 0, nfft-1, ss, se, wbuf)
         endif
         if (wrout(pmmda)) then
            tracebuf(0) = r
            call wrtape(lunit(pmmda),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

c max of abs values
      if (calc(pmmaa)) then
         if (null) then
            r = null_value
         else
            r = maxabs(uin, 0, nfft-1, ss, se )
         endif
         if (wrout(pmmaa)) then
            tracebuf(0) = r
            call wrtape(lunit(pmmaa),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

c time of max abs value
      if (calc(pmtma)) then
         if (null) then
            r = null_value
         else
            tmin = 0.
            sr = nsi
            r = maxabst(uin, 0, nfft-1, ss, se, tmin, sr, 0.)
         endif
         if (wrout(pmtma)) then
            tracebuf(0) = r
            call wrtape(lunit(pmtma),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

c number of samples between thresholds
      if (calc(pmnbt)) then
         if (null) then
            r = null_value
         else
            r = numsbt(uin, 0, nfft-1, ss, se, lower_threshold, 
     :           upper_threshold )
         endif
         if (wrout(pmnbt)) then
            tracebuf(0) = r
            call wrtape(lunit(pmnbt),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

c     Simple copy of upper horizon.
      if (calc(pmcph)) then
         r = uin(ss)
         if (wrout(pmcph)) then
            tracebuf(0) = r
            call wrtape(lunit(pmcph),tracebuf(-lenhed),nbytes_out)
         else
            uout(reduction) = r
            reduction = reduction + 1
         endif
      endif

c     Do we need to write out the multi-reduction file?
      if (nstream .gt. 0) then
         call vmov(uout(0), 1, tracebuf(0), 1, reduction)
         call wrtape(luout,tracebuf(-lenhed),nbytes_out_aug)
      endif

      return
      end
