C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
cirflg 0 (AVA - Average)
      real function avgsmp(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgsmp = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = arr(k) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avgsmp = sum/n
cc    write(0,*) 'avgsmp:', avgsmp
      return
      end

cirflg 1 (AAA - Average of absolute values)
      real function avgabs(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgabs = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = abs(arr(k)) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avgabs = sum/n
cc    write(0,*) 'avgabs: ',avgabs,minsmp,maxsmp,minwin,maxwin
      return
      end

cirflg 2 (LPV - Largest postiive (> 0) value)
      real function peak(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      p = arr(minwin)
      n = 1
      do k = minwin,maxwin
         p = max(p,arr(k))
         n = n + 1
      enddo
      if (p .le. 0.0) then
          peak = rnul
      else
          peak = p
      endif 
cc    write(0,*) 'peak:', p, peak
      return
      end

cirflg 3 (LNV - Largest negative (< 0) value)
      real function trough(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      trough = arr(minwin)
      do k = min(minwin,maxwin), max(minwin,maxwin)
         trough = min(trough,arr(k))
      enddo
      if (trough .ge. 0.0) then
          trough = rnul
      else
          trough = abs(trough)
      endif
cc    write(0,*) 'trough:', trough
      return
      end

cirflg 4 (APV - Average of positive (> 0) values)
      real function avgpos(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgpos = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         if (arr(k) .gt. 0.0) then
             sum = sum + arr(k)
             n = n + 1
         endif
      enddo
      if (n .gt. 0) avgpos = sum/n
cc    write(0,*) 'avgpos:', avgpos
      return
      end

cirflg 5 (ANV - Average of negative (< 0) values)
      real function avgneg(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgneg = rnul
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         if (arr(k) .lt. 0.0) then
             sum = sum + arr(k)
             n = n + 1
         endif
      enddo
      if (n .gt. 0) avgneg = abs(sum/n)
cc    write(0,*) 'avgneg:', avgneg
      return
      end 

cirflg 6 (A36 - Angle of phase vector sum; +360 if negative)
      real function avgphs(phase,minsmp,maxsmp,minwin,maxwin,rnul)
      real phase(minsmp:maxsmp)
      double precision sx, sy, d2r
      parameter (d2r=0.017453293,phi=0.01)
      avgphs = rnul
      sx = 0.0
      sy = 0.0
      do i = minwin, maxwin, isign(1,maxwin-minwin)
         theta = phase(i)*d2r
         sx = sx + cos(theta)
         sy = sy + sin(theta)
      enddo
      if (sqrt(sx*sx+sy*sy) .gt. phi) then
          avgphs = atan2(sy,sx)/d2r
          if (avgphs .lt. 0.0) then
              avgphs = avgphs + 360.0
          endif
      endif
cc    write(0,*) 'avgphs:', avgphs
      return
      end 

cirflg 7 (A18 - Angle of phase vector sum; +180)
      real function phs180(phase,minsmp,maxsmp,minwin,maxwin,rnul)
      real phase(minsmp:maxsmp)
      double precision sx, sy, d2r
      parameter (d2r=0.017453293,phi=0.01)
      phs180 = rnul
      sx = 0.0
      sy = 0.0
      do i = minwin, maxwin, isign(1,maxwin-minwin)
         theta = phase(i)*d2r
         sx = sx + cos(theta)
         sy = sy + sin(theta)
      enddo
      if (sqrt(sx*sx+sy*sy) .gt. phi) then
          phs180 = 180.0 + atan2(sy,sx)/d2r
      endif
cc    write(0,*) 'phs180:', phs180
      return
      end 

cirflg 8 (PM - Phase magnitude)
      real function phsmag(phase,minsmp,maxsmp,minwin,maxwin,rnul)
      real phase(minsmp:maxsmp)
      double precision sx, sy, d2r
      parameter (d2r=0.017453293,phi=1.0E-6)
      phsmag = rnul
      sx = 0.0
      sy = 0.0
      do i = minwin, maxwin, isign(1,maxwin-minwin)
         theta = phase(i)*d2r
         sx = sx + cos(theta)
         sy = sy + sin(theta)
      enddo
      phsmag = sqrt(sx*sx+sy*sy)
      if (phsmag .le. phi) phsmag = rnul 
cc    write(0,*) 'phsmag:', phsmag
      return
      end 

cirflg 9 (AAD - Average of absolute sample to sample difference)
      real function avgdif(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avgdif = 0
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin) - 1
         sum = abs(arr(k+1) - arr(k)) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avgdif = sum/n
cc    write(0,*) 'avgdif:', avgdif
      return
      end

cirflg 10 (SAD - Sum of absolute sample to sample difference)
      real function totdif(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      totdif = 0
      sum = 0.0D0
      do k = min(minwin,maxwin), max(minwin,maxwin) - 1
         sum = abs(arr(k+1) - arr(k)) + sum
      enddo
      totdif = sum
cc    write(0,*) 'totdif:', totdif
      return
      end

cirflg 11 (ESS - Energy, sum of sample*sample)
      real function energy(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      energy = 0
      sum = 0.0D0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = arr(k)*arr(k) + sum
      enddo
      energy = sum
cc    write(0,*) 'energy:', energy
      return
      end

cirflg 12 (TLP - Time of largest positive (> 0) value)
      real function peakt(arr,minsmp,maxsmp,minwin,maxwin,
     1                    tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      data nent /0/
      nent = nent+1
cc    write(0,*) 'peakt:',nent,minsmp,maxsmp,minwin,maxwin,tmin,sr
      peakt = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
cc       write(0,*) 'i,t,arr(i):', i, (i-1)*sr, arr(i)
         if (arr(i) .gt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .gt. 0.0) then
c          peakt = tmin + (ip-1)*sr
c fixed this July 5 2000....was finding max peak one sample off
c Garossino
          peakt = tmin + (ip)*sr
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. max(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) peakt = peakt + x*sr
              endif
          endif
      endif
cc    write(0,*) 'ip,peakt,tmin,sr:', ip,peakt,tmin,sr
cc    write(0,*) ' '
      return
      end

cirflg 13 (TLN - Time of largest negative (< 0) value)
      real function trought(arr,minsmp,maxsmp,minwin,maxwin,
     1                      tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      trought = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
         if (arr(i) .lt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .lt. 0.0) then
c          trought = tmin + (ip-1)*sr
c fixed this logic...was off a sample
c Garossino July 5 2000
          trought = tmin + (ip)*sr
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. min(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) trought = trought + x*sr
              endif
          endif
      endif
cc    write(0,*) 'trought:', trought
      return
      end

cirflg 14 (12 with parabola fit)
      real function peakp(arr,minsmp,maxsmp,minwin,maxwin,
     1                    tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      peakp = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
         if (arr(i) .gt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .gt. 0.0) then
          peakp = arr(ip)
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. max(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) peakp = y
              endif
          endif
      endif
cc    write(0,*) 'peakp:', peakp
      return
      end

cirflg 15 (13 with parabola fit)
      real function troughp(arr,minsmp,maxsmp,minwin,maxwin,
     1                      tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      troughp = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
         if (arr(i) .lt. arr(ip)) then
             ip = i
         elseif (arr(i) .eq. arr(ip)) then
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (arr(ip) .lt. 0.0) then
          troughp = arr(ip)
          if (ip .gt. is .and. ip .lt. ie) then
              if (arr(ip) .eq. min(arr(ip-1),arr(ip),arr(ip+1))) then
                  call parab(arr(ip-1),arr(ip),arr(ip+1),x,y)
                  if (abs(x) .lt. 1.0) troughp = y
              endif
          endif
      endif
      if (troughp .ne. rnul) troughp = -troughp
cc    write(0,*) 'rnul,troughp:', rnul,troughp
      return
      end

      subroutine parab(c1,c2,c3,x,y)
      a=0.5*(c1+c3-2.0*c2)
      b=0.5*(c3-c1)
      c=c2
      x=-b/(2.0*a)
      y=a*x**2+b*x+c
      return
      end

cirflg 15 (unused)
      real function avg180(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      avg180 = 0.0
      sum = 0.0D0
      n = 0
      do k = min(minwin,maxwin), max(minwin,maxwin)
         sum = arr(k) + sum
         n = n + 1
      enddo
      if (n .ne. 0) avg180 = sum/n + 180.0
cc    write(0,*) 'avg180:', avg180
      return
      end

cirflg 16 (SAV - Sum of absolute values)
      real function abssum(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision sum
      sum = 0.0D0
      abssum = rnul
      n = 0
      do k = minwin, maxwin, isign(1,maxwin-minwin)
         sum = abs(arr(k)) + sum
         n = n + 1
      enddo
      if (n .gt. 0) then
          abssum = sum
      endif
cc    write(0,*) 'abssum:', abssum
      return
      end

cirflg 17 (DAV - Decay of absolute values)
      real function adecay(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      double precision asum, hsum
      adecay = rnul
      ks = min(minwin,maxwin)
      ke = max(minwin,maxwin)
      asum = 0.0D0
      hsum = 0.0D0
      na = 0
      nh = 0
      do k = ks, ke
c        write(0,*) k, arr(k)
         asum = abs(arr(k)) + asum
         na = na + 1
      enddo
      if (na .gt. 0) then
          do k = ks, ke
             hsum = abs(arr(k)) + hsum
             nh = nh + 1
             if (2*hsum .ge. asum) then
                 adecay = real(nh)/real(na) * 100.0
                 goto 1
             endif
          enddo
      endif
1     continue
c     write(0,*) 'adecay,na,nh,asum,hsum,ks,ke:',
c    $adecay,na,nh,asum,hsum,ks,ke
      return
      end             

cirflg 18
C      function ctrans(arr,minsmp,maxsmp,minwin,maxwin,rnul)
C      real arr(minsmp:maxsmp)
C      ctrans = 0.0
C      is = min(minwin,maxwin)
C      ie = max(minwin,maxwin)
C      snow = arr(is)
C      do i = is, ie
C         slast = snow
C         snow = arr(i)
C         if (snow .ne. slast) then
C             if (snow .ne. 0.0) then
C                 ctrans = ctrans + 1.0
C             endif
C         endif
C      enddo
C      ctrans = ctrans/(ie-is+1)
Cc     write(0,*) 'ctrans:', ctrans
C      return
C      end
C
Ccirflg 19
C      function tfsrng(arr,minsmp,maxsmp,minwin,maxwin,tmin,sr,smin,
C     $                  smax,rnul)
C      real arr(minsmp:maxsmp)
C      tfsrng = rnul
C      is = min(minwin,maxwin)
C      ie = max(minwin,maxwin)
C      ss = min(smin,smax)
C      se = max(smin,smax)
C      ip = is
C      do i = is, ie
C  s = arr(i)
C         if (s .ge. ss .and. s .le. se) then
C             tfsrng = tmin + (i-1)*sr
Cccc          write(0,*) 'tfsrng:', tfsrng
C             return
C         endif
C      enddo
Cccc   write(0,*) 'tfsrng: rnul'
C      return
C      end

cirflg 18 (LAD - Largest peak/trough amplitude difference)
      real function ptr(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      ptr = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      peak = arr(is)
      trough = arr(is)
      do ip = is, ie
         peak = max(peak,arr(ip))
         trough = min(trough,arr(ip))
      enddo
      ptr = peak + trough
      return
      end

cirflg 19 (LTD - Largest peak/trough time difference)
      real function ptrpos(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      real arr(minsmp:maxsmp)
      integer peakpos, troughpos
      ptr = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)

      peak = arr(is)
      peakpos = is
      trough = arr(is)
      troughpos = is

      do ip = is+1, ie
         if (arr(ip) .gt. peak) then
            peak = arr(ip)
            peakpos = ip
         endif
         if (arr(ip) .lt. trough) then
            trough = arr(ip)
            troughpos = ip
         endif
      enddo
c     If the peak position is at a higher time than the troughpos,
c     ptrpos will be positive.  Otherwise, it will be negative.
      ptrpos = peakpos - troughpos
      return
      end

cirflg 20 (SD - Standard deviation)
      real function stddev(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), rnul
      real avg
      double precision sum
      integer ip, n, is, ie
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      avg = avgsmp(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      sum = 0.0d0
      n = ie - is + 1
      do ip = is, ie
         sum = sum + ((arr(ip) - avg)**2)
      enddo
      if (n .ne. 0) then
         stddev = sqrt(sum / n)
      else
         stddev = 0.0
      endif
      end

cirflg 21 (SDP - Standard deviation of positive (> 0) values)
      real function stdpos(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), rnul
      real avg
      double precision sum
      integer ip, n, is, ie
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      avg = avgpos(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      sum = 0.0d0
      n = 0
      do ip = is, ie
         if (arr(ip) .gt. 0.0) then
            sum = sum + ((arr(ip) - avg)**2)
            n = n + 1
         endif
      enddo
      if (n .gt. 0) then
         stdpos = sqrt(sum / n)
      else
         stdpos = 0.0
      endif
      end

cirflg 22 (SDN - Standard deviation of negative (> 0) values)
      real function stdneg(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), rnul
      real avg
      double precision sum
      integer ip, n, is, ie
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      avg = avgneg(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      sum = 0.0d0
      n = 0
      do ip = is, ie
         if (arr(ip) .lt. 0.0) then
            sum = sum + ((arr(ip) - avg)**2)
            n = n + 1
         endif
      enddo
      if (n .gt. 0) then
         stdneg = sqrt(sum / n)
      else
         stdneg = 0.0
      endif
      end

cirflg 23 (SDA - Standard deviation of absolute values)
      real function stdabs(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), rnul
      real avg
      double precision sum
      integer ip, n, is, ie
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      avg = avgabs(arr,minsmp,maxsmp,minwin,maxwin,rnul)
      sum = 0.0d0
      n = ie - is + 1
      do ip = is, ie
         sum = sum + ((abs(arr(ip)) - avg)**2)
      enddo
      if (n .ne. 0) then
         stdabs = sqrt(sum / n)
      else
         stdabs = 0.0
      endif
      end

cirflg 24 (MED - Median)
      real function medval(arr,minsmp,maxsmp,minwin,maxwin,work)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), work(minsmp:maxsmp)
      integer ip, is, ie
      real median
      external median

      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)

c     Make a copy
      do ip = is, ie
         work(ip) = arr(ip)
      enddo
      
c     Compute the median
      medval = median(work,minsmp,maxsmp,minwin,maxwin)
      return
      end

cirflg 25 (MDA - Median of positive values)
      real function medpos(arr,minsmp,maxsmp,minwin,maxwin,work)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), work(minsmp:maxsmp)
      integer ip, is, ie, n
      real median
      external median

      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)

c     Make a copy of positive values only
      n = minwin - 1
      do ip = is, ie
         if (arr(ip) .gt. 0.0) then
            n = n + 1
            work(n) = arr(ip)
         endif
      enddo

      if (n .ge. minwin) then
         medpos = median(work,minsmp,maxsmp,minwin,n)
      else
         medpos = 0.0
      endif
      return
      end

cirflg 26 (MDN - Median of negative values)
      real function medneg(arr,minsmp,maxsmp,minwin,maxwin,work)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), work(minsmp:maxsmp)
      integer ip, is, ie, n
      real median
      external median

      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)

c     Make a copy of negative values only
      n = minwin - 1
      do ip = is, ie
         if (arr(ip) .lt. 0.0) then
            n = n + 1
            work(n) = arr(ip)
         endif
      enddo

      if (n .ge. minwin) then
         medneg = median(work,minsmp,maxsmp,minwin,n)
      else
         medneg = 0.0
      endif
      return
      end

cirflg 27 (MDA - Median of absolute values)
      real function medabs(arr,minsmp,maxsmp,minwin,maxwin,work)
      integer minsmp, maxsmp, minwin, maxwin
      real arr(minsmp:maxsmp), work(minsmp:maxsmp)
      integer ip, is, ie
      real median
      external median

      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)

c     Make a copy of absolute values
      do ip = is, ie
         work(ip) = abs(arr(ip))
      enddo
      
c     Compute the median
      medabs = median(work,minsmp,maxsmp,minwin,maxwin)
      return
      end

cirflg 28 (MAA - maximum of absolute values)
      real function maxabs(arr,minsmp,maxsmp,minwin,maxwin)
      real arr(minsmp:maxsmp)
      integer is, ie
      maxabs = -1.0
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      do k = is, ie
         if ( abs(arr(k)) .gt. maxabs )maxabs = abs(arr(k))
      enddo
cc    write(0,*) 'maxabs: ',maxabs,minsmp,maxsmp,minwin,maxwin
      return
      end

cirflg 29 (TMA - Time of maximum absolute value)
      real function maxabst(arr,minsmp,maxsmp,minwin,maxwin,
     1                    tmin,sr,rnul)
      real arr(minsmp:maxsmp)
      data nent /0/
      nent = nent+1
cc    write(0,*) 'peakt:',nent,minsmp,maxsmp,minwin,maxwin,tmin,sr
      maxabst = rnul
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      ic = (is+ie)/2
      ip = is
      do i = is, ie
cc       write(0,*) 'i,t,arr(i):', i, (i-1)*sr, arr(i)
         if (abs(arr(i)) .gt. abs(arr(ip))) then
             ip = i
         elseif (abs(arr(i)) .eq. abs(arr(ip))) then
c pick closest max to center of window
             if (abs(i-ic) .lt. abs(ip-ic)) ip = i
         endif
      enddo
      if (abs(arr(ip)) .gt. 0.0) then
c          maxabst = tmin + (ip-1)*sr
c fixed this logic as it was reporting times off a sample
c Garossino July 5 2000
          maxabst = tmin + (ip)*sr
          if (ip .gt. is .and. ip .lt. ie) then
              if (abs(arr(ip)) .eq. max(abs(arr(ip-1)),abs(arr(ip)),
     :            abs(arr(ip+1)))) then
                 call parab(abs(arr(ip-1)),abs(arr(ip)),abs(arr(ip+1)),
     :                x,y)
                 if (abs(x) .lt. 1.0) maxabst = maxabst + x*sr
              endif
          endif
      endif
cc    write(0,*) 'ip,maxabst,tmin,sr:', ip,maxabst,tmin,sr
cc    write(0,*) ' '
      return
      end

cirflg 30 (NBT - number of samples between thresholds)
      real function numsbt(arr,minsmp,maxsmp,minwin,maxwin,
     :     lower_threshold,upper_threshold)
      real arr(minsmp:maxsmp)
      real lower_threshold, upper_threshold
      integer is, ie

      numsbt = 0.0
      
      is = min(minwin,maxwin)
      ie = max(minwin,maxwin)
      do k = is, ie
         if ( arr(k) .ge. lower_threshold .and. 
     :        arr(k) .le. upper_threshold .and.
     :        arr(k) .ne. 0.0 ) numsbt = numsbt + 1.0
      enddo
cc    write(0,*) 'numsbt: ',numsbt,minsmp,maxsmp,minwin,maxwin,
cc     :        upper_threshold, lower_threshold
      return
      end

