C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c windstat reads in 3D data set and outputs the envelope, phase and
c frequency values for every trace.
c**********************************************************************c

c Changes:
c
c     November 3, 2000: Changed -NBT option to -CBT to eliminate conflict
c			with input dataset name.
c     Wade
c
c     October 23, 2000: Added -NBT capability for Steve Wigger [Stavanger]
c                       which counts the number of samples between 
c                       a user defined lower and upper threshold.  The
c                       routine does not count hard zeroes as part of the
c                       total.  I also upped the binary logic to keep 
c                       trace of reductions in the line header.  With this
c                       entry we have passed 30.  Next time I will have to 
c                       do this is when we pass 45.  This meant increasing
c                       hdrs(2) to hdrs(3) and using MCLE03 in the line
c                       header along with MCLE01 and MCLE02.
c     Garossino
c
c     August 18, 2000:  if ntrc on the input data is 1 [single trace
c                       records] then the routine now reports status
c                       every 1000 traces instead of every record.  Also
c                       added a check to watch for a premature EOF and if
c                       encountered to flush the buffers and close 
c                       gracefully.  This was done to be compatible with
c                       the -undead option that Steve added to lm3dvtosis
c                       where the line header would be lying about the 
c                       total number of records and traces coming at this
c                       routine.
c     Garossino
c
c     June 5, 2000: fixed I/O routine rdtrace.F to NOT do a double fft
c                   on every input trace trying to calculate a quadrature
c                   trace.  This brought execution speed down by an order
c                   of magnitude.
c     Garossino
c
c     Apr 26, 2000: Added -ssam and -MAA capability
c     Garossino
c______________________________________________________________________
c          Kelly D. Crawford (Amoco E&PT, Tulsa, OK, USA).  99% of this
c          program was shamelessly (but with permission) copied from
c          Kurt J. Marfurt (Amoco E&PT, Tulsa, OK, USA) and
c          Steven L. Farmer (Amoco E&PT, Tulsa, OK, USA) on May 9, 1995.
c          Details on how to build the program were obtained from
c          Greg A. Partyka (Amoco E&PT, Tulsa, OK, USA).
c______________________________________________________________________
c 
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c______________________________________________________________________
c     parameters needed for dynamic memory allocation routine 'galloc'.
c______________________________________________________________________
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)

c______________________________________________________________________
c     Lots of assorted declarations.
c______________________________________________________________________
      integer rs, re, ns, ne, ss, se
C     integer maxs, i2fact, lenhed, luang, i, jerr, ierror
      integer i2fact, lenhed, luang, i, jerr, ierror
      integer luin, luout, lbytes, lbyout, lentr2
      integer nsamp_in,  nrec_in,  ntr_in
      integer nrec_out, ntr_out, nbytes_out, nsamp_out
      integer nstream, nfile, nsi
      integer l_uin, l_uquad, l_wbuf, l_uout, l_work, l_tracebuf
      integer l_free, l_rtabf, l_itabf, l_rtabi, l_itabi
      integer lenuout, maxtracebuf, lens, ierrcd, initfftf
      integer ifmt_StaCor,l_StaCor,ln_StaCor
      integer ifmt_uh,l_uh,ln_uh,ifmt_lh,l_lh,ln_lh
      integer ntraces, jrec, nt, nfft
      integer lenwork, lenitab, lenrtab, lenattr

      real tstart_orig, dz, fref, dt, dtmsec, dsamp
      real power, vtot, wtot, v1, w1, v2, w2
      real uw, lw, lower_threshold, upper_threshold
      real null_value

      integer hdrs(3)
      logical horizons
      character*(6) uh, lh

c______________________________________________________________________
      integer     hbegin
      integer     sheader(SZLNHD)
      integer     ipwr(4)
      real        cputim(20),waltim(20)
#include <save_defs.h>
      parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)
c
      character*256  file_in, file_out
      character*6    name

c Grab the declarations for the process identifiers
#include "initproc.h"

c     pipelen should be big enough to handle all of the settings in
c     the initproc subroutine.  If you add another attribute output
c     you need to increment pipelen by 1.
      integer        pipelen
      parameter     (pipelen = 32)

      integer        pipe(pipelen), lunit(pipelen)
      logical        wrout(pipelen), calc(pipelen)
      logical        quadrature(pipelen), available(pipelen)
      character*(4)  keyword(pipelen)
      character*(60) description(pipelen)

      logical        verbose,query,depth_section,eof,wrint,IKP
      logical        live,calcquad,all, ssam

      integer        argis
      integer        stdin,stdout,stderr
      character*9    host,blank9
      data           name/'WINDST'/
      data           host/'         '/
      data           blank9/'         '/
      data           luang/88/
      data eof/.false./

c_______________________________________________________________
c     check to see if we are running under IKP.
c_______________________________________________________________
      call ikpchk(host)
      if(host .ne. blank9) then
         IKP=.true.
         write(LER,*)'windstat running inside XIKP'
c        Set up pipes from 3..pipelen+2
c        Note that pipes may run into conflicts with
c        /home/gp17/usp/include/f77/iounit.h
         do 1 i=1,pipelen
            pipe(i) = i+2
 1       continue
      else
         IKP=.false.
      endif
c_______________________________________________________________
c     initialize timing arrays.
c_______________________________________________________________
      call vclr(cputim,1,20)
      call vclr(waltim,1,20)
      call timstr(vtot,wtot)
      call timstr(v1,w1)
      stdin=LIN
      stdout=LOT
      stderr=LER
c_______________________________________________________________
c     Help?
c_______________________________________________________________
      query=((argis('-?') .gt. 0) .or. (argis('-h') .gt. 0)
     1  .or. (argis('-help') .gt. 0))
      if (query) then
         call help(ler)
         call exitfu(0)
      endif

c_______________________________________________________________
c     Does user just want a list of what is available?
c_______________________________________________________________
      query=((argis('-avail')     .gt. 0)
     1  .or. (argis('-available') .gt. 0))
      if (query) then
c        Call initproc to set up the arrays.
         call initproc(pipelen, quadrature,
     1                 available, keyword, description)
c        Check each option.
         write(ler,*) 'The following options are available:'
         do 6 i = 1, pipelen
            if (available(i)) then
               write(ler,*) '    ', keyword(i), ':', description(i)
            endif
 6       continue
         call exitfu(0)
      endif

c_______________________________________________________________
c     These are used to encode which functions we selected into
c     the header.
c_______________________________________________________________
      hdrs(1) = 0
      hdrs(2) = 0
      hdrs(3) = 0

c_______________________________________________________________
c     open printout files
c_______________________________________________________________
#include <f77/open.h>
c check to see if the user wants to reports executions stats to stderr

      ssam = (argis('-ssam') .gt. 0)

c_______________________________________________________________
c     get i/o data set names
c_______________________________________________________________
      call argstr('-N',file_in, ' ', ' ')
      call argstr('-O',file_out,' ', ' ')
      power=1.
      ierror=0

      if (file_in .eq. 'BT') then
        write(LER,*)'WINDSTAT ERROR: The -NBT flag has been',
     1   ' changed to -CBT'
        write(LERR,*)'WINDSTAT ERROR: The -NBT flag has been',
     1   ' changed to -CBT'
	call exitfu(1)
      endif
c_______________________________________________________________
c     open logical unit numbers for input and output
c_______________________________________________________________
      call getln(luin,file_in,'r',0)
      call getln(luout, file_out,'w', 1)
c_______________________________________________________________
c     read line header of input file.
c_______________________________________________________________
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(lerr,*)'WINDSTAT: no header read from unit ',luin
         write(ler,*)'WINDSTAT: no header read from unit ',luin
         call exitfu(4666)
      endif

c_______________________________________________________________
c     Does the user want me to decode a windstat-generated file
c     to see what order the reductions were done in?
c_______________________________________________________________
      if (argis('-decode') .gt. 0) then
c        Call initproc to set up the arrays.
         call initproc(pipelen, quadrature,
     1                 available, keyword, description)

c        Grab the header words
         call saver(sheader,'MCLE01',hdrs(1),LINEHEADER)
         call saver(sheader,'MCLE02',hdrs(2),LINEHEADER)
         call saver(sheader,'MCLE03',hdrs(3),LINEHEADER)

c        Reductions are encoded in bits in the hdrs array.  Decode
c        each one and print the result.
         isample = 0
         do 8 i = 1, pipelen
            if (i .le. 15) then
               ibit = mod(hdrs(1) / (2**(i-1)), 2)
            elseif (i .gt. 15 .and. i .le. 30 ) then
               ibit = mod(hdrs(2) / (2**(i-16)), 2)
            elseif (i .gt. 30  ) then
               ibit = mod(hdrs(3) / (2**(i-31)), 2)
            endif
            if (ibit .eq. 1) then
               isample = isample + 1
               write(ler,7)'Sample ',isample,' : ',description(i)
 7             format(1x,a7,i3,a3,a)
            endif
 8       continue
         call exitfu(0)
      endif

C_______________________________________________________________________
c     pull relevant values from line header.
C_______________________________________________________________________
      call saver(sheader,'NumSmp',nsamp_in,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumRec',nrec_in,LINEHEADER)
      call saver(sheader,'NumTrc',ntr_in,LINEHEADER)
      call saver(sheader,'TmMsFS',tstart_orig,LINEHEADER)
      call saver(sheader,'HrzNul',null_value,LINEHEADER)
c_______________________________________________________________________
c     Historical line header stuff
c_______________________________________________________________________
      call savhlh(sheader,lbytes,lbyout)

c_______________________________________________________________
c     Initialize the smart rtape.
c_______________________________________________________________
      call argi4('-rs', rs, 1, 1)
      call argi4('-re', re, nrec_in, nrec_in)
      call argi4('-ns', ns, 1, 1)
      call argi4('-ne', ne, ntr_in, ntr_in)
      call init_srtape(luin, ntr_in, lerr, rs, re, ns, ne)

c_______________________________________________________________________
c     What is the input sample range?  First see if the user specified
c     a trace header word to look for.  If so, use it as we read in
c     each trace to determine the top and bottom sample.  If not, see
c     if the user specified a start/end sample time.
c_______________________________________________________________________
      call argstr('-uh', uh, '*NONE*', '*NONE*')
      call argstr('-lh', lh, '*NONE*', '*NONE*')
      if (uh .eq. '*NONE*' .and. lh .eq. '*NONE*') then
         horizons = .FALSE.
      else
         horizons = .TRUE.
         if (uh .ne. '*NONE*') then
            call savelu(uh, ifmt_uh, l_uh, ln_uh, TRACEHEADER)
         endif
         if (lh .ne. '*NONE*') then
            call savelu(lh, ifmt_lh, l_lh, ln_lh, TRACEHEADER)
         endif
      endif
      call argr4('-uw', uw, 0., 0.)
      call argr4('-lw', lw, 0., 0.)

c     Grab start and end times.  Convert to array indices.
c     Note that tstart_orig is the time of the first sample.
c     To convert the time to an index, use
c        floor( (time-tstart_orig)/nsi + 1.5)
c     We need 0-based indices, so change the 1.5 to 0.5.
      call argi4('-s', ss, -1, -1)
      call argi4('-e', se, -1, -1)
      if (ss .le. 0) then
         ss = 0
      else
         ss = int(0.5 + real(ss - tstart_orig)/real(nsi))
         if (ss .le. 0) ss = 0
      endif
      if (se .le. 0) then
         se = nsamp_in - 1
      else
         se = int(0.5 + real(se - tstart_orig)/real(nsi))
         if (se .gt. (nsamp_in-1)) se = nsamp_in - 1
      endif

c_______________________________________________________________________
c     Add any start/end record/trace info
c_______________________________________________________________________
      nrec_out  = re - rs + 1
      ntr_out   = ne - ns + 1
      call savew(sheader,'NumRec',nrec_out,LINEHEADER)
      call savew(sheader,'NumTrc',ntr_out,LINEHEADER)

c_______________________________________________________________________
c     retrieve any threshold selection made by the user
c_______________________________________________________________________
      call argr4( '-lt', lower_threshold, -1.e32, -1.e32 )
      call argr4( '-ut', upper_threshold, 1.e32, 1.e32 )
      
c_______________________________________________________________
c     check keywords for each explicit attribute
c     if they are detected, open a file or add to the data stream.
c_______________________________________________________________
      nstream=0
      nfile=0
      nsamp_out=1

c_______________________________________________________________
c     Initialize the process details.
c_______________________________________________________________
      call initproc(pipelen, quadrature,
     1              available, keyword, description)

c_______________________________________________________________
c        Open the file or pipe
c_______________________________________________________________
      calcquad = .FALSE.
      all = (argis('-all') .gt. 0)
      do 5 i = 1, pipelen
c        Is this option selected?
         call chkfile(i,description(i),keyword(i),
     1                calc(i),wrout(i),lunit(i),all,hdrs,
     2                nstream,nfile,luout,lerr,sheader,
     3                IKP,pipelen,pipe(i),nsamp_out,lbyout)
         if (calc(i)) then
            if (available(i)) then
c              Check to see if we need to compute the quadrature (if any
c              reduction needs it, we will always have to compute it).
               calcquad = (calcquad .or. quadrature(i))
            else
               write(lerr,*)'Option ',keyword(i),' (',description(i),')'
               write(lerr,*)'   is not yet implemented...'
               calc(i) = .FALSE.
            endif
         endif
 5    continue

      if(nstream .gt. 0) then
c_______________________________________________________________
c        Output line header for multireduction file.
c_______________________________________________________________

c        Add encoded header words.  Use "windstat -Nfn -decode" to
c        get the ordered list of reductions.
         call savew(sheader,'MCLE01',hdrs(1),LINEHEADER)
         call savew(sheader,'MCLE02',hdrs(2),LINEHEADER)
         call savew(sheader,'MCLE03',hdrs(3),LINEHEADER)

         call savew(sheader,'NumSmp',nstream,LINEHEADER)
         call wrtape(luout,sheader,lbyout)
      elseif(nfile .eq. 0. .and. .not. all) then             
         write(lerr,*) 'command line error!'
         write(lerr,*) 'must specify one or more of attributes' 
     1                     //' on command line'
         write(ler,*) 'command line error!'
         write(ler,*) 'must specify one or more of attributes' 
     1                     //' on command line'
         call exitfu(3666)
      endif

      call argr4('-dz',dz,0.,0.)            
      verbose=(argis('-V') .gt. 0)
      if(dz .lt. 0.) then
         write(lerr,*) 'error! ',
     1                 ' non-negative dz must be entered '
     2                 //'after -dz on command line!'
         write(lerr,*) 'dz = ',dz
         write(ler,*) 'error! ',
     1                 ' non-negative dz must be entered '
     2                 //'after -dz on command line!'
         write(ler,*) 'dz = ',dz
         ierror=ierror+1
      endif
      if(dz .gt. 0.) then
         depth_section=.true.
         if(fref .eq. 0.) fref=30.
      else
         depth_section=.false.
         if(fref .eq. 0.) fref=60.
      endif

c need to add UnitSc capability on units....this old stuff 
c is no longer used in USP

      if(nsi .gt. 16) then
         dtmsec=.001*nsi
      else
         dtmsec=nsi
      endif
      if(depth_section) then
         dtmsec=dz
         dt=.001*dz
         dsamp=dz
      else
         dsamp=dtmsec
      endif
      ierror=0
      dt=.001*dtmsec

c______________________________________________________________________
c     For reductions, we only put out one sample per trace
c______________________________________________________________________
      nbytes_out=(1+lenhed)*szsmpd
      nbytes_out_aug=(nstream+lenhed)*szsmpd

      nt=nsamp_in-1  
c______________________________________________________________________
c     calculate length of mixed radix fft that fits lenwnd best.
c     limit to radices 2,3 and 5 to allow use both cray scilib
c     and qtc routines.
c______________________________________________________________________
      call nrfft(nt+1,5,nfft,ipwr)

      lentr2=lntrhd+(nt+1)*i2fact
c
      call hlhprt (sheader,lbytes,name,len(name),lerr)
c
      write(lerr,*)
      write(lerr,'(a,t40,i5,t50,a)') 'input seismic file name',
     1                         luin,file_in
      write(lerr,'(a,t40,i5,t50,a)') 'output multi-attribute file name',
     1                         luout,file_out
      write(lerr,'(a,t40,i5)') 'number of input records',nrec_in 
      write(lerr,'(a,t40,i5)') 'number of input traces',ntr_in  
      write(lerr,'(a,t40,i5)') 'number of input samples',nsamp_in
      write(lerr,'(a,t40,f12.6)') 'input data sample interval (msec)', 
     1                         dtmsec
      write(lerr,'(a,t40,f12.6)') 'sample interval (sec)', dt
      write(lerr,'(a,t40,i5)') 'number of output records',nrec_out
      write(lerr,'(a,t40,i5)') 'number of output traces',ntr_out
      write(lerr,'(a,t40,i5)') 'number of output samples',1
      write(lerr,'(a,t40,i5)') 'nt',nt,'nfft',nfft
      write(lerr,'(a,t40,i5)') 'lentr2',lentr2
      write(lerr,'(a,t40,i5)') 'nbytes_out',nbytes_out
      write(lerr,'(a,t40,i5)') 'nbytes_out_aug',nbytes_out_aug
c
      write(lerr,'(a,t40,l5)') 'scale output between (-128:+127)?',
     1                           wrint
      write(lerr,'(a,t40,l5)') 'verbose output?',verbose     
      write(lerr,*)' '
c______________________________________________________________________
c     calculate buffer requirements for nested mixed radix ffts.
c     cray scilib routine rfftmlt runs twice as fast as mathadvantage
c     routine rnfftm.
c
c     buffer   mathadvantage rnfftm        cray scilib rfftmlt
c
c     itab      nfft+34                      2*nfft
c     rtab      3(nfft/2)+13                 2*nfft
c     work      18*ntrace                    4*nfft*ntrace
c______________________________________________________________________
      if(szsmpd .eq. 4) then
         lenitab=nfft+34
         lenrtab=3*(nfft/2)+13
         lenwork=18
      else
         lenitab=max(2*nfft,nfft+34)
         lenrtab=max(2*nfft,3*(nfft/2)+13)
         lenwork=max(4*(1+1)*nfft,18)
      endif
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      lenattr=(nt+1)*ntr_out
      maxtracebuf = max(nt, nstream)
      lenuout = max(nfft, nstream)
c____________________________________________________________________
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('uin',l_uin,l_free,nfft,lerr)
      call mapmem('uquad',l_uquad,l_free,nfft,lerr)
      call mapmem('wbuf',l_wbuf,l_free,nfft,lerr)
      call mapmem('uout',l_uout,l_free,lenuout,lerr)
      call mapmem('tracebuf',l_tracebuf,l_free,
     1            maxtracebuf+1+lenhed,lerr)
c
      call mapmem('rtabf',l_rtabf,l_free,lenrtab,lerr)
      call mapmem('itabf',l_itabf,l_free,lenitab,lerr)
      call mapmem('rtabi',l_rtabi,l_free,lenrtab,lerr)
      call mapmem('itabi',l_itabi,l_free,lenitab,lerr)
      call mapmem('work',l_work,l_free,lenwork,lerr)
c___________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(ler,'(//,a)') 'allocate dynamic memory for WINDSTAT: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(lerr,*)'memory can be decreased by using the -M option'
         write(lerr,*)
         write(lerr,*)'program WINDSTAT aborted'
c
         write(ler,*)'galloc memory allocation error from main'
         write(ler,*)'ierrcd = ',ierrcd
         write(ler,*)
         write(ler,*)'probable cause: too much memory requested!'
         write(ler,*)'go check your seismic headers and command'//
     1                ' line arguments!'
         write(ler,*)'memory can be decreased by using the -M option'
         write(ler,*)
         write(ler,*)'program WINDSTAT aborted'
         call exit(101)
      endif
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
c_______________________________________________________________________
c     set fft initialization flag.
c_______________________________________________________________________
      initfftf=1

c_______________________________________________________________________
c     Loop over all desired traces.  Compute over range [re,rs], [ne,ns].
c_______________________________________________________________________
      ntraces = (re - rs + 1) * (ne - ns + 1)

      do 80000 jrec=1,ntraces
c_______________________________________________________________________
c        get the next trace
c_______________________________________________________________________

         call rdtrace(s(l_tracebuf),s(l_uin),s(l_uquad),
     1                calcquad,live,luin,maxtracebuf,
     2                l_StaCor,ifmt_StaCor,ln_StaCor,
     3                eof,lenhed,nt,nfft,lerr,
     4                s(l_rtabf),s(l_itabf),s(l_rtabi),
     5                s(l_itabi),s(l_work),
     6                lenrtab,lenitab,lenwork,initfftf,
     7                cputim,waltim)

         if ( eof ) goto 80000

c_______________________________________________________________________
c      calculate attributes.
c_______________________________________________________________________
         call process(s(l_tracebuf),s(l_uin),s(l_uquad),
     1        s(l_wbuf),s(l_uout),nbytes_out,nbytes_out_aug,
     2        lenhed,nt,nfft,live,lenuout,maxtracebuf,
     3        pipelen,calc,lunit,luout,wrout,
     4        nstream,nsi,ss,se,horizons,uh,lh,uw,lw,
     5        ifmt_uh,l_uh,ln_uh,ifmt_lh,l_lh,ln_lh,
     6        tstart_orig,nsamp_in,null_value,
     7        lower_threshold, upper_threshold,lerr,cputim,waltim)

c report execution status if desired

         if ( ssam ) then

            if ( ntr_out .eq. 1 ) then

               if ( mod(jrec,1000).eq.0) 
     :              write(LER,*)' (windstat) start, current, end, 1,',
     :                 jrec,ntraces
            else
            
               if ( mod(jrec,ntr_out).eq.0) 
     :              write(LER,*)' (windstat) start, current, end, 1,',
     :                 jrec,ntraces
            endif
         endif

80000 continue
c_____________________________________________________________
c     close out those attribute files that were opened.
c_____________________________________________________________
      do 999 i = 1, pipelen
         if (wrout(i)) call lbclos(lunit(i))
 999  continue
      if (nstream .gt. 0 .and. luout .ne. stdout) call lbclos(luout)
      call lbclos(luin)

c_____________________________________________________________
c     write out timing statistics.
c_____________________________________________________________
      call timend(cputim(20),vtot,v2,waltim(20),wtot,w2)
      write(lerr,'(A30,2A15,/)') 'routine','cpu time','wall time'
      write(lerr,'(A30,2f15.3)')
     1         'read input',cputim(1),waltim(1),
     2         'calculate',cputim(2),waltim(2),
     2         'write output',cputim(10),waltim(10),
     7         'total',cputim(20),waltim(20)

      write(ler,*)'normal completion. routine WINDSTAT'           
      write(lerr,*)'normal completion. routine WINDSTAT'           
      close(lerr)
      call exitfu(0)
c      call exitfu(666)
c
      end
      subroutine help(ler)

      write(ler,*)
     1'**************************************************************'
      write(ler,*)'3D seismic reductions'
      write(ler,*)
     1'**************************************************************'
      write(ler,*)'execute windstat by typing windstat and list of'
     1                   //' program parameters.'

      write(ler,*)' '
      write(ler,*)
     1' -N [file_in]  (stdin)      : input seismic file name'          
      write(ler,*)
     1' -O [file_out]  (stdout)    : output multi-reduction file name'        
      write(ler,*)
     1' -all                  : Do all reductions.  Store in single'
      write(ler,*)
     1'                         file specified by the -O option'
      write(ler,*)
     1' -uh [hdrwrd]          : Header word containing the time for'
      write(ler,*)
     1'                         the upper horizon'
      write(ler,*)
     1' -lh [hdrwrd]          : Header word containing the time for'
      write(ler,*)
     1'                         the lower horizon'
      write(ler,*)
     1' -uw [upper_horizon_offset] : Offset (+-) from upper horizon'
      write(ler,*)
     1' -lw [lower_horizon_offset] : Offset (+-) from lower horizon'
      write(ler,*)
     1' -rs[start_record] -re[end_record] : start and end record'
      write(ler,*)
     1' -ns[start_trace] -ne[end_trace]   : start and end trace'
      write(ler,*)
     1' -s[start_time] -e[end_time]       : start and end time'
      write(ler,*)
     1' -avail                : Print list of available options'
      write(ler,*)
     1' -ssam                 : if present, execution status to stderr'
      write(ler,*)
     1' -V                    : if present, verbose printout'
      write(ler,*)' '
      write(ler,*)
     1' The -decode option will decode the line header of a'
      write(ler,*)
     1'     windstat-generated file to determine which reductions'
      write(ler,*)
     1'     are stored there.  This is only valid for datasets that'
      write(ler,*)
     1'     contain multiple reductions.'
      write(ler,*)' '

      write(ler,*)
     1' Specifying a set of reductions with no associated filenames'
      write(ler,*)
     1' (or specifying -all) will cause windstat to concatenate the'
      write(ler,*)
     1' reductions into the file specified by -O (or default to stdout)'
      write(ler,*)' '

      write(ler,*)
     1 ' average (-AVA)'
      write(ler,*)
     1 ' average of absolute values (-AAA)'
      write(ler,*)
     1 ' largest positive (> 0) value (-LPV)'
      write(ler,*)
     1 ' largest negative (< 0) value (-LNV)'
      write(ler,*)
     1 ' average of positive (> 0) values (-APV)'
      write(ler,*)
     1 ' average of negative (< 0) values (-ANV)'
      write(ler,*)
     1 ' angle of phase vector sum; +360 if negative (-A36)'
      write(ler,*)
     1 ' angle of phase vector sum; +180 (-A18)'
      write(ler,*)
     1 ' phase magnitude (-PMG)'
      write(ler,*)
     1 ' average of absolute sample to sample difference (-AAD)'
      write(ler,*)
     1 ' sum of absolute sample to sample difference (-SAD)'
      write(ler,*)
     1 ' energy, sum  of sample*sample (-ESS)'
      write(ler,*)
     1 ' time of largest positive (> 0) value (-TLP)'
      write(ler,*)
     1 ' time of largest negative (< 0) value (-TLN)'
      write(ler,*)
     1 ' -TLP with parabola fit (-P12)'
      write(ler,*)
     1 ' -TLN with parabola fit (-P13)'
      write(ler,*)
     1 ' sum of absolute values (-SAV)'
      write(ler,*)
     1 ' decay of absolute values (-DAV)'
      write(ler,*)
     1 ' largest peak/trough amplitude difference (-LAD)'
      write(ler,*)
     1 ' largest peak/trough time difference (-LTD)'
      write(ler,*)
     1 ' standard deviation (-STD)'
      write(ler,*)
     1 ' standard deviation of positive (> 0) values (-SDP)'
      write(ler,*)
     1 ' standard deviation of negative (< 0) values (-SDN)'
      write(ler,*)
     1 ' standard deviation of absolute values (-SDA)'
      write(ler,*)
     1 ' median (-MED)'
      write(ler,*)
     1 ' median of positive (> 0) values (-MDP)'
      write(ler,*)
     1 ' median of negative (< 0) values (-MDN)'
      write(ler,*)
     1 ' median of absolute values (-MDA)'
      write(ler,*)
     1 ' maximum of absolute values (-MAA)'
      write(ler,*)
     1 ' time of maximum absolute value (-TMA)'
      write(ler,*)
     1 ' number of samples between thresholds(-NBT)'
      write(ler,*)
     1 ' copy single horizon (-CPH)'
      write(ler,*)

      write(ler,*)' '
      write(ler,*)'usage:'
      write(ler,*)
      write(ler,*)'windstat -N[file_in] -O[file_out]'
      write(ler,*)'         -uh[hdrwrd] -lh[hdrwrd]'
      write(ler,*)'         -uw[upper_horizon_offset]'
      write(ler,*)'         -lw[lower_horizon_offset]'
      write(ler,*)'         -rs[start_record] -re[end_record]'
      write(ler,*)'         -ns[start_trace] -ne[end_trace]'
      write(ler,*)'         -s[start_time] -e[end_time]'
      write(ler,*)'         -lt[lower_threshold]'
      write(ler,*)'         -ut[upper_threshold]'
      write(ler,*)' '
      write(ler,*)'         -avail -decode -V'
      write(ler,*)' '
      write(ler,*)'    Reductions:'
      write(ler,*)'       -all'
      write(ler,*)'       -AVA[file] -AAA[file]'
      write(ler,*)'       -LPV[file] -LNV[file]'
      write(ler,*)'       -APV[file] -ANV[file]'
      write(ler,*)'       -A36[file] -A18[file]'
      write(ler,*)'       -PMG[file] -AAD[file]'
      write(ler,*)'       -SAD[file] -ESS[file]'
      write(ler,*)'       -TLP[file] -TLN[file]'
      write(ler,*)'       -P12[file] -P13[file]'
      write(ler,*)'       -SAV[file] -DAV[file]'
      write(ler,*)'       -LAD[file] -LTD[file]'
      write(ler,*)'       -STD[file] -SDP[file]'
      write(ler,*)'       -SDN[file] -SDA[file]'
      write(ler,*)'       -MED[file] -MDP[file]'
      write(ler,*)'       -MDN[file] -MDA[file]'
      write(ler,*)'       -MAA[file] -TMA[file]'
      write(ler,*)'       -CPH[file] -CBT[file]'
      write(ler,*)' '
      write(ler,*)

      return
      end
