C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rotor(DataRecord,TraceHeaders,ntrc,nsampo,nsi,Xtrace
     :     ,Ytrace,Ztrace,x,y,z,StartTime,EndTime,JJ,
     :     AngleToAdd,AngleConstant,verbos)

#include <f77/iounit.h>

c
c ----- variables passed from main -----
c

      integer ntrc,nsampo,nsi,Xtrace,Ytrace,Ztrace,JJ
      integer TraceHeaders(*)

      real DataRecord(*),x(*),y(*),z(*),AngleToAdd,AngleConstant
      real EndTime(*),StartTime(*)

      logical verbos

c
c ----- local variables -----
c

      integer i,j,IntegerzMax,MaxSample
      integer index1,index2,index3,Start,End

      real rad2deg,x2y2,MaxAmplitude,xMax,yMax,zMax,pi
      real RadianPhi,DegreePhi,MaxTime,CosPhi,SinPhi,xtemp,ytemp

c
c ----- initialize variables -----
c

      pi = 3.1415926
      rad2deg = 57.29578
      index1 = 1
      index2 = nsampo+1
      index3 = 2*nsampo+1

c
c ----- load x,y,z traces based on user defined input trace location -----
c

      if(Xtrace.eq.1)call vmov(DataRecord(1),1,x(1),1,nsampo)
      if(Xtrace.eq.2)call vmov(DataRecord(index2),1,x(1),1,nsampo)
      if(Xtrace.eq.3)call vmov(DataRecord(index3),1,x(1),1,nsampo)

      if(Ytrace.eq.1)call vmov(DataRecord(1),1,y(1),1,nsampo)
      if(Ytrace.eq.2)call vmov(DataRecord(index2),1,y(1),1,nsampo)
      if(Ytrace.eq.3)call vmov(DataRecord(index3),1,y(1),1,nsampo)

      if(Ztrace.eq.1)call vmov(DataRecord(1),1,z(1),1,nsampo)
      if(Ztrace.eq.2)call vmov(DataRecord(index2),1,z(1),1,nsampo)
      if(Ztrace.eq.3)call vmov(DataRecord(index3),1,z(1),1,nsampo)


c
c ----- watch out for dead traces -----
c

      IF (       TraceHeaders(1).eq.30000
     :     .and. TraceHeaders(2).eq.30000
     :     .and. TraceHeaders(3).eq.30000 ) then

         write(LERR,*)' WARNING :All components for record ',JJ,' dead.'
         write(LERR,*)'          Processing of this record is bypassed.'
         write(LERR,*)' '

      ELSEIF(AngleConstant.lt.1.e-30)then
         
c
c ----- do well rotation -----
c

c
c ----- get start and end window in samples for this record -----
c

       Start = nint(StartTime(JJ)/float(nsi))
       End = nint(EndTime(JJ)/float(nsi))

       if(Start.lt.1)Start = 1
       if(End.gt.nsampo)End = nsampo

c
c ----- locate maximum resultant of x and y -----
c

         MaxAmplitude = 0.0

         do i=Start,End

            x2y2 = x(i)*x(i)+y(i)*y(i)

            if(x2y2.ge.MaxAmplitude)then

               MaxAmplitude = x2y2
               MaxSample = i

            endif

         enddo

         xMax = x(MaxSample)
         yMax = y(MaxSample)
         zMax = z(MaxSample)

         IntegerzMax = ifix(zMax)

c
c ----- compute angle and align for x along positive lobe -----
c

         RadianPhi = atan2(yMax,xMax) + pi*(1-isign(1,IntegerzMax))/2
     :        + AngleToAdd/rad2deg
         DegreePhi = RadianPhi*rad2deg
         MaxTime = MaxSample*nsi

         if(verbos.and.AngleConstant.lt.1.e-20)
     :        write(LERR,10)MaxTime,xMax,yMax,zMax,DegreePhi,JJ
 10      format(f5.0,2x,3e12.4,3x,f6.1,3x,i5)

c
c ----- rotate x and y -----
c

         CosPhi = cos(RadianPhi)
         SinPhi = sin(RadianPhi)

         do i = 1,nsampo

            xTemp = x(i)
            yTemp = y(i)
            x(i) = (xTemp*CosPhi)+(yTemp*SinPhi)
            y(i) = (yTemp*CosPhi)-(xTemp*SinPhi)

         enddo

      ELSE


c
c ----- constant rotation of AngleConstant input by user -----
c       required only.  No calculation of angle based
c       on input data is desired
c

         DegreePhi = AngleConstant
         RadianPhi = AngleConstant/rad2deg

c
c ----- rotate x and y -----
c

         CosPhi = cos(RadianPhi)
         SinPhi = sin(RadianPhi)

         do i = 1,nsampo

            xTemp = x(i)
            yTemp = y(i)
            x(i) = (xTemp*CosPhi)+(yTemp*SinPhi)
            y(i) = (xTemp*SinPhi)+(yTemp*CosPhi)

         enddo

      ENDIF

c
c ----- load traces back to DataRecord array -----
c

      if(Xtrace.eq.1)call vmov(x(1),1,DataRecord(1),1,nsampo)
      if(Xtrace.eq.2)call vmov(x(1),1,DataRecord(index2),1,nsampo)
      if(Xtrace.eq.3)call vmov(x(1),1,DataRecord(index3),1,nsampo)

      if(Ytrace.eq.1)call vmov(y(1),1,DataRecord(1),1,nsampo)
      if(Ytrace.eq.2)call vmov(y(1),1,DataRecord(index2),1,nsampo)
      if(Ytrace.eq.3)call vmov(y(1),1,DataRecord(index3),1,nsampo)

      if(Ztrace.eq.1)call vmov(z(1),1,DataRecord(1),1,nsampo)
      if(Ztrace.eq.2)call vmov(z(1),1,DataRecord(index2),1,nsampo)
      if(Ztrace.eq.3)call vmov(z(1),1,DataRecord(index3),1,nsampo)

c
c ----- perform same rotation on remaining sources if present -----
c

      do i = 2,(ntrc/3),1

c
c ----- load x,y,z traces based on user defined input trace location -----
c

         index1 = (i-1)*3*nsampo+1
         index2 = ((i-1)*3+1)*nsampo+1
         index3 = ((i-1)*3+2)*nsampo+1
         
         if(Xtrace.eq.1)call vmov(DataRecord(index1),1,x(1),1,nsampo)
         if(Xtrace.eq.2)call vmov(DataRecord(index2),1,x(1),1,nsampo)
         if(Xtrace.eq.3)call vmov(DataRecord(index3),1,x(1),1,nsampo)
         
         if(Ytrace.eq.1)call vmov(DataRecord(index1),1,y(1),1,nsampo)
         if(Ytrace.eq.2)call vmov(DataRecord(index2),1,y(1),1,nsampo)
         if(Ytrace.eq.3)call vmov(DataRecord(index3),1,y(1),1,nsampo)
         
         if(Ztrace.eq.1)call vmov(DataRecord(index1),1,z(1),1,nsampo)
         if(Ztrace.eq.2)call vmov(DataRecord(index2),1,z(1),1,nsampo)
         if(Ztrace.eq.3)call vmov(DataRecord(index3),1,z(1),1,nsampo)
         
c     
c     ----- watch for dead traces -----
c     

         IF (       TraceHeaders((i-1)*3+1).eq.30000
     :        .and. TraceHeaders(((i-1)*3+1)+1).eq.30000
     :        .and. TraceHeaders(((i-1)*3+2)+1).eq.30000 ) then

            write(LERR,*)' WARNING :All components for record ',JJ,' 
     :           are dead.'
            write(LERR,*)'          Processing of this record bypassed.'
            write(LERR,*)' '
            
         ELSE
   
c
c ----- rotate x and y through DegreePhi -----
c

            do j=1,nsampo
               
               xTemp = x(j)
               yTemp = y(j)
               x(j) = (xTemp*CosPhi)+(yTemp*SinPhi)
               y(j) = (xTemp*SinPhi)+(yTemp*CosPhi)
               
            enddo
            
         ENDIF

c
c ----- load traces back to DataRecord Array -----
c

         if(Xtrace.eq.1)call vmov(x(1),1,DataRecord(index1),1,nsampo)
         if(Xtrace.eq.2)call vmov(x(1),1,DataRecord(index2),1,nsampo)
         if(Xtrace.eq.3)call vmov(x(1),1,DataRecord(index3),1,nsampo)
         
         if(Ytrace.eq.1)call vmov(y(1),1,DataRecord(index1),1,nsampo)
         if(Ytrace.eq.2)call vmov(y(1),1,DataRecord(index2),1,nsampo)
         if(Ytrace.eq.3)call vmov(y(1),1,DataRecord(index3),1,nsampo)
         
         if(Ztrace.eq.1)call vmov(z(1),1,DataRecord(index1),1,nsampo)
         if(Ztrace.eq.2)call vmov(z(1),1,DataRecord(index2),1,nsampo)
         if(Ztrace.eq.3)call vmov(z(1),1,DataRecord(index3),1,nsampo)
         

      enddo

      return
      end


