C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ---------------------------Routine Wrot------------------------------
c
c
c This is a port of some old Perkin-Elmer code I retrieved from Rusty
c Alfords VM ID.  It is meant to orientate three component data in the
c x,y plane.  If multiple sources are present, common receiver locations
c are rotated by the same angle.  The polarity is estimated form the 
c z component if possible.
c
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c
c     declare variables
c

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c -----
c basic usp variables
c -----

      integer     lhed( SZLNHD )
      integer     nsamp,nsampo,nsi,ntrc,nrec,nreco,iform
      integer     luin,lbytes,nbytes,obytes,luout
      integer     argis,irs,ire,JJ,KK


      character   name*7,ntap*256,otap*256

      logical     verbos,query

c
c ----- dimension program specific variables -----
c

      integer     Xtrace,Ytrace,Ztrace,lupick,le1,NumPicks
      integer     l_RecNum,l_StaCor,l_NumSmp,l_NumRec
      integer     DeadTraces(SZLNHD)

      real        AngleToAdd,AngleConstant

      character   ptap*100

      logical     pick,flat

c
c ----- dynamic memory variables -----
c

      integer   errcd1,errcd2,errcd3,errcd4,errcd5,errcd6,errcd7,errcd8
      integer   abort
      integer   TraceHeaders

      real     DataRecord,x,y,z,Record,StartTime,EndTime,PickOverride

      pointer     (wkadr1, DataRecord(2000000))
      pointer     (wkadr2, x(2000000))
      pointer     (wkadr3, y(2000000))
      pointer     (wkadr4, z(2000000))
      pointer     (wkadr5, Record(2000000))
      pointer     (wkadr6, StartTime(2000000))
      pointer     (wkadr7, EndTime(2000000))
      pointer     (wkadr8, TraceHeaders(200000))

c ----- integer program variables -----
c
c     Xtrace    : trace number of x component
c     Ytrace    : trace number of y component
c     Ztrace    : trace number of z component
c     lupick     : logical unit for pickfile/flatfile
c     le1        : length of pickfile/flatfile name
c     errcd1-7   : used with galloc
c     abort      : used with galloc
c     TraceHeaders : array to hold trace headers
c
c ----- real program variables -----
c
c     DataRecord()    : input data record
c     x(),y(),z()     : component traces
c     Record()        : record number from pickfile/flatfile
c     StartTime()     : start times from pickfile/flatfile
c     EndTime()       : end times from pickfile/flatfile
c
c ----- pointer program variables -----
c
c     wkadr1-8     : points to location of 1st element of array
c
c ----- logical program variables -----
c
c     pick         : flag to indicate pick file input
c     flat         : flag to indicate flat file input
c
c
c ----- initialize necessary variables -----
c

      data name/'WROT'/,abort/0/,luin/1/
      data Xtrace/0/,Ytrace/0/,Ztrace/0/
      verbos = .false.
      pick = .false.
      flat = .false.

c
c ----- get online help if necessary -----
c

      query = (argis('-?').gt.0 .or. argis('-h').gt.0)

      if ( query ) then

           call help ()
           stop

      endif

c debug ----- ieee exception handler to find those mysterious bugs
c       
c       ieeer = ieee_handler ('set','overflow',killit)
c -----

c
c ----- open printout files -----
c

#include <f77/open.h>

c
c ----- get command line parameters -----
c

      call cmdln(ntap,otap,ptap,le1,irs,ire,Xtrace,Ytrace,
     :    Ztrace,pick,flat,PickOverride,AngleToAdd,AngleConstant,verbos)

c
c ----- get logical units for input,output and pick/flat files-----
c

      call getln(luin,ntap,'r',0)
      call getln (luout,otap,'w',1)

      write(LERR,*)'Input unit # is ',luin,' for DSN= ',ntap
      write(LERR,*)'Output unit # is ',luout,' for DSN= ',otap


      if(pick)then
         call alloclun(lupick)
         open(unit=lupick,file=ptap(1:le1),status='unknown',iostat=ierr)
         write(LERR,*)'Pickfile unit # is ',lupick,' for ',ptap

         if(ierr.ne.0)then

            write(LERR,*)'FATAL: Error opening pick file ',ptap
            write(LERR,*)'       Check existance.'
            write(LERR,*)' '
            stop
            
         endif
      endif

      if(flat)then
         call alloclun(lupick)
         open(unit=lupick,file=ptap(1:le1),status='unknown',iostat=ierr)
         write(LERR,*)'Flatfile unit # is ',lupick,' for ',ptap

         if(ierr .ne. 0) then

            write(LERR,*)'FATAL: Error opening flat file ',ptap(1:le1)
            write(LERR,*)'       Check existance.'
            write(LERR,*)' '
            stop
            
         endif
      endif

c
c ----- read line header, check to see if input empty -----
c

      lbytes = 0
      call rtape(luin,lhed,lbytes)
      write(LERR,*)'lbytes= ',lbytes

      if(lbytes .eq. 0) then
         write(LERR,*)'wrot: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

c
c ----- save certain parameters -----
c

      call saver(lhed, 'NumSmp', nsamp , LINHED)
      call saver(lhed, 'SmpInt', nsi   , LINHED)
      call saver(lhed, 'NumTrc', ntrc  , LINHED)
      call saver(lhed, 'NumRec', nrec  , LINHED)
      call saver(lhed, 'Format', iform , LINHED)


      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('NumSmp',ifmt,l_NumSmp,length,LINEHEADER)
      call savelu('NumRec',ifmt,l_NumRec,length,LINEHEADER)

c
c ----- set record start and end defaults -----
c

      if(irs .eq. 0) irs=1
      if(ire .eq. 0) ire=nrec

c
c ----- determine number of records to process -----
c

      nreco=ire-irs+1


c ----- determine number of output samples -----
c

      nsampo=nsamp

c
c ----- modify output lineheader -----
c

      call savew2(lhed,ifmt,l_NumSmp,length,nsampo,LINEHEADER)
      call savew2(lhed,ifmt,l_NumRec,length,nreco,LINEHEADER)

c
c ----- change output bytes to reflect change -----
c       from time to # traces
c

      obytes = SZTRHD + SZSMPD * nsampo

c
c ----- adjust historical line header & write header -----
c

      call savhlh(lhed,lbytes,lbyout)

      call wrtape(luout,lhed,lbyout)

c
c ----- printout -----
c

      call verbal(nsamp,nsampo,nsi,ntrc,nrec,nreco,iform,
     :     irs,ire,Xtrace,Ytrace,Ztrace,PickOverride,AngleToAdd,
     :     AngleConstant)

c
c ----- malloc only space we're going to use -----
c

      itemRecord = ntrc * nsamp * SZSMPD
      itemTrace = nsamp * SZSMPD
      itemHeader =  ntrc * ITRWRD * SZSMPD

      call galloc(wkadr1,itemRecord,errcd1,abort)
      call galloc(wkadr2,itemTrace,errcd2,abort)
      call galloc(wkadr3,itemTrace,errcd3,abort)
      call galloc(wkadr4,itemTrace,errcd4,abort)
      call galloc(wkadr8,itemHeader,errcd8,abort)

      if (errcd1 .ne. 0 .or. errcd2 .ne. 0 .or. errcd3 .ne. 0 .or. 
     :     errcd4 .ne. 0 .or. errcd8 .ne. 0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemRecord+3*itemTrace+itemHeader,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemRecord+3*itemTrace+itemHeader,'  bytes'
         write(LERR,*)' '
      endif

c
c ----- counts picks and galloc required space -----
c

      if(pick)call PickCount(lupick,NumPicks)
      if(flat)call FlatCount(lupick,NumPicks)

      itemPicks = NumPicks*SZSAMP+1
      if(nreco.gt.NumPicks)itemPicks = nreco*SZSAMP+1

      call galloc(wkadr5,itemPicks,errcd5,abort)
      call galloc(wkadr6,itemPicks,errcd6,abort)
      call galloc(wkadr7,itemPicks,errcd7,abort)

      if (errcd5 .ne. 0 .or. errcd6 .ne. 0 .or. errcd7 .ne. 0)then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemPicks*3,'  bytes'
         write(LERR,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemPicks*3,'  bytes'
         write(LERR,*)' '
      endif

c
c ----- read and store pick/flat file -----
c

      if(pick)call ReadPicks(lupick,Record,StartTime,EndTime,irs,
     :     ire,PickOverride,verbos)

      if(flat)call ReadFlatFile(lupick,Record,StartTime,EndTime,
     :     irs,ire,PickOverride,verbos)

      if(verbos.and.AngleConstant.lt.1.e-30)then

c
c ----- header for printout file -----
c

         write(LERR,*)' '
         write(LERR,*)'Statistics for Maximum x,y Resultant'
         write(LERR,*)'Time       x           y           z            
     :angle    record'

      endif

c
c ----- skip to start record -----
c

      call recskp(1,irs-1,luin,ntrc,lhed)

      DO 100 JJ = irs, ire

c
c -----  read record & store to array -----
c
         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsampo

         DO KK = 1, ntrc

            nbytes = 0
            call rtape(luin,lhed,nbytes)
              
            if(nbytes .eq. 0) then

               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',KK
               go to 999
                 
            endif

c -----
c     reset array indices for this trace
c -----

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsampo
            
            call saver2(lhed,ifmt_StaCor,l_StaCor,ln_StaCor,
     :           DeadTraces(KK),TRACEHEADER)

c -----
c     load headers for safekeeping
c -----

            call vmov (lhed,1,TraceHeaders(IndexHeader),1,ITRWRD)

c -----
c     load time series
c -----

            call vmov(lhed(ITHWP1),1,DataRecord(IndexTrace),1,nsampo)

         ENDDO


C
c ----- now that DataRecord is loaded rotate data -----
c


         call rotor(DataRecord,DeadTraces,ntrc,nsampo,nsi,Xtrace,
     :        Ytrace,Ztrace,x,y,z,StartTime,EndTime,JJ,AngleToAdd,
     :        AngleConstant,verbos)

c
c ----- output rotated DataRecord ----
c
c -----
c     Time for output, Loop over Traces
c -----

         IndexTrace = 1 - nsampo
         IndexHeader = 1 - ITRWRD

         DO KK = 1,ntrc

            IndexTrace = IndexTrace + nsampo
            IndexHeader = IndexHeader + ITRWRD

c
c ----- reassign trace headers -----
c

            call vmov (TraceHeaders(IndexHeader),1,lhed,1,ITRWRD)

c
c ----- load the output trace from DataRecord to lhed -----
c

            call vclr(lhed(ITHWP1),1,nsamp)
            call vmov(DataRecord(IndexTrace),1,lhed(ITHWP1),1,nsampo)
                    
c
c ----- write out trace -----
c

            call wrtape(luout,lhed,obytes)

         ENDDO

 100  CONTINUE

c
c ----- cleanup prior to normal termination -----
c

 999  continue

      write(LERR,*)' '
      write(LERR,*)'Normal Completion'
      write(LERR,*)'processed ',nreco,' records'


      call lbclos(luin)
      call lbclos(luout)
      if(pick.or.flat)close(lupick)

      stop
      end

